/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;

public enum CldrDataType {
    BCP47(DtdType.ldmlBCP47, new DtdType[0]),
    SUPPLEMENTAL(DtdType.supplementalData, new DtdType[0]),
    LDML(DtdType.ldml, DtdType.ldmlICU);

    private static final ImmutableMap<String, CldrDataType> NAME_MAP;
    private final DtdType mainType;
    private final ImmutableList<DtdType> extraTypes;
    private final Comparator<String> elementComparator;
    private final Comparator<String> attributeComparator;

    public static CldrDataType forXmlName(String name) {
        CldrDataType type = NAME_MAP.get(name);
        Preconditions.checkArgument(type != null, "unsupported DTD type: %s", (Object)name);
        return type;
    }

    static CldrDataType forRawType(DtdType rawType) {
        return CldrDataType.forXmlName(rawType.name());
    }

    private CldrDataType(DtdType mainType, DtdType ... extraTypes) {
        this.mainType = mainType;
        this.extraTypes = ImmutableList.copyOf(extraTypes);
        DtdData dtd = DtdData.getInstance(mainType);
        this.elementComparator = CldrDataType.wrapToHandleUnknownNames(dtd.getElementComparator(), dtd.getElementFromName()::containsKey);
        this.attributeComparator = CldrDataType.wrapToHandleUnknownNames(dtd.getAttributeComparator(), dtd.getAttributesFromName()::containsKey);
    }

    String getLdmlName() {
        return this.mainType.name();
    }

    Stream<Path> getSourceDirectories() {
        return this.mainType.directories.stream().map(x$0 -> Paths.get(x$0, new String[0]));
    }

    Stream<DtdData.Element> getElements() {
        Stream<DtdData.Element> elements = CldrDataType.elementsFrom(this.mainType);
        if (!this.extraTypes.isEmpty()) {
            elements = Stream.concat(elements, this.extraTypes.stream().flatMap(CldrDataType::elementsFrom));
        }
        return elements;
    }

    private static Stream<DtdData.Element> elementsFrom(DtdType dataType) {
        return DtdData.getInstance(dataType).getElementFromName().values().stream();
    }

    DtdData.Attribute getAttribute(String elementName, String attributeName) {
        DtdData.Attribute attr;
        block1: {
            DtdType t2;
            attr = DtdData.getInstance(this.mainType).getAttribute(elementName, attributeName);
            if (attr != null) break block1;
            Iterator iterator = this.extraTypes.iterator();
            while (iterator.hasNext() && (attr = DtdData.getInstance(t2 = (DtdType)((Object)iterator.next())).getAttribute(elementName, attributeName)) == null) {
            }
        }
        return attr;
    }

    Comparator<String> getElementComparator() {
        return this.elementComparator;
    }

    Comparator<String> getAttributeComparator() {
        return this.attributeComparator;
    }

    private static Comparator<String> wrapToHandleUnknownNames(Comparator<String> compare, Predicate<String> isKnown) {
        return (lname, rname) -> {
            if (isKnown.test((String)lname)) {
                return isKnown.test((String)rname) ? compare.compare((String)lname, (String)rname) : -1;
            }
            return isKnown.test((String)rname) ? 1 : lname.compareTo((String)rname);
        };
    }

    boolean isDistinguishingAttribute(String elementName, String attributeName) {
        DtdData.Attribute attribute = this.getAttribute(elementName, attributeName);
        if (attribute != null) {
            return attribute.attributeStatus == DtdData.AttributeStatus.distinguished && !attribute.isDeprecated();
        }
        return false;
    }

    boolean isValueAttribute(String elementName, String attributeName) {
        DtdData.Attribute attribute = this.getAttribute(elementName, attributeName);
        if (attribute != null) {
            return attribute.attributeStatus == DtdData.AttributeStatus.value && !attribute.isDeprecated();
        }
        return true;
    }

    boolean isValueAttribute(AttributeKey key) {
        return this.isValueAttribute(key.getElementName(), key.getAttributeName());
    }

    boolean isOptionalAttribute(AttributeKey key) {
        DtdData.Attribute attribute = this.getAttribute(key.getElementName(), key.getAttributeName());
        return attribute == null || attribute.mode == DtdData.Mode.OPTIONAL;
    }

    static {
        NAME_MAP = Arrays.stream(CldrDataType.values()).collect(ImmutableMap.toImmutableMap(t2 -> t2.mainType.name(), Function.identity()));
    }
}

