/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrDraftStatus;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrPaths;
import org.unicode.cldr.api.CldrValue;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

final class XmlDataSource
implements CldrData {
    private static final Splitter TRIMMING_LINE_SPLITTER = Splitter.on('\n').trimResults().omitEmptyStrings();
    private static final CharMatcher NOT_WHITESPACE = CharMatcher.whitespace().negate();
    private final CldrDataType dtdType;
    private final ImmutableSet<Path> xmlFiles;
    private final CldrDraftStatus minimalDraftStatus;
    private final Function<Path, Reader> openFn;
    private volatile ImmutableMap<CldrPath, CldrValue> pathValueMap = null;
    private volatile boolean isDtdOrder = false;
    private final Object cacheLock = new Object();
    private static ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    XmlDataSource(CldrDataType dtdType, Set<Path> xmlFiles, CldrDraftStatus draftStatus) {
        this(dtdType, xmlFiles, draftStatus, XmlDataSource::openFile);
    }

    XmlDataSource(CldrDataType dtdType, Set<Path> xmlFiles, CldrDraftStatus draftStatus, Function<Path, Reader> openFn) {
        this.xmlFiles = ImmutableSet.copyOf(xmlFiles);
        this.dtdType = dtdType;
        this.minimalDraftStatus = Preconditions.checkNotNull(draftStatus);
        this.openFn = Preconditions.checkNotNull(openFn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CldrPath, CldrValue> getPathValueMap(CldrData.PathOrder order) {
        Object object;
        Object map;
        boolean mustSort = order == CldrData.PathOrder.DTD;
        ImmutableMap<CldrPath, CldrValue> localMapRef = this.pathValueMap;
        if (localMapRef == null) {
            map = mustSort ? new TreeMap() : new LinkedHashMap();
            this.read(arg_0 -> XmlDataSource.lambda$getPathValueMap$0((Map)map, arg_0), this.dtdType, true);
            localMapRef = ImmutableMap.copyOf(map);
            object = this.cacheLock;
            synchronized (object) {
                if (this.pathValueMap == null) {
                    this.pathValueMap = localMapRef;
                    this.isDtdOrder = mustSort;
                    return localMapRef;
                }
            }
        }
        if (mustSort && !this.isDtdOrder) {
            map = ImmutableSortedMap.naturalOrder();
            localMapRef = ((ImmutableMap.Builder)map).putAll(this.pathValueMap).build();
            object = this.cacheLock;
            synchronized (object) {
                if (!this.isDtdOrder) {
                    this.pathValueMap = localMapRef;
                    this.isDtdOrder = true;
                }
            }
        }
        return localMapRef;
    }

    @Override
    public void accept(CldrData.PathOrder order, CldrData.ValueVisitor visitor) {
        this.getPathValueMap(order).values().forEach(visitor::visit);
    }

    @Override
    public CldrValue get(CldrPath path) {
        return this.getPathValueMap(CldrData.PathOrder.ARBITRARY).get(path);
    }

    private static Reader openFile(Path p) {
        try {
            return Files.newBufferedReader(p);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void read(CldrData.ValueVisitor visitor, CldrDataType dtdType, boolean validating) {
        XMLReader xmlReader = XmlDataSource.createXmlReader(validating);
        xmlReader.setErrorHandler(ERROR_HANDLER);
        xmlReader.setContentHandler(new PathValueHandler(visitor, dtdType));
        for (Path p : this.xmlFiles) {
            try {
                Reader r = this.openFn.apply(p);
                try {
                    InputSource src = new InputSource(r);
                    src.setSystemId(p.toString());
                    XmlDataSource.parseXml(xmlReader, src, p);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }

    private static void parseXml(XMLReader xmlReader, InputSource src, Path path) {
        try {
            xmlReader.parse(src);
        }
        catch (IncompatibleDtdException incompatibleDtdException) {
        }
        catch (SAXParseException e) {
            throw new IllegalArgumentException("error reading " + String.valueOf(path) + " (line " + e.getLineNumber() + ")", e);
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("error reading " + String.valueOf(path), e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("\n------------------------------------------------------------------\nUnknown error reading " + String.valueOf(path) + "\n\nThis can sometimes be caused by using a version of Java which does\nnot support all the XML parsing features required by this tool.\nTry setting the JAVA_HOME environment variable to a different Java\nrelease, if possible.\n------------------------------------------------------------------\n>", e);
        }
    }

    private static XMLReader createXmlReader(boolean validating) {
        XMLReader xmlReader;
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", validating);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return xmlReader;
    }

    private boolean hasAllowedDraftStatus(CldrPath path) {
        return path.getDraftStatus().map(s2 -> s2.compareTo(this.minimalDraftStatus) >= 0).orElse(true);
    }

    private static CldrPath extendPath(CldrPath parent, String elementName, Attributes xmlAttributes, int sortIndex, CldrDataType dataType, BiConsumer<AttributeKey, String> valueAttributeCollector) {
        AbstractCollection attributeKeyValuePairs = ImmutableList.of();
        CldrDraftStatus draftStatus = null;
        if (xmlAttributes.getLength() > 0) {
            draftStatus = CldrDraftStatus.forString(xmlAttributes.getValue("draft"));
            Stream<Map.Entry<String, String>> sortedAttributes = IntStream.range(0, xmlAttributes.getLength()).mapToObj(xmlAttributes::getQName).sorted(dataType.getAttributeComparator()).map(s2 -> Maps.immutableEntry(s2, xmlAttributes.getValue((String)s2)));
            ArrayList valueAttributes = new ArrayList();
            CldrPaths.processAttributes(sortedAttributes, elementName, valueAttributeCollector, dataType).forEach(e -> {
                valueAttributes.add((String)e.getKey());
                valueAttributes.add((String)e.getValue());
            });
            attributeKeyValuePairs = valueAttributes;
        }
        return new CldrPath(parent, elementName, (List<String>)((Object)attributeKeyValuePairs), dataType, draftStatus, sortIndex);
    }

    private static /* synthetic */ void lambda$getPathValueMap$0(Map map, CldrValue value) {
        map.put(value.getPath(), value);
    }

    private static final class IncompatibleDtdException
    extends RuntimeException {
        private IncompatibleDtdException() {
        }
    }

    private final class PathValueHandler
    extends DefaultHandler {
        private final CldrData.ValueVisitor visitor;
        private final CldrDataType dataType;
        private final Multiset<String> orderedElementIndices = HashMultiset.create();
        private final Map<AttributeKey, String> valueAttributes = new LinkedHashMap<AttributeKey, String>();
        private CldrPath path = null;
        private StringBuilder elementText = new StringBuilder();
        private boolean wasLeafElement = true;

        private PathValueHandler(CldrData.ValueVisitor visitor, CldrDataType dataType) {
            this.visitor = visitor;
            this.dataType = dataType;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.path == null && !qName.equals(this.dataType.getLdmlName())) {
                throw new IncompatibleDtdException();
            }
            int sortIndex = -1;
            if (CldrPaths.isOrdered(this.dataType, qName)) {
                sortIndex = this.orderedElementIndices.size();
                this.orderedElementIndices.add(qName);
            }
            this.path = XmlDataSource.extendPath(this.path, qName, attributes, sortIndex, this.dataType, this.valueAttributes::put);
            this.elementText.setLength(0);
            this.wasLeafElement = true;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.elementText.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.wasLeafElement) {
                if (XmlDataSource.this.hasAllowedDraftStatus(this.path) && CldrPaths.shouldEmit(this.path)) {
                    Object value = String.join((CharSequence)"\n", TRIMMING_LINE_SPLITTER.split(this.elementText));
                    if (!((String)value).isEmpty()) {
                        int n = NOT_WHITESPACE.indexIn(this.elementText);
                        if (n > 0 && this.elementText.charAt(n) != '\n') {
                            value = Strings.repeat(" ", n) + (String)value;
                        }
                        if ((n = NOT_WHITESPACE.lastIndexIn(this.elementText)) < this.elementText.length() - 1 && this.elementText.charAt(n) != '\n') {
                            value = (String)value + Strings.repeat(" ", this.elementText.length() - 1 - n);
                        }
                    }
                    this.visitor.visit(CldrValue.create((String)value, this.valueAttributes, this.path));
                }
            } else {
                Preconditions.checkState(CharMatcher.whitespace().matchesAllOf(this.elementText), "mixed content found in XML file: %s", (Object)this.path);
            }
            this.elementText.setLength(0);
            this.orderedElementIndices.elementSet().removeIf(s2 -> !this.path.containsElement((String)s2));
            this.path = this.path.getParent();
            this.valueAttributes.keySet().removeIf(k -> k.getElementName().equals(qName));
            this.wasLeafElement = false;
        }
    }
}

