/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

public class GapString
implements CharSequence {
    private static final int GROWTH_INCREMENT = 15;
    private static final int GROWTH_FACTOR = 3;
    private char[] buffer = new char[10];
    private int pastLength = 0;
    private int gapLength = 10;

    public GapString() {
    }

    public GapString(CharSequence s2) {
        this.insert(0, s2);
    }

    @Override
    public char charAt(int index) {
        try {
            return this.buffer[index < this.pastLength ? index : index + this.gapLength];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    @Override
    public int length() {
        return this.buffer.length - this.gapLength;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.buffer, 0, this.pastLength);
        int futureStart = this.pastLength + this.gapLength;
        b.append(this.buffer, futureStart, this.buffer.length - futureStart);
        return b.toString();
    }

    public GapString insert(int index, CharSequence s2, int start, int end) {
        if (s2 instanceof String) {
            return this.insert(index, (String)s2, start, end);
        }
        int gapNeeded = end - start;
        if (this.pastLength != index) {
            this.shiftTo(index, gapNeeded);
        } else {
            int growthNeeded = gapNeeded - this.gapLength;
            if (growthNeeded > 0) {
                this.growToLength((this.buffer.length + growthNeeded) * 3 + 15);
            }
        }
        for (int i = start; i < end; ++i) {
            this.buffer[this.pastLength++] = s2.charAt(i);
        }
        this.gapLength -= gapNeeded;
        return this;
    }

    public GapString insert(int index, CharSequence s2) {
        return this.insert(index, s2, 0, s2.length());
    }

    public GapString insert(int index, String s2) {
        return this.insert(index, s2, 0, s2.length());
    }

    public GapString insert(int index, String s2, int start, int end) {
        int gapNeeded = end - start;
        if (this.pastLength != index) {
            this.shiftTo(index, gapNeeded);
        } else {
            int growthNeeded = gapNeeded - this.gapLength;
            if (growthNeeded > 0) {
                this.growToLength((this.buffer.length + growthNeeded) * 3 + 15);
            }
        }
        s2.getChars(start, end, this.buffer, this.pastLength);
        this.pastLength += end - start;
        this.gapLength -= gapNeeded;
        return this;
    }

    public GapString insert(int index, char[] s2) {
        return this.insert(index, s2, 0, s2.length);
    }

    public GapString insert(int index, char[] s2, int start, int end) {
        int gapNeeded = end - start;
        if (this.pastLength != index) {
            this.shiftTo(index, gapNeeded);
        } else {
            int growthNeeded = gapNeeded - this.gapLength;
            if (growthNeeded > 0) {
                this.growToLength((this.buffer.length + growthNeeded) * 3 + 15);
            }
        }
        System.arraycopy(s2, start, this.buffer, this.pastLength, gapNeeded);
        this.pastLength += end - start;
        this.gapLength -= gapNeeded;
        return this;
    }

    public GapString insert(int index, char s2) {
        if (this.pastLength != index || this.pastLength < index + 1) {
            this.shiftTo(index, 1);
        }
        this.buffer[this.pastLength++] = s2;
        --this.gapLength;
        return this;
    }

    public GapString append(boolean x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString append(char x) {
        return this.insert(this.length(), x);
    }

    public GapString append(char[] x) {
        return this.insert(this.length(), x);
    }

    public GapString append(char[] x, int start, int end) {
        return this.insert(this.length(), x, start, end);
    }

    public GapString append(double x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString append(float x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString append(int x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString append(CharSequence x, int start, int end) {
        return this.insert(this.length(), x, start, end);
    }

    public GapString append(Object x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString append(long x) {
        return this.insert(this.length(), String.valueOf(x));
    }

    public GapString appendCodePoint(int x) {
        return this.insertCodePoint(this.length(), x);
    }

    private GapString insertCodePoint(int index, int x) {
        if (x < 65536) {
            return this.insert(index, (char)x);
        }
        return this.insert(index, Character.toChars(x));
    }

    public GapString append(String s2) {
        return this.insert(this.buffer.length - this.gapLength, s2, 0, s2.length());
    }

    public GapString append(CharSequence string) {
        return this.insert(this.buffer.length - this.gapLength, string);
    }

    public GapString delete(int start, int end) {
        if (this.pastLength >= start && this.pastLength < end) {
            this.pastLength = start;
        } else if (this.pastLength != start) {
            this.shiftTo(start, 0);
        }
        this.gapLength += end - start;
        return this;
    }

    public GapString replace(int start, int end, CharSequence other, int otherStart, int otherEnd) {
        this.delete(start, end);
        return this.insert(start, other, otherStart, otherEnd);
    }

    public GapString compact() {
        if (this.gapLength > 0) {
            this.growToLength(this.buffer.length - this.gapLength);
        }
        return this;
    }

    public boolean equals(Object other) {
        try {
            return this.equals((CharSequence)other);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(CharSequence other) {
        int i;
        int len = this.buffer.length - this.gapLength;
        if (other.length() != len) {
            return false;
        }
        for (i = 0; i < this.pastLength; ++i) {
            if (this.buffer[i] == other.charAt(i)) continue;
            return false;
        }
        int j = i;
        i += this.gapLength;
        while (i < this.buffer.length) {
            if (this.buffer[i] != other.charAt(j++)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 0;
        for (i = 0; i < this.pastLength; ++i) {
            result = 37 * result + this.buffer[i];
        }
        i += this.gapLength;
        while (i < this.buffer.length) {
            result = 37 * result + this.buffer[i];
            ++i;
        }
        return result;
    }

    private void shiftTo(int newPastLength, int gapNeeded) {
        int newMinusOldPastLength;
        int growth = gapNeeded - this.gapLength;
        if (growth > 0) {
            this.growToLength((this.buffer.length + growth) * 3 + 15);
        }
        if ((newMinusOldPastLength = newPastLength - this.pastLength) == 0) {
            return;
        }
        if (newMinusOldPastLength > 0) {
            System.arraycopy(this.buffer, this.pastLength + this.gapLength, this.buffer, this.pastLength, newMinusOldPastLength);
        } else {
            System.arraycopy(this.buffer, newPastLength, this.buffer, this.pastLength + this.gapLength + newMinusOldPastLength, -newMinusOldPastLength);
        }
        this.pastLength = newPastLength;
    }

    private void growToLength(int neededLength) {
        char[] temp = new char[neededLength];
        System.arraycopy(this.buffer, 0, temp, 0, this.pastLength);
        int futureStart = this.pastLength + this.gapLength;
        int futureLength = this.buffer.length - futureStart;
        System.arraycopy(this.buffer, futureStart, temp, neededLength - futureLength, futureLength);
        this.gapLength += neededLength - this.buffer.length;
        this.buffer = temp;
    }
}

