/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.Transform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class Iterables<T>
implements Iterable<T>,
Iterator<T> {
    private List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private Iterator<T> current = null;
    private int position = 0;

    public Iterables<T> and(Iterator<T> iteratorsIn) {
        if (this.current == null) {
            this.current = iteratorsIn;
        }
        this.iterators.add(iteratorsIn);
        return this;
    }

    public Iterables<T> and(Iterable<T> iterable) {
        return this.and(iterable.iterator());
    }

    public Iterables<T> and(T ... iteratorsIn) {
        return this.and((Iterable<T>)Arrays.asList(iteratorsIn));
    }

    public <S> Iterables<T> and(Transform<S, T> transform, Iterator<S> iteratorsIn) {
        return this.and(new TransformIterator<S, T>(transform, iteratorsIn));
    }

    public <S> Iterables<T> and(Transform<S, T> transform, Iterable<S> iteratorsIn) {
        return this.and(new TransformIterator<S, T>(transform, iteratorsIn.iterator()));
    }

    public <S> Iterables<T> and(Transform<S, T> transform, S ... iteratorsIn) {
        return this.and(transform, Arrays.asList(iteratorsIn).iterator());
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (this.current != null) {
            if (this.current.hasNext()) {
                return true;
            }
            ++this.position;
            if (this.position >= this.iterators.size()) {
                this.current = null;
                return false;
            }
            this.current = this.iterators.get(this.position);
        }
        return false;
    }

    @Override
    public T next() {
        return this.current.next();
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    static final class TransformIterator<S, T>
    implements Iterator<T> {
        private Transform<S, T> transform;
        private Iterator<S> iterator;

        public TransformIterator(Transform<S, T> transform, Iterator<S> iterator) {
            this.iterator = iterator;
            this.transform = transform;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.transform.transform(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

