/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

public class UDataInfo {
    public static final byte BIGENDIAN = 1;
    public static final byte ASCII_FAMILY = 0;
    public static final byte SIZE_OF_UCHAR = 2;
    public short size;
    public short reservedWord;
    public byte isBigEndian;
    public byte charsetFamily;
    public byte sizeofUChar;
    public byte reservedByte;
    public byte[] dataFormat;
    public byte[] formatVersion;
    public byte[] dataVersion;

    public UDataInfo(short size, short reservedWord, byte isBigEndian, byte charsetFamily, byte sizeofUChar, byte reservedByte, byte[] dataFormat, byte[] formatVersion, byte[] dataVersion) throws IncorrectArrayLengthException {
        if (dataFormat.length != 4) {
            throw new IncorrectArrayLengthException("The byte array 'dataFormat' must be of length 4.");
        }
        if (formatVersion.length != 4) {
            throw new IncorrectArrayLengthException("The byte array 'formatVersion' must be of length 4.");
        }
        if (dataVersion.length != 4) {
            throw new IncorrectArrayLengthException("The byte array 'dataVersion' must be of length 4.");
        }
        this.size = size;
        this.reservedWord = reservedWord;
        this.isBigEndian = isBigEndian;
        this.charsetFamily = charsetFamily;
        this.sizeofUChar = sizeofUChar;
        this.reservedByte = reservedByte;
        this.dataFormat = dataFormat;
        this.formatVersion = formatVersion;
        this.dataVersion = dataVersion;
    }

    public static short getSize() {
        return 20;
    }

    public byte[] getByteArray() {
        byte[] b = new byte[20];
        byte[] sizeBytes = UDataInfo.shortToBytes(this.size);
        b[0] = sizeBytes[0];
        b[1] = sizeBytes[1];
        b[2] = 0;
        b[3] = 0;
        b[4] = this.isBigEndian;
        b[5] = this.charsetFamily;
        b[6] = this.sizeofUChar;
        b[7] = 0;
        b[8] = this.dataFormat[0];
        b[9] = this.dataFormat[1];
        b[10] = this.dataFormat[2];
        b[11] = this.dataFormat[3];
        b[12] = this.formatVersion[0];
        b[13] = this.formatVersion[1];
        b[14] = this.formatVersion[2];
        b[15] = this.formatVersion[3];
        b[16] = this.dataVersion[0];
        b[17] = this.dataVersion[1];
        b[18] = this.dataVersion[2];
        b[19] = this.dataVersion[3];
        return b;
    }

    private static byte[] shortToBytes(short x) {
        byte[] b = new byte[2];
        int mask = -1;
        b[1] = (byte)(x & mask);
        b[0] = (byte)(x >>> 8 & mask);
        return b;
    }

    class IncorrectArrayLengthException
    extends Exception {
        private static final long serialVersionUID = -3238261375903639881L;

        IncorrectArrayLengthException(String message) {
            super(message);
        }
    }
}

