/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.json.Ldml2JsonConverter;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.PatternCache;

public class LdmlConfigFileReader {
    final List<Ldml2JsonConverter.JSONSection> sections = new ArrayList<Ldml2JsonConverter.JSONSection>();
    final Map<String, String> packages = new TreeMap<String, String>();
    final Map<String, String> dependencies = new HashMap<String, String>();

    public List<Ldml2JsonConverter.JSONSection> getSections() {
        return this.sections;
    }

    public Set<String> getPackages() {
        return this.packages.keySet();
    }

    public Map<String, String> getPackageDescriptions() {
        return this.packages;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public void read(String configFile, Ldml2JsonConverter.RunType type) {
        FileProcessor myReader = new FileProcessor(){

            @Override
            protected boolean handleLine(int lineCount, String line) {
                String[] lineParts = line.trim().split("\\s*;\\s*");
                String section = null;
                String path = null;
                String packageName = null;
                String dependency = null;
                String packageDesc = "A CLDR package with no packageDesc description.";
                boolean hasSection = false;
                boolean hasPath = false;
                boolean hasPackage = false;
                boolean hasDependency = false;
                for (String linePart : lineParts) {
                    int pos = linePart.indexOf(61);
                    if (pos < 0) {
                        throw new IllegalArgumentException();
                    }
                    String key = linePart.substring(0, pos);
                    String value = linePart.substring(pos + 1);
                    if (key.equals("section")) {
                        hasSection = true;
                        section = value;
                        continue;
                    }
                    if (key.equals("path")) {
                        hasPath = true;
                        path = value;
                        continue;
                    }
                    if (key.equals("package")) {
                        hasPackage = true;
                        packageName = value;
                        continue;
                    }
                    if (key.equals("packageDesc")) {
                        packageDesc = value;
                        continue;
                    }
                    if (!key.equals("dependency")) continue;
                    hasDependency = true;
                    dependency = value;
                }
                if (hasSection && hasPath) {
                    Ldml2JsonConverter.JSONSection j = new Ldml2JsonConverter.JSONSection();
                    j.section = section;
                    j.pattern = PatternCache.get(path);
                    if (hasPackage) {
                        j.packageName = packageName;
                    }
                    LdmlConfigFileReader.this.sections.add(j);
                }
                if (hasDependency && hasPackage) {
                    LdmlConfigFileReader.this.dependencies.put(packageName, dependency);
                }
                if (hasPackage) {
                    LdmlConfigFileReader.this.packages.putIfAbsent(packageName, packageDesc);
                }
                return true;
            }
        };
        if (configFile != null) {
            myReader.process(configFile);
        } else {
            switch (type) {
                case main: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config.txt");
                    break;
                }
                case supplemental: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_supplemental.txt");
                    break;
                }
                case segments: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_segments.txt");
                    break;
                }
                case rbnf: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_rbnf.txt");
                    break;
                }
                default: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_" + type.name() + ".txt");
                }
            }
        }
        Ldml2JsonConverter.JSONSection j = new Ldml2JsonConverter.JSONSection();
        j.section = "other";
        j.pattern = PatternCache.get(".*");
        this.sections.add(j);
    }
}

