/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DateConstants;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PatternPlaceholders;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;
import org.unicode.cldr.util.XPathParts;

public class CheckForExemplars
extends FactoryCheckCLDR {
    public static final UnicodeSet RTL_CONTROLS = new UnicodeSet("[\\u061C\\u200E\\u200F]").freeze();
    public static final UnicodeSet ILLEGAL_RTL_CONTROLS = new UnicodeSet("[\\u202A-\\u202E\\u2066-\\u2069]").freeze();
    public static final UnicodeSet LB_JOIN_CONTROLS = new UnicodeSet("[\\u200B\\u2060]").freeze();
    public static final UnicodeSet RTL = new UnicodeSet("[[:bc=AL:][:bc=R:]]").freeze();
    private static final String STAND_IN = "#";
    private static final List<String> FORBIDDEN_VALUES = new ArrayList<String>(Arrays.asList("n/a"));
    private static final String FORBIDDEN_VALUE_MESSAGE = "This value is forbidden for any path. If you believe this item is not an error, add a forum post with an explanation about why this value is not an error. The CLDR Technical Committee will reply to your forum post if they need any more information in order to resolve the error or next steps on how to resolve if they still believe it is an error.";
    static String[] EXEMPLAR_SKIPS = new String[]{"/currencySpacing", "/exemplarCharacters", "/localizedPatternChars", "/segmentations", "/references", "/localeDisplayNames/variants/", "/commonlyUsed", "/defaultNumberingSystem", "/otherNumberingSystems", "/exponential", "/nan", "/scientificFormats", "/inText", "/orientation", "/symbol[@alt=\"narrow\"]", "/characters/parseLenients", "/nameOrderLocales"};
    static String[] DATE_PARTS = new String[]{"/hourFormat", "/dateFormatItem", "/intervalFormatItem", "/dateFormatLength", "timeFormatLength"};
    static final UnicodeSet START_PAREN = new UnicodeSet("[[:Ps:]]").freeze();
    static final UnicodeSet END_PAREN = new UnicodeSet("[[:Pe:]]").freeze();
    static final UnicodeSet UNIT_DISALLOWED_PARENS = new UnicodeSet(START_PAREN).addAll(END_PAREN).removeAll(new UnicodeSet("[\\[\\]\uff3b\uff3d]")).freeze();
    static final UnicodeSet ALL_CURRENCY_SYMBOLS = new UnicodeSet("[[:Sc:]]").freeze();
    static final UnicodeSet LETTER = new UnicodeSet("[[A-Za-z]]").freeze();
    static final UnicodeSet NUMBERS = new UnicodeSet("[[:N:]]").freeze();
    static final UnicodeSet DISALLOWED_HOUR_FORMAT = new UnicodeSet("[[:letter:]]").remove(72).remove(109).freeze();
    static final UnicodeSet DISALLOWED_IN_RANGE = new UnicodeSet("[:L:]").freeze();
    private UnicodeSet exemplars;
    private UnicodeSet exemplarsPlusAscii;
    private static final Pattern IGNORE_PLACEHOLDER_PARENTHESES = PatternCache.get("\\p{Ps}#\\p{Pe}");
    public static final Pattern PLACEHOLDER = PatternCache.get("\\{[0-9a-zA-Z-]+\\}");
    private boolean skip;
    private Collator col;
    private Collator spaceCol;
    UnicodeSetPrettyPrinter prettyPrint;
    private CLDRFile.Status otherPathStatus = new CLDRFile.Status();
    private Matcher patternMatcher = PLACEHOLDER.matcher("");
    private boolean errorDefaultOption;
    private DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
    StringBuilder justText = new StringBuilder();
    public static final Pattern LEAD_OR_TRAIL_WHITESPACE_OK = PatternCache.get("/(references/reference|insertBetween)");
    private Matcher leadOrTrailWhitespaceOk = LEAD_OR_TRAIL_WHITESPACE_OK.matcher("");
    private static UnicodeSet ASCII = new UnicodeSet("[\\u0020-\\u007F]").freeze();
    private PatternPlaceholders patternPlaceholders = PatternPlaceholders.getInstance();
    private SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private Relation scriptToCurrencies;
    static final UnicodeSet ESCAPE = new UnicodeSet("[\u2770\u2771]").freeze();
    static final String TEST = "\u0609";
    static final Normalizer2 NFC = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.COMPOSE);

    public CheckForExemplars(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFile, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        UnicodeSet auxiliary;
        if (cldrFile == null) {
            return this;
        }
        this.skip = true;
        super.handleSetCldrFileToCheck(cldrFile, options, possibleErrors);
        if (cldrFile.getLocaleID().equals("root")) {
            return this;
        }
        this.errorDefaultOption = options.get(CheckCLDR.Options.Option.exemplarErrors) != null;
        String locale = cldrFile.getLocaleID();
        this.col = Collator.getInstance(new ULocale(locale));
        this.spaceCol = Collator.getInstance(new ULocale(locale));
        this.spaceCol.setStrength(0);
        CLDRFile resolvedFile = this.getResolvedCldrFileToCheck();
        boolean[] ok = new boolean[1];
        this.exemplars = this.safeGetExemplars("", possibleErrors, resolvedFile, ok);
        if (this.exemplars == null) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.noExemplarCharacters).setMessage("No Exemplar Characters: {0}", this.getClass().getName());
            possibleErrors.add(item);
            return this;
        }
        this.exemplars = !ok[0] ? new UnicodeSet() : new UnicodeSet(this.exemplars);
        boolean isRTL = RTL.containsSome(this.exemplars);
        if (isRTL) {
            this.exemplars.addAll(RTL_CONTROLS);
        }
        if ((auxiliary = this.safeGetExemplars("auxiliary", possibleErrors, resolvedFile, ok)) != null) {
            this.exemplars.addAll(auxiliary);
        }
        this.exemplars.addAll(CheckExemplars.AlwaysOK).addAll(LB_JOIN_CONTROLS).freeze();
        this.exemplarsPlusAscii = new UnicodeSet(this.exemplars).addAll(ASCII).freeze();
        this.skip = false;
        this.prettyPrint = UnicodeSetPrettyPrinter.ROOT_ICU;
        return this;
    }

    private UnicodeSet getNumberSystemExemplars() {
        String numberSystem = this.getCldrFileToCheck().getStringValue("//ldml/numbers/defaultNumberingSystem");
        String digits = this.sdi.getDigits(numberSystem);
        return new UnicodeSet().addAll(digits);
    }

    private UnicodeSet safeGetExemplars(String type, List<CheckCLDR.CheckStatus> possibleErrors, CLDRFile resolvedFile, boolean[] ok) {
        UnicodeSet result = null;
        try {
            result = resolvedFile.getExemplarSet(type, CLDRFile.WinningChoice.WINNING);
            ok[0] = true;
        }
        catch (IllegalArgumentException iae) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.couldNotAccessExemplars).setMessage("Could not get exemplar set: " + iae.toString()));
            ok[0] = false;
        }
        return result;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        UnicodeSet disallowed;
        if (fullPath == null) {
            return this;
        }
        if (value == null) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        if (this.skip) {
            return this;
        }
        if (path == null) {
            throw new InternalCldrException("Empty path!");
        }
        if (this.getCldrFileToCheck() == null) {
            throw new InternalCldrException("no file to check!");
        }
        String sourceLocale = this.getResolvedCldrFileToCheck().getSourceLocaleID(path, this.otherPathStatus);
        if ("code-fallback".equals(sourceLocale)) {
            return this;
        }
        this.checkIllegalCharacters(value, result);
        this.checkForbiddenValues(value, result);
        if (this.containsPart(path, EXEMPLAR_SKIPS)) {
            return this;
        }
        CheckCLDR.CheckStatus.Type errorOption = this.errorDefaultOption & sourceLocale.equals(this.getResolvedCldrFileToCheck().getLocaleID()) ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
        value = this.checkAndReplacePlaceholders(path, value, result);
        if (path.startsWith("//ldml/numbers/miscPatterns") && path.contains("[@type=\"range\"]") && DISALLOWED_IN_RANGE.containsSome(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("Range patterns should not have letters.", new Object[0]));
        }
        if (this.containsPart(path, DATE_PARTS)) {
            if (!this.extractDatePatternText(value, STAND_IN, this.justText)) {
                return this;
            }
            value = this.justText.toString();
            if (NUMBERS.containsSome(value)) {
                disallowed = new UnicodeSet().addAll(value).retainAll(NUMBERS);
                this.addMissingMessage(disallowed, CheckCLDR.CheckStatus.errorType, CheckCLDR.CheckStatus.Subtype.patternCannotContainDigits, CheckCLDR.CheckStatus.Subtype.patternCannotContainDigits, "cannot occur in date or time patterns", result);
            }
            if (path.endsWith("/hourFormat") && !(disallowed = new UnicodeSet().addAll(value).retainAll(DISALLOWED_HOUR_FORMAT)).isEmpty()) {
                this.addMissingMessage(disallowed, CheckCLDR.CheckStatus.errorType, CheckCLDR.CheckStatus.Subtype.patternContainsInvalidCharacters, CheckCLDR.CheckStatus.Subtype.patternContainsInvalidCharacters, "cannot occur in the hour format", result);
            }
        }
        if (path.startsWith("//ldml/posix/messages")) {
            return this;
        }
        if (path.contains("/currency") && path.contains("/symbol")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                disallowed.removeAll(ALL_CURRENCY_SYMBOLS);
                disallowed.removeAll(LETTER);
                if (disallowed.size() > 0) {
                    this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
                }
            }
        } else if (path.contains("/gmtFormat") || path.contains("/gmtZeroFormat") || path.contains("/gmtUnknownFormat")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                disallowed.removeAll(LETTER);
                if (disallowed.size() > 0) {
                    this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
                }
            }
        } else if (path.contains("/months") || path.contains("/quarters")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                disallowed.removeAll("IVXivx");
                if (path.contains("/calendar[@type=\"generic\"]/months")) {
                    disallowed.removeAll("M");
                }
                if (disallowed.size() > 0) {
                    this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
                }
            }
        } else if (path.contains("/localeDisplayNames") && !path.contains("/localeDisplayPattern")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                if (path.contains("[@type=\"iso8601\"]")) {
                    disallowed.removeAll("ISO");
                }
                if (disallowed.size() > 0) {
                    this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
                }
            }
            if (path.contains("/codePatterns") && !(disallowed = new UnicodeSet().addAll(value).retainAll(NUMBERS)).isEmpty()) {
                this.addMissingMessage(disallowed, CheckCLDR.CheckStatus.errorType, CheckCLDR.CheckStatus.Subtype.patternCannotContainDigits, CheckCLDR.CheckStatus.Subtype.patternCannotContainDigits, "cannot occur in locale fields", result);
            }
        } else if (path.contains("/units")) {
            String noValidParentheses = IGNORE_PLACEHOLDER_PARENTHESES.matcher(value).replaceAll("");
            disallowed = new UnicodeSet().addAll(UNIT_DISALLOWED_PARENS).retainAll(noValidParentheses);
            if (!disallowed.isEmpty()) {
                this.addMissingMessage(disallowed, CheckCLDR.CheckStatus.errorType, CheckCLDR.CheckStatus.Subtype.parenthesesNotAllowed, CheckCLDR.CheckStatus.Subtype.parenthesesNotAllowed, "cannot occur in units", result);
            }
        } else if (path.endsWith("/exemplarCity")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (disallowed != null) {
                if ("root".equals(sourceLocale)) {
                    return this;
                }
                LocaleIDParser parser = new LocaleIDParser().set(sourceLocale);
                String script = parser.getScript();
                if (script.length() == 0) {
                    String localeID = this.sdi.getLikelySubtags().get(sourceLocale);
                    if (localeID == null && (localeID = this.sdi.getLikelySubtags().get(parser.getLanguage())) == null) {
                        throw new IllegalArgumentException("A likely subtag for " + parser.getLanguage() + " is required to get its script.");
                    }
                    script = parser.set(localeID).getScript();
                }
                int myscript = UScript.getCodeFromName(script);
                UnicodeSet toRemove = new UnicodeSet();
                for (int i = 0; i < disallowed.size(); ++i) {
                    int c = disallowed.charAt(i);
                    if (UScript.getScript(c) != myscript) continue;
                    toRemove.add(c);
                }
                disallowed.removeAll(toRemove);
                if (disallowed.size() > 0) {
                    this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
                }
            }
        } else if (path.contains("/annotations") && !path.contains("[@type")) {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                this.addMissingMessage(disallowed, CheckCLDR.CheckStatus.warningType, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
            }
        } else {
            disallowed = this.containsAllCountingParens(this.exemplars, this.exemplarsPlusAscii, value);
            if (null != disallowed) {
                this.addMissingMessage(disallowed, errorOption, CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars, CheckCLDR.CheckStatus.Subtype.asciiCharactersNotInMainOrAuxiliaryExemplars, "are not in the exemplar characters", result);
            }
        }
        if (!(value.equals(value.trim()) || path.contains("SpaceReplacement") || this.leadOrTrailWhitespaceOk.reset(path).find())) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.mustNotStartOrEndWithSpace).setMessage("This item must not start or end with whitespace, or be empty."));
        }
        return this;
    }

    private void checkIllegalCharacters(String value, List<CheckCLDR.CheckStatus> result) {
        if (ILLEGAL_RTL_CONTROLS.containsSome(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharacter).setMessage("Bidi markup can only include LRM RLM ALM, not paired characters such as FSI PDI"));
        } else if (ESCAPE.containsSome(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharacter).setMessage("The characters {0} are illegal", ESCAPE.toPattern(false)));
        }
    }

    private void checkForbiddenValues(String value, List<CheckCLDR.CheckStatus> result) {
        if (FORBIDDEN_VALUES.contains(value.toLowerCase())) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.forbiddenValue).setMessage(FORBIDDEN_VALUE_MESSAGE));
        }
    }

    private String checkAndReplacePlaceholders(String path, String value, List<CheckCLDR.CheckStatus> result) {
        CheckCLDR.CheckStatus.Type statusType = this.getPhase() == CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.warningType : CheckCLDR.CheckStatus.errorType;
        PatternPlaceholders.PlaceholderStatus placeholderStatus = this.patternPlaceholders.getStatus(path);
        Map<String, PatternPlaceholders.PlaceholderInfo> placeholderInfo = this.patternPlaceholders.get(path);
        int minimum = placeholderInfo.size();
        int maximum = placeholderInfo.size();
        if (placeholderStatus == PatternPlaceholders.PlaceholderStatus.LOCALE_DEPENDENT || placeholderStatus == PatternPlaceholders.PlaceholderStatus.MULTIPLE) {
            SupplementalDataInfo sdi;
            PluralRules rules;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            PluralRules.PluralType ptype = PluralRules.PluralType.CARDINAL;
            String keyword = parts.getAttributeValue(-1, "count");
            if (keyword == null) {
                keyword = parts.getAttributeValue(-1, "ordinal");
                ptype = PluralRules.PluralType.ORDINAL;
            }
            if ((rules = (sdi = CLDRConfig.getInstance().getSupplementalDataInfo()).getPluralRules(new ULocale(this.getCldrFileToCheck().getLocaleID()), ptype)) != null) {
                try {
                    if (rules.getUniqueKeywordValue(keyword) != -0.00123456777) {
                        minimum = 0;
                    }
                }
                catch (Exception exception) {}
            }
        } else if (placeholderStatus == PatternPlaceholders.PlaceholderStatus.OPTIONAL) {
            minimum = 1;
        }
        Matcher matcher = this.patternMatcher.reset(value);
        TreeMultiset<String> matchList = TreeMultiset.create();
        while (matcher.find()) {
            matchList.add(matcher.group());
        }
        Set distinctPlaceholders = matchList.elementSet();
        int countDistinctPlaceholders = distinctPlaceholders.size();
        if (countDistinctPlaceholders > 0 && placeholderStatus != PatternPlaceholders.PlaceholderStatus.OPTIONAL) {
            int expected = 0;
            for (String string : distinctPlaceholders) {
                int elementValue = Integer.parseInt(string.substring(1, string.length() - 1), 10);
                if (elementValue != expected) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(statusType).setSubtype(CheckCLDR.CheckStatus.Subtype.gapsInPlaceholderNumbers).setMessage("Placeholders {0} should be strictly increasing, starting at zero.", distinctPlaceholders));
                    break;
                }
                ++expected;
            }
        }
        if (matchList.size() > countDistinctPlaceholders && placeholderStatus != PatternPlaceholders.PlaceholderStatus.MULTIPLE) {
            LinkedHashSet<String> errors = new LinkedHashSet<String>();
            for (Multiset.Entry entry : matchList.entrySet()) {
                if (entry.getCount() <= 1) continue;
                errors.add((String)entry.getElement());
            }
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(statusType).setSubtype(CheckCLDR.CheckStatus.Subtype.duplicatePlaceholders).setMessage("Duplicate placeholders: {0}.", Joiner.on(", ").join(errors)));
        }
        if (countDistinctPlaceholders < minimum) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(statusType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingPlaceholders).setMessage("Need at least {0} placeholder(s), but only have {1}. Placeholders are: {2}", minimum, countDistinctPlaceholders, placeholderInfo));
        } else if (countDistinctPlaceholders > maximum) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(statusType).setSubtype(CheckCLDR.CheckStatus.Subtype.extraPlaceholders).setMessage("Need no more than {0} placeholders, but have too many with {1}.", countDistinctPlaceholders, minimum));
        }
        return matchList.isEmpty() ? value : this.patternMatcher.replaceAll(STAND_IN);
    }

    private boolean asciiNotAllowed(String localeID, String currency) {
        String charOrientation = this.getResolvedCldrFileToCheck().getStringValue("//ldml/layout/orientation/characterOrder");
        if (charOrientation.equals("right-to-left")) {
            return true;
        }
        LocaleIDParser parser = new LocaleIDParser().set(localeID);
        String script = parser.getScript();
        if (script.length() == 0) {
            localeID = this.sdi.getLikelySubtags().get(localeID);
            if (localeID == null && (localeID = this.sdi.getLikelySubtags().get(parser.getLanguage())) == null) {
                throw new IllegalArgumentException("A likely subtag for " + parser.getLanguage() + " is required to get its script.");
            }
            script = parser.set(localeID).getScript();
        }
        if (script.equals("Latn")) {
            return false;
        }
        Set<String> currencies = this.getCurrenciesForScript(script);
        return currencies != null && currencies.contains(currency);
    }

    private Set<String> getCurrenciesForScript(String script) {
        if (this.scriptToCurrencies != null) {
            return this.scriptToCurrencies.get(script);
        }
        Relation<String, String> scriptToTerritories = new Relation<String, String>(new HashMap(), HashSet.class);
        for (String lang : this.sdi.getBasicLanguageDataLanguages()) {
            SupplementalDataInfo.BasicLanguageData langData = this.sdi.getBasicLanguageDataMap(lang).get((Object)SupplementalDataInfo.BasicLanguageData.Type.primary);
            if (langData == null) continue;
            for (String curScript : langData.getScripts()) {
                scriptToTerritories.putAll(curScript, langData.getTerritories());
            }
        }
        Date now = DateConstants.NOW;
        this.scriptToCurrencies = new Relation(new HashMap(), HashSet.class);
        for (Object curScript : scriptToTerritories.keySet()) {
            Set territories = scriptToTerritories.get(curScript);
            HashSet<String> currencies = new HashSet<String>();
            for (String territory : territories) {
                Set<SupplementalDataInfo.CurrencyDateInfo> currencyInfo = this.sdi.getCurrencyDateInfo(territory);
                for (SupplementalDataInfo.CurrencyDateInfo info : currencyInfo) {
                    if (!info.isLegalTender() || info.getEnd().compareTo(now) <= 0) continue;
                    currencies.add(info.getCurrency());
                }
            }
            this.scriptToCurrencies.putAll(curScript, currencies);
        }
        return this.scriptToCurrencies.get(script);
    }

    public boolean extractDatePatternText(String value, String variableReplacement, StringBuilder justText) {
        boolean haveText = false;
        try {
            this.formatParser.set(value);
        }
        catch (Exception e) {
            return false;
        }
        boolean doReplacement = variableReplacement != null && variableReplacement.length() > 0;
        justText.setLength(0);
        for (Object item : this.formatParser.getItems()) {
            if (item instanceof String) {
                justText.append(item);
                haveText = true;
                continue;
            }
            if (!doReplacement) continue;
            justText.append(variableReplacement);
        }
        return haveText;
    }

    public boolean containsPart(String source, String ... segments) {
        for (int i = 0; i < segments.length; ++i) {
            if (source.indexOf(segments[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    private void addMissingMessage(UnicodeSet missing, CheckCLDR.CheckStatus.Type warningVsError, CheckCLDR.CheckStatus.Subtype subtype, CheckCLDR.CheckStatus.Subtype subtypeAscii, String qualifier, List<CheckCLDR.CheckStatus> result) {
        String fixedMissing = this.prettyPrint.format(missing);
        BitSet scripts = new BitSet();
        for (String s2 : missing) {
            int script = UScript.getScript(s2.codePointAt(0));
            if (script == 1 || script == 0) continue;
            scripts.set(script);
        }
        StringBuilder scriptString = new StringBuilder();
        if (!scripts.isEmpty()) {
            scriptString.append("{");
            int i = scripts.nextSetBit(0);
            while (i >= 0) {
                if (scriptString.length() > 1) {
                    scriptString.append(", ");
                }
                scriptString.append(UScript.getName(i));
                i = scripts.nextSetBit(i + 1);
            }
            scriptString.append("}");
        }
        String message = "The characters \u200e{0}\u200e {1} {2}.";
        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(warningVsError).setSubtype(ASCII.containsAll(missing) ? subtypeAscii : subtype).setMessage("The characters \u200e{0}\u200e {1} {2}.", fixedMissing, scriptString, qualifier));
    }

    private UnicodeSet containsAllCountingParens(UnicodeSet exemplarSet, UnicodeSet exemplarSetPlusASCII, String value) {
        UnicodeSet result = null;
        if (exemplarSet.containsAll(value)) {
            return result;
        }
        value = NFC.normalize(value);
        int lastPos = 0;
        while (true) {
            int start = START_PAREN.findIn(value, lastPos, false);
            String outside = value.substring(lastPos, start);
            result = this.addDisallowedItems(exemplarSet, outside, result);
            if (start == value.length()) break;
            int end = END_PAREN.findIn(value, ++start, false);
            String inside = value.substring(start, end);
            result = this.addDisallowedItems(exemplarSetPlusASCII, inside, result);
            if (end == value.length()) break;
            lastPos = end + 1;
        }
        return result;
    }

    private UnicodeSet addDisallowedItems(UnicodeSet exemplarSet, String outside, UnicodeSet result) {
        if (!exemplarSet.containsAll(outside)) {
            if (result == null) {
                result = new UnicodeSet();
            }
            result.addAll(new UnicodeSet().addAll(outside).removeAll(exemplarSet));
        }
        return result;
    }

    static class PlaceholderTransform
    implements Transform<String, Set<String>> {
        PlaceholderTransform() {
        }

        @Override
        public Set<String> transform(String source) {
            String[] parts;
            LinkedHashSet<String> placeholders = new LinkedHashSet<String>();
            for (String part : parts = source.split(";\\s+")) {
                int equalsPos = part.indexOf(61);
                String placeholder = part.substring(0, equalsPos).trim();
                placeholders.add(placeholder);
            }
            return placeholders;
        }
    }
}

