/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.CaseMap;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.BestMinimalPairSamples;
import org.unicode.cldr.test.EmojiSubdivisionNames;
import org.unicode.cldr.test.ExampleCache;
import org.unicode.cldr.test.HelpMessages;
import org.unicode.cldr.test.RelatedDatePathValues;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRFileOverride;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CodePointEscaper;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.EmojiConstants;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PluralSamples;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.ScriptToExemplars;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.SupplementalCalendarData;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.Units;
import org.unicode.cldr.util.XListFormatter;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class ExampleGenerator {
    private static final String FSLASH = "\u2044";
    private static final String ISOLATE_FSLASH = "\u200c\u2044\u200c";
    private static final String INTERNAL = "internal: ";
    private static final String SUBTRACTS = "\u2796";
    private static final String ADDS = "\u2795";
    private static final String HINTS = "\ud83d\udddd\ufe0f";
    private static final String EXAMPLE_OF_INCORRECT = "\u274c  ";
    private static final String EXAMPLE_OF_CAUTION = "\u26a0\ufe0f  ";
    private static final boolean DEBUG_EXAMPLE_GENERATOR = false;
    static final boolean DEBUG_SHOW_HELP = false;
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final String ALT_STAND_ALONE = "[@alt=\"stand-alone\"]";
    private static final String EXEMPLAR_CITY_LOS_ANGELES = "//ldml/dates/timeZoneNames/zone[@type=\"America/Los_Angeles\"]/exemplarCity";
    private static final Pattern URL_PATTERN = Pattern.compile("http://[\\-a-zA-Z0-9]+(\\.[\\-a-zA-Z0-9]+)*([/#][\\-a-zA-Z0-9]+)*");
    private static final SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    static final UnitConverter UNIT_CONVERTER = supplementalDataInfo.getUnitConverter();
    public static final double NUMBER_SAMPLE = 123456.789;
    public static final double NUMBER_SAMPLE_WHOLE = 2345.0;
    public static final TimeZone ZONE_SAMPLE = TimeZone.getTimeZone("America/Indianapolis");
    public static final TimeZone GMT_ZONE_SAMPLE = TimeZone.getTimeZone("Etc/GMT");
    private static final String exampleStart = "<div class='cldr_example'>";
    private static final String exampleStartAuto = "<div class='cldr_example_auto' dir='auto'>";
    private static final String exampleStartRTL = "<div class='cldr_example_rtl' dir='rtl'>";
    private static final String exampleStartHeader = "<div class='cldr_example_rtl'>";
    private static final String exampleEnd = "</div>";
    private static final String startItalic = "<i>";
    private static final String endItalic = "</i>";
    private static final String startSup = "<sup>";
    private static final String endSup = "</sup>";
    private static final String startSub = "<sub>";
    private static final String endSub = "</sub>";
    private static final String backgroundAutoStart = "<span class='cldr_background_auto'>";
    private static final String backgroundAutoEnd = "</span>";
    private String backgroundStart = "<span class='cldr_substituted'>";
    private String backgroundEnd = "</span>";
    public static final String backgroundStartSymbol = "\ue234";
    public static final String backgroundEndSymbol = "\ue235";
    private static final String backgroundTempSymbol = "\ue236";
    private static final String exampleSeparatorSymbol = "\ue237";
    private static final String startItalicSymbol = "\ue238";
    private static final String endItalicSymbol = "\ue239";
    private static final String startSupSymbol = "\ue23a";
    private static final String endSupSymbol = "\ue23b";
    private static final String backgroundAutoStartSymbol = "\ue23c";
    private static final String backgroundAutoEndSymbol = "\ue23d";
    private static final String exampleStartAutoSymbol = "\ue23e";
    private static final String exampleStartRTLSymbol = "\ue23f";
    private static final String exampleStartHeaderSymbol = "\ue240";
    private static final String exampleEndSymbol = "\ue241";
    private static final String startSubSymbol = "\ue242";
    private static final String endSubSymbol = "\ue243";
    private static final String contextheader = "Key: \ue23cneutral\ue23d, RTL";
    public static final char TEXT_VARIANT = '\ufe0e';
    private static final UnicodeSet BIDI_MARKS = new UnicodeSet("[:Bidi_Control:]").freeze();
    public static final Date DATE_SAMPLE;
    private static final Date DATE_SAMPLE2;
    private static final Date DATE_SAMPLE3;
    private static final Date DATE_SAMPLE4;
    private static final Date DATE_SAMPLE5;
    static final List<DecimalQuantity> CURRENCY_SAMPLES;
    public static final Pattern PARAMETER;
    public static final Pattern PARAMETER_SKIP0;
    public static final Pattern ALL_DIGITS;
    private static final Calendar generatingCalendar;
    private static final Date FIRST_INTERVAL;
    private static final Map<String, Date> SECOND_INTERVAL;
    private static final Date FIRST_INTERVAL2;
    private static final Map<String, Date> SECOND_INTERVAL2;
    private boolean verboseErrors = false;
    private final Calendar calendar = Calendar.getInstance(ZONE_SAMPLE, ULocale.ENGLISH);
    private final CLDRFile cldrFile;
    private final CLDRFile englishFile;
    private CLDRFile cyrillicFile;
    private CLDRFile japanFile;
    private final BestMinimalPairSamples bestMinimalPairSamples;
    private final ExampleCache exCache = new ExampleCache();
    private final ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    private final SupplementalDataInfo.PluralInfo pluralInfo;
    private final GrammarInfo grammarInfo;
    private PluralSamples patternExamples;
    private final Map<String, String> subdivisionIdToName;
    private String creationTime = null;
    private final IntervalFormat intervalFormat = new IntervalFormat();
    private PathDescription pathDescription;
    private final boolean typeIsEnglish;
    private final boolean isRTL;
    HelpMessages helpMessages;
    public static final Map<String, List<String>> COUNTS;
    private static final CaseMap.Title TITLECASE;
    static final SimpleUnicodeSetFormatter SUSF;
    static final SimpleUnicodeSetFormatter SUSFNS;
    static final String LRM = "\u200e";
    static final UnicodeSet NEEDS_LRM;
    private static final boolean SHOW_NON_SPACING_IN_UNICODE_SET = true;
    PersonNamesCache personNamesCache = this.exCache.registerCache(new PersonNamesCache(), "//ldml/personNames/sampleName[@item=\"([^\"]*+)\"]/nameField[@type=\"([^\"]*+)\"]", "//ldml/personNames/initialPattern[@type=\"([^\"]*+)\"]", "//ldml/personNames/foreignSpaceReplacement", "//ldml/personNames/nativeSpaceReplacement", "//ldml/personNames/personName[@order=\"([^\"]*+)\"][@length=\"([^\"]*+)\"][@usage=\"([^\"]*+)\"][@formality=\"([^\"]*+)\"]/namePattern");
    private static final Function<String, String> BACKGROUND_TRANSFORM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDate(int year, int month, int date, int hour, int minute, int second) {
        Calendar calendar = generatingCalendar;
        synchronized (calendar) {
            generatingCalendar.setTimeZone(GMT_ZONE_SAMPLE);
            generatingCalendar.set(year, month, date, hour, minute, second);
            return generatingCalendar.getTime();
        }
    }

    public void setCachingEnabled(boolean enabled) {
        this.exCache.setCachingEnabled(enabled);
        this.icuServiceBuilder.setCachingEnabled(enabled);
    }

    public CLDRFile getCldrFile() {
        return this.cldrFile;
    }

    public void updateCache(String xpath) {
        this.exCache.update(xpath);
        this.icuServiceBuilder.clearCache();
    }

    public String getBackgroundEnd() {
        return this.backgroundEnd;
    }

    public void setBackgroundEnd(String backgroundEnd) {
        this.backgroundEnd = backgroundEnd;
    }

    public String getBackgroundStart() {
        return this.backgroundStart;
    }

    public void setBackgroundStart(String backgroundStart) {
        this.backgroundStart = backgroundStart;
    }

    public void setVerboseErrors(boolean verbosity) {
        this.verboseErrors = verbosity;
    }

    public ExampleGenerator(CLDRFile resolvedCldrFile) {
        this(resolvedCldrFile, CLDRConfig.getInstance().getEnglish());
    }

    public ExampleGenerator(CLDRFile resolvedCldrFile, CLDRFile englishFile) {
        if (!resolvedCldrFile.isResolved()) {
            throw new IllegalArgumentException("CLDRFile must be resolved");
        }
        if (!englishFile.isResolved()) {
            throw new IllegalArgumentException("English CLDRFile must be resolved");
        }
        this.cldrFile = resolvedCldrFile;
        String localeId = this.cldrFile.getLocaleID();
        this.subdivisionIdToName = EmojiSubdivisionNames.getSubdivisionIdToName(localeId);
        this.pluralInfo = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, localeId);
        this.grammarInfo = supplementalDataInfo.getGrammarInfo(localeId);
        this.englishFile = englishFile;
        this.typeIsEnglish = resolvedCldrFile == englishFile;
        this.icuServiceBuilder.setCldrFile(resolvedCldrFile);
        this.bestMinimalPairSamples = new BestMinimalPairSamples(this.cldrFile, this.icuServiceBuilder, false);
        String characterOrder = this.cldrFile.getStringValue("//ldml/layout/orientation/characterOrder");
        this.isRTL = characterOrder != null && characterOrder.equals("right-to-left");
    }

    public String getExampleHtml(String xpath, String value) {
        return this.getExampleHtmlExtended(xpath, value, false);
    }

    public String getNonTrivialExampleHtml(String xpath, String value) {
        return this.getExampleHtmlExtended(xpath, value, true);
    }

    private String getExampleHtmlExtended(String xpath, String value, boolean nonTrivial) {
        Object result;
        if (value == null || xpath == null || xpath.endsWith("/alias")) {
            return null;
        }
        try {
            if (CldrUtility.INHERITANCE_MARKER.equals(value) && (value = this.cldrFile.getBaileyValue(xpath, null, null)) == null) {
                return null;
            }
            result = this.exCache.computeIfAbsent(xpath, value, (star, x, v) -> this.constructExampleHtml((String)x, (String)v, nonTrivial));
        }
        catch (RuntimeException e) {
            String unchained = this.verboseErrors ? "<br>" + this.finalizeBackground(ExampleGenerator.unchainException(e)) : "";
            result = "<i>Parsing error. " + this.finalizeBackground(e.getMessage()) + endItalic + unchained;
        }
        return result;
    }

    private String constructExampleHtml(String xpath, String value, boolean nonTrivial) {
        ArrayList<String> examples = new ArrayList<String>();
        this.constructExampleHtmlExtended(xpath, value, examples);
        String result = this.formatExampleList(examples);
        if (result != null) {
            result = nonTrivial && value.equals(result) ? null : this.finalizeBackground(result);
        }
        return result;
    }

    private void constructExampleHtmlExtended(String xpath, String value, List<String> examples) {
        boolean showContexts = this.isRTL || BIDI_MARKS.containsSome(value);
        XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
        if (parts.contains("dateRangePattern")) {
            this.handleDateRangePattern(value, examples);
        } else if (parts.contains("timeZoneNames")) {
            this.handleTimeZoneName(parts, value, examples);
        } else if (parts.contains("localeDisplayNames")) {
            this.handleDisplayNames(xpath, parts, value, examples);
        } else if (parts.contains("currency")) {
            this.handleCurrency(xpath, parts, value, examples);
        } else if (parts.contains("eras")) {
            this.handleEras(parts, value, examples);
        } else if (parts.contains("quarters")) {
            this.handleQuarters(parts, value, examples);
        } else if (parts.contains("relative") || parts.contains("relativeTime") || parts.contains("relativePeriod")) {
            this.handleRelative(xpath, parts, value, examples);
        } else if (parts.contains("dayPeriods")) {
            this.handleDayPeriod(parts, value, examples);
        } else if (parts.contains("monthContext")) {
            this.handleDateSymbol(parts, value, examples);
        } else if (parts.contains("pattern") || parts.contains("dateFormatItem")) {
            if (parts.contains("calendar")) {
                this.handleDateFormatItem(xpath, value, showContexts, examples);
            } else if (parts.contains("miscPatterns")) {
                this.handleMiscPatterns(parts, value, examples);
            } else if (parts.contains("numbers")) {
                if (parts.contains("currencyFormat")) {
                    this.handleCurrencyFormat(parts, value, showContexts, examples);
                } else if (!parts.contains("rationalFormats")) {
                    this.handleDecimalFormat(parts, value, showContexts, examples);
                }
            }
        } else if (parts.contains("rationalFormats")) {
            this.handleRationalFormat(parts, value, showContexts, examples);
        } else if (parts.contains("minimumGroupingDigits")) {
            this.handleMinimumGrouping(parts, value, examples);
        } else if (parts.getElement(2).contains("symbols")) {
            this.handleNumberSymbol(parts, value, examples);
        } else if (parts.contains("defaultNumberingSystem") || parts.contains("otherNumberingSystems")) {
            this.handleNumberingSystem(value, examples);
        } else if (parts.contains("currencyFormats") && parts.contains("unitPattern")) {
            this.formatCountValue(xpath, parts, value, examples);
        } else if (parts.getElement(-1).equals("compoundUnitPattern")) {
            this.handleCompoundUnit(parts, examples);
        } else if (parts.getElement(-1).equals("compoundUnitPattern1") || parts.getElement(-1).equals("unitPrefixPattern")) {
            this.handleCompoundUnit1(parts, value, examples);
        } else if (parts.getElement(-2).equals("unit") && (parts.getElement(-1).equals("unitPattern") || parts.getElement(-1).equals("displayName"))) {
            this.handleFormatUnit(parts, value, examples);
        } else if (parts.getElement(-1).equals("perUnitPattern")) {
            this.handleFormatPerUnit(value, examples);
        } else if (parts.getElement(-2).equals("minimalPairs")) {
            this.handleMinimalPairs(parts, value, examples);
        } else if (parts.getElement(-1).equals("durationUnitPattern")) {
            this.handleDurationUnit(value, examples);
        } else if (parts.contains("intervalFormats")) {
            this.handleIntervalFormats(parts, value, examples);
        } else if (parts.getElement(1).equals("delimiters")) {
            this.handleDelimiters(parts, xpath, value, examples);
        } else if (parts.getElement(1).equals("listPatterns")) {
            this.handleListPatterns(parts, value, examples);
        } else if (parts.getElement(2).equals("ellipsis")) {
            this.handleEllipsis(parts.getAttributeValue(-1, "type"), value, examples);
        } else if (parts.getElement(-1).equals("monthPattern")) {
            this.handleMonthPatterns(parts, value, examples);
        } else if (parts.getElement(-1).equals("appendItem")) {
            this.handleAppendItems(parts, value, examples);
        } else if (parts.getElement(-1).equals("annotation")) {
            this.handleAnnotationName(parts, value, examples);
        } else if (parts.getElement(-1).equals("characterLabel")) {
            this.handleLabel(parts, value, examples);
        } else if (parts.getElement(-1).equals("characterLabelPattern")) {
            this.handleLabelPattern(parts, value, examples);
        } else if (parts.getElement(1).equals("personNames")) {
            this.handlePersonName(parts, value, examples);
        } else if (parts.getElement(-1).equals("exemplarCharacters") || parts.getElement(-1).equals("parseLenient")) {
            this.handleUnicodeSet(parts, xpath, value, examples);
        }
    }

    private void handleUnicodeSet(XPathParts parts, String xpath, String value, List<String> examples) {
        UnicodeSet valueSet;
        try {
            valueSet = new UnicodeSet(value);
        }
        catch (Exception e) {
            return;
        }
        String winningValue = this.cldrFile.getWinningValue(xpath);
        if (!winningValue.equals(value)) {
            UnicodeSet winningSet = new UnicodeSet(winningValue);
            UnicodeSet value_minus_winning = new UnicodeSet(valueSet).removeAll(winningSet);
            UnicodeSet winning_minus_value = new UnicodeSet(winningSet).removeAll(valueSet);
            if (!value_minus_winning.isEmpty()) {
                examples.add("\u200e\u2795 " + SUSF.format(value_minus_winning));
            }
            if (!winning_minus_value.isEmpty()) {
                examples.add("\u200e\u2796 " + SUSF.format(winning_minus_value));
            }
        }
        if (parts.containsAttributeValue("type", "auxiliary")) {
            LanguageTagParser ltp = new LanguageTagParser();
            String ltpScript = ltp.set(this.cldrFile.getLocaleID()).getResolvedScript();
            UnicodeSet exemplars = ScriptToExemplars.getExemplars(ltpScript);
            UnicodeSet main = this.cldrFile.getExemplarSet(CLDRFile.ExemplarType.main, CLDRFile.WinningChoice.WINNING);
            UnicodeSet mainAndAux = new UnicodeSet(main).addAll(valueSet);
            if (!mainAndAux.containsAll(exemplars)) {
                examples.add("\u200e\ud83d\udddd\ufe0f " + SUSF.format(new UnicodeSet(exemplars).removeAll(mainAndAux)));
            }
        }
        if (valueSet.containsSome(CodePointEscaper.FORCE_ESCAPE)) {
            for (String nsm : new UnicodeSet(valueSet).retainAll(CodePointEscaper.FORCE_ESCAPE)) {
                examples.add(CodePointEscaper.toExample(nsm.codePointAt(0)));
            }
        }
        examples.add(this.setBackground(INTERNAL) + valueSet.toPattern(false));
    }

    private void handlePersonName(XPathParts parts, String value, List<String> examples) {
        Object debugState = "start";
        try {
            PersonNameFormatter.FormatParameters formatParameters = new PersonNameFormatter.FormatParameters(PersonNameFormatter.Order.from(parts.getAttributeValue(2, "order")), PersonNameFormatter.Length.from(parts.getAttributeValue(2, "length")), PersonNameFormatter.Usage.from(parts.getAttributeValue(2, "usage")), PersonNameFormatter.Formality.from(parts.getAttributeValue(2, "formality")));
            CLDRFile cldrFile2 = this.getCldrFile();
            switch (parts.getElement(2)) {
                case "nameOrderLocales": {
                    NameGetter nameGetter2 = cldrFile2.nameGetter();
                    for (String localeId : PersonNameFormatter.SPLIT_SPACE.split(value)) {
                        String name = localeId.equals("und") ? "\u00abany other\u00bb" : nameGetter2.getNameFromIdentifier(localeId);
                        examples.add(localeId + " = " + name);
                    }
                    break;
                }
                case "personName": {
                    Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames = this.personNamesCache.getSampleNames(cldrFile2);
                    PersonNameFormatter personNameFormatter = this.personNamesCache.getPersonNameFormatter(cldrFile2);
                    boolean lastIsNative = false;
                    for (Map.Entry<PersonNameFormatter.SampleType, SimpleNameObject> typeAndSampleNameObject : sampleNames.entrySet()) {
                        PersonNameFormatter.NamePattern namePattern = PersonNameFormatter.NamePattern.from(0, value);
                        boolean isNative = typeAndSampleNameObject.getKey().isNative();
                        if (isNative != lastIsNative) {
                            String title = isNative ? "\ud83d\udfe8 Native name and script:" : "\ud83d\udfe7 Foreign name and native script:";
                            examples.add(startItalicSymbol + title + endItalicSymbol);
                            lastIsNative = isNative;
                        }
                        debugState = "<NamePattern.from: " + String.valueOf(namePattern);
                        PersonNameFormatter.FallbackFormatter fallbackInfo = personNameFormatter.getFallbackInfo();
                        debugState = "<getFallbackInfo: " + String.valueOf(fallbackInfo);
                        PersonNameFormatter.TransformingNameObject nameObject = new PersonNameFormatter.TransformingNameObject((PersonNameFormatter.NameObject)typeAndSampleNameObject.getValue(), BACKGROUND_TRANSFORM);
                        String result = namePattern.format(nameObject, formatParameters, fallbackInfo);
                        debugState = "<namePattern.format: " + result;
                        examples.add(result);
                    }
                    String script = new LikelySubtags().getLikelyScript(this.cldrFile.getLocaleID());
                    Output<Boolean> haveHeaderLine = new Output<Boolean>(false);
                    if (!script.equals("Latn")) {
                        this.formatSampleName(formatParameters, this.englishFile, examples, haveHeaderLine);
                    }
                    if (!script.equals("Cyrl")) {
                        this.formatSampleName(formatParameters, PersonNameScripts.Cyrl, examples, haveHeaderLine);
                    }
                    if (script.equals("Jpan")) break;
                    this.formatSampleName(formatParameters, PersonNameScripts.Jpan, examples, haveHeaderLine);
                }
            }
        }
        catch (Exception e) {
            StringBuffer stackTrace;
            try (StringWriter sw = new StringWriter();
                 PrintWriter p = new PrintWriter(sw);){
                e.printStackTrace(p);
                stackTrace = sw.getBuffer();
            }
            catch (Exception e2) {
                stackTrace = new StringBuffer("internal error");
            }
            examples.add("Internal error: " + e.getMessage() + "\n" + (String)debugState + "\n" + String.valueOf(stackTrace));
        }
    }

    public void formatSampleName(PersonNameFormatter.FormatParameters formatParameters, PersonNameScripts script, List<String> examples, Output<Boolean> haveHeaderLine) {
        switch (script) {
            case Cyrl: {
                if (this.cyrillicFile == null) {
                    this.cyrillicFile = CLDRConfig.getInstance().getCldrFactory().make("uk", true);
                }
                this.formatSampleName(formatParameters, this.cyrillicFile, examples, haveHeaderLine);
                break;
            }
            case Jpan: {
                if (this.japanFile == null) {
                    this.japanFile = CLDRConfig.getInstance().getCldrFactory().make("ja", true);
                }
                this.formatSampleName(formatParameters, this.japanFile, examples, haveHeaderLine);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void formatSampleName(PersonNameFormatter.FormatParameters formatParameters, CLDRFile cldrFile2, List<String> examples, Output<Boolean> haveHeaderLine) {
        String result2;
        PersonNameFormatter formatter2 = new PersonNameFormatter(cldrFile2);
        Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames2 = PersonNameFormatter.loadSampleNames(cldrFile2);
        SimpleNameObject sampleName = this.getBestAvailable(sampleNames2, PersonNameFormatter.SampleType.nativeFull, PersonNameFormatter.SampleType.nativeGGS);
        if (sampleName != null && (result2 = formatter2.format(new PersonNameFormatter.TransformingNameObject((PersonNameFormatter.NameObject)sampleName, BACKGROUND_TRANSFORM), formatParameters)) != null) {
            if (!((Boolean)haveHeaderLine.value).booleanValue()) {
                haveHeaderLine.value = Boolean.TRUE;
                examples.add("\ue238\ud83d\udfe5 Foreign name and script:\ue239");
            }
            examples.add(result2);
        }
    }

    private SimpleNameObject getBestAvailable(Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNamesMap, PersonNameFormatter.SampleType ... sampleTypes) {
        for (PersonNameFormatter.SampleType sampleType : sampleTypes) {
            SimpleNameObject result = sampleNamesMap.get((Object)sampleType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void handleLabelPattern(XPathParts parts, String value, List<String> examples) {
        if ("category-list".equals(parts.getAttributeValue(-1, "type"))) {
            CLDRFile cfile = this.getCldrFile();
            SimpleFormatter initialPattern = SimpleFormatter.compile(this.setBackground(value));
            String path = NameType.TERRITORY.getKeyPath("FR");
            String regionName = cfile.getStringValue(path);
            String flagName = cfile.getStringValue("//ldml/characterLabels/characterLabel[@type=\"flag\"]");
            examples.add(this.invertBackground(EmojiConstants.getEmojiFromRegionCodes("FR") + " \u21d2 " + initialPattern.format(flagName, regionName)));
        }
    }

    private void handleLabel(XPathParts parts, String value, List<String> examples) {
        switch (parts.getAttributeValue(-1, "type")) {
            case "flag": {
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                CLDRFile cfile = this.getCldrFile();
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                this.addFlag(value2, "FR", cfile, initialPattern, examples);
                this.addFlag(value2, "CN", cfile, initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbeng", initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbsct", initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbwls", initialPattern, examples);
                return;
            }
            case "keycap": {
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                CLDRFile cfile = this.getCldrFile();
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                examples.add(this.invertBackground(initialPattern.format(value2, "1")));
                examples.add(this.invertBackground(initialPattern.format(value2, "10")));
                examples.add(this.invertBackground(initialPattern.format(value2, "#")));
                return;
            }
        }
    }

    private void addFlag(String value2, String isoRegionCode, CLDRFile cfile, SimpleFormatter initialPattern, List<String> examples) {
        String path = NameType.TERRITORY.getKeyPath(isoRegionCode);
        String regionName = cfile.getStringValue(path);
        examples.add(this.invertBackground(EmojiConstants.getEmojiFromRegionCodes(isoRegionCode) + " \u21d2 " + initialPattern.format(value2, regionName)));
    }

    private void addSubdivisionFlag(String value2, String isoSubdivisionCode, SimpleFormatter initialPattern, List<String> examples) {
        String subdivisionName = this.subdivisionIdToName.get(isoSubdivisionCode);
        if (subdivisionName == null) {
            subdivisionName = isoSubdivisionCode;
        }
        examples.add(this.invertBackground(EmojiConstants.getEmojiFromSubdivisionCodes(isoSubdivisionCode) + " \u21d2 " + initialPattern.format(value2, subdivisionName)));
    }

    private void handleAnnotationName(XPathParts parts, String value, List<String> examples) {
        if (!"tts".equals(parts.getAttributeValue(-1, "type"))) {
            return;
        }
        String cp = parts.getAttributeValue(-1, "cp");
        if (cp == null || cp.isEmpty()) {
            return;
        }
        int first = cp.codePointAt(0);
        switch (first) {
            case 128106: {
                examples.add(this.formatGroup(value, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc67", "\ud83d\udc66"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66", "\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc66"));
                break;
            }
            case 128143: {
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc68"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc69"));
                break;
            }
            case 128145: {
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc68"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc69"));
                break;
            }
            default: {
                boolean isSkin = EmojiConstants.MODIFIERS.contains(first);
                if (!isSkin && !EmojiConstants.HAIR.contains(first)) break;
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                CLDRFile cfile = this.getCldrFile();
                String skin = "\ud83c\udffd";
                Object hair = "\ud83e\uddb0";
                String skinName = this.getEmojiName(cfile, skin);
                String hairName = this.getEmojiName(cfile, (String)hair);
                if (hairName == null) {
                    hair = "[missing]";
                }
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                SimpleFormatter listPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/listPatterns/listPattern[@type=\"unit-short\"]/listPatternPart[@type=\"2\"]"));
                hair = EmojiConstants.JOINER_STRING + (String)hair;
                this.formatPeople(cfile, first, isSkin, value2, "\ud83d\udc69", skin, skinName, (String)hair, hairName, initialPattern, listPattern, examples);
                this.formatPeople(cfile, first, isSkin, value2, "\ud83d\udc68", skin, skinName, (String)hair, hairName, initialPattern, listPattern, examples);
            }
        }
    }

    private String getEmojiName(CLDRFile cfile, String skin) {
        return cfile.getStringValue("//ldml/annotations/annotation[@cp=\"" + skin + "\"][@type=\"tts\"]");
    }

    private String formatGroup(String value, String sourceEmoji, String ... components) {
        CLDRFile cfile = this.getCldrFile();
        SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
        String value2 = backgroundEndSymbol + value + backgroundStartSymbol;
        String[] names = new String[components.length];
        int i = 0;
        for (String component : components) {
            names[i++] = this.getEmojiName(cfile, component);
        }
        return backgroundStartSymbol + sourceEmoji + " \u21d2 " + initialPattern.format(value2, this.longListPatternExample(EmojiConstants.COMPOSED_NAME_LIST.getPath(), "n/a", "n/a2", names));
    }

    private void formatPeople(CLDRFile cfile, int first, boolean isSkin, String value2, String person, String skin, String skinName, String hair, String hairName, SimpleFormatter initialPattern, SimpleFormatter listPattern, Collection<String> examples) {
        String personName = this.getEmojiName(cfile, person);
        StringBuilder emoji = new StringBuilder(person).appendCodePoint(first);
        String cp = UTF16.valueOf(first);
        cp = isSkin ? cp : EmojiConstants.JOINER_STRING + cp;
        examples.add(person + cp + " \u21d2 " + this.invertBackground(initialPattern.format(personName, value2)));
        emoji.setLength(0);
        emoji.append(personName);
        if (isSkin) {
            skinName = value2;
            skin = cp;
        } else {
            hairName = value2;
            hair = cp;
        }
        examples.add(person + skin + hair + " \u21d2 " + this.invertBackground(listPattern.format(initialPattern.format(personName, skinName), hairName)));
    }

    private void handleDayPeriod(XPathParts parts, String value, List<String> examples) {
        String dayPeriodType = parts.getAttributeValue(5, "type");
        if (dayPeriodType == null) {
            return;
        }
        DayPeriodInfo.Type aType = dayPeriodType.equals("format") ? DayPeriodInfo.Type.format : DayPeriodInfo.Type.selection;
        DayPeriodInfo dayPeriodInfo = supplementalDataInfo.getDayPeriods(aType, this.cldrFile.getLocaleID());
        String periodString = parts.getAttributeValue(-1, "type");
        if (periodString == null) {
            return;
        }
        DayPeriodInfo.DayPeriod dayPeriod = DayPeriodInfo.DayPeriod.valueOf(periodString);
        String periods = dayPeriodInfo.toString(dayPeriod);
        examples.add(periods);
        if ("format".equals(dayPeriodType)) {
            Row.R3<Integer, Integer, Boolean> info;
            if (value == null) {
                value = "\ufffd";
            }
            if ((info = dayPeriodInfo.getFirstDayPeriodInfo(dayPeriod)) != null) {
                int time = ((Integer)info.get0() + (Integer)info.get1()) % 86400000 / 2;
                String timeFormatString = this.icuServiceBuilder.formatDayPeriod(time, backgroundStartSymbol + value + backgroundEndSymbol);
                examples.add(this.invertBackground(timeFormatString));
            }
        }
    }

    private void handleDateSymbol(XPathParts parts, String value, List<String> examples) {
        String checkPath;
        String dateFormat;
        int skeletonIndex;
        String length = parts.findAttributeValue("monthWidth", "type");
        if (length.equals("narrow")) {
            return;
        }
        String context = parts.findAttributeValue("monthContext", "type");
        String calendarId = parts.findAttributeValue("calendar", "type");
        String monthNumId = parts.findAttributeValue("month", "type");
        String[] skeletons = new String[]{"yMMMMd", "yMMMd", "yMMMM", "yMMM"};
        int n = skeletonIndex = length.equals("wide") ? 0 : 1;
        if (!context.equals("format")) {
            skeletonIndex += 2;
        }
        if ((dateFormat = this.cldrFile.getWinningValue(checkPath = "//ldml/dates/calendars/calendar[@type=\"" + calendarId + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeletons[skeletonIndex] + "\"]")) == null || dateFormat.indexOf("MMM") < 0) {
            skeletonIndex = length.equals("wide") ? skeletonIndex + 1 : skeletonIndex - 1;
            checkPath = "//ldml/dates/calendars/calendar[@type=\"" + calendarId + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeletons[skeletonIndex] + "\"]";
            dateFormat = this.cldrFile.getWinningValue(checkPath);
        }
        if (dateFormat == null) {
            return;
        }
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendarId, dateFormat);
        sdf.setTimeZone(ZONE_SAMPLE);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        String[] monthNames = dfs.getMonths(0, 1);
        monthNames[8] = value;
        dfs.setMonths(monthNames, 0, 1);
        monthNames = dfs.getMonths(0, 0);
        monthNames[8] = value;
        dfs.setMonths(monthNames, 0, 0);
        monthNames = dfs.getMonths(1, 1);
        monthNames[8] = value;
        dfs.setMonths(monthNames, 1, 1);
        monthNames = dfs.getMonths(1, 0);
        monthNames[8] = value;
        dfs.setMonths(monthNames, 1, 0);
        sdf.setDateFormatSymbols(dfs);
        examples.add(sdf.format(DATE_SAMPLE));
    }

    private void handleMinimalPairs(XPathParts parts, String minimalPattern, List<String> examples) {
        String sampleBad;
        String sample;
        Output<String> output = new Output<String>();
        String locale = this.getCldrFile().getLocaleID();
        switch (parts.getElement(-1)) {
            case "ordinalMinimalPairs": {
                String count = parts.getAttributeValue(-1, "ordinal");
                sample = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.ordinal, count);
                String otherCount = ExampleGenerator.getOtherCount(locale, SupplementalDataInfo.PluralType.ordinal, count);
                sampleBad = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.ordinal, otherCount);
                break;
            }
            case "pluralMinimalPairs": {
                String count = parts.getAttributeValue(-1, "count");
                sample = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, count);
                String otherCount = ExampleGenerator.getOtherCount(locale, SupplementalDataInfo.PluralType.cardinal, count);
                sampleBad = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, otherCount);
                break;
            }
            case "caseMinimalPairs": {
                String gCase = parts.getAttributeValue(-1, "case");
                sample = this.bestMinimalPairSamples.getBestUnitWithCase(gCase, output);
                sampleBad = this.getOtherCase(sample);
                break;
            }
            case "genderMinimalPairs": {
                String gender = parts.getAttributeValue(-1, "gender");
                sample = this.bestMinimalPairSamples.getBestUnitWithGender(gender, output);
                String otherGender = this.getOtherGender(gender);
                sampleBad = this.bestMinimalPairSamples.getBestUnitWithGender(otherGender, output);
                break;
            }
            default: {
                return;
            }
        }
        String formattedUnit = ExampleGenerator.format(minimalPattern, backgroundStartSymbol + sample + backgroundEndSymbol);
        examples.add(formattedUnit);
        if (sampleBad == null) {
            sampleBad = "n/a";
        }
        formattedUnit = ExampleGenerator.format(minimalPattern, backgroundStartSymbol + sampleBad + backgroundEndSymbol);
        examples.add(EXAMPLE_OF_INCORRECT + formattedUnit);
    }

    private String getOtherGender(String gender) {
        if (gender == null || this.grammarInfo == null) {
            return null;
        }
        Collection<String> unitGenders = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
        for (String otherGender : unitGenders) {
            if (gender.equals(otherGender)) continue;
            return otherGender;
        }
        return null;
    }

    private String getOtherCase(String sample) {
        if (sample == null) {
            return null;
        }
        Collection<String> unitCases = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
        Output<String> output = new Output<String>();
        for (String otherCase : unitCases) {
            String sampleBad = this.bestMinimalPairSamples.getBestUnitWithCase(otherCase, output);
            if (sample.equals(sampleBad)) continue;
            return sampleBad;
        }
        return null;
    }

    private static String getOtherCount(String locale, SupplementalDataInfo.PluralType ordinal, String count) {
        String otherCount = null;
        if (!Objects.equals(count, "other")) {
            otherCount = "other";
        } else {
            SupplementalDataInfo.PluralInfo rules = SupplementalDataInfo.getInstance().getPlurals(ordinal, locale);
            Set<String> counts = rules.getAdjustedCountStrings();
            for (String tryCount : counts) {
                if (tryCount.equals("other")) continue;
                otherCount = tryCount;
                break;
            }
        }
        return otherCount;
    }

    private UnitLength getUnitLength(XPathParts parts) {
        return UnitLength.valueOf(parts.getAttributeValue(-3, "type").toUpperCase(Locale.ENGLISH));
    }

    private void handleFormatUnit(XPathParts parts, String unitPattern, List<String> examples) {
        String count;
        DecimalQuantity amount;
        String longUnitId = parts.getAttributeValue(-2, "type");
        String shortUnitId = UNIT_CONVERTER.getShortId(longUnitId);
        if (UnitConverter.HACK_SKIP_UNIT_NAMES.contains(shortUnitId)) {
            return;
        }
        if (parts.getElement(-1).equals("unitPattern") && (amount = this.getBest(SupplementalDataInfo.PluralInfo.Count.valueOf(count = parts.getAttributeValue(-1, "count")))) != null) {
            if (shortUnitId.equals("light-speed")) {
                ImmutableMap<String, String> overrideMap = ImmutableMap.of(parts.toString(), unitPattern);
                examples.add("Used as a fallback in the following:");
                CLDRFileOverride cldrFileOverride = new CLDRFileOverride(this.cldrFile, overrideMap);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-second", amount);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-minute", amount);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-hour", amount);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-day", amount);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-week", amount);
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-speed-month", amount);
                examples.add("Compare with:");
                this.addFormattedUnitsConstructed(cldrFileOverride, examples, parts, "light-year", amount);
                return;
            }
            this.addFormattedUnits(examples, parts, unitPattern, shortUnitId, amount);
        }
        Map<Rational, String> relatedUnits = UNIT_CONVERTER.getRelatedExamples(shortUnitId, UnitConverter.getExampleUnitSystems(this.cldrFile.getLocaleID()));
        String unitSystem = null;
        boolean first = true;
        for (Map.Entry<Rational, String> relatedUnitInfo : relatedUnits.entrySet()) {
            if (unitSystem == null) {
                Set<UnitConverter.UnitSystem> systems = UNIT_CONVERTER.getSystemsEnum(shortUnitId);
                unitSystem = UnitConverter.UnitSystem.getSystemsDisplay(systems);
            }
            Rational relatedValue = relatedUnitInfo.getKey();
            String relatedUnit = relatedUnitInfo.getValue();
            Set<UnitConverter.UnitSystem> systems = UNIT_CONVERTER.getSystemsEnum(relatedUnit);
            String relation = "\u2261";
            String relatedValueDisplay = relatedValue.toString(Rational.FormatStyle.approx);
            if (relatedValueDisplay.startsWith("~")) {
                relation = "\u2248";
                relatedValueDisplay = relatedValueDisplay.substring(1);
            }
            if (first) {
                if (!examples.isEmpty()) {
                    examples.add("");
                }
                first = false;
            }
            examples.add(String.format("1 %s%s %s %s %s%s", shortUnitId, unitSystem, relation, relatedValueDisplay, relatedUnit, UnitConverter.UnitSystem.getSystemsDisplay(systems)));
        }
    }

    private void addFormattedUnitsConstructed(CLDRFile file, List<String> examples, XPathParts parts, String shortUnitId, DecimalQuantity amount) {
        UnitConverter.UnitId unitId = UNIT_CONVERTER.createUnitId(shortUnitId);
        String pattern = unitId.toString(file, parts.getAttributeValue(2, "type"), parts.getAttributeValue(-1, "count"), null, null, true);
        this.addSimpleFormattedUnits(examples, pattern, amount);
    }

    public void addFormattedUnits(List<String> examples, XPathParts parts, String unitPattern, String shortUnitId, DecimalQuantity amount) {
        String formattedAmount = this.addSimpleFormattedUnits(examples, unitPattern, amount);
        if (parts.getElement(-2).equals("unit") && unitPattern != null) {
            String minimalPattern;
            String gCase = parts.getAttributeValue(-1, "case");
            if (gCase == null) {
                gCase = GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(null);
            }
            Collection<String> unitCaseInfo = null;
            if (this.grammarInfo != null) {
                unitCaseInfo = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            }
            if ((minimalPattern = this.cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + gCase + "\"]")) != null) {
                String composed = ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol);
                examples.add(backgroundStartSymbol + ExampleGenerator.format(minimalPattern, backgroundEndSymbol + composed + backgroundStartSymbol) + backgroundEndSymbol);
                if (unitCaseInfo != null && !unitCaseInfo.isEmpty()) {
                    String constrastingCase = this.getConstrastingCase(unitPattern, gCase, unitCaseInfo, parts);
                    if (constrastingCase != null) {
                        minimalPattern = this.cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + constrastingCase + "\"]");
                        composed = ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol);
                        examples.add("\u274c  \ue234" + ExampleGenerator.format(minimalPattern, backgroundEndSymbol + composed + backgroundStartSymbol) + backgroundEndSymbol);
                    }
                } else {
                    examples.add("\u26a0\ufe0f  \ufe0fNo Case Minimal Pair available yet\ufe0f");
                }
            }
        }
    }

    private String addSimpleFormattedUnits(List<String> examples, String unitPattern, DecimalQuantity amount) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        String formattedAmount = numberFormat.format(amount.toBigDecimal());
        examples.add(ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol));
        return formattedAmount;
    }

    private String getConstrastingCase(String unitPattern, String gCase, Collection<String> unitCaseInfo, XPathParts parts) {
        for (String otherCase : unitCaseInfo) {
            if (otherCase.equals(gCase)) continue;
            parts.putAttributeValue(-1, "case", "nominative".equals(otherCase) ? null : otherCase);
            String otherValue = this.cldrFile.getStringValue(parts.toString());
            if (otherValue == null || otherValue.equals(unitPattern)) continue;
            return otherCase;
        }
        return null;
    }

    private void handleFormatPerUnit(String value, List<String> examples) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        examples.add(ExampleGenerator.format(value, backgroundStartSymbol + numberFormat.format(1L) + backgroundEndSymbol));
    }

    public void handleCompoundUnit(XPathParts parts, List<String> examples) {
        UnitLength unitLength = this.getUnitLength(parts);
        String compoundType = parts.getAttributeValue(-2, "type");
        SupplementalDataInfo.PluralInfo.Count count = SupplementalDataInfo.PluralInfo.Count.valueOf(CldrUtility.ifNull(parts.getAttributeValue(-1, "count"), "other"));
        this.handleCompoundUnit(unitLength, compoundType, count, examples);
    }

    public void handleCompoundUnit(UnitLength unitLength, String compoundType, SupplementalDataInfo.PluralInfo.Count count, List<String> examples) {
        String unit2mid;
        String unit1mid;
        DecimalQuantity amount = this.getBest(count);
        if (amount == null) {
            examples.add("n/a");
            return;
        }
        DecimalQuantity oneValue = DecimalQuantity_DualStorageBCD.fromExponentString("1");
        switch (compoundType) {
            default: {
                examples.add("n/a");
                return;
            }
            case "per": {
                unit1mid = this.getFormattedUnit("length-meter", unitLength, amount);
                unit2mid = this.getFormattedUnit("duration-second", unitLength, oneValue, "");
                break;
            }
            case "times": {
                unit1mid = this.getFormattedUnit("force-newton", unitLength, oneValue, this.icuServiceBuilder.getNumberFormat(1).format(amount.toBigDecimal()));
                unit2mid = this.getFormattedUnit("length-meter", unitLength, amount, "");
            }
        }
        String unit1 = backgroundStartSymbol + unit1mid.trim() + backgroundEndSymbol;
        String unit2 = backgroundStartSymbol + unit2mid.trim() + backgroundEndSymbol;
        String form = this.pluralInfo.getPluralRules().select(amount);
        String perPath = this.makeCompoundUnitPath(unitLength, compoundType, "compoundUnitPattern");
        examples.add(ExampleGenerator.format(this.getValueFromFormat(perPath, form), unit1, unit2));
    }

    public void handleCompoundUnit1(XPathParts parts, String compoundPattern, List<String> examples) {
        UnitLength unitLength = this.getUnitLength(parts);
        String pathCount = parts.getAttributeValue(-1, "count");
        if (pathCount == null) {
            this.handleCompoundUnit1Name(unitLength, compoundPattern, examples);
        } else {
            this.handleCompoundUnit1(unitLength, SupplementalDataInfo.PluralInfo.Count.valueOf(pathCount), compoundPattern, examples);
        }
    }

    private void handleCompoundUnit1Name(UnitLength unitLength, String compoundPattern, List<String> examples) {
        String pathFormat = "//ldml/units/unitLength" + unitLength.typeString + "/unit[@type=\"{0}\"]/displayName";
        String meterFormat = this.getValueFromFormat(pathFormat, "length-meter");
        String modFormat = this.combinePrefix(meterFormat, compoundPattern, unitLength == UnitLength.LONG);
        examples.add(this.removeEmptyRuns(modFormat));
    }

    public void handleCompoundUnit1(UnitLength unitLength, SupplementalDataInfo.PluralInfo.Count count, String compoundPattern, List<String> examples) {
        DecimalQuantity amount = this.getBest(count);
        if (amount == null) {
            examples.add("n/a");
            return;
        }
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        String form1 = this.pluralInfo.getPluralRules().select(amount);
        String pathFormat = "//ldml/units/unitLength" + unitLength.typeString + "/unit[@type=\"{0}\"]/unitPattern[@count=\"{1}\"]";
        String meterFormat = this.getValueFromFormat(pathFormat, "length-meter", form1);
        String modFormat = this.combinePrefix(meterFormat, compoundPattern, unitLength == UnitLength.LONG);
        examples.add(this.removeEmptyRuns(ExampleGenerator.format(modFormat, numberFormat.format(amount.toBigDecimal()))));
    }

    public String combinePrefix(String unitFormat, String inCompoundPattern, boolean lowercaseUnitIfNoSpaceInCompound) {
        String compoundPattern = backgroundEndSymbol + inCompoundPattern.replace("{0}", "\ue234{0}\ue235") + backgroundStartSymbol;
        String modFormat = Units.combinePattern(unitFormat, compoundPattern, lowercaseUnitIfNoSpaceInCompound);
        return backgroundStartSymbol + modFormat + backgroundEndSymbol;
    }

    public String makeCompoundUnitPath(UnitLength unitLength, String compoundType, String patternType) {
        return "//ldml/units/unitLength" + unitLength.typeString + "/compoundUnit[@type=\"" + compoundType + "\"]/" + patternType;
    }

    private DecimalQuantity getBest(SupplementalDataInfo.PluralInfo.Count count) {
        PluralRules.DecimalQuantitySamples samples = this.pluralInfo.getPluralRules().getDecimalSamples(count.name(), PluralRules.SampleType.DECIMAL);
        if (samples == null) {
            samples = this.pluralInfo.getPluralRules().getDecimalSamples(count.name(), PluralRules.SampleType.INTEGER);
        }
        if (samples == null) {
            return null;
        }
        Set<PluralRules.DecimalQuantitySamplesRange> samples2 = samples.getSamples();
        PluralRules.DecimalQuantitySamplesRange range = samples2.iterator().next();
        return range.end;
    }

    private void handleMiscPatterns(XPathParts parts, String value, List<String> examples) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(0);
        String start = backgroundStartSymbol + numberFormat.format(99L) + backgroundEndSymbol;
        if ("range".equals(parts.getAttributeValue(-1, "type"))) {
            String end = backgroundStartSymbol + numberFormat.format(144L) + backgroundEndSymbol;
            examples.add(ExampleGenerator.format(value, start, end));
        } else {
            examples.add(ExampleGenerator.format(value, start));
        }
    }

    private void handleIntervalFormats(XPathParts parts, String value, List<String> examples) {
        if (parts.getElement(6).equals("intervalFormatFallback")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            String fallbackFormat = this.invertBackground(this.setBackground(value));
            examples.add(ExampleGenerator.format(fallbackFormat, dateFormat.format(FIRST_INTERVAL), dateFormat.format(SECOND_INTERVAL.get("y"))));
            return;
        }
        this.addIntervalExample(FIRST_INTERVAL, SECOND_INTERVAL, parts, value, examples);
        this.addIntervalExample(FIRST_INTERVAL2, SECOND_INTERVAL2, parts, value, examples);
        Set<String> relatedPatterns = RelatedDatePathValues.getRelatedPathValues(this.cldrFile, parts);
        if (!relatedPatterns.isEmpty()) {
            examples.add("Related Flexible Dates:");
            for (String pattern : relatedPatterns) {
                SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(parts.getAttributeValue(3, "type"), pattern);
                examples.add(sdf.format(FIRST_INTERVAL));
                examples.add(sdf.format(FIRST_INTERVAL2));
            }
        }
        LinkedHashSet<String> dedup = new LinkedHashSet<String>(examples);
        examples.clear();
        examples.addAll(dedup);
    }

    private void addIntervalExample(Date earlier, Map<String, Date> laterMap, XPathParts parts, String value, List<String> examples) {
        String greatestDifference = parts.getAttributeValue(-1, "id");
        if (greatestDifference.equals("H")) {
            greatestDifference = "h";
        } else if (greatestDifference.equals("B") || greatestDifference.equals("b")) {
            greatestDifference = "a";
        }
        this.intervalFormat.setPattern(parts, value);
        Date later = laterMap.get(greatestDifference);
        if (later != null) {
            examples.add(this.intervalFormat.format(earlier, later));
        }
    }

    private void handleDelimiters(XPathParts parts, String xpath, String value, List<String> examples) {
        String lastElement = parts.getElement(-1);
        String[] elements = new String[]{"quotationStart", "alternateQuotationStart", "alternateQuotationEnd", "quotationEnd"};
        String[] quotes = new String[4];
        String baseXpath = xpath.substring(0, xpath.lastIndexOf(47));
        for (int i = 0; i < quotes.length; ++i) {
            String currElement = elements[i];
            quotes[i] = lastElement.equals(currElement) ? backgroundStartSymbol + value + backgroundEndSymbol : this.cldrFile.getWinningValue(baseXpath + "/" + currElement);
        }
        String example = this.cldrFile.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"calendar\"][@type=\"gregorian\"]");
        examples.add(this.invertBackground(ExampleGenerator.format("{0}They said {1}" + example + "{2}.{3}", quotes)));
    }

    private void handleListPatterns(XPathParts parts, String value, List<String> examples) {
        String listPatternType = parts.getAttributeValue(-2, "type");
        if (listPatternType == null || !listPatternType.contains("unit")) {
            this.handleRegularListPatterns(parts, value, XListFormatter.ListTypeLength.from(listPatternType), examples);
        } else {
            this.handleDurationListPatterns(parts, value, UnitLength.from(listPatternType), examples);
        }
    }

    private void handleRegularListPatterns(XPathParts parts, String value, XListFormatter.ListTypeLength listTypeLength, List<String> examples) {
        String patternType = parts.getAttributeValue(-1, "type");
        if (patternType == null) {
            return;
        }
        String pathFormat = "//ldml/localeDisplayNames/territories/territory[@type=\"{0}\"]";
        String territory1 = this.getValueFromFormat(pathFormat, "CH");
        String territory2 = this.getValueFromFormat(pathFormat, "JP");
        if (patternType.equals("2")) {
            examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(value), territory1, territory2)));
            return;
        }
        String territory3 = this.getValueFromFormat(pathFormat, "EG");
        String territory4 = this.getValueFromFormat(pathFormat, "CA");
        examples.add(this.longListPatternExample(listTypeLength.getPath(), patternType, value, territory1, territory2, territory3, territory4));
    }

    private void handleDurationListPatterns(XPathParts parts, String value, UnitLength unitWidth, List<String> examples) {
        String patternType = parts.getAttributeValue(-1, "type");
        if (patternType == null) {
            return;
        }
        String duration1 = this.getFormattedUnit("duration-day", unitWidth, 4.0);
        String duration2 = this.getFormattedUnit("duration-hour", unitWidth, 2.0);
        if (patternType.equals("2")) {
            examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(value), duration1, duration2)));
            return;
        }
        String duration3 = this.getFormattedUnit("duration-minute", unitWidth, 37.0);
        String duration4 = this.getFormattedUnit("duration-second", unitWidth, 23.0);
        examples.add(this.longListPatternExample(unitWidth.listTypeLength.getPath(), patternType, value, duration1, duration2, duration3, duration4));
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, DecimalQuantity unitAmount) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        return this.getFormattedUnit(unitType, unitWidth, unitAmount, numberFormat.format(unitAmount.toBigDecimal()));
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, double unitAmount) {
        return this.getFormattedUnit(unitType, unitWidth, new DecimalQuantity_DualStorageBCD(unitAmount));
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, DecimalQuantity unitAmount, String formattedUnitAmount) {
        String form = this.pluralInfo.getPluralRules().select(unitAmount);
        String pathFormat = "//ldml/units/unitLength" + unitWidth.typeString + "/unit[@type=\"{0}\"]/unitPattern[@count=\"{1}\"]";
        return ExampleGenerator.format(this.getValueFromFormat(pathFormat, unitType, form), formattedUnitAmount);
    }

    private String longListPatternExample(String listPathFormat, String patternType, String value, String ... items) {
        String doublePattern = this.getPattern(listPathFormat, "2", patternType, value);
        String startPattern = this.getPattern(listPathFormat, "start", patternType, value);
        String middlePattern = this.getPattern(listPathFormat, "middle", patternType, value);
        String endPattern = this.getPattern(listPathFormat, "end", patternType, value);
        ListFormatter listFormatter = new ListFormatter(doublePattern, startPattern, middlePattern, endPattern);
        String example = listFormatter.format(items);
        return this.invertBackground(example);
    }

    private String getPattern(String pathFormat, String pathPatternType, String valuePatternType, String value) {
        return valuePatternType.equals(pathPatternType) ? this.setBackground(value) : this.getValueFromFormat(pathFormat, pathPatternType);
    }

    private String getValueFromFormat(String format, Object ... arguments) {
        return this.cldrFile.getWinningValue(ExampleGenerator.format(format, arguments));
    }

    public void handleEllipsis(String type, String value, List<String> examples) {
        String pathFormat = "//ldml/localeDisplayNames/territories/territory[@type=\"{0}\"]";
        String territory1 = this.getValueFromFormat(pathFormat, "CH");
        String territory2 = this.getValueFromFormat(pathFormat, "JP");
        if (territory1 == null || territory2 == null) {
            return;
        }
        if (!type.contains("word")) {
            territory1 = ExampleGenerator.clip(territory1, 0, 1);
            territory2 = ExampleGenerator.clip(territory2, 1, 0);
        }
        if (type.contains("initial")) {
            territory1 = territory2;
        }
        examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(value), territory1, territory2)));
    }

    public static String clip(String text, int clipStart, int clipEnd) {
        BreakIterator bi = BreakIterator.getCharacterInstance();
        bi.setText(text);
        for (int i = 0; i < clipStart; ++i) {
            bi.next();
        }
        int start = bi.current();
        bi.last();
        for (int i = 0; i < clipEnd; ++i) {
            bi.previous();
        }
        int end = bi.current();
        return start >= end ? text : text.substring(start, end);
    }

    private void handleMonthPatterns(XPathParts parts, String value, List<String> examples) {
        String calendar = parts.getAttributeValue(3, "type");
        String context = parts.getAttributeValue(5, "type");
        String month = "8";
        if (!context.equals("numeric")) {
            String width = parts.getAttributeValue(6, "type");
            String xpath = "//ldml/dates/calendars/calendar[@type=\"{0}\"]/months/monthContext[@type=\"{1}\"]/monthWidth[@type=\"{2}\"]/month[@type=\"8\"]";
            month = this.getValueFromFormat(xpath, calendar, context, width);
        }
        examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(value), month)));
    }

    private void handleAppendItems(XPathParts parts, String value, List<String> examples) {
        String request = parts.getAttributeValue(-1, "request");
        if (!"Timezone".equals(request)) {
            return;
        }
        String calendar = parts.getAttributeValue(3, "type");
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendar, 0, 2, null);
        String zone = this.cldrFile.getStringValue("//ldml/dates/timeZoneNames/gmtZeroFormat");
        examples.add(ExampleGenerator.format(value, this.setBackground(sdf.format(DATE_SAMPLE)), this.setBackground(zone)));
    }

    private void handleDurationUnit(String value, List<String> examples) {
        SimpleDateFormat df = this.icuServiceBuilder.getDateFormat("gregorian", value.replace('h', 'H'));
        df.setTimeZone(TimeZone.GMT_ZONE);
        long time = 20243000L;
        try {
            examples.add(df.format(new Date(time)));
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    private void formatCountValue(String xpath, XPathParts parts, String value, List<String> examples) {
        SupplementalDataInfo.PluralInfo.Count count;
        if (!parts.containsAttribute("count")) {
            return;
        }
        SupplementalDataInfo.PluralInfo plurals = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, this.cldrFile.getLocaleID());
        PluralRules pluralRules = plurals.getPluralRules();
        String unitType = parts.getAttributeValue(-2, "type");
        if (unitType == null) {
            unitType = "USD";
        }
        boolean isPattern = parts.contains("unitPattern");
        boolean isCurrency = !parts.contains("units");
        LinkedHashSet<DecimalQuantity> exampleCount = new LinkedHashSet<DecimalQuantity>(CURRENCY_SAMPLES);
        String countString = parts.getAttributeValue(-1, "count");
        if (countString == null) {
            return;
        }
        try {
            count = SupplementalDataInfo.PluralInfo.Count.valueOf(countString);
        }
        catch (Exception e) {
            return;
        }
        ExampleGenerator.getStartEndSamples(pluralRules.getDecimalSamples(countString, PluralRules.SampleType.INTEGER), exampleCount);
        ExampleGenerator.getStartEndSamples(pluralRules.getDecimalSamples(countString, PluralRules.SampleType.DECIMAL), exampleCount);
        String result = "";
        DecimalFormat currencyFormat = this.icuServiceBuilder.getCurrencyFormat(unitType);
        int decimalCount = currencyFormat.getMinimumFractionDigits();
        ArrayList<DecimalQuantity> examplesSeen = new ArrayList<DecimalQuantity>();
        int maxCount = 2;
        block2: for (int phase = 0; phase < 2; ++phase) {
            for (DecimalQuantity example : exampleCount) {
                if (isCurrency && phase == 0) {
                    DecimalQuantity_DualStorageBCD newExample = new DecimalQuantity_DualStorageBCD();
                    newExample.copyFrom(example);
                    newExample.setMinFraction(decimalCount);
                    example = newExample;
                }
                if (examplesSeen.contains(example)) continue;
                examplesSeen.add(example);
                if (!pluralRules.select(example).equals(count.toString())) continue;
                if (value == null) {
                    String fallbackPath = this.cldrFile.getCountPathWithFallback(xpath, count, true);
                    value = this.cldrFile.getStringValue(fallbackPath);
                }
                String resultItem = this.formatCurrency(value, unitType, isPattern, isCurrency, count, example);
                result = this.addExampleResult(resultItem, result);
                if (isPattern) {
                    String territory = this.getDefaultTerritory();
                    String currency = supplementalDataInfo.getDefaultCurrency(territory);
                    if (currency.equals(unitType) && (currency = "EUR").equals(unitType)) {
                        currency = "JAY";
                    }
                    resultItem = this.formatCurrency(value, currency, isPattern, isCurrency, count, example);
                    result = this.addExampleResult(resultItem, result);
                }
                if (--maxCount >= 1) continue;
                break block2;
            }
        }
        examples.add(result.isEmpty() ? null : result);
    }

    public static void getStartEndSamples(PluralRules.DecimalQuantitySamples samples, Set<DecimalQuantity> target) {
        if (samples != null) {
            for (PluralRules.DecimalQuantitySamplesRange item : samples.getSamples()) {
                target.add(item.start);
                target.add(item.end);
            }
        }
    }

    private String formatCurrency(String value, String unitType, boolean isPattern, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count, DecimalQuantity example) {
        String unitPattern;
        String unitName;
        if (isPattern) {
            unitName = this.getUnitName(unitType, isCurrency, count);
            unitPattern = this.typeIsEnglish ? this.getUnitPattern(unitType, isCurrency, count) : value;
        } else {
            unitPattern = this.getUnitPattern(unitType, isCurrency, count);
            unitName = this.typeIsEnglish ? this.getUnitName(unitType, isCurrency, count) : value;
        }
        unitPattern = isPattern ? this.setBackground(unitPattern) : this.setBackgroundExceptMatch(unitPattern, PARAMETER_SKIP0);
        MessageFormat unitPatternFormat = new MessageFormat(unitPattern);
        DecimalFormat unitDecimalFormat = this.icuServiceBuilder.getNumberFormat(1);
        unitDecimalFormat.setMaximumFractionDigits((int)example.getPluralOperand(PluralRules.Operand.v));
        unitDecimalFormat.setMinimumFractionDigits((int)example.getPluralOperand(PluralRules.Operand.v));
        String formattedNumber = unitDecimalFormat.format(example.toDouble());
        unitPatternFormat.setFormatByArgumentIndex(0, unitDecimalFormat);
        String resultItem = unitPattern.replace("{0}", formattedNumber).replace("{1}", unitName);
        if (isPattern) {
            resultItem = this.invertBackground(resultItem);
        }
        return resultItem;
    }

    private String addExampleResult(String resultItem, String resultToAddTo) {
        return this.addExampleResult(resultItem, resultToAddTo, false);
    }

    private String addExampleResult(String resultItem, String resultToAddTo, boolean showContexts) {
        if (!showContexts) {
            if (((String)resultToAddTo).length() != 0) {
                resultToAddTo = (String)resultToAddTo + exampleSeparatorSymbol;
            }
            resultToAddTo = (String)resultToAddTo + resultItem;
        } else {
            resultToAddTo = (String)resultToAddTo + exampleStartAutoSymbol + resultItem + exampleEndSymbol;
            resultToAddTo = (String)resultToAddTo + exampleStartRTLSymbol + resultItem + exampleEndSymbol;
        }
        return resultToAddTo;
    }

    private String getUnitPattern(String unitType, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count) {
        return this.cldrFile.getStringValue(isCurrency ? "//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/unitPattern" + this.countAttribute(count) : "//ldml/units/unit[@type=\"" + unitType + "\"]/unitPattern" + this.countAttribute(count));
    }

    private String getUnitName(String unitType, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count) {
        return this.cldrFile.getStringValue(isCurrency ? "//ldml/numbers/currencies/currency[@type=\"" + unitType + "\"]/displayName" + this.countAttribute(count) : "//ldml/units/unit[@type=\"" + unitType + "\"]/unitPattern" + this.countAttribute(count));
    }

    public String countAttribute(SupplementalDataInfo.PluralInfo.Count count) {
        return "[@count=\"" + String.valueOf((Object)count) + "\"]";
    }

    private void handleMinimumGrouping(XPathParts parts, String value, List<String> examples) {
        String numberSystem = this.cldrFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        String checkPath = "//ldml/numbers/decimalFormats[@numberSystem=\"" + numberSystem + "\"]/decimalFormatLength/decimalFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        String decimalFormat = this.cldrFile.getWinningValue(checkPath);
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(decimalFormat, numberSystem);
        numberFormat.setMinimumGroupingDigits(Integer.parseInt(value));
        double sampleNum1 = 543.21;
        double sampleNum2 = 6543.21;
        double sampleNum3 = 76543.21;
        examples.add(this.formatNumber(numberFormat, sampleNum1));
        examples.add(this.formatNumber(numberFormat, sampleNum2));
        examples.add(this.formatNumber(numberFormat, sampleNum3));
    }

    private void handleNumberSymbol(XPathParts parts, String value, List<String> examples) {
        String formattedValue;
        int index;
        String symbolType = parts.getElement(-1);
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        double numberSample = 123456.789;
        String originalValue = this.cldrFile.getWinningValue(parts.toString());
        boolean isSuperscripting = false;
        if (symbolType.equals("decimal") || symbolType.equals("group")) {
            index = 1;
        } else if (symbolType.equals("minusSign")) {
            index = 1;
            numberSample = -numberSample;
        } else if (symbolType.equals("percentSign")) {
            index = 2;
            numberSample = 0.23;
        } else if (symbolType.equals("perMille")) {
            index = 2;
            numberSample = 0.023;
            originalValue = this.cldrFile.getWinningValue(parts.addRelative("../percentSign").toString());
        } else if (symbolType.equals("approximatelySign")) {
            index = 1;
            numberSample = -numberSample;
            originalValue = this.cldrFile.getWinningValue(parts.addRelative("../minusSign").toString());
        } else if (symbolType.equals("exponential") || symbolType.equals("plusSign")) {
            index = 3;
        } else if (symbolType.equals("superscriptingExponent")) {
            index = 3;
            isSuperscripting = true;
        } else {
            return;
        }
        DecimalFormat x = this.icuServiceBuilder.getNumberFormat(index, numberSystem);
        if (isSuperscripting) {
            DecimalFormatSymbols symbols = x.getDecimalFormatSymbols();
            char[] digits = symbols.getDigits();
            x.setDecimalFormatSymbols(symbols);
            x.setNegativeSuffix(endSupSymbol + x.getNegativeSuffix());
            x.setPositiveSuffix(endSupSymbol + x.getPositiveSuffix());
            x.setExponentSignAlwaysShown(false);
            originalValue = symbols.getExponentSeparator();
            formattedValue = backgroundEndSymbol + value + digits[1] + digits[0] + "\ue234\ue23a";
        } else {
            x.setExponentSignAlwaysShown(true);
            formattedValue = backgroundEndSymbol + value + backgroundStartSymbol;
        }
        String example = x.format(numberSample);
        example = example.replace(originalValue, formattedValue);
        examples.add(backgroundStartSymbol + example + backgroundEndSymbol);
    }

    private void handleNumberingSystem(String value, List<String> examples) {
        NumberFormat x = this.icuServiceBuilder.getGenericNumberFormat(value);
        x.setGroupingUsed(false);
        examples.add(x.format(2345.0));
    }

    private void handleTimeZoneName(XPathParts parts, String value, List<String> examples) {
        Object result = null;
        if (parts.contains("exemplarCity")) {
            String timezone = parts.getAttributeValue(3, "type");
            String countryCode = supplementalDataInfo.getZone_territory(timezone);
            if (countryCode == null) {
                result = value == null ? timezone.substring(timezone.lastIndexOf(47) + 1).replace('_', ' ') : value;
                examples.add((String)result);
                return;
            }
            if (countryCode.equals("001")) {
                try {
                    String hourOffset = timezone.substring(timezone.contains("+") ? 8 : 7);
                    int hours = Integer.parseInt(hourOffset);
                    result = this.getGMTFormat(null, null, hours);
                }
                catch (RuntimeException e) {
                    return;
                }
            } else {
                result = this.setBackground(this.cldrFile.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, countryCode));
            }
        } else if (parts.contains("zone")) {
            result = value;
        } else if (parts.contains("regionFormat")) {
            result = ExampleGenerator.format(value, this.setBackground(this.cldrFile.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, "JP")));
            result = this.addExampleResult(ExampleGenerator.format(value, this.setBackground(this.cldrFile.getWinningValue(EXEMPLAR_CITY_LOS_ANGELES))), (String)result);
        } else if (parts.contains("fallbackFormat")) {
            String central = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/metazone[@type=\"America_Central\"]/long/generic"));
            String cancun = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/zone[@type=\"America/Cancun\"]/exemplarCity"));
            result = ExampleGenerator.format(value, cancun, central);
        } else if (parts.contains("gmtFormat")) {
            result = this.getGMTFormat(null, value, -8);
        } else if (parts.contains("hourFormat")) {
            result = this.getGMTFormat(value, null, -8);
        } else if (parts.contains("metazone") && !parts.contains("commonlyUsed")) {
            if (value != null && value.length() > 0) {
                result = this.getMZTimeFormat() + " " + value;
            } else if (parts.contains("generic")) {
                String metazone_name = parts.getAttributeValue(3, "type");
                String timezone = supplementalDataInfo.getZoneForMetazoneByRegion(metazone_name, "001");
                String countryCode = supplementalDataInfo.getZone_territory(timezone);
                String regionFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/regionFormat");
                String countryName = this.cldrFile.getWinningValue("//ldml/localeDisplayNames/territories/territory[@type=\"" + countryCode + "\"]");
                result = this.setBackground(this.getMZTimeFormat() + " " + ExampleGenerator.format(regionFormat, countryName));
            } else {
                String gmtFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/gmtFormat");
                String hourFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/hourFormat");
                String metazone_name = parts.getAttributeValue(3, "type");
                String tz_string = supplementalDataInfo.getZoneForMetazoneByRegion(metazone_name, "001");
                TimeZone currentZone = TimeZone.getTimeZone(tz_string);
                int tzOffset = currentZone.getRawOffset();
                if (parts.contains("daylight")) {
                    tzOffset += currentZone.getDSTSavings();
                }
                long tm_hrs = (long)tzOffset / 216000000L;
                long tm_mins = (long)tzOffset % 216000000L / 3600000L;
                result = this.setBackground(this.getMZTimeFormat() + " " + this.getGMTFormat(hourFormat, gmtFormat, (int)tm_hrs, (int)tm_mins));
            }
        }
        examples.add((String)result);
    }

    private void handleDateFormatItem(String xpath, String value, boolean showContexts, List<String> examples) {
        String fullpath = this.cldrFile.getFullXPath(xpath);
        XPathParts parts = XPathParts.getFrozenInstance(fullpath);
        String calendar = parts.findAttributeValue("calendar", "type");
        if (parts.contains("dateTimeFormat")) {
            int dtfLengthOffset;
            SimpleDateFormat tlf;
            String formatType = parts.findAttributeValue("dateTimeFormat", "type");
            String length = parts.findAttributeValue("dateTimeFormatLength", "type");
            SimpleDateFormat df = this.cldrFile.getDateFormat(calendar, length, this.icuServiceBuilder);
            df.setTimeZone(ZONE_SAMPLE);
            SimpleDateFormat simpleDateFormat = tlf = !length.equals("short") ? this.cldrFile.getTimeFormat(calendar, "full", this.icuServiceBuilder) : this.cldrFile.getTimeFormat(calendar, "long", this.icuServiceBuilder);
            if (tlf == null) {
                return;
            }
            tlf.setTimeZone(ZONE_SAMPLE);
            SimpleDateFormat tsf = this.cldrFile.getTimeFormat(calendar, "short", this.icuServiceBuilder);
            tsf.setTimeZone(ZONE_SAMPLE);
            String relativeDayXPath = this.cldrFile.getWinningPath("//ldml/dates/fields/field[@type=\"day\"]/relative[@type=\"0\"]");
            String relativeDayValue = this.cldrFile.getWinningValue(relativeDayXPath);
            String dfResult = df.format(DATE_SAMPLE);
            String tlfResult = tlf.format(DATE_SAMPLE);
            String tsfResult = tsf.format(DATE_SAMPLE);
            if (!formatType.contentEquals("relative")) {
                examples.add(this.cldrFile.glueDateTimeFormatWithGluePattern(this.setBackground(dfResult), this.setBackground(tlfResult), calendar, value, this.icuServiceBuilder));
                examples.add(this.cldrFile.glueDateTimeFormatWithGluePattern(this.setBackground(dfResult), this.setBackground(tsfResult), calendar, value, this.icuServiceBuilder));
            }
            if (formatType.contentEquals("standard") && (dtfLengthOffset = xpath.indexOf("dateTimeFormatLength")) > 0) {
                String intervalFormatFallbackXPath = xpath.substring(0, dtfLengthOffset).concat("intervalFormats/intervalFormatFallback");
                String intervalFormatFallbackValue = this.cldrFile.getWinningValue(intervalFormatFallbackXPath);
                String tsfAMResult = tsf.format(DATE_SAMPLE3);
                String timeRange = ExampleGenerator.format(intervalFormatFallbackValue, tsfAMResult, tsfResult);
                examples.add(this.cldrFile.glueDateTimeFormatWithGluePattern(this.setBackground(dfResult), this.setBackground(timeRange), calendar, value, this.icuServiceBuilder));
                examples.add(this.cldrFile.glueDateTimeFormatWithGluePattern(this.setBackground(relativeDayValue), this.setBackground(timeRange), calendar, value, this.icuServiceBuilder));
            }
            if (formatType.contentEquals("relative")) {
                examples.add(this.cldrFile.glueDateTimeFormatWithGluePattern(this.setBackground(relativeDayValue), this.setBackground(tsfResult), calendar, value, this.icuServiceBuilder));
            }
            return;
        }
        String id = parts.findAttributeValue("dateFormatItem", "id");
        if ("NEW".equals(id) || value == null) {
            examples.add("\ue238n/a\ue239");
            return;
        }
        String numbersOverride = parts.findAttributeValue("pattern", "numbers");
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendar, value, numbersOverride);
        String defaultNumberingSystem = this.cldrFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        String timeSeparator = this.cldrFile.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + defaultNumberingSystem + "']/timeSeparator");
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        dfs.setTimeSeparatorString(timeSeparator);
        sdf.setDateFormatSymbols(dfs);
        if (id == null || id.indexOf(66) < 0) {
            sdf.setTimeZone(ZONE_SAMPLE);
            if (value.contains("MMM") || value.contains("LLL")) {
                examples.add(sdf.format(DATE_SAMPLE));
                this.addRelatedAvailable(parts, calendar, numbersOverride, dfs, examples);
                return;
            }
            String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
            String sup_twelve_example = sdf.format(DATE_SAMPLE);
            String sub_ten_example = sdf.format(DATE_SAMPLE5);
            example = this.addExampleResult(sup_twelve_example, example, showContexts);
            if (!sup_twelve_example.equals(sub_ten_example)) {
                example = this.addExampleResult(sub_ten_example, example, showContexts);
            }
            examples.add(example);
            this.addRelatedAvailable(parts, calendar, numbersOverride, dfs, examples);
            return;
        }
        DayPeriodInfo dayPeriodInfo = supplementalDataInfo.getDayPeriods(DayPeriodInfo.Type.format, this.cldrFile.getLocaleID());
        LinkedHashSet<DayPeriodInfo.DayPeriod> dayPeriods = new LinkedHashSet<DayPeriodInfo.DayPeriod>(dayPeriodInfo.getPeriods());
        for (DayPeriodInfo.DayPeriod dayPeriod : dayPeriods) {
            Row.R3<Integer, Integer, Boolean> info;
            if (dayPeriod.equals((Object)DayPeriodInfo.DayPeriod.midnight) || (info = dayPeriodInfo.getFirstDayPeriodInfo(dayPeriod)) == null) continue;
            int time = ((Integer)info.get0() + (Integer)info.get1()) / 2;
            String formatted = sdf.format(time);
            examples.add(formatted);
        }
    }

    private void addRelatedAvailable(XPathParts parts, String calendar, String numbersOverride, DateFormatSymbols dfs, List<String> examples) {
        Set<String> related = RelatedDatePathValues.getRelatedPathValues(this.cldrFile, parts);
        if (!related.isEmpty()) {
            examples.add("Related formats:");
            related.stream().forEach(x -> {
                SimpleDateFormat sdf2 = this.icuServiceBuilder.getDateFormat(calendar, (String)x, numbersOverride);
                sdf2.setDateFormatSymbols(dfs);
                sdf2.setTimeZone(ZONE_SAMPLE);
                String example2 = sdf2.format(DATE_SAMPLE);
                if (!examples.contains(example2)) {
                    examples.add(example2);
                }
            });
        }
    }

    private boolean symbolIsLetters(String currencySymbol, boolean onBothSides) {
        int len = currencySymbol.length();
        if (len == 0) {
            return false;
        }
        int limitChar = currencySymbol.codePointAt(0);
        if (UCharacter.isLetter(limitChar)) {
            if (!onBothSides) {
                return true;
            }
        } else if (onBothSides) {
            return false;
        }
        if (len > 1) {
            limitChar = currencySymbol.codePointAt(len - 1);
            return UCharacter.isLetter(limitChar);
        }
        return false;
    }

    private void handleCurrencyFormat(XPathParts parts, String value, boolean showContexts, List<String> examples) {
        boolean altAlpha;
        String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
        String territory = this.getDefaultTerritory();
        String currency = supplementalDataInfo.getDefaultCurrency(territory);
        String checkPath = "//ldml/numbers/currencies/currency[@type=\"" + currency + "\"]/symbol";
        String currencySymbol = this.cldrFile.getWinningValue(checkPath);
        String altValue = parts.getAttributeValue(-1, "alt");
        boolean bl = altAlpha = altValue != null && altValue.equals("alphaNextToNumber");
        if (altAlpha && !this.symbolIsLetters(currencySymbol, true)) {
            currencySymbol = currency;
        }
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        DecimalFormat df = this.icuServiceBuilder.getCurrencyFormat(currency, currencySymbol, numberSystem);
        String typeValue = parts.getAttributeValue(-1, "type");
        boolean noCompact = typeValue != null && value.equals("0");
        int minIntegerDigits = typeValue.length();
        this.fixDecimalFormatForCompact(df, noCompact, value, currency, minIntegerDigits);
        String countValue = parts.getAttributeValue(-1, "count");
        if (countValue != null) {
            examples.add(this.formatCountDecimal(df, countValue));
            return;
        }
        double sampleAmount = 1295.0;
        example = this.addExampleResult(this.formatNumber(df, sampleAmount), example, showContexts);
        example = this.addExampleResult(this.formatNumber(df, -sampleAmount), example, showContexts);
        if (showContexts && !altAlpha) {
            if (this.symbolIsLetters(currencySymbol, false)) {
                currency = "EUR";
                checkPath = "//ldml/numbers/currencies/currency[@type=\"" + currency + "\"]/symbol";
                currencySymbol = this.cldrFile.getWinningValue(checkPath);
            } else {
                currencySymbol = currency;
            }
            df = this.icuServiceBuilder.getCurrencyFormat(currency, currencySymbol, numberSystem);
            df.applyPattern(value);
            example = this.addExampleResult(this.formatNumber(df, sampleAmount), example, showContexts);
            example = this.addExampleResult(this.formatNumber(df, -sampleAmount), example, showContexts);
        }
        examples.add(example);
    }

    private void fixDecimalFormatForCompact(DecimalFormat df, boolean noCompact, String value, String currency, int minIntegerDigits) {
        if (noCompact) {
            df.setMinimumIntegerDigits(minIntegerDigits);
        } else {
            df.applyPattern(value);
            if (currency != null) {
                SupplementalDataInfo supplementalData = CONFIG.getSupplementalDataInfo();
                SupplementalDataInfo.CurrencyNumberInfo info = supplementalData.getCurrencyNumberInfo(currency);
                int digits = info.getDigits();
                df.setMinimumFractionDigits(digits);
                df.setMaximumFractionDigits(digits);
            }
        }
    }

    private String getDefaultTerritory() {
        String territory = "US";
        if (!this.typeIsEnglish) {
            CLDRLocale loc = CLDRLocale.getInstance(this.cldrFile.getLocaleID());
            territory = loc.getCountry();
            if ((territory == null || territory.length() == 0) && (loc = supplementalDataInfo.getDefaultContentFromBase(loc)) != null && (territory = loc.getCountry()).equals("001") && loc.getLanguage().equals("ar")) {
                territory = "EG";
            }
            if (territory == null || territory.length() == 0) {
                territory = "US";
            }
        }
        return territory;
    }

    private void handleDecimalFormat(XPathParts parts, String value, boolean showContexts, List<String> examples) {
        String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        String countValue = parts.getAttributeValue(-1, "count");
        String typeValue = parts.getAttributeValue(-1, "type");
        boolean noCompact = typeValue != null && value.equals("0");
        int minIntegerDigits = typeValue.length();
        DecimalFormat numberFormat = noCompact ? this.icuServiceBuilder.getNumberFormat(ICUServiceBuilder.integer, numberSystem) : this.icuServiceBuilder.getNumberFormat(value, numberSystem);
        this.fixDecimalFormatForCompact(numberFormat, noCompact, value, null, minIntegerDigits);
        if (countValue != null) {
            examples.add(this.formatCountDecimal(numberFormat, countValue));
            return;
        }
        double sampleNum1 = 5.43;
        double sampleNum2 = 123456.789;
        if (parts.getElement(4).equals("percentFormat")) {
            sampleNum1 = 0.0543;
        }
        example = this.addExampleResult(this.formatNumber(numberFormat, sampleNum1), example, showContexts);
        example = this.addExampleResult(this.formatNumber(numberFormat, sampleNum2), example, showContexts);
        example = this.addExampleResult(this.formatNumber(numberFormat, -sampleNum2), example, showContexts);
        examples.add(example);
    }

    private void handleRationalFormat(XPathParts parts, String value, boolean showContexts, List<String> examples) {
        String element;
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        boolean isLatin = numberSystem == null || numberSystem.equals("latn");
        DecimalFormat numberFormat = isLatin ? null : this.icuServiceBuilder.getNumberFormat("0", numberSystem);
        switch (element = parts.getElement(-1)) {
            case "rationalPattern": {
                String den;
                String num;
                Pair<String, String> simpleFractionPair = null;
                ArrayList<Pair<Object, Object>> fractionPairs = new ArrayList<Pair<Object, Object>>();
                Pair<String, String> extraPair = null;
                if (isLatin) {
                    num = "1";
                    den = "2";
                    extraPair = Pair.of("\u00b9", "\u2082");
                } else {
                    num = numberFormat.format(1L);
                    den = numberFormat.format(2L);
                }
                simpleFractionPair = Pair.of(num, den);
                fractionPairs.add(simpleFractionPair);
                fractionPairs.add(Pair.of(startSupSymbol + num + endSupSymbol, startSubSymbol + den + endSubSymbol));
                if (extraPair != null) {
                    fractionPairs.add(extraPair);
                }
                examples.add(value.replace(FSLASH, ISOLATE_FSLASH).replace("{0}", this.setBackground(simpleFractionPair.getFirst())).replace("{1}", this.setBackground(simpleFractionPair.getSecond())));
                for (Pair pair : fractionPairs) {
                    examples.add(value.replace("{0}", this.setBackground((String)pair.getFirst())).replace("{1}", this.setBackground((String)pair.getSecond())));
                }
                break;
            }
            case "integerAndRationalPattern": {
                String den;
                String num;
                String base;
                boolean superSub = "superSub".equals(parts.getAttributeValue(-1, "alt"));
                XPathParts xPathParts = parts.cloneAsThawed().setElement(-1, "rationalPattern").setAttribute(-1, "alt", null);
                String rationalPart = this.cldrFile.getStringValue(xPathParts.toString());
                LinkedHashSet<Object> fractions = new LinkedHashSet<Object>();
                String extra = null;
                if (isLatin) {
                    base = "3";
                    num = "1";
                    den = "2";
                    extra = "\u00bd";
                } else {
                    base = numberFormat.format(3L);
                    num = numberFormat.format(1L);
                    den = numberFormat.format(2L);
                }
                if (!superSub) {
                    fractions.add(rationalPart.replace(FSLASH, ISOLATE_FSLASH).replace("{0}", num).replace("{1}", den));
                }
                if (extra != null) {
                    fractions.add(extra);
                }
                fractions.add(startSupSymbol + num + "\ue23b\u2044\ue242" + den + endSubSymbol);
                for (String string : fractions) {
                    examples.add(value.replace("{0}", this.setBackground(base)).replace("{1}", this.setBackground(string)));
                }
                break;
            }
            case "rationalUsage": {
                return;
            }
        }
    }

    private String formatCountDecimal(DecimalFormat numberFormat, String countValue) {
        String temp;
        int fractionLength;
        SupplementalDataInfo.PluralInfo.Count count;
        try {
            count = SupplementalDataInfo.PluralInfo.Count.valueOf(countValue);
        }
        catch (Exception e) {
            String locale = this.getCldrFile().getLocaleID();
            SupplementalDataInfo.PluralInfo pluralInfo = supplementalDataInfo.getPlurals(locale);
            count = pluralInfo.getCount(DecimalQuantity_DualStorageBCD.fromExponentString(countValue));
        }
        Double numberSample = this.getExampleForPattern(numberFormat, count);
        if (numberSample == null) {
            numberSample = 0.0;
        }
        int n = fractionLength = (temp = String.valueOf(numberSample)).endsWith(".0") ? 0 : temp.length() - temp.indexOf(46) - 1;
        if (fractionLength != numberFormat.getMaximumFractionDigits()) {
            numberFormat = numberFormat.clone();
            numberFormat.setMinimumFractionDigits(fractionLength);
            numberFormat.setMaximumFractionDigits(fractionLength);
        }
        return this.formatNumber(numberFormat, numberSample);
    }

    private String formatNumber(DecimalFormat format, double value) {
        String example = format.format(value);
        return this.setBackgroundOnMatch(example, ALL_DIGITS);
    }

    private Double getExampleForPattern(DecimalFormat format, SupplementalDataInfo.PluralInfo.Count count) {
        int numDigits;
        Map<SupplementalDataInfo.PluralInfo.Count, Double> samples;
        if (this.patternExamples == null) {
            this.patternExamples = PluralSamples.getInstance(this.cldrFile.getLocaleID());
        }
        if ((samples = this.patternExamples.getSamples(numDigits = format.getMinimumIntegerDigits())) == null) {
            return null;
        }
        return samples.get((Object)count);
    }

    private void handleCurrency(String xpath, XPathParts parts, String value, List<String> examples) {
        String currency = parts.getAttributeValue(-2, "type");
        String fullPath = this.cldrFile.getFullXPath(xpath, false);
        if (parts.contains("symbol")) {
            if (fullPath != null && fullPath.contains("[@choice=\"true\"]")) {
                ChoiceFormat cf = new ChoiceFormat(value);
                value = cf.format(123456.789);
            }
            if (value == null) {
                throw new NullPointerException(String.valueOf(this.cldrFile.getSourceLocation(fullPath)) + ": " + this.cldrFile.getLocaleID() + ": : Error: no currency symbol for " + currency);
            }
            DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat(currency, value);
            String result = x.format(123456.789);
            result = this.setBackground(result).replace(value, backgroundEndSymbol + value + backgroundStartSymbol);
            examples.add(result);
        } else if (parts.contains("displayName")) {
            this.formatCountValue(xpath, parts, value, examples);
        }
    }

    private void handleDateRangePattern(String value, List<String> examples) {
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", 2, 0);
        examples.add(ExampleGenerator.format(value, this.setBackground(dateFormat.format(DATE_SAMPLE)), this.setBackground(dateFormat.format(DATE_SAMPLE2))));
    }

    private void handleEras(XPathParts parts, String value, List<String> examples) {
        SupplementalCalendarData.CalendarData calendarData;
        String calendarId = parts.getAttributeValue(3, "type");
        String type = parts.getAttributeValue(-1, "type");
        String id = calendarId;
        if (id.equals("generic") || id.equals("iso8601")) {
            id = "gregorian";
        }
        if ((calendarData = supplementalDataInfo.getCalendarData().get(id)) == null) {
            throw new IllegalArgumentException("Could not load supplementalCalendarData for " + id);
        }
        int typeIndex = Integer.parseInt(type);
        SupplementalCalendarData.EraData eraData = calendarData.get(typeIndex);
        if (eraData == null) {
            return;
        }
        GregorianCalendar startCal = eraData.getStartCalendar();
        GregorianCalendar endCal = eraData.getEndCalendar();
        SupplementalCalendarData.EraData eminusone = calendarData.get(typeIndex - 1);
        SupplementalCalendarData.EraData eplusone = calendarData.get(typeIndex + 1);
        SupplementalCalendarData.EraData prevEra = null;
        SupplementalCalendarData.EraData nextEra = null;
        if (eminusone != null && eminusone.compareTo(eraData) < 0) {
            prevEra = eminusone;
        } else if (eplusone != null && eplusone.compareTo(eraData) < 0) {
            prevEra = eplusone;
        }
        if (eminusone != null && eminusone.compareTo(eraData) > 0) {
            nextEra = eminusone;
        } else if (eplusone != null && eplusone.compareTo(eraData) > 0) {
            nextEra = eplusone;
        }
        if (startCal == null && prevEra != null && prevEra.getEnd() != null) {
            startCal = prevEra.getEndCalendar();
            startCal.setTimeInMillis(startCal.getTimeInMillis() + 5184000000L);
        }
        if (endCal == null && nextEra != null && nextEra.getStart() != null) {
            endCal = nextEra.getStartCalendar();
            endCal.setTimeInMillis(endCal.getTimeInMillis() - 5184000000L);
        }
        GregorianCalendar sampleDate = null;
        if (startCal != null && endCal != null) {
            sampleDate = endCal;
            sampleDate.setTimeInMillis(sampleDate.getTimeInMillis() - 5184000000L);
        } else if (startCal == null && endCal != null) {
            sampleDate = endCal;
            sampleDate.setTimeInMillis(sampleDate.getTimeInMillis() - 5184000000L);
        } else if (startCal != null && endCal == null) {
            sampleDate = new GregorianCalendar(2002, 6, 15);
            if (sampleDate.before(startCal)) {
                sampleDate = startCal;
                sampleDate.setTimeInMillis(sampleDate.getTimeInMillis() + 5184000000L);
            }
        } else {
            sampleDate = null;
        }
        if (sampleDate == null) {
            return;
        }
        Date sample = sampleDate.getTime();
        String skeleton = "Gy";
        String checkPath = "//ldml/dates/calendars/calendar[@type=\"" + calendarId + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeleton + "\"]";
        String dateFormat = this.cldrFile.getWinningValue(checkPath);
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendarId, dateFormat);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        String[] eraNames = dfs.getEras();
        eraNames[typeIndex] = value;
        dfs.setEras(eraNames);
        sdf.setDateFormatSymbols(dfs);
        examples.add(sdf.format(sample));
    }

    void handleQuarters(XPathParts parts, String value, List<String> examples) {
        String calendarId = parts.getAttributeValue(3, "type");
        if (!calendarId.equals("gregorian")) {
            return;
        }
        String width = parts.findAttributeValue("quarterWidth", "type");
        if (width.equals("narrow")) {
            return;
        }
        String context = parts.findAttributeValue("quarterContext", "type");
        String type = parts.getAttributeValue(-1, "type");
        int quarterIndex = Integer.parseInt(type) - 1;
        String skeleton = width.equals("wide") ? "yQQQQ" : "yQQQ";
        String checkPath = "//ldml/dates/calendars/calendar[@type=\"" + calendarId + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeleton + "\"]";
        String dateFormat = this.cldrFile.getWinningValue(checkPath);
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendarId, dateFormat);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        int widthVal = width.equals("abbreviated") ? 0 : 1;
        String[] quarterNames = dfs.getQuarters(0, widthVal);
        quarterNames[quarterIndex] = value;
        dfs.setQuarters(quarterNames, 0, widthVal);
        sdf.setDateFormatSymbols(dfs);
        sdf.setTimeZone(ZONE_SAMPLE);
        int[] monthSamples = new int[]{1, 4, 7, 10};
        int month = monthSamples[quarterIndex];
        this.calendar.set(1999, month, 5, 13, 25, 59);
        Date sample = this.calendar.getTime();
        examples.add(sdf.format(sample));
    }

    private void handleRelative(String xpath, XPathParts parts, String value, List<String> examples) {
        String type = parts.findAttributeValue("field", "type");
        String skeleton = type.startsWith("hour") ? "Hm" : (type.startsWith("minute") || type.startsWith("second") ? "ms" : (type.startsWith("year") || type.startsWith("month") || type.startsWith("quarter") ? "yMMMM" : "MMMMd"));
        String availableFormatPath = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + skeleton + "\"]";
        String dateFormat = this.cldrFile.getWinningValue(availableFormatPath);
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat("gregorian", dateFormat);
        String sampleDate = sdf.format(DATE_SAMPLE);
        String contextTransformPath = "//ldml/contextTransforms/contextTransformUsage[@type=\"relative\"]/contextTransform[@type=\"stand-alone\"]";
        String contextTransformValue = this.cldrFile.getWinningValue(contextTransformPath);
        String example1 = sampleDate + " (" + value + ")";
        if (contextTransformValue != null && contextTransformValue.equals("titlecase-firstword")) {
            value = TITLECASE.apply(Locale.forLanguageTag(this.getCldrFile().getLocaleID()), null, value);
        }
        String example2 = value + " (" + sampleDate + ")";
        examples.add("Set letter case for top example:");
        if (parts.contains("relativeTimePattern")) {
            String count = parts.getAttributeValue(-1, "count");
            List<String> exampleCounts = COUNTS.get(count);
            String exampleCount = exampleCounts.get(0);
            if (exampleCounts.size() > 1) {
                int exampleCountSize = exampleCounts.size();
                PluralRules.DecimalQuantitySamples samples = this.pluralInfo.getPluralRules().getDecimalSamples(count, PluralRules.SampleType.INTEGER);
                if (samples == null) {
                    exampleCount = exampleCounts.get(exampleCountSize - 1);
                } else {
                    Map<SupplementalDataInfo.PluralInfo.Count, String> countToStringExamplesMap = this.pluralInfo.getCountToStringExamplesMap();
                    String stringExamples = countToStringExamplesMap.get((Object)SupplementalDataInfo.PluralInfo.Count.valueOf(count));
                    for (int i = 1; i < exampleCountSize; ++i) {
                        String exampleCountTest = exampleCounts.get(i);
                        if (!stringExamples.contains(exampleCountTest)) continue;
                        exampleCount = exampleCountTest;
                        break;
                    }
                }
            }
            if (!exampleCount.contains(".")) {
                DecimalFormat df = this.icuServiceBuilder.getNumberFormat("0");
                exampleCount = df.format(Integer.parseInt(exampleCount));
            } else {
                DecimalFormat df = this.icuServiceBuilder.getNumberFormat("0.0");
                exampleCount = df.format(Double.parseDouble(exampleCount));
            }
            examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(example1), exampleCount)));
            examples.add(this.invertBackground(ExampleGenerator.format(this.setBackground(example2), exampleCount)));
        } else {
            examples.add(ExampleGenerator.format(example1, new Object[0]));
            examples.add(ExampleGenerator.format(example2, new Object[0]));
        }
        examples.add("See letter case instructions at right.");
    }

    private String getLocaleDisplayPattern(String elementToOverride, String element, String value) {
        String localeDisplayPatternPath = "//ldml/localeDisplayNames/localeDisplayPattern/";
        if (elementToOverride.equals(element)) {
            return value;
        }
        return this.cldrFile.getWinningValue("//ldml/localeDisplayNames/localeDisplayPattern/" + elementToOverride);
    }

    private void handleDisplayNames(String xpath, XPathParts parts, String value, List<String> examples) {
        block34: {
            block36: {
                String nameType;
                block35: {
                    String result = null;
                    if (parts.contains("codePatterns")) {
                        String type = parts.getAttributeValue(-1, "type");
                        result = ExampleGenerator.format(value, this.setBackground(type.equals("language") ? "ace" : (type.equals("script") ? "Avst" : (type.equals("territory") ? "057" : "CODE"))));
                        examples.add(result);
                        return;
                    }
                    if (parts.contains("localeDisplayPattern")) {
                        String element = parts.getElement(-1);
                        value = this.setBackground(value);
                        String localeKeyTypePattern = this.getLocaleDisplayPattern("localeKeyTypePattern", element, value);
                        String localePattern = this.getLocaleDisplayPattern("localePattern", element, value);
                        String localeSeparator = this.getLocaleDisplayPattern("localeSeparator", element, value);
                        ArrayList<String> locales = new ArrayList<String>();
                        if (element.equals("localePattern")) {
                            locales.add("uz-AF");
                        }
                        locales.add(element.equals("localeKeyTypePattern") ? "uz-Arab-u-tz-etadd" : "uz-Arab-AF");
                        locales.add("uz-Arab-AF-u-tz-etadd-nu-arab");
                        NameGetter nameGetter = this.cldrFile.nameGetter();
                        for (int i = 0; i < locales.size(); ++i) {
                            examples.add(this.invertBackground(nameGetter.getNameFromIdentifierEtc((String)locales.get(i), NameGetter.NameOpt.DEFAULT, localeKeyTypePattern, localePattern, localeSeparator)));
                        }
                        return;
                    }
                    if (!parts.contains("languages") && !parts.contains("scripts") && !parts.contains("territories")) break block34;
                    String type = parts.getAttributeValue(-1, "type");
                    if (type.contains("_")) {
                        result = value != null && !value.equals(type) ? value : this.cldrFile.getBaileyValue(xpath, null, null);
                        examples.add(result);
                        return;
                    }
                    value = this.setBackground(value);
                    String menuAttr = parts.getAttributeValue(-1, "menu");
                    if (menuAttr != null) {
                        String extension;
                        String core;
                        XPathParts other = parts.cloneAsThawed();
                        switch (menuAttr) {
                            case "core": {
                                core = value;
                                extension = this.cldrFile.getStringValue(other.setAttribute(-1, "menu", "extension").toString());
                                break;
                            }
                            default: {
                                core = this.cldrFile.getStringValue(other.setAttribute(-1, "menu", "core").toString());
                                extension = value;
                            }
                        }
                        String localePattern = this.getCldrFile().getStringValue("//ldml/localeDisplayNames/localeDisplayPattern/localePattern");
                        examples.add(this.invertBackground(MessageFormat.format(localePattern, core, extension)));
                        return;
                    }
                    nameType = parts.getElement(3);
                    Map<String, String> likely = supplementalDataInfo.getLikelySubtags();
                    String alt = parts.getAttributeValue(-1, "alt");
                    boolean isStandAloneValue = "stand-alone".equals(alt);
                    if (!isStandAloneValue) {
                        Object tag = "language".equals(nameType) ? type : "und_" + type;
                        String max = LikelySubtags.maximize((String)tag, likely);
                        if (max == null) {
                            return;
                        }
                        LanguageTagParser ltp = new LanguageTagParser().set(max);
                        String languageName = null;
                        String scriptName = null;
                        String territoryName = null;
                        if (nameType.equals("language")) {
                            languageName = value;
                        } else if (nameType.equals("script")) {
                            scriptName = value;
                        } else {
                            territoryName = value;
                        }
                        if (languageName == null) {
                            languageName = this.cldrFile.getStringValueWithBailey(NameType.LANGUAGE.getKeyPath(ltp.getLanguage()));
                            if (languageName == null) {
                                languageName = this.cldrFile.getStringValueWithBailey(NameType.LANGUAGE.getKeyPath("en"));
                            }
                            if (languageName == null) {
                                languageName = ltp.getLanguage();
                            }
                        }
                        if (scriptName == null) {
                            scriptName = this.cldrFile.getStringValueWithBailey(NameType.SCRIPT.getKeyPath(ltp.getScript()));
                            if (scriptName == null) {
                                scriptName = this.cldrFile.getStringValueWithBailey(NameType.SCRIPT.getKeyPath("Latn"));
                            }
                            if (scriptName == null) {
                                scriptName = ltp.getScript();
                            }
                        }
                        if (territoryName == null) {
                            territoryName = this.cldrFile.getStringValueWithBailey(NameType.TERRITORY.getKeyPath(ltp.getRegion()));
                            if (territoryName == null) {
                                territoryName = this.cldrFile.getStringValueWithBailey(NameType.TERRITORY.getKeyPath("US"));
                            }
                            if (territoryName == null) {
                                territoryName = ltp.getRegion();
                            }
                        }
                        languageName = languageName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        scriptName = scriptName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        territoryName = territoryName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        String localePattern = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localePattern");
                        String localeSeparator = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator");
                        String scriptTerritory = ExampleGenerator.format(localeSeparator, scriptName, territoryName);
                        if (!nameType.equals("script")) {
                            examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, territoryName)));
                        }
                        if (!nameType.equals("territory")) {
                            examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, scriptName)));
                        }
                        examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, scriptTerritory)));
                    }
                    if (isStandAloneValue) break block35;
                    Output<String> pathWhereFound = new Output<String>();
                    if (this.cldrFile.getStringValueWithBailey(xpath + ALT_STAND_ALONE, pathWhereFound, null) != null && ((String)pathWhereFound.value).contains(ALT_STAND_ALONE)) break block36;
                }
                String codePattern = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/codePatterns/codePattern[@type=\"" + nameType + "\"]");
                examples.add(this.invertBackground(ExampleGenerator.format(codePattern, value)));
            }
            return;
        }
        if (parts.getElement(-1).equals("type")) {
            String kpath = "//ldml/localeDisplayNames/keys/key[@type=\"collation\"]";
            String ktppath = "//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern";
            String ktpath = "//ldml/localeDisplayNames/types/type[@key=\"collation\"][@type=\"dictionary\"]";
            String ktspath = "//ldml/localeDisplayNames/types/type[@key=\"collation\"][@type=\"dictionary\"][@scope=\"core\"]";
            String key = parts.getAttributeValue(-1, "key");
            String type = parts.getAttributeValue(-1, "type");
            String scope = parts.getAttributeValue(-1, "scope");
            String keyPath = kpath.replace("collation", key);
            if (scope != null) {
                String keyName = this.getCldrFile().getStringValue(keyPath);
                examples.add(this.setBackground(keyName));
                examples.add(this.setBackground("\u00a0\u00a0\u00a0others\u2026"));
                examples.add(this.setBackground("\u00a0\u00a0\u00a0") + value);
                examples.add(this.setBackground("\u00a0\u00a0\u00a0\u2026others"));
                String keyTypePattern = this.getCldrFile().getStringValue(ktppath);
                String combined = this.invertBackground(MessageFormat.format(keyTypePattern, keyName, this.setBackground(value)));
                examples.add(combined);
            }
        }
    }

    private String formatExampleList(String[] examples) {
        String result = examples[0];
        int len = examples.length;
        for (int i = 1; i < len; ++i) {
            result = this.addExampleResult(examples[i], result);
        }
        return result;
    }

    public String formatExampleList(Collection<String> examples) {
        if (examples == null || examples.isEmpty()) {
            return null;
        }
        String result = "";
        boolean first = true;
        for (String example : examples) {
            if (first) {
                result = example;
                first = false;
                continue;
            }
            result = this.addExampleResult(example, result);
        }
        return result;
    }

    public static String format(String format, Object ... objects) {
        if (format == null) {
            return null;
        }
        return MessageFormat.format(format, objects);
    }

    public static String unchainException(Exception e) {
        Object stackStr = "[unknown stack]<br>";
        try {
            StringWriter asString = new StringWriter();
            e.printStackTrace(new PrintWriter(asString));
            stackStr = "<pre>" + String.valueOf(asString) + "</pre>";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stackStr;
    }

    private String setBackground(String inputPattern) {
        if (inputPattern == null) {
            return "?";
        }
        Matcher m4 = PARAMETER.matcher(inputPattern);
        return backgroundStartSymbol + m4.replaceAll("\ue235$1\ue234") + backgroundEndSymbol;
    }

    private String setBackgroundExceptMatch(String input, Pattern patternToEmbed) {
        Matcher m4 = patternToEmbed.matcher(input);
        return backgroundStartSymbol + m4.replaceAll("\ue235$1\ue234") + backgroundEndSymbol;
    }

    private String setBackgroundOnMatch(String inputPattern, Pattern patternToEmbed) {
        Matcher m4 = patternToEmbed.matcher(inputPattern);
        return m4.replaceAll("\ue234$1\ue235");
    }

    private String finalizeBackground(String input) {
        if (input == null) {
            return null;
        }
        String coreString = TransliteratorUtilities.toHTML.transliterate(input).replace("\ue234\ue235", "").replace("\ue235\ue234", "").replace(backgroundStartSymbol, this.backgroundStart).replace(backgroundEndSymbol, this.backgroundEnd).replace(backgroundAutoStartSymbol, backgroundAutoStart).replace(backgroundAutoEndSymbol, backgroundAutoEnd).replace(exampleSeparatorSymbol, "</div><div class='cldr_example'>").replace(exampleStartAutoSymbol, exampleStartAuto).replace(exampleStartRTLSymbol, exampleStartRTL).replace(exampleStartHeaderSymbol, exampleStartHeader).replace(exampleEndSymbol, exampleEnd).replace(startItalicSymbol, startItalic).replace(endItalicSymbol, endItalic).replace(startSupSymbol, startSup).replace(endSupSymbol, endSup).replace(startSubSymbol, startSub).replace(endSubSymbol, endSub);
        return input.contains(exampleStartAutoSymbol) ? coreString : exampleStart + coreString + exampleEnd;
    }

    private String invertBackground(String input) {
        return input == null ? null : backgroundStartSymbol + input.replace(backgroundStartSymbol, backgroundTempSymbol).replace(backgroundEndSymbol, backgroundStartSymbol).replace(backgroundTempSymbol, backgroundEndSymbol) + backgroundEndSymbol;
    }

    private String removeEmptyRuns(String input) {
        return input.replace("\ue234\ue235", "").replace("\ue235\ue234", "");
    }

    private String getGMTFormat(String gmtHourString, String gmtFormat, int hours) {
        return this.getGMTFormat(gmtHourString, gmtFormat, hours, 0);
    }

    private String getGMTFormat(String gmtHourString, String gmtFormat, int hours, int minutes) {
        boolean hoursBackground = false;
        if (gmtHourString == null) {
            hoursBackground = true;
            gmtHourString = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/hourFormat");
        }
        if (gmtFormat == null) {
            hoursBackground = false;
            gmtFormat = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/gmtFormat"));
        }
        String[] plusMinus = gmtHourString.split(";");
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", plusMinus[hours >= 0 ? 0 : 1]);
        dateFormat.setTimeZone(ZONE_SAMPLE);
        this.calendar.set(1999, 9, 27, Math.abs(hours), minutes, 0);
        Date sample = this.calendar.getTime();
        String hourString = dateFormat.format(sample);
        if (hoursBackground) {
            hourString = this.setBackground(hourString);
        }
        String result = ExampleGenerator.format(gmtFormat, hourString);
        return result;
    }

    private String getMZTimeFormat() {
        String timeFormat = this.cldrFile.getWinningValue("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
        if (timeFormat == null) {
            timeFormat = "HH:mm";
        }
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", timeFormat);
        dateFormat.setTimeZone(ZONE_SAMPLE);
        this.calendar.set(1999, 9, 13, 13, 25, 59);
        Date sample = this.calendar.getTime();
        String result = dateFormat.format(sample);
        return result;
    }

    public synchronized String getHelpHtml(String xpath, String value) {
        String description;
        if (this.pathDescription == null) {
            HashMap<String, List<Set<String>>> starredPaths = new HashMap<String, List<Set<String>>>();
            HashMap<String, String> extras = new HashMap<String, String>();
            this.pathDescription = new PathDescription(supplementalDataInfo, this.englishFile, extras, starredPaths, PathDescription.ErrorHandling.CONTINUE);
            if (this.helpMessages == null) {
                this.helpMessages = new HelpMessages("test_help_messages.html");
            }
        }
        if ((description = this.pathDescription.getDescription(xpath, value, null)) == null || description.equals("SKIP")) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(description);
        if (AnnotationUtil.pathIsAnnotation(xpath)) {
            String cp = AnnotationUtil.getEmojiFromXPath(xpath);
            String hex = Utility.hex(cp, 4, " U+");
            if (AnnotationUtil.haveEmojiImageFile(cp)) {
                String fn = AnnotationUtil.calculateEmojiImageFilename(cp);
                buffer.append("\n\n<br><img class='emojiImage' height='64px' width='auto' src='images/emoji/" + fn + "' title='U+" + hex + "'>\n");
            }
        }
        return buffer.toString();
    }

    public static String simplify(String exampleHtml) {
        return ExampleGenerator.simplify(exampleHtml, false);
    }

    public static String simplify(String exampleHtml, boolean internal) {
        int endIndex;
        if (exampleHtml == null) {
            return null;
        }
        if (internal) {
            return "\u3016" + ((String)exampleHtml).replace(backgroundStartSymbol, "\u276c").replace(backgroundEndSymbol, "\u276d") + "\u3017";
        }
        int startIndex = ((String)exampleHtml).indexOf(exampleStartHeader);
        if (startIndex >= 0 && (endIndex = ((String)exampleHtml).indexOf(exampleEnd, startIndex)) > startIndex) {
            String head = ((String)exampleHtml).substring(0, startIndex);
            String tail = ((String)exampleHtml).substring(endIndex += exampleEnd.length());
            exampleHtml = head + tail;
        }
        return ((String)exampleHtml).replace(exampleStart, "\u3016").replace(exampleStartAuto, "\u3010").replace(exampleStartRTL, "\u3010\u20ea").replace(exampleEnd, "\u3017").replace("<span class='cldr_substituted'>", "\u276c").replace(backgroundAutoEnd, "\u276d");
    }

    static {
        Calendar calendar = Calendar.getInstance(ZONE_SAMPLE, ULocale.ENGLISH);
        calendar.set(1999, 8, 5, 13, 25, 59);
        DATE_SAMPLE = calendar.getTime();
        calendar.set(1999, 9, 27, 13, 25, 59);
        DATE_SAMPLE2 = calendar.getTime();
        calendar.set(1999, 8, 5, 7, 0, 0);
        DATE_SAMPLE3 = calendar.getTime();
        calendar.set(1999, 8, 5, 23, 0, 0);
        DATE_SAMPLE4 = calendar.getTime();
        calendar.set(1999, 8, 5, 3, 25, 59);
        DATE_SAMPLE5 = calendar.getTime();
        CURRENCY_SAMPLES = ImmutableList.of(DecimalQuantity_DualStorageBCD.fromExponentString("1.23"), DecimalQuantity_DualStorageBCD.fromExponentString("0"), DecimalQuantity_DualStorageBCD.fromExponentString("2.34"), DecimalQuantity_DualStorageBCD.fromExponentString("3.45"), DecimalQuantity_DualStorageBCD.fromExponentString("5.67"), DecimalQuantity_DualStorageBCD.fromExponentString("1"));
        PARAMETER = PatternCache.get("(\\{(?:0|[1-9][0-9]*)\\})");
        PARAMETER_SKIP0 = PatternCache.get("(\\{[1-9][0-9]*\\})");
        ALL_DIGITS = PatternCache.get("(\\p{Nd}+(.\\p{Nd}+)?)");
        generatingCalendar = Calendar.getInstance(ULocale.US);
        FIRST_INTERVAL = ExampleGenerator.getDate(2008, 10, 13, 5, 7, 9);
        SECOND_INTERVAL = CldrUtility.asMap(new Object[][]{{"G", ExampleGenerator.getDate(1009, 11, 14, 17, 25, 35)}, {"y", ExampleGenerator.getDate(2009, 11, 14, 17, 26, 35)}, {"M", ExampleGenerator.getDate(2008, 11, 14, 17, 26, 35)}, {"d", ExampleGenerator.getDate(2008, 10, 14, 17, 26, 35)}, {"a", ExampleGenerator.getDate(2008, 10, 13, 17, 26, 35)}, {"h", ExampleGenerator.getDate(2008, 10, 13, 6, 26, 35)}, {"m", ExampleGenerator.getDate(2008, 10, 13, 5, 26, 35)}, {"s", ExampleGenerator.getDate(2008, 10, 13, 5, 25, 35)}});
        FIRST_INTERVAL2 = ExampleGenerator.getDate(2008, 1, 3, 5, 7, 9);
        SECOND_INTERVAL2 = CldrUtility.asMap(new Object[][]{{"G", ExampleGenerator.getDate(1009, 2, 4, 18, 8, 10)}, {"y", ExampleGenerator.getDate(2009, 2, 4, 18, 8, 10)}, {"M", ExampleGenerator.getDate(2008, 2, 4, 18, 8, 10)}, {"d", ExampleGenerator.getDate(2008, 1, 4, 18, 8, 10)}, {"a", ExampleGenerator.getDate(2008, 1, 3, 18, 8, 10)}, {"h", ExampleGenerator.getDate(2008, 1, 3, 6, 7, 10)}, {"m", ExampleGenerator.getDate(2008, 1, 3, 5, 7, 9)}});
        COUNTS = new HashMap<String, List<String>>(){
            {
                this.put("zero", List.of("0"));
                this.put("one", List.of("1"));
                this.put("two", List.of("2"));
                this.put("few", List.of("3", "20"));
                this.put("many", List.of("11", "1000000", "6", "7", "21", "0.5"));
                this.put("other", List.of("100", "22", "23", "14", "0.5"));
            }
        };
        TITLECASE = CaseMap.toTitle().wholeString().noLowercase();
        SUSF = new SimpleUnicodeSetFormatter(SimpleUnicodeSetFormatter.BASIC_COLLATOR);
        SUSFNS = new SimpleUnicodeSetFormatter(SimpleUnicodeSetFormatter.BASIC_COLLATOR, CodePointEscaper.FORCE_ESCAPE_WITH_NONSPACING);
        NEEDS_LRM = new UnicodeSet("[:BidiClass=R:]").freeze();
        BACKGROUND_TRANSFORM = x -> backgroundStartSymbol + x + backgroundEndSymbol;
    }

    public class IntervalFormat {
        DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
        SimpleDateFormat firstFormat = new SimpleDateFormat();
        SimpleDateFormat secondFormat = new SimpleDateFormat();
        StringBuilder first = new StringBuilder();
        StringBuilder second = new StringBuilder();
        BitSet letters = new BitSet();

        public String format(Date earlier, Date later) {
            if (earlier == null || later == null) {
                return null;
            }
            if (later.compareTo(earlier) < 0) {
                Date tmp = earlier;
                earlier = later;
                later = tmp;
            }
            return this.firstFormat.format(earlier) + this.secondFormat.format(later);
        }

        public IntervalFormat setPattern(XPathParts parts, String pattern) {
            if (this.formatParser == null || pattern == null) {
                return this;
            }
            try {
                this.formatParser.set(pattern);
            }
            catch (NullPointerException e) {
                System.err.println("Caught NullPointerException in IntervalFormat.setPattern, pattern = " + pattern);
                e.printStackTrace();
                return null;
            }
            this.first.setLength(0);
            this.second.setLength(0);
            boolean doFirst = true;
            this.letters.clear();
            for (Object item : this.formatParser.getItems()) {
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    char c = item.toString().charAt(0);
                    if (this.letters.get(c)) {
                        doFirst = false;
                    } else {
                        this.letters.set(c);
                    }
                    if (doFirst) {
                        this.first.append(item);
                        continue;
                    }
                    this.second.append(item);
                    continue;
                }
                if (doFirst) {
                    this.first.append(this.formatParser.quoteLiteral((String)item));
                    continue;
                }
                this.second.append(this.formatParser.quoteLiteral((String)item));
            }
            String calendar = parts.findAttributeValue("calendar", "type");
            this.firstFormat = ExampleGenerator.this.icuServiceBuilder.getDateFormat(calendar, this.first.toString());
            this.firstFormat.setTimeZone(GMT_ZONE_SAMPLE);
            this.secondFormat = ExampleGenerator.this.icuServiceBuilder.getDateFormat(calendar, this.second.toString());
            this.secondFormat.setTimeZone(GMT_ZONE_SAMPLE);
            return this;
        }
    }

    public static enum UnitLength {
        LONG(XListFormatter.ListTypeLength.UNIT_WIDE),
        SHORT(XListFormatter.ListTypeLength.UNIT_SHORT),
        NARROW(XListFormatter.ListTypeLength.UNIT_NARROW);

        final String typeString = "[@type=\"" + this.name().toLowerCase(Locale.ENGLISH) + "\"]";
        final XListFormatter.ListTypeLength listTypeLength;

        private UnitLength(XListFormatter.ListTypeLength listTypeLength) {
            this.listTypeLength = listTypeLength;
        }

        public static UnitLength from(String listPatternType) {
            switch (listPatternType) {
                case "unit": {
                    return LONG;
                }
                case "unit-narrow": {
                    return NARROW;
                }
                case "unit-short": {
                    return SHORT;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static enum PersonNameScripts {
        Latn,
        Cyrl,
        Jpan;

    }

    private static class PersonNamesCache
    implements ExampleCache.ClearableCache {
        Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames = null;
        PersonNameFormatter personNameFormatter = null;

        private PersonNamesCache() {
        }

        @Override
        public void clear() {
            this.sampleNames = null;
            this.personNameFormatter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<PersonNameFormatter.SampleType, SimpleNameObject> getSampleNames(CLDRFile cldrFile) {
            PersonNamesCache personNamesCache = this;
            synchronized (personNamesCache) {
                if (this.sampleNames == null) {
                    this.sampleNames = PersonNameFormatter.loadSampleNames(cldrFile);
                }
                return this.sampleNames;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PersonNameFormatter getPersonNameFormatter(CLDRFile cldrFile) {
            PersonNamesCache personNamesCache = this;
            synchronized (personNamesCache) {
                if (this.personNameFormatter == null) {
                    this.personNameFormatter = new PersonNameFormatter(cldrFile);
                }
                return this.personNameFormatter;
            }
        }

        public String toString() {
            return "[" + (this.sampleNames == null ? "" : Joiner.on('\n').join(this.sampleNames.entrySet())) + ", " + (this.personNameFormatter == null ? "" : this.personNameFormatter.toString()) + "]";
        }
    }
}

