/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.Validity;

public class ChartSubdivisions
extends Chart {
    static SubdivisionNames EN = new SubdivisionNames("en", "main", "subdivisions");

    public static void main(String[] args) {
        new ChartSubdivisions().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "Territory Subdivisions";
    }

    @Override
    public String getExplanation() {
        return "<p>Shows the subdivisions of territories, using the Unicode Subdivision Codes with the English names (and sort order). For more information see the LDML spec.<p>" + Chart.dataScrapeMessage(null, null, "common/supplemental/subdivisions.xml", "common/validity/subdivision.xml");
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Region", "class='source'", null, "class='source'", true).setSortPriority(1).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("Subdivision1", "class='target'", null, "class='target'", true).setSortPriority(2).addColumn("Code", "class='target'", CldrUtility.getDoubleLinkMsg(), "class='target'", true).setBreakSpans(true).addColumn("Subdivision2", "class='target'", null, "class='target'", true).setSortPriority(3).addColumn("Code", "class='target'", CldrUtility.getDoubleLinkMsg(), "class='target'", true);
        Map<String, Row.R2<List<String>, String>> aliases = SDI.getLocaleAliasInfo().get("subdivision");
        HashSet remainder = new HashSet(Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.region).get((Object)Validity.Status.regular));
        Relation inverseAliases = Relation.of(new HashMap(), TreeSet.class);
        for (Map.Entry<String, Row.R2<List<String>, String>> entry : aliases.entrySet()) {
            List value = (List)entry.getValue().get0();
            inverseAliases.putAll(value, entry.getKey());
        }
        for (String container : SDI.getContainersForSubdivisions()) {
            boolean containerIsRegion = SubdivisionNames.isRegionCode(container);
            String region = containerIsRegion ? container : SubdivisionNames.getRegionFromSubdivision(container);
            for (String contained : SDI.getContainedSubdivisions(container)) {
                Row.R2<List<String>, String> a2;
                if (contained.equals("usas")) {
                    boolean bl = false;
                }
                if (SDI.getContainedSubdivisions(contained) != null) continue;
                String s1 = containerIsRegion ? contained : container;
                String s2 = containerIsRegion ? "" : contained;
                Object name1 = ChartSubdivisions.getName(s1);
                Object name2 = ChartSubdivisions.getName(s2);
                Row.R2<List<String>, String> a1 = aliases.get(s1);
                if (a1 != null) {
                    name1 = "= " + (String)((List)a1.get0()).get(0) + " (" + (String)name1 + ")";
                }
                if ((a2 = aliases.get(s2)) != null) {
                    name2 = "= " + (String)((List)a2.get0()).get(0) + " (" + (String)name2 + ")";
                }
                tablePrinter.addRow().addCell((Comparable)((Object)ENGLISH.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, region))).addCell((Comparable)((Object)region)).addCell((Comparable)name1).addCell((Comparable)((Object)s1)).addCell((Comparable)name2).addCell((Comparable)((Object)s2)).finishRow();
                remainder.remove(region);
            }
        }
        for (String region : remainder) {
            Set regionAliases = inverseAliases.get(region);
            tablePrinter.addRow().addCell((Comparable)((Object)ENGLISH.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, region))).addCell((Comparable)((Object)region)).addCell((Comparable)(regionAliases == null ? "\u00abnone\u00bb" : "=" + Joiner.on(", ").join(regionAliases))).addCell((Comparable)((Object)"")).addCell((Comparable)((Object)"")).addCell((Comparable)((Object)"")).finishRow();
        }
        pw.write(tablePrinter.toTable());
    }

    private static String getName(String s1) {
        return s1.isEmpty() ? "" : TransliteratorUtilities.toHTML.transform(CldrUtility.ifNull(EN.get(s1), ""));
    }
}

