/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringIterables;

public class LanguageCodeConverter {
    private static Map<String, String> languageNameToCode = new TreeMap<String, String>();
    private static Set<String> exceptionCodes = new TreeSet<String>();
    private static Set<String> parseErrors = new LinkedHashSet<String>();
    private static Map<String, Row.R2<List<String>, String>> languageAliases = CLDRConfig.getInstance().getSupplementalDataInfo().getLocaleAliasInfo().get("language");
    public static final Map<String, String> GOOGLE_CLDR = Builder.with(new LinkedHashMap()).put("iw", "he").put("jw", "jv").put("tl", "fil").put("pt-BR", "pt").put("xx-bork", "x_bork").put("xx-elmer", "x_elmer").put("xx-hacker", "x_hacker").put("xx-pirate", "x_pirate").put("xx-klingon", "tlh").put("zh-CN", "zh").put("zh-TW", "zh_Hant").put("zh-HK", "zh_Hant_HK").put("sit-NP", "lif").put("ut", "und").put("un", "und").put("xx", "und").freeze();
    public static final Map<String, String> CLDR_GOOGLE = Builder.with(new HashMap()).putAllTransposed(GOOGLE_CLDR).freeze();
    public static final Map<String, String> EXTRA_SCRIPTS = Builder.with(new HashMap()).on("crs", "pcm", "tlh").put("Latn").freeze();

    private static void addNameToCode(String type, String code, String name) {
        if (code.equals("mru") && name.equals("mru")) {
            return;
        }
        String oldCode = languageNameToCode.get(name = name.toLowerCase(Locale.ENGLISH));
        if (oldCode != null) {
            if (!oldCode.equals(code)) {
                parseErrors.add("Name Collision! " + type + ": " + name + " <" + oldCode + ", " + code + ">");
            } else {
                return;
            }
        }
        languageNameToCode.put(name, code);
    }

    public static String toGoogleLocaleId(String localeId) {
        String result = CLDR_GOOGLE.get(localeId = localeId.replace("-", "_"));
        result = result == null ? localeId : result;
        return result.replace("_", "-");
    }

    public static String fromGoogleLocaleId(String localeId) {
        String result = GOOGLE_CLDR.get(localeId = localeId.replace("_", "-"));
        result = result == null ? localeId : result;
        return result.replace("-", "_");
    }

    public static String toUnderbarLocale(String localeId) {
        return localeId.replace("-", "_");
    }

    public static String toHyphenLocale(String localeId) {
        return localeId.replace("_", "-");
    }

    public static String getCodeForName(String languageName) {
        return languageNameToCode.get(languageName.toLowerCase(Locale.ENGLISH));
    }

    public static Set<String> getExceptionCodes() {
        return exceptionCodes;
    }

    public static Set<String> getParseErrors() {
        return parseErrors;
    }

    public static Map<String, String> getLanguageNameToCode() {
        return languageNameToCode;
    }

    static {
        Map<String, Map<String, Map<String, String>>> lstreg = StandardCodes.getLStreg();
        Map<String, Map<String, String>> languages = lstreg.get("language");
        HashSet<String> validCodes = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> codeInfo : languages.entrySet()) {
            String name;
            Map<String, String> info;
            String deprecated;
            List replacements;
            String code = codeInfo.getKey();
            Row.R2<List<String>, String> replacement = languageAliases.get(code);
            if (replacement != null && ((replacements = (List)replacement.get0()).size() != 1 || (code = (String)replacements.get(0)).contains("_")) || (deprecated = (info = codeInfo.getValue()).get("Deprecated")) != null || (name = info.get("Description")).equals("Private use")) continue;
            validCodes.add(code);
            if (name.contains("\u25aa")) {
                for (String namePart : name.split("\u25aa")) {
                    LanguageCodeConverter.addNameToCode("lstr", code, namePart);
                }
                continue;
            }
            LanguageCodeConverter.addNameToCode("lstr", code, name);
        }
        for (String code : validCodes) {
            String icuName = ULocale.getDisplayName(code, "en");
            LanguageCodeConverter.addNameToCode("cldr", code, icuName);
        }
        LanguageTagParser ltp = new LanguageTagParser();
        for (String line : StringIterables.in(CldrUtility.getUTF8Data("external/alternate_language_names.txt"))) {
            String[] parts = CldrUtility.cleanSemiFields(line);
            if (parts == null || parts.length == 0) continue;
            String code = parts[0];
            if (!validCodes.contains(code)) {
                if (code.equals("*OMIT")) {
                    parseErrors.add("Skipping " + line);
                    continue;
                }
                String base = ltp.set(code).getLanguage();
                if (!validCodes.contains(base)) {
                    Row.R2<List<String>, String> alias = languageAliases.get(base);
                    if (alias != null) {
                        code = (String)((List)alias.get0()).get(0);
                    } else {
                        parseErrors.add("Skipping " + line);
                        continue;
                    }
                }
            }
            exceptionCodes.add(LanguageCodeConverter.toUnderbarLocale(code));
            if (parts.length < 2) continue;
            Object name = parts[1];
            if (parts.length > 2) {
                name = (String)name + ";" + parts[2];
            }
            LanguageCodeConverter.addNameToCode("exception", code, (String)name);
        }
        for (String cldr : GOOGLE_CLDR.values()) {
            String goodCode = LanguageCodeConverter.toUnderbarLocale(cldr);
            exceptionCodes.add(goodCode);
        }
        languageNameToCode = Collections.unmodifiableMap(languageNameToCode);
        exceptionCodes = Collections.unmodifiableSet(exceptionCodes);
        parseErrors = Collections.unmodifiableSet(parseErrors);
    }
}

