/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowPlurals;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoreCoverageInfo;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.XPathParts;

public class ShowLocaleCoverage {
    private static final String TSV_BASE = "https://github.com/unicode-org/cldr-staging/blob/main/docs/charts/" + ToolConstants.CHART_VI.getVersionString(1, 2) + "/tsv/";
    public static final Splitter LF_SPLITTER = Splitter.on('\n');
    private static final double BASIC_THRESHOLD = 1.0;
    private static final double MODERATE_THRESHOLD = 0.995;
    private static final double MODERN_THRESHOLD = 0.995;
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final String TSV_MISSING_SUMMARY_HEADER = "#Path Level\t#Locales\tLocales\tSection\tPage\tHeader\tCode";
    private static final String TSV_MISSING_HEADER = "#LCode\tEnglish Name\tScript\tLocale Level\tPath Level\tSTStatus\tBailey\tSection\tPage\tHeader\tCode\tST Link";
    private static final String PROPERTIES_HEADER = "# coverageLevels.txt\n# Copyright \u00a9 2023 Unicode, Inc.\n# CLDR data files are interpreted according to the\n# LDML specification: http://unicode.org/reports/tr35/\n# For terms of use, see http://www.unicode.org/copyright.html\n#\n# For format and usage information, see:\n# https://cldr.unicode.org/index/cldr-spec/coverage-levels.\n\n";
    private static final String TSV_MISSING_BASIC_HEADER = "#Locale\tProv.\tUnconf.\tMissing\tPath*\tAttributes";
    private static final String TSV_MISSING_COUNTS_HEADER = "#Locale\tTargetLevel\t\u2116 Found\t\u2116 Unconfirmed\t\u2116 Missing";
    private static final boolean DEBUG = true;
    private static final char DEBUG_FILTER = '\u0000';
    private static final String LATEST = ToolConstants.CHART_VERSION;
    private static CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final StandardCodes SC = StandardCodes.make();
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = testInfo.getSupplementalDataInfo();
    private static final StandardCodes STANDARD_CODES = SC;
    private static Factory factory = testInfo.getCommonAndSeedAndMainAndAnnotationsFactory();
    private static final CLDRFile ENGLISH = factory.make("en", true);
    static final Option.Options myOptions = new Option.Options();
    private static final RegexLookup<Boolean> SUPPRESS_PATHS_CAN_BE_EMPTY = new RegexLookup<Boolean>().add("\\[@alt=\"accounting\"]", Boolean.valueOf(true)).add("\\[@alt=\"variant\"]", (Boolean)true).add("^//ldml/localeDisplayNames/territories/territory.*@alt=\"short", (Boolean)true).add("^//ldml/localeDisplayNames/languages/language.*_", (Boolean)true).add("^//ldml/numbers/currencies/currency.*/symbol", (Boolean)true).add("^//ldml/characters/exemplarCharacters", (Boolean)true);
    private static CLDRFile.DraftStatus minimumDraftStatus = CLDRFile.DraftStatus.unconfirmed;
    private static final PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(ENGLISH);
    private static Set<String> COMMON_LOCALES;
    private static final CoverageInfo coverageInfo;
    private static final Set<ULocale> ICU_Locales;

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.filter, args, true);
        Matcher matcher = PatternCache.get(MyOptions.filter.option.getValue()).matcher("");
        if (MyOptions.chart.option.doesOccur()) {
            ShowLocaleCoverage.showCoverage(null, matcher);
            return;
        }
        Set<String> locales = null;
        String organization = MyOptions.organization.option.getValue();
        boolean useOrgLevel = MyOptions.organization.option.doesOccur();
        if (useOrgLevel) {
            locales = STANDARD_CODES.getLocaleCoverageLocales(organization);
        }
        if (MyOptions.version.option.doesOccur()) {
            Object number = MyOptions.version.option.getValue().trim();
            if (!((String)number).contains(".")) {
                number = (String)number + ".0";
            }
            factory = Factory.make(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + (String)number + "/common/main/", ".*");
        } else if (MyOptions.directories.option.doesOccur()) {
            String directories = MyOptions.directories.option.getValue().trim();
            CLDRConfig cldrConfig = CONFIG;
            String base = null;
            int colonPos = directories.indexOf(58);
            if (colonPos >= 0) {
                base = directories.substring(0, colonPos).trim();
                directories = directories.substring(colonPos + 1).trim();
            } else {
                base = cldrConfig.getCldrBaseDirectory().toString();
            }
            String[] items = directories.split(",\\s*");
            File[] fullDirectories = new File[items.length];
            int i = 0;
            for (String item : items) {
                fullDirectories[i++] = new File(base + "/" + item + "/main");
            }
            factory = SimpleFactory.make(fullDirectories, ".*");
            COMMON_LOCALES = SimpleFactory.make(base + "/common/main", ".*").getAvailableLanguages();
        }
        ShowLocaleCoverage.fixCommonLocales();
        ShowLocaleCoverage.showCoverage(null, matcher, locales, useOrgLevel);
    }

    private static void fixCommonLocales() {
        if (COMMON_LOCALES == null) {
            COMMON_LOCALES = factory.getAvailableLanguages();
        }
    }

    static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher) throws IOException {
        ShowLocaleCoverage.showCoverage(anchors, matcher, null, false);
    }

    private static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher, Set<String> locales, boolean useOrgLevel) throws IOException {
        String title = "Locale Coverage";
        try (PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Locale Coverage", null, anchors));
             PrintWriter tsv_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-coverage.tsv");
             PrintWriter tsv_missing = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing.tsv");
             PrintWriter tsv_missing_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-summary.tsv");
             PrintWriter tsv_missing_basic = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-basic.tsv");
             PrintWriter tsv_missing_counts = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-counts.tsv");
             TempPrintWriter propertiesCoverage = TempPrintWriter.openUTF8Writer(CLDRPaths.COMMON_DIRECTORY + "properties/", "coverageLevels.txt");){
            tsv_missing_summary.println(TSV_MISSING_SUMMARY_HEADER);
            tsv_missing.println(TSV_MISSING_HEADER);
            tsv_missing_basic.println(TSV_MISSING_BASIC_HEADER);
            tsv_missing_counts.println(TSV_MISSING_COUNTS_HEADER);
            int propertiesCoverageTabCount = 2;
            propertiesCoverage.printlnWithTabs(2, PROPERTIES_HEADER);
            Set<String> checkModernLocales = STANDARD_CODES.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
            TreeSet<String> availableLanguages = new TreeSet<String>(factory.getAvailableLanguages());
            availableLanguages.addAll(checkModernLocales);
            AbstractMultimap languageToRegion = TreeMultimap.create();
            LanguageTagParser ltp = new LanguageTagParser();
            LanguageTagCanonicalizer ltc = new LanguageTagCanonicalizer(true);
            for (String locale : factory.getAvailable()) {
                String country = ltp.set(locale).getRegion();
                if (country.isEmpty()) continue;
                languageToRegion.put(ltc.transform(ltp.getLanguageScript()), country);
            }
            languageToRegion = ImmutableMultimap.copyOf(languageToRegion);
            ShowLocaleCoverage.fixCommonLocales();
            System.out.println(Joiner.on("\n").join(languageToRegion.asMap().entrySet()));
            System.out.println("# Writing coverage: " + String.valueOf(availableLanguages));
            NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.ENGLISH);
            percentFormat.setMaximumFractionDigits(1);
            pw.println("<p style='text-align: left'>This chart shows the coverage levels in this release. Totals are listed after the main chart.</p>\n<blockquote><ul>\n<li><a href='#main_table'>Main Table</a></li>\n<li><a href='#level_counts'>Level Counts</a></li>\n</ul></blockquote>\n<h3>Column Key</h3>\n<table class='subtle' style='margin-left:3em; margin-right:3em'>\n<tr><th>Default Region</th><td>The default region for locale code, based on likely subtags</td></tr>\n<tr><th>\u2116 Locales</th><td>Note that the coverage of regional locales inherits from their parents.</td></tr>\n<tr><th>Target Level</th><td>The default target Coverage Level in CLDR. Particular organizations may have different target levels. Languages with high levels of coverage are marked with \u2021, even though they are not tracked by the technical committee.</td></tr>\n<tr><th>\u225f</th><td>Indicates whether the CLDR Target is less than, equal to, or greater than the Computed Level.</td></tr>\n<tr><th>Computed Level</th><td>Computed from the percentage values, taking the first level that meets a threshold (currently \ud83c\udd3c " + percentFormat.format(0.995) + ", \u24dc " + percentFormat.format(0.995) + ", \u24d1 " + percentFormat.format(1.0) + ").</td></tr>\n<tr><th>ICU</th><td>Indicates whether included in the current version of ICU</td></tr>\n<tr><th>Confirmed</th><td>Confirmed items as a percentage of all supplied items. If low, the coverage can be improved by getting multiple organizations to confirm.</td></tr>\n<tr><th>\ud83c\udd3c%,\u00a0\u24dc%,\u00a0\u24d1%,\u00a0\u24d2%</th><td>Coverage at Levels: \ud83c\udd3c = Modern, \u24dc = Moderate, \u24d1 = Basic, \u24d2 = Core. The percentage of items at that level and below is computed from <i>confirmed_items/total_items</i>. A high-level summary of the meaning of the coverage values is at <a target='_blank' href='http://www.unicode.org/reports/tr35/tr35-info.html#Coverage_Levels'>Coverage Levels</a>. The Core values are described on <a target='_blank' href='https://cldr.unicode.org/index/cldr-spec/core-data-for-new-locales'>Core Data</a>. </td></tr>\n<tr><th>Missing Features</th><td>These are not single items, but rather specific features, such as plural rules or unit grammar info. They are listed if missing at the computed level. For more information, see <a href='https://cldr.unicode.org/index/locale-coverage'>Missing Features</a><br>Example: <i>\u24dc collation</i> means this feature should be supported at a Moderate level.<br><ul><li><i>Except for Core, these are not accounted for in the percent values.</i></li><li>The information needs to be provided in tickets, not through the Survey Tool.</li></ul></td></tr>\n<tr><th>" + ShowLocaleCoverage.linkTsv("", "TSVFiles") + ":</th><td>\n<ul><li>" + ShowLocaleCoverage.linkTsv("locale-coverage.tsv") + " \u2014 A version of this file, suitable for loading into a spreadsheet.</li>\n<li>" + ShowLocaleCoverage.linkTsv("locale-missing.tsv") + " \u2014 Missing items for the CLDR target locales.</li>\n<li>" + ShowLocaleCoverage.linkTsv("locale-missing-summary.tsv") + " \u2014 Summary of missing items for the CLDR target locales, by Section/Page/Header.</li>\n<li>" + ShowLocaleCoverage.linkTsv("locale-missing-basic.tsv") + " \u2014 Missing items that keep locales from reaching the Basic level.</li>\n<li>" + ShowLocaleCoverage.linkTsv("locale-missing-counts.tsv") + " \u2014 Counts of items per locale that are found, unconfirmed, or missing, at the target level. (Or at *basic, if there is no target level.)</li>\n</td></tr>\n</table>\n");
            Relation<VettingViewer.MissingStatus, String> missingPaths = Relation.of(new EnumMap(VettingViewer.MissingStatus.class), TreeSet.class, CLDRFile.getComparator(DtdType.ldml));
            TreeSet<String> unconfirmed = new TreeSet<String>(CLDRFile.getComparator(DtdType.ldml));
            Set<String> defaultContents = SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales();
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            AbstractCollection levelsToShow = new ArrayList<Level>(EnumSet.allOf(Level.class));
            levelsToShow.remove((Object)Level.COMPREHENSIVE);
            levelsToShow.remove((Object)Level.UNDETERMINED);
            levelsToShow = ImmutableList.copyOf(levelsToShow);
            AbstractCollection reversedLevels = new ArrayList<Level>(levelsToShow);
            Collections.reverse(reversedLevels);
            reversedLevels = ImmutableList.copyOf(reversedLevels);
            int localeCount = 0;
            TablePrinter tablePrinter = new TablePrinter().addColumn("Language", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("English Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Native Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Script", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Default Region", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("\u2116 Locales", "class='source'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}").addColumn("Target Level", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("\u225f", "class='target'", null, "class='target'", true).setBreakSpans(true).setSortPriority(1).setSortAscending(false).addColumn("Computed Level", "class='target'", null, "class='target'", true).setBreakSpans(true).setSortPriority(0).setSortAscending(false).addColumn("ICU", "class='target'", null, "class='target'", true).setBreakSpans(true).addColumn("Confirmed", "class='target'", null, "class='targetRight' style='color:gray'", true).setBreakSpans(true).setCellPattern("{0,number,0.0%}");
            NumberFormat tsvPercent = NumberFormat.getPercentInstance(Locale.ENGLISH);
            tsvPercent.setMaximumFractionDigits(2);
            block50: for (Level level : reversedLevels) {
                String titleLevel = level.getAbbreviation() + "%";
                tablePrinter.addColumn(titleLevel, "class='target'", null, "class='targetRight'", true).setCellPattern("{0,number,0.0%}").setBreakSpans(true);
                switch (level) {
                    default: {
                        tablePrinter.setSortPriority(2).setSortAscending(false);
                        continue block50;
                    }
                    case BASIC: {
                        tablePrinter.setSortPriority(3).setSortAscending(false);
                        continue block50;
                    }
                    case MODERATE: {
                        tablePrinter.setSortPriority(4).setSortAscending(false);
                        continue block50;
                    }
                    case MODERN: 
                }
                tablePrinter.setSortPriority(5).setSortAscending(false);
            }
            tablePrinter.addColumn("Missing Features", "class='target'", null, "class='target'", true).setBreakSpans(true);
            long start = System.currentTimeMillis();
            LikelySubtags likelySubtags = new LikelySubtags();
            EnumMap<Level, Double> targetLevel = new EnumMap<Level, Double>(Level.class);
            targetLevel.put(Level.CORE, 0.02);
            targetLevel.put(Level.BASIC, 0.16);
            targetLevel.put(Level.MODERATE, 0.33);
            targetLevel.put(Level.MODERN, 1.0);
            TreeMultimap<String, String> pathToLocale = TreeMultimap.create();
            Counter<Level> computedLevels = new Counter<Level>();
            Counter<Level> computedSublocaleLevels = new Counter<Level>();
            for (String locale : availableLanguages) {
                try {
                    String visibleLevelGoal;
                    Level foundLevel;
                    Object goalLevel;
                    String base;
                    if (locale.contains("supplemental") || locales != null && !locales.contains(locale) && !locales.contains(base = CLDRLocale.getInstance(locale).getLanguage()) || matcher != null && !matcher.reset(locale).matches() || defaultContents.contains(locale) || "root".equals(locale) || "und".equals(locale)) continue;
                    tsv_missing_summary.flush();
                    tsv_missing.flush();
                    tsv_missing_basic.flush();
                    tsv_missing_counts.flush();
                    boolean isSeed = new File(CLDRPaths.SEED_DIRECTORY, locale + ".xml").exists();
                    String region = ltp.set(locale).getRegion();
                    if (!region.isEmpty()) continue;
                    Level cldrLocaleLevelGoal = SC.getLocaleCoverageLevel(Organization.cldr, locale);
                    String specialFlag = ShowLocaleCoverage.getSpecialFlag(locale);
                    boolean cldrLevelGoalBasicToModern = Level.CORE_TO_MODERN.contains((Object)cldrLocaleLevelGoal);
                    String max = likelySubtags.maximize(locale);
                    String script = ltp.set(max).getScript();
                    String defRegion = ltp.getRegion();
                    String language = likelySubtags.minimize(locale);
                    missingPaths.clear();
                    unconfirmed.clear();
                    CLDRFile file = factory.make(locale, true, minimumDraftStatus);
                    if (locale.equals("af")) {
                        boolean bl = false;
                    }
                    IterableFilter pathSource = new IterableFilter(file.fullIterable());
                    VettingViewer.getStatus(pathSource, file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmed);
                    long found = 0L;
                    long unconfirmedc = 0L;
                    long missing = 0L;
                    Level level = cldrLocaleLevelGoal.compareTo(Level.BASIC) < 0 ? Level.BASIC : cldrLocaleLevelGoal;
                    for (Level level2 : Level.values()) {
                        if (level2.compareTo(level) > 0) continue;
                        found += foundCounter.get(level2);
                        unconfirmedc += unconfirmedCounter.get(level2);
                        missing += missingCounter.get(level2);
                    }
                    Iterator goalFlag = cldrLocaleLevelGoal == level ? "" : "*";
                    tsv_missing_counts.println((String)specialFlag + locale + "\t" + (String)((Object)goalFlag) + String.valueOf((Object)level) + "\t" + found + "\t" + unconfirmedc + "\t" + missing);
                    Collection sublocales = languageToRegion.asMap().get(language);
                    if (sublocales == null) {
                        sublocales = Collections.emptySet();
                    }
                    sublocales = ImmutableSet.copyOf(sublocales);
                    EnumMap<Level, Integer> totals = new EnumMap<Level, Integer>(Level.class);
                    EnumMap<Level, Integer> confirmed = new EnumMap<Level, Integer>(Level.class);
                    EnumSet<CoreCoverageInfo.CoreItems> specialMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                    StatusCounter starredCounter = new StatusCounter();
                    TreeMultimap<CoreCoverageInfo.CoreItems, String> detailedErrors = TreeMultimap.create();
                    Set<CoreCoverageInfo.CoreItems> set = CoreCoverageInfo.getCoreCoverageInfo(file, detailedErrors);
                    for (CoreCoverageInfo.CoreItems item : set) {
                        foundCounter.add(item.desiredLevel, 1L);
                    }
                    for (Map.Entry entry : detailedErrors.entries()) {
                        CoreCoverageInfo.CoreItems coreItem = (CoreCoverageInfo.CoreItems)((Object)entry.getKey());
                        String path = (String)entry.getValue();
                        specialMissingPaths.add(coreItem);
                        if (coreItem.desiredLevel == Level.BASIC) {
                            starredCounter.gatherStarred(path, null);
                        }
                        missingCounter.add(coreItem.desiredLevel, 1L);
                    }
                    if (cldrLevelGoalBasicToModern) {
                        goalLevel = cldrLocaleLevelGoal;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            String line;
                            String path = entry.getValue();
                            String status = entry.getKey().toString();
                            foundLevel = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)goalLevel).compareTo(foundLevel) < 0) continue;
                            String lineToPrint1 = line = ShowLocaleCoverage.spreadsheetLine(locale, language, script, specialFlag, file.getStringValue(path), (Level)((Object)goalLevel), foundLevel, status, path, file, pathToLocale);
                            tsv_missing.println(lineToPrint1);
                        }
                        for (String path : unconfirmed) {
                            Level foundLevel2 = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)goalLevel).compareTo(foundLevel2) < 0) continue;
                            String line = ShowLocaleCoverage.spreadsheetLine(locale, language, script, specialFlag, file.getStringValue(path), (Level)((Object)goalLevel), foundLevel2, "n/a", path, file, pathToLocale);
                            tsv_missing.println(line);
                        }
                    } else {
                        goalLevel = Level.BASIC;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            String path = entry.getValue();
                            Level foundLevel3 = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)goalLevel).compareTo(foundLevel3) < 0) continue;
                            starredCounter.gatherStarred(path, null);
                        }
                        for (String path : unconfirmed) {
                            CLDRFile.DraftStatus draftStatus;
                            String fullPath = file.getFullXPath(path);
                            CLDRFile.DraftStatus draftStatus2 = draftStatus = fullPath.contains("unconfirmed") ? CLDRFile.DraftStatus.unconfirmed : CLDRFile.DraftStatus.provisional;
                            foundLevel = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)goalLevel).compareTo(foundLevel) < 0) continue;
                            starredCounter.gatherStarred(path, draftStatus);
                        }
                    }
                    if (!starredCounter.starredPathToData.isEmpty()) {
                        for (Map.Entry entry : starredCounter.starredPathToData.entrySet()) {
                            String starredPath = (String)entry.getKey();
                            StatusData statusData = (StatusData)entry.getValue();
                            String valueString = statusData.values.stream().map(x -> Joiner.on(", ").join((Iterable<? extends Object>)x)).collect(Collectors.joining("; "));
                            tsv_missing_basic.println((String)specialFlag + locale + "\t" + statusData.missing + "\t" + statusData.provisional + "\t" + statusData.unconfirmed + "\t" + starredPath.replace("\"*\"", "'*'") + "\t" + valueString);
                        }
                        tsv_missing_basic.println((String)specialFlag + locale + "\t" + starredCounter.missingTotal + "\t" + starredCounter.provisionalTotal + "\t" + starredCounter.unconfirmedTotal + "\tTotals\t");
                        tsv_missing_basic.println("\t\t\t\t\t");
                    }
                    int sumFound = 0;
                    boolean bl = false;
                    int sumUnconfirmed = 0;
                    for (Level level3 : levelsToShow) {
                        int n;
                        long foundCount = foundCounter.get(level3);
                        long unconfirmedCount = unconfirmedCounter.get(level3);
                        long missingCount = missingCounter.get(level3);
                        sumFound = (int)((long)sumFound + foundCount);
                        sumUnconfirmed = (int)((long)sumUnconfirmed + unconfirmedCount);
                        n = (int)((long)n + missingCount);
                        confirmed.put(level3, sumFound);
                        totals.put(level3, sumFound + sumUnconfirmed + n);
                    }
                    EnumMap<Level, Integer> accumTotals = new EnumMap<Level, Integer>(Level.class);
                    EnumMap<Level, Integer> accumConfirmed = new EnumMap<Level, Integer>(Level.class);
                    int currTotals = 0;
                    int currConfirmed = 0;
                    for (Level level4 : levelsToShow) {
                        accumConfirmed.put(level4, currConfirmed += ((Integer)confirmed.get((Object)level4)).intValue());
                        accumTotals.put(level4, currTotals += ((Integer)totals.get((Object)level4)).intValue());
                    }
                    Level computed = Level.UNDETERMINED;
                    EnumMap<Level, Double> levelToProportion = new EnumMap<Level, Double>(Level.class);
                    for (Level level5 : reversedLevels) {
                        int confirmedCoverage = (Integer)accumConfirmed.get((Object)level5);
                        double total = ((Integer)accumTotals.get((Object)level5)).intValue();
                        double proportion = (double)confirmedCoverage / total;
                        levelToProportion.put(level5, proportion);
                        if (computed != Level.UNDETERMINED) continue;
                        switch (level5) {
                            case MODERN: {
                                if (!(proportion >= 0.995)) break;
                                computed = level5;
                                break;
                            }
                            case MODERATE: {
                                if (!(proportion >= 0.995)) break;
                                computed = level5;
                                break;
                            }
                            case BASIC: {
                                if (!(proportion >= 1.0)) break;
                                computed = level5;
                                break;
                            }
                        }
                    }
                    EnumSet<CoreCoverageInfo.CoreItems> shownMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                    Level computedWithCore = computed == Level.UNDETERMINED ? Level.BASIC : computed;
                    for (CoreCoverageInfo.CoreItems item : specialMissingPaths) {
                        if (item.desiredLevel.compareTo(computedWithCore) <= 0) {
                            shownMissingPaths.add(item);
                            continue;
                        }
                        boolean bl2 = false;
                    }
                    computedLevels.add(computed, 1L);
                    computedSublocaleLevels.add(computed, sublocales.size());
                    String coreMissingString = Joiner.on(", ").join(shownMissingPaths);
                    String visibleLevelComputed = computed == Level.UNDETERMINED ? "" : computed.toString();
                    String string = visibleLevelGoal = cldrLocaleLevelGoal == Level.UNDETERMINED ? "" : (String)specialFlag + cldrLocaleLevelGoal.toString();
                    String goalComparedToComputed = computed == cldrLocaleLevelGoal ? " \u2261" : (cldrLocaleLevelGoal.compareTo(computed) < 0 ? " <" : " >");
                    tablePrinter.addRow().addCell((Comparable)((Object)language)).addCell((Comparable)((Object)ENGLISH.nameGetter().getNameFromIdentifierOptAlt(language, NameGetter.NameOpt.COMPOUND_ONLY, CLDRFile.SHORT_ALTS))).addCell((Comparable)((Object)file.nameGetter().getNameFromIdentifier(language))).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)defRegion)).addCell(Integer.valueOf(sublocales.size())).addCell((Comparable)((Object)visibleLevelGoal)).addCell((Comparable)((Object)goalComparedToComputed)).addCell((Comparable)((Object)visibleLevelComputed)).addCell((Comparable)((Object)ShowLocaleCoverage.getIcuValue(language))).addCell(Double.valueOf((double)sumFound / (double)(sumFound + sumUnconfirmed)));
                    for (Level level6 : reversedLevels) {
                        tablePrinter.addCell((Comparable)levelToProportion.get((Object)level6));
                    }
                    tablePrinter.addCell((Comparable)((Object)coreMissingString)).finishRow();
                    if (computed != Level.UNDETERMINED) {
                        propertiesCoverage.printlnWithTabs(2, locale + " ;\t" + visibleLevelComputed + " ;\t" + ENGLISH.nameGetter().getNameFromIdentifier(locale));
                    }
                    ++localeCount;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String lineToPrint = "\n#EOF";
            propertiesCoverage.printlnWithTabs(2, lineToPrint);
            pw.println("<h3><a name='main_table' href='#main_table'>Main Table</a></h3>");
            pw.println(tablePrinter.toTable());
            pw.println("<h3><a name='level_counts' href='#level_counts'>Level Counts</a></h3>\n<table class='subtle'><tr>\n<th style='text-align:left'>Level</th><th style='text-align:left'>Languages</th><th style='text-align:left'>Locales</th></tr>");
            long totalCount = 0L;
            long totalLocaleCount = 0L;
            for (Level level : Lists.reverse(Arrays.asList(Level.values()))) {
                long count = computedLevels.get(level);
                long localesCount = computedSublocaleLevels.get(level);
                if (count == 0L || level == Level.UNDETERMINED) continue;
                totalCount += count;
                totalLocaleCount += localesCount;
                Object visibleImputed = level == Level.UNDETERMINED ? "<" + Level.BASIC.toString() : level.toString();
                pw.println("<tr><th style='text-align:left'>" + (String)visibleImputed + "</th><td style='text-align:right'>" + count + "</td><td style='text-align:right'>" + localesCount + "</td></tr>");
            }
            pw.println("<tr><th style='text-align:left'>Total</th><td style='text-align:right'>" + totalCount + "</td><td style='text-align:right'>" + totalLocaleCount + "</td></tr>\n");
            pw.println("<tr><th style='text-align:left'>in dev.</th><td style='text-align:right'>" + computedLevels.get(Level.UNDETERMINED) + "</td><td style='text-align:right'>" + computedSublocaleLevels.get(Level.UNDETERMINED) + "</td></tr>\n</table>");
            TreeMultimap<Level, String> levelToLocales = TreeMultimap.create();
            for (Map.Entry entry : pathToLocale.asMap().entrySet()) {
                String path = (String)entry.getKey();
                Collection localeSet = entry.getValue();
                levelToLocales.clear();
                for (String locale : localeSet) {
                    Level foundLevel = coverageInfo.getCoverageLevel(path, locale);
                    levelToLocales.put(foundLevel, locale);
                }
                String phString = "n/a\tn/a\tn/a\tn/a";
                try {
                    PathHeader ph = pathHeaderFactory.fromPath(path);
                    phString = ph.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Map.Entry entry2 : levelToLocales.asMap().entrySet()) {
                    Level level = (Level)((Object)entry2.getKey());
                    localeSet = entry2.getValue();
                    tsv_missing_summary.println(String.valueOf((Object)level) + "\t" + localeSet.size() + "\t" + Joiner.on(" ").join(localeSet.stream().map(x -> x + ShowLocaleCoverage.getSpecialFlag(x)).collect(Collectors.toSet())) + "\t" + phString);
                }
            }
            tablePrinter.toTsv(tsv_summary);
            long end = System.currentTimeMillis();
            System.out.println(end - start + " millis = " + (end - start) / (long)localeCount + " millis/locale");
            ShowPlurals.appendBlanksForScrolling(pw);
        }
    }

    private static String linkTsv(String tsvFileName) {
        return "<a href='" + TSV_BASE + tsvFileName + "' target='cldr-tsv'>" + tsvFileName + "</a>";
    }

    private static String linkTsv(String tsvFileName, String anchorText) {
        return "<a href='" + TSV_BASE + tsvFileName + "' target='cldr-tsv'>" + anchorText + "</a>";
    }

    private static String getSpecialFlag(String locale) {
        return SC.getLocaleCoverageLevel(Organization.special, locale) == Level.UNDETERMINED ? "" : "\u2021";
    }

    private static String spreadsheetLine(String locale, String language, String script, String specialFlag, String nativeValue, Level cldrLocaleLevelGoal, Level itemLevel, String status, String path, CLDRFile resolvedFile, Multimap<String, String> pathToLocale) {
        if (pathToLocale != null) {
            pathToLocale.put(path, locale);
        }
        Enum surveyToolStatus = null;
        String bailey = resolvedFile == null ? "" : resolvedFile.getStringValue(path);
        Object phString = "na\tn/a\tn/a\t" + path;
        try {
            PathHeader ph = pathHeaderFactory.fromPath(path);
            phString = ph.toString();
        }
        catch (Exception ph) {
            // empty catch block
        }
        String line = specialFlag + language + "\t" + ENGLISH.nameGetter().getNameFromIdentifier(language) + "\t" + ENGLISH.nameGetter().getNameFromTypeEnumCode(NameType.SCRIPT, script) + "\t" + String.valueOf((Object)cldrLocaleLevelGoal) + "\t" + String.valueOf((Object)itemLevel) + "\t" + (surveyToolStatus == null ? "n/a" : surveyToolStatus.toString()) + "\t" + bailey + "\t" + (String)phString + "\t" + PathHeader.getUrlForLocalePath(locale, path);
        return line;
    }

    private static String getIcuValue(String locale) {
        return ICU_Locales.contains(new ULocale(locale)) ? "ICU" : "";
    }

    static {
        coverageInfo = new CoverageInfo(SUPPLEMENTAL_DATA_INFO);
        ICU_Locales = ImmutableSet.copyOf(ULocale.getAvailableLocales());
    }

    private static class IterableFilter
    implements Iterable<String> {
        private Iterable<String> source;
        private static final Set<String> SUPPRESS_PATHS_AFTER_SUBMISSION = ImmutableSet.of();

        IterableFilter(Iterable<String> source) {
            this.source = source;
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorFilter(this.source.iterator());
        }

        private static class IteratorFilter
        implements Iterator<String> {
            Iterator<String> source;
            String peek;

            public IteratorFilter(Iterator<String> source) {
                this.source = source;
                this.fillPeek();
            }

            @Override
            public boolean hasNext() {
                return this.peek != null;
            }

            @Override
            public String next() {
                String result = this.peek;
                this.fillPeek();
                return result;
            }

            private void fillPeek() {
                this.peek = null;
                while (this.source.hasNext()) {
                    this.peek = this.source.next();
                    if (!SUPPRESS_PATHS_AFTER_SUBMISSION.contains(this.peek) && SUPPRESS_PATHS_CAN_BE_EMPTY.get(this.peek) != Boolean.TRUE) break;
                    this.peek = null;
                }
            }
        }
    }

    public static class FoundAndTotal {
        final int found;
        final int total;

        @SafeVarargs
        public FoundAndTotal(Counter<Level> ... counters) {
            int[] count = new int[]{0, 0, 0};
            for (Level level : Level.values()) {
                if (level == Level.COMPREHENSIVE) continue;
                int i = 0;
                for (Counter<Level> counter : counters) {
                    int n = i++;
                    count[n] = (int)((long)count[n] + counter.get(level));
                }
            }
            this.found = count[0];
            this.total = this.found + count[1] + count[2];
        }

        public String toString() {
            return this.found + "/" + this.total;
        }
    }

    public static class StatusCounter {
        private static final Set<String> ATTRS_TO_REMOVE = Set.of("standard");
        Map<String, StatusData> starredPathToData = new TreeMap<String, StatusData>();
        int missingTotal;
        int provisionalTotal;
        int unconfirmedTotal;

        public void gatherStarred(String path, CLDRFile.DraftStatus draftStatus) {
            String starredPath = PathStarrer.get(path);
            StatusData statusData = this.starredPathToData.get(starredPath);
            if (statusData == null) {
                statusData = new StatusData();
                this.starredPathToData.put(starredPath, statusData);
            }
            if (draftStatus == null) {
                ++statusData.missing;
                ++this.missingTotal;
            } else {
                switch (draftStatus) {
                    case unconfirmed: {
                        ++statusData.unconfirmed;
                        ++this.unconfirmedTotal;
                        break;
                    }
                    case provisional: {
                        ++statusData.provisional;
                        ++this.provisionalTotal;
                        break;
                    }
                }
            }
            List attributes = CldrUtility.removeAll(new ArrayList<String>(XPathParts.getFrozenInstance(path).getAttributeValues()), ATTRS_TO_REMOVE);
            if (!attributes.isEmpty()) {
                statusData.values.add(attributes);
            }
        }
    }

    public static class StatusData {
        int missing;
        int provisional;
        int unconfirmed;
        Set<List<String>> values = new TreeSet(Comparators.lexicographical(Comparator.naturalOrder()));
    }

    static enum MyOptions {
        filter(".+", ".*", "Filter the information based on id, using a regex argument."),
        chart(null, null, "chart only"),
        organization(".+", null, "Only locales for organization"),
        version(".+", LATEST, "To get different versions"),
        rawData(null, null, "Output the raw data from all coverage levels"),
        targetDir(".*", CLDRPaths.GEN_DIRECTORY + "/statistics/", "target output file."),
        directories("(.*:)?[a-z]+(,[a-z]+)*", "common", "Space-delimited list of main source directories: common,seed,exemplar.\nOptional, <baseDir>:common,seed");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

