/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.unicode.cldr.test.BuildIcuCompactDecimalFormat;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.GeneratePluralRanges;
import org.unicode.cldr.tool.PluralMinimalPairs;
import org.unicode.cldr.tool.PluralRulesFactory;
import org.unicode.cldr.tool.ShowLanguages;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.PluralSnapshot;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ShowPlurals {
    private static final String NO_PLURAL_DIFFERENCES = "<i>no plural differences</i>";
    private static final String NOT_AVAILABLE = "<i>Not available.<br>Please <a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a> to supply.</i>";
    final SupplementalDataInfo supplementalDataInfo;

    public static void main(String[] args) {
        Factory cldrFactory = CLDRConfig.getInstance().getCldrFactory();
        CLDRFile english = CLDRConfig.getInstance().getEnglish();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            new ShowPlurals().printPlurals(english, null, pw, cldrFactory);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public ShowPlurals() {
        this.supplementalDataInfo = CLDRConfig.getInstance().getSupplementalDataInfo();
    }

    public ShowPlurals(SupplementalDataInfo supplementalDataInfo) {
        this.supplementalDataInfo = supplementalDataInfo;
    }

    public void printPlurals(CLDRFile english, String localeFilter, PrintWriter index, Factory factory) throws IOException {
        String section1 = "Rules";
        String section2 = "Comparison";
        String title = "Language Plural Rules";
        PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Language Plural Rules", null, ShowLanguages.SUPPLEMENTAL_INDEX_ANCHORS));
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        ShowLanguages.showContents(pw, "rules", "Rules", "comparison", "Comparison");
        pw.append("<h2>" + CldrUtility.getDoubleLinkedText("rules", "1. " + section1) + "</h2>" + System.lineSeparator());
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        this.printPluralTable(english, localeFilter, pw, factory);
        pw.append("</div>\n");
        pw.append("<h2>" + CldrUtility.getDoubleLinkedText("comparison", "2. " + section2) + "</h2>" + System.lineSeparator());
        pw.append("<p style='text-align:left'>The plural forms are abbreviated by first letter, with 'x' for 'other'. If values are made redundant by explicit 0 and 1, they are underlined. The fractional and integral results are separated for clarity.</p>" + System.lineSeparator());
        pw.append("<div style='margin-right:2em; margin-left:2em'>\n");
        PluralSnapshot.writeTables(english, pw);
        pw.append("</div>\n");
        pw.append("</div>\n");
        ShowPlurals.appendBlanksForScrolling(pw);
        pw.close();
    }

    public static void appendBlanksForScrolling(Appendable pw) {
        try {
            pw.append(Utility.repeat("<br>", 100)).append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public void printPluralTable(CLDRFile english, String localeFilter, Appendable appendable, Factory factory) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().setTableAttributes("class='dtf-table'").addColumn("Name", "class='source'", null, "class='source'", true).setSortPriority(0).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Type", "class='source'", null, "class='source'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setBreakSpans(true).addColumn("Category", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setSpanRows(false).addColumn("Examples", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Minimal Pairs", "class='target'", null, "class='target'", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Rules", "class='target'", null, "class='target' nowrap", true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").setSpanRows(false);
        PluralRulesFactory prf = PluralRulesFactory.getInstance(this.supplementalDataInfo);
        Set<String> cardinalLocales = this.supplementalDataInfo.getPluralLocales(SupplementalDataInfo.PluralType.cardinal);
        Set<String> ordinalLocales = this.supplementalDataInfo.getPluralLocales(SupplementalDataInfo.PluralType.ordinal);
        LinkedHashSet<String> all = new LinkedHashSet<String>(cardinalLocales);
        all.addAll(ordinalLocales);
        LanguageTagCanonicalizer canonicalizer = new LanguageTagCanonicalizer();
        SampleMaker sampleMaker = new SampleMaker();
        for (String locale : this.supplementalDataInfo.getPluralLocales()) {
            CLDRFile cldrFile2;
            if (localeFilter != null && !localeFilter.equals(locale) || locale.equals("root")) continue;
            String name = english.nameGetter().getNameFromIdentifier(locale);
            String canonicalLocale = canonicalizer.transform(locale);
            if (!locale.equals(canonicalLocale)) {
                String redirect = "<i>=<a href='#" + canonicalLocale + "'>" + canonicalLocale + "</a></i>";
                tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)redirect)).addCell((Comparable)((Object)redirect)).addCell((Comparable)((Object)redirect)).addCell((Comparable)((Object)redirect)).addCell((Comparable)((Object)redirect)).finishRow();
                continue;
            }
            try {
                cldrFile2 = factory.make(locale, true);
            }
            catch (Exception e1) {
                continue;
            }
            sampleMaker.setCldrFile(cldrFile2);
            for (SupplementalDataInfo.PluralType pluralType : SupplementalDataInfo.PluralType.values()) {
                Object rules;
                if (pluralType == SupplementalDataInfo.PluralType.ordinal && !ordinalLocales.contains(locale) || pluralType == SupplementalDataInfo.PluralType.cardinal && !cardinalLocales.contains(locale)) continue;
                SupplementalDataInfo.PluralInfo plurals = this.supplementalDataInfo.getPlurals(pluralType, locale);
                ULocale locale2 = new ULocale(locale);
                PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(locale2.toString());
                rules = (String)rules + (((String)(rules = plurals.getRules())).length() == 0 ? "other:<i>everything</i>" : ";other:<i>everything else</i>");
                rules = ((String)rules).replace(":", " \u2192 ").replace(";", ";<br>");
                PluralRules pluralRules = plurals.getPluralRules();
                Set<SupplementalDataInfo.PluralInfo.Count> counts = plurals.getCounts();
                for (SupplementalDataInfo.PluralInfo.Count count : counts) {
                    String samplePattern;
                    Object sample;
                    String rule;
                    String keyword = count.toString();
                    PluralRules.DecimalQuantitySamples exampleList = pluralRules.getDecimalSamples(keyword, PluralRules.SampleType.INTEGER);
                    PluralRules.DecimalQuantitySamples exampleList2 = pluralRules.getDecimalSamples(keyword, PluralRules.SampleType.DECIMAL);
                    if (exampleList == null) {
                        exampleList = exampleList2;
                        exampleList2 = null;
                    }
                    Object examples = this.getExamples(exampleList);
                    if (exampleList2 != null) {
                        examples = (String)examples + "<br>" + this.getExamples(exampleList2);
                    }
                    rule = (rule = pluralRules.getRules(keyword)) != null ? rule.replace(":", " \u2192 ").replace(" and ", " and<br>&nbsp;&nbsp;").replace(" or ", " or<br>") : (counts.size() == 1 ? "<i>everything</i>" : "<i>everything else</i>");
                    Object object = sample = counts.size() == 1 ? NO_PLURAL_DIFFERENCES : NOT_AVAILABLE;
                    if (samplePatterns != null && (samplePattern = samplePatterns.get(pluralType.standardType, SupplementalDataInfo.PluralInfo.Count.valueOf(keyword))) != null) {
                        DecimalQuantity sampleDecimal = SupplementalDataInfo.PluralInfo.getNonZeroSampleIfPossible(exampleList);
                        sample = sampleMaker.getSample(sampleDecimal, samplePattern);
                        if (exampleList2 != null) {
                            sampleDecimal = SupplementalDataInfo.PluralInfo.getNonZeroSampleIfPossible(exampleList2);
                            sample = (String)sample + "<br>" + sampleMaker.getSample(sampleDecimal, samplePattern);
                        }
                    }
                    tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)pluralType.toString())).addCell((Comparable)((Object)count.toString())).addCell((Comparable)((Object)((String)examples).toString())).addCell((Comparable)sample).addCell((Comparable)((Object)rule)).finishRow();
                }
            }
            List<GeneratePluralRanges.RangeSample> rangeInfoList = null;
            try {
                rangeInfoList = new GeneratePluralRanges(this.supplementalDataInfo).getRangeInfo(cldrFile2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rangeInfoList != null) {
                for (GeneratePluralRanges.RangeSample item : rangeInfoList) {
                    tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)"range")).addCell((Comparable)((Object)(String.valueOf((Object)item.start) + "+" + String.valueOf((Object)item.end)))).addCell((Comparable)((Object)(String.valueOf(item.min) + "\u2013" + String.valueOf(item.max)))).addCell((Comparable)((Object)item.resultExample.replace(". ", ".<br>"))).addCell((Comparable)((Object)(String.valueOf((Object)item.start) + " + " + String.valueOf((Object)item.end) + " \u2192 " + String.valueOf((Object)item.result)))).finishRow();
                }
                continue;
            }
            String message = this.supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, locale).getCounts().size() == 1 ? NO_PLURAL_DIFFERENCES : NOT_AVAILABLE;
            tablePrinter.addRow().addCell((Comparable)((Object)name)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)"range")).addCell((Comparable)((Object)"<i>n/a</i>")).addCell((Comparable)((Object)"<i>n/a</i>")).addCell((Comparable)((Object)message)).addCell((Comparable)((Object)"<i>n/a</i>")).finishRow();
        }
        appendable.append(tablePrinter.toTable()).append(System.lineSeparator());
    }

    private String getExamples(PluralRules.DecimalQuantitySamples exampleList) {
        return Joiner.on(", ").join(exampleList.getSamples()) + (exampleList.bounded ? "" : ", \u2026");
    }

    static final class SampleMaker {
        ICUServiceBuilder icusb = new ICUServiceBuilder();
        CLDRFile cldrFile;

        SampleMaker() {
        }

        void setCldrFile(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
            this.icusb.setCldrFile(cldrFile);
        }

        private String getSample(DecimalQuantity numb, String samplePattern) {
            String value;
            if (numb.getExponent() > 0) {
                LinkedHashSet<String> debugCreationErrors = new LinkedHashSet<String>();
                String[] debugOriginals = null;
                CompactDecimalFormat cdfCurr = BuildIcuCompactDecimalFormat.build(this.cldrFile, debugCreationErrors, debugOriginals, CompactDecimalFormat.CompactStyle.SHORT, ULocale.forLanguageTag(this.cldrFile.getLocaleID()), BuildIcuCompactDecimalFormat.CurrencyStyle.PLAIN, null);
                value = cdfCurr.format(numb.toDouble());
            } else {
                NumberFormat nf = this.icusb.getGenericNumberFormat("latn");
                nf.setMaximumFractionDigits((int)numb.getPluralOperand(PluralRules.Operand.v));
                nf.setMinimumFractionDigits((int)numb.getPluralOperand(PluralRules.Operand.v));
                value = nf.format(numb.toDouble());
            }
            String sample = samplePattern.replace('\u00a0', ' ').replace("{0}", value).replace(". ", ".<br>");
            return sample;
        }
    }
}

