/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.Units;
import org.unicode.cldr.util.Validity;

public class UnitValidityCanonicalizer {
    static final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    static final UnitConverter uc = sdi.getUnitConverter();
    static final MapComparator<String> categoryComparator = new MapComparator<String>(Arrays.asList("duration", "graphics", "length", "area", "volume", "acceleration", "speed", "mass", "energy", "magnetic", "power", "electric", "frequency", "pressure", "temperature", "digital", "short", "angle", "concentr", "consumption", "force", "light", "torque")).setErrorOnMissing(true).freeze();
    public static Comparator<String> UNIT_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Output<String> metricUnit2;
            UnitConverter.ConversionInfo ci2;
            String q2;
            Units.TypeAndCore tc1 = Units.splitUnit(o1, new Units.TypeAndCore());
            Units.TypeAndCore tc2 = Units.splitUnit(o2, new Units.TypeAndCore());
            int comp = categoryComparator.compare(tc1.type, tc2.type);
            if (comp != 0) {
                return comp;
            }
            String q1 = UnitValidityCanonicalizer.getTweakedQuantityFromUnit(tc1);
            comp = q1.compareTo(q2 = UnitValidityCanonicalizer.getTweakedQuantityFromUnit(tc2));
            if (comp != 0) {
                return comp;
            }
            Set<UnitConverter.UnitSystem> s1 = uc.getSystemsEnum(tc1.core);
            Set<UnitConverter.UnitSystem> s2 = uc.getSystemsEnum(tc2.core);
            comp = Integer.compare(UnitValidityCanonicalizer.getOrder(s1), UnitValidityCanonicalizer.getOrder(s2));
            if (comp != 0) {
                return comp;
            }
            Output<String> metricUnit1 = new Output<String>();
            UnitConverter.ConversionInfo ci1 = uc.parseUnitId(tc1.core, metricUnit1, false);
            comp = ci1.compareTo(ci2 = uc.parseUnitId(tc2.core, metricUnit2 = new Output<String>(), false));
            if (comp != 0) {
                return comp;
            }
            return o1.compareTo(o2);
        }
    };

    public static int getOrder(Set<UnitConverter.UnitSystem> set) {
        Iterator<UnitConverter.UnitSystem> iterator = set.iterator();
        if (iterator.hasNext()) {
            UnitConverter.UnitSystem us = iterator.next();
            return us.ordinal();
        }
        return 666;
    }

    private static String getTweakedQuantityFromUnit(Units.TypeAndCore tc1) {
        String result = uc.getQuantityFromUnit(tc1.core, false);
        return result == null ? "unknown" : result;
    }

    public static List<String> getInfo(String o1) {
        ArrayList<String> result = new ArrayList<String>();
        Units.TypeAndCore tc1 = Units.splitUnit(o1, new Units.TypeAndCore());
        result.add(tc1.type);
        String tweakedQuantity = UnitValidityCanonicalizer.getTweakedQuantityFromUnit(tc1);
        result.add(tweakedQuantity);
        result.add(tweakedQuantity.equals(tc1.type) ? "" : "\u2260");
        if (!tweakedQuantity.equals("unknown")) {
            result.add(uc.getSystemsEnum(tc1.core).toString());
            Output<String> metricUnit1 = new Output<String>();
            UnitConverter.ConversionInfo parseUnitId = uc.parseUnitId(tc1.core, metricUnit1, false);
            result.add(parseUnitId.toDecimal());
            result.add(metricUnit1.toString());
        }
        return result;
    }

    public static void main(String[] args) {
        Map<Validity.Status, Set<String>> validityUnits = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.unit);
        TreeSet<String> sorted = new TreeSet<String>(UNIT_COMPARATOR);
        System.out.println("long unit\tST category\tquantity\tST!=Q\tsystems\tfactor / offset from:\tbase unit");
        for (Map.Entry<Validity.Status, Set<String>> entry : validityUnits.entrySet()) {
            if (entry.getKey() == Validity.Status.deprecated) continue;
            sorted.addAll((Collection<String>)entry.getValue());
            System.out.println("Status=" + String.valueOf((Object)entry.getKey()));
            for (String s2 : sorted) {
                System.out.println(s2 + "\t" + Joiner.on('\t').join(UnitValidityCanonicalizer.getInfo(s2)));
            }
        }
        System.out.println("\n#FOR VALIDITY");
        System.out.println(Joiner.on('\n').join(sorted));
    }
}

