/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.Output;
import java.io.File;
import java.io.PrintWriter;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.AttributeValueValidity;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class VerifyAttributeValues
extends XMLFileReader.SimpleHandler {
    private static final File BASE_DIR = new File(CLDRPaths.BASE_DIRECTORY);
    private static final SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
    public static final Joiner SPACE_JOINER = Joiner.on(' ');
    public static final Splitter SPACE_SPLITTER = Splitter.on(' ').trimResults().omitEmptyStrings();
    private DtdData dtdData;
    private final Errors file_element_attribute;
    private final String file;
    private final EnumMap<AttributeValueValidity.LocaleSpecific, Set<String>> localeSpecific = new EnumMap(AttributeValueValidity.LocaleSpecific.class);
    private final Set<AttributeValueValidity.AttributeValueSpec> missing;

    private VerifyAttributeValues(String fileName, Errors file_element_attribute, Set<AttributeValueValidity.AttributeValueSpec> missing) {
        this.file_element_attribute = file_element_attribute;
        this.file = fileName.startsWith(BASE_DIR.toString()) ? fileName.substring(BASE_DIR.toString().length()) : fileName;
        this.missing = missing;
    }

    public static void check(String fileName, Errors errors, Set<AttributeValueValidity.AttributeValueSpec> missing) {
        try {
            VerifyAttributeValues platformHandler = new VerifyAttributeValues(fileName, errors, missing);
            new XMLFileReader().setHandler(platformHandler).read(fileName, -1, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(fileName, e);
        }
    }

    @Override
    public void handlePathValue(String path, String value) {
        XPathParts parts = XPathParts.getFrozenInstance(path);
        if (this.dtdData == null) {
            this.dtdData = DtdData.getInstance(DtdType.valueOf(parts.getElement(0)));
            if (this.dtdData.dtdType == DtdType.ldml) {
                String name = this.file;
                String locale = name.substring(name.lastIndexOf(47) + 1, name.lastIndexOf(46));
                this.localeSpecific.put(AttributeValueValidity.LocaleSpecific.pluralCardinal, supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, locale).getPluralRules().getKeywords());
                this.localeSpecific.put(AttributeValueValidity.LocaleSpecific.pluralOrdinal, supplementalData.getPlurals(SupplementalDataInfo.PluralType.ordinal, locale).getPluralRules().getKeywords());
                this.localeSpecific.put(AttributeValueValidity.LocaleSpecific.dayPeriodFormat, this.getPeriods(DayPeriodInfo.Type.format, locale));
                this.localeSpecific.put(AttributeValueValidity.LocaleSpecific.dayPeriodSelection, this.getPeriods(DayPeriodInfo.Type.selection, locale));
            } else {
                this.localeSpecific.clear();
            }
            AttributeValueValidity.setLocaleSpecifics(this.localeSpecific);
        }
        for (int i = 0; i < parts.size(); ++i) {
            if (parts.getAttributeCount(i) == 0) continue;
            Map<String, String> attributes = parts.getAttributes(i);
            String element = parts.getElement(i);
            if (element.equals("attributeValues")) continue;
            DtdData.Element elementInfo = this.dtdData.getElementFromName().get(element);
            for (String attribute : attributes.keySet()) {
                DtdData.Attribute attributeInfo = elementInfo.getAttributeNamed(attribute);
                if (!attributeInfo.values.isEmpty()) continue;
                String attributeValue = attributes.get(attribute);
                if (this.dtdData.isDeprecated(element, attribute, attributeValue)) {
                    this.file_element_attribute.put(this.file, this.dtdData.dtdType, element, attribute, attributeValue, "deprecated");
                    continue;
                }
                Output<String> reason = new Output<String>();
                AttributeValueValidity.Status haveTest = AttributeValueValidity.check(this.dtdData, element, attribute, attributeValue, reason);
                switch (haveTest) {
                    case ok: {
                        break;
                    }
                    case deprecated: 
                    case illegal: {
                        this.file_element_attribute.put(this.file, this.dtdData.dtdType, element, attribute, attributeValue, (String)reason.value);
                        break;
                    }
                    case noTest: {
                        this.missing.add(new AttributeValueValidity.AttributeValueSpec(this.dtdData.dtdType, element, attribute, attributeValue));
                    }
                }
            }
        }
    }

    private Set<String> getPeriods(DayPeriodInfo.Type selection, String locale) {
        TreeSet<String> result = new TreeSet<String>();
        DayPeriodInfo dayPeriods = supplementalData.getDayPeriods(DayPeriodInfo.Type.format, locale);
        for (DayPeriodInfo.DayPeriod period : dayPeriods.getPeriods()) {
            result.add(period.toString());
        }
        result.add("am");
        result.add("pm");
        return new LinkedHashSet<String>(result);
    }

    public static int findAttributeValues(File file, int max, Matcher fileMatcher, Errors errors, Set<AttributeValueValidity.AttributeValueSpec> allMissing, PrintWriter out) {
        String name = file.getName();
        if (file.isDirectory() && !name.equals("specs") && !name.equals("tools") && !file.toString().contains(".svn")) {
            int processed = 0;
            int count = max;
            for (File subfile : file.listFiles()) {
                String subname = subfile.getName();
                if (--count < 0 && !"en.xml".equals(subname) && !"root.xml".equals(subname)) continue;
                processed += VerifyAttributeValues.findAttributeValues(subfile, max, fileMatcher, errors, allMissing, out);
            }
            if (out != null) {
                out.println("Processed files: " + processed + " \tin " + String.valueOf(file));
                out.flush();
            }
            return processed;
        }
        if (name.endsWith(".xml") && (fileMatcher == null || fileMatcher.reset(name.substring(0, name.length() - 4)).matches())) {
            VerifyAttributeValues.check(file.toString(), errors, allMissing);
            return 1;
        }
        return 0;
    }

    public static final class Errors {
        final ChainedMap.M3<String, AttributeValueValidity.AttributeValueSpec, String> file_element_attribute = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);

        public void put(String file, DtdType dtdType, String element, String attribute, String attributeValue, String problem) {
            this.file_element_attribute.put(file, new AttributeValueValidity.AttributeValueSpec(dtdType, element, attribute, attributeValue), problem);
        }

        public Iterable<Row.R3<String, AttributeValueValidity.AttributeValueSpec, String>> getRows() {
            return this.file_element_attribute.rows();
        }
    }
}

