/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Level;

public class CalculatedCoverageLevels {
    private static final Level DEFAULT_ROOT_LEVEL = Level.MODERN;
    final Map<String, Level> levels;

    protected CalculatedCoverageLevels(Map<String, Level> levels) {
        this.levels = Collections.unmodifiableMap(levels);
    }

    public Map<String, Level> getLevels() {
        return this.levels;
    }

    public Level getEffectiveCoverageLevel(String locale) {
        return this.getEffectiveCoverageLevel(CLDRLocale.getInstance(locale));
    }

    public Level getEffectiveCoverageLevel(CLDRLocale locale) {
        if (locale == CLDRLocale.ROOT) {
            return DEFAULT_ROOT_LEVEL;
        }
        Level level = this.levels.get(locale.getBaseName());
        if (level != null) {
            return level;
        }
        CLDRLocale parent = locale.getParent();
        if (parent == CLDRLocale.ROOT) {
            return null;
        }
        return this.getEffectiveCoverageLevel(parent);
    }

    public boolean isLocaleAtLeastBasic(String locale) {
        return this.levels.containsKey(locale);
    }

    static CalculatedCoverageLevels fromFile() throws IOException {
        return CalculatedCoverageLevels.fromFile(CLDRPaths.COMMON_DIRECTORY);
    }

    static CalculatedCoverageLevels fromFile(String dir) throws IOException {
        try (BufferedReader r = FileUtilities.openUTF8Reader(dir + "properties/", "coverageLevels.txt");){
            CalculatedCoverageLevels calculatedCoverageLevels = CalculatedCoverageLevels.fromReader(r);
            return calculatedCoverageLevels;
        }
    }

    public static CalculatedCoverageLevels forVersion(VersionInfo v) throws IOException {
        return CalculatedCoverageLevels.fromFile(ToolConstants.getBaseDirectory(v) + "/common/");
    }

    static CalculatedCoverageLevels fromReader(BufferedReader r) throws IOException {
        String line;
        TreeMap<String, Level> levels = new TreeMap<String, Level>();
        Splitter SEMICOLON = Splitter.on(';').trimResults();
        int no = 0;
        while ((line = r.readLine()) != null) {
            ++no;
            if ((line = line.trim()).isBlank() || line.startsWith("#")) continue;
            List<String> l = SEMICOLON.splitToList(line);
            if (l.size() != 3) {
                throw new IllegalArgumentException("coverageLevels.txt:" + no + ": expected 2 fields, got " + l.size());
            }
            String uloc = l.get(0);
            String level = l.get(1);
            String name = l.get(2);
            Level lev = Level.fromString(level);
            if (levels.put(uloc, lev) == null) continue;
            throw new IllegalArgumentException("coverageLevels.txt:" + no + ": duplicate locale " + uloc);
        }
        return new CalculatedCoverageLevels(levels);
    }

    public static CalculatedCoverageLevels getInstance() {
        return CalculatedCoverageLevelsHelper.INSTANCE.levels;
    }

    private static final class CalculatedCoverageLevelsHelper {
        public CalculatedCoverageLevels levels;
        public static CalculatedCoverageLevelsHelper INSTANCE = new CalculatedCoverageLevelsHelper();

        public CalculatedCoverageLevelsHelper() {
            try {
                this.levels = CalculatedCoverageLevels.fromFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.err.println("Could not load CalculatedCoverageLevels: " + String.valueOf(ioe));
                this.levels = null;
            }
        }
    }
}

