/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import org.unicode.cldr.util.StringByteConverter;

public class CompactStringByteConverter
extends StringByteConverter {
    public static final boolean DEBUG = false;
    private boolean deltaEncoded;
    private int last;

    public CompactStringByteConverter(boolean deltaEncoded) {
        this.deltaEncoded = deltaEncoded;
    }

    public boolean isDeltaEncoded() {
        return this.deltaEncoded;
    }

    @Override
    public void clear() {
        this.last = 64;
    }

    @Override
    public int toBytes(char cp, byte[] output, int bytePosition) {
        if (this.deltaEncoded) {
            int delta = cp - this.last;
            bytePosition = CompactStringByteConverter.writeInt(delta, output, bytePosition);
            this.last = cp;
            this.last = this.last & 0xFFFFFF80 | 0x40;
            return bytePosition;
        }
        return CompactStringByteConverter.writeUnsignedInt(cp, output, bytePosition);
    }

    @Override
    public int toBytes(CharSequence source, byte[] output, int bytePosition) {
        if (this.deltaEncoded) {
            int last = 64;
            for (int i = 0; i < source.length(); ++i) {
                char cp = source.charAt(i);
                int delta = cp - last;
                bytePosition = CompactStringByteConverter.writeInt(delta, output, bytePosition);
                last = cp;
                last = last & 0xFFFFFF80 | 0x40;
            }
        } else {
            for (int i = 0; i < source.length(); ++i) {
                char cp = source.charAt(i);
                bytePosition = CompactStringByteConverter.writeUnsignedInt(cp, output, bytePosition);
            }
        }
        return bytePosition;
    }

    @Override
    public Appendable fromBytes(byte[] input, int byteStart, int byteLength, Appendable result) {
        try {
            int[] ioBytePosition = new int[]{0};
            if (this.deltaEncoded) {
                int last = 64;
                while (ioBytePosition[0] < byteLength) {
                    int delta = CompactStringByteConverter.readInt(input, ioBytePosition);
                    result.append((char)(last += delta));
                    last = last & 0xFFFFFF80 | 0x40;
                }
            } else {
                while (ioBytePosition[0] < byteLength) {
                    int last = CompactStringByteConverter.readUnsignedInt(input, ioBytePosition);
                    result.append((char)last);
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Internal error", e);
        }
    }

    public static int writeInt(int source, byte[] output, int bytePosition) {
        int sign = 0;
        if (source < 0) {
            sign = 64;
            source ^= 0xFFFFFFFF;
        }
        int mask = -64;
        int offset = -1;
        while ((source & mask) != 0) {
            offset += 7;
            mask <<= 7;
        }
        while (offset > 0) {
            output[bytePosition++] = (byte)(source >> offset & 0x7F);
            offset -= 7;
        }
        output[bytePosition++] = (byte)(0x80 | sign | source & 0x3F);
        return bytePosition;
    }

    public static int readInt(byte[] input, int[] ioBytePosition) {
        byte nextByte;
        int result = 0;
        int bytePosition = ioBytePosition[0];
        while ((nextByte = input[bytePosition++]) >= 0) {
            result <<= 7;
            result |= nextByte;
        }
        result <<= 6;
        result |= nextByte & 0x3F;
        if ((nextByte & 0x40) != 0) {
            result ^= 0xFFFFFFFF;
        }
        ioBytePosition[0] = bytePosition;
        return result;
    }

    public static int writeUnsignedInt(int source, byte[] output, int bytePosition) {
        int mask = -128;
        int offset = 0;
        while ((source & mask) != 0) {
            offset += 7;
            mask <<= 7;
        }
        while (offset > 0) {
            output[bytePosition++] = (byte)(source >> offset & 0x7F);
            offset -= 7;
        }
        output[bytePosition++] = (byte)(0x80 | source);
        return bytePosition;
    }

    public static int readUnsignedInt(byte[] input, int[] ioBytePosition) {
        byte nextByte;
        int result = 0;
        int bytePosition = ioBytePosition[0];
        while ((nextByte = input[bytePosition++]) >= 0) {
            result <<= 7;
            result |= nextByte;
        }
        result <<= 7;
        ioBytePosition[0] = bytePosition;
        return result |= nextByte & 0x7F;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 4;
    }
}

