/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EnumNames<T extends Enum<?>> {
    private Map<String, T> namesToEnum = new HashMap<String, T>();
    private ArrayList<String> enumToPreferredName = new ArrayList();

    public void add(T enumItem, String ... alternateNames) {
        String name = ((Enum)enumItem).name();
        this.namesToEnum.put(name, enumItem);
        this.namesToEnum.put(name.toLowerCase(Locale.ENGLISH), enumItem);
        if (alternateNames.length == 0) {
            this.enumToPreferredName.add(name);
        } else {
            this.enumToPreferredName.add(alternateNames[0]);
            for (String other : alternateNames) {
                this.namesToEnum.put(other, enumItem);
                this.namesToEnum.put(other.toLowerCase(Locale.ENGLISH), enumItem);
            }
        }
    }

    public T forString(String name) {
        Enum result = (Enum)this.namesToEnum.get(name);
        if (result != null) {
            return (T)result;
        }
        result = (Enum)this.namesToEnum.get(name.toLowerCase(Locale.ENGLISH));
        if (result != null) {
            return (T)result;
        }
        throw new IllegalArgumentException("No enum value for " + name + ", should be one of " + String.valueOf(this.namesToEnum.keySet()));
    }

    public String toString(T item) {
        return this.enumToPreferredName.get(((Enum)item).ordinal());
    }
}

