/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.UTF16;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Differ;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.MergeLists;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XEquivalenceClass;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

@Deprecated
public class FindDTDOrder
implements DeclHandler,
ContentHandler,
ErrorHandler {
    static final boolean SHOW_PROGRESS = CldrUtility.getProperty("verbose", false);
    static final boolean SHOW_ALL = CldrUtility.getProperty("show_all", false);
    private static final boolean DEBUG = false;
    private static FindDTDOrder INSTANCE;
    private boolean recordingAttributeElements;
    Relation<String, String> ancestorToDescendant = null;
    PrintWriter log = null;
    Set elementOrderings = new LinkedHashSet();
    Set<String> allDefinedElements = new LinkedHashSet<String>();
    boolean showReason = false;
    Object DONE = new Object();
    Relation<String, String> elementToChildren = Relation.of(new TreeMap(), TreeSet.class);
    private List<String> orderingList = new ArrayList<String>();
    String sep = "\n\t\t\t";
    static final Set<String> ELEMENT_SKIP_LIST;
    static final Set<String> SUBELEMENT_SKIP_LIST;
    Set<String> skipCommon = new LinkedHashSet<String>(Arrays.asList("validSubLocales", "standard", "references", "alt", "draft"));
    Set<String> attributeSet = new TreeSet<String>();
    List<String> attributeList;
    Map<String, Set<String>> attribEquiv;
    Relation<String, String> attributeToElements;
    private XEquivalenceClass attributeEquivalents;

    public static void main(String[] args) throws IOException {
        System.out.println("Outdated, no longer used");
        FindDTDOrder me = FindDTDOrder.getInstance();
        me.showData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FindDTDOrder getInstance() {
        Class<FindDTDOrder> clazz = FindDTDOrder.class;
        synchronized (FindDTDOrder.class) {
            if (INSTANCE == null) {
                try {
                    FindDTDOrder me = new FindDTDOrder();
                    XMLReader xmlReader = CLDRFile.createXMLReader(true);
                    xmlReader.setContentHandler(me);
                    xmlReader.setErrorHandler(me);
                    xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", me);
                    me.recordingAttributeElements = true;
                    String filename = CLDRPaths.MAIN_DIRECTORY + "/root.xml";
                    File file = new File(filename);
                    File dtd = new File(PathUtilities.getNormalizedPathString(file) + "/../../../common/dtd/ldml.dtd");
                    FileInputStream fis = new FileInputStream(filename);
                    InputSource is = new InputSource(fis);
                    is.setSystemId(PathUtilities.getNormalizedPathString(file) + "/../");
                    xmlReader.parse(is);
                    fis.close();
                    me.recordingAttributeElements = false;
                    filename = CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY + "/supplementalData.xml";
                    File file2 = new File(filename);
                    fis = new FileInputStream(filename);
                    is = new InputSource(fis);
                    is.setSystemId(PathUtilities.getNormalizedPathString(file) + "/../");
                    xmlReader.parse(is);
                    fis.close();
                    List<String> rawDtdAttributeOrder = Collections.unmodifiableList(new ArrayList<String>(me.attributeSet));
                    List<String> cldrFileAttributeOrder = CLDRFile.getAttributeOrder();
                    LinkedHashSet<String> modifiedDtdOrder = new LinkedHashSet<String>(cldrFileAttributeOrder);
                    modifiedDtdOrder.retainAll(rawDtdAttributeOrder);
                    modifiedDtdOrder.addAll(rawDtdAttributeOrder);
                    modifiedDtdOrder.removeAll(me.getCommonAttributes());
                    modifiedDtdOrder.addAll(me.getCommonAttributes());
                    ArrayList<String> dtdAttributeOrder = new ArrayList<String>(modifiedDtdOrder);
                    dtdAttributeOrder.remove("from");
                    dtdAttributeOrder.add(dtdAttributeOrder.indexOf("to"), "from");
                    me.attributeList = Collections.unmodifiableList(dtdAttributeOrder);
                    me.checkData();
                    me.orderingList = Collections.unmodifiableList(me.orderingList);
                    INSTANCE = me;
                }
                catch (Exception e) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void writeAttributeElements() {
        System.out.println("\n======== Start Attributes to Elements (unblocked) \n");
        for (String attribute : this.attributeToElements.keySet()) {
            TreeSet<String> filtered = new TreeSet<String>();
            for (String element : this.attributeToElements.getAll(attribute)) {
                if (this.isBlocked(element)) continue;
                filtered.add(element);
            }
            System.out.println(attribute + "\t" + CldrUtility.join(filtered, " "));
        }
        System.out.println("\n======== End Attributes to Elements\n");
        System.out.println("\n======== Start Elements to Children (skipping alias, special)\n");
        this.showElementTree("ldml", "", new HashSet<String>());
        System.out.println("\n======== End Elements to Children\n");
    }

    private void showElementTree(String element, String indent, HashSet<String> seenSoFar) {
        if (this.isBlocked(element)) {
            return;
        }
        Set<String> children = this.elementToChildren.getAll(element);
        if (seenSoFar.contains(element)) {
            System.out.println((String)indent + element + (String)(children == null || children.size() == 0 ? "" : "\t*dup*\t" + String.valueOf(children)));
            return;
        }
        System.out.println((String)indent + element);
        seenSoFar.add(element);
        if (children != null) {
            indent = (String)indent + "\t";
            for (String child : children) {
                this.showElementTree(child, (String)indent, seenSoFar);
            }
        }
    }

    private boolean isBlocked(String element) {
        return this.isAncestorOf("supplementalData", element) || this.isAncestorOf("collation", element) || this.isAncestorOf("cldrTest", element) || this.isAncestorOf("transform", element);
    }

    private boolean isAncestorOf(String possibleAncestor, String possibleDescendent) {
        Set<String> possibleDescendents;
        if (this.ancestorToDescendant == null) {
            this.ancestorToDescendant = Relation.of(new TreeMap(), TreeSet.class);
            this.buildPairwiseRelations(new ArrayList<String>(), "ldml");
        }
        if ((possibleDescendents = this.ancestorToDescendant.getAll(possibleAncestor)) == null) {
            return false;
        }
        return possibleDescendents.contains(possibleDescendent);
    }

    private void buildPairwiseRelations(List<String> parents, String current) {
        Set<String> children = this.elementToChildren.getAll(current);
        if (children == null || children.size() == 0) {
            return;
        }
        ArrayList<String> newParents = new ArrayList<String>(parents);
        newParents.add(current);
        for (String child : children) {
            for (String ancestor : newParents) {
                this.ancestorToDescendant.put(ancestor, child);
                this.buildPairwiseRelations(newParents, child);
            }
        }
    }

    FindDTDOrder() {
        this.attributeSet.add("_q");
        this.attributeSet.addAll(this.skipCommon);
        this.attribEquiv = new TreeMap<String, Set<String>>();
        this.attributeToElements = Relation.of(new TreeMap(), TreeSet.class);
        this.log = new PrintWriter(System.out);
    }

    public void checkData() {
        Object first;
        MergeLists<String> mergeLists = new MergeLists<String>(new TreeSet<String>(new UTF16.StringComparator(true, false, 0))).add((Collection<String>)Arrays.asList("ldml")).addAll(this.elementOrderings);
        List<String> result = mergeLists.merge();
        Collection<String> badOrder = MergeLists.hasConsistentOrderWithEachOf(result, this.elementOrderings);
        if (badOrder != null) {
            throw new IllegalArgumentException("Failed to find good order: " + String.valueOf(badOrder));
        }
        this.showReason = false;
        this.orderingList.add("ldml");
        if (SHOW_PROGRESS) {
            this.log.println("SHOW_PROGRESS ");
            for (Object value : this.elementOrderings) {
                this.log.println(value);
            }
        }
        while ((first = this.getFirst()) != this.DONE) {
            if (first != null) {
                if (this.orderingList.contains(first)) {
                    throw new IllegalArgumentException("Already present: " + String.valueOf(first));
                }
                this.orderingList.add(first.toString());
                continue;
            }
            this.showReason = true;
            this.getFirst();
            if (SHOW_PROGRESS) {
                this.log.println();
            }
            if (SHOW_PROGRESS) {
                this.log.println("Failed ordering. So far:");
            }
            Iterator<String> it = this.orderingList.iterator();
            while (it.hasNext()) {
                if (!SHOW_PROGRESS) continue;
                this.log.print("\t" + it.next());
            }
            if (SHOW_PROGRESS) {
                this.log.println();
            }
            if (SHOW_PROGRESS) {
                this.log.println("Items:");
            }
            if (!SHOW_PROGRESS) break;
            this.log.println();
            break;
        }
        TreeSet<String> missing = new TreeSet<String>(this.allDefinedElements);
        missing.removeAll(this.orderingList);
        this.orderingList.addAll(missing);
        this.attributeEquivalents = new XEquivalenceClass(null);
        for (String ename : this.attribEquiv.keySet()) {
            Set<String> s2 = this.attribEquiv.get(ename);
            Iterator<String> it2 = s2.iterator();
            String first2 = it2.next();
            while (it2.hasNext()) {
                this.attributeEquivalents.add(first2, it2.next(), ename);
            }
        }
    }

    private void showData() throws IOException {
        String oldAttributeOrder = this.breakLines(CLDRFile.getAttributeOrder());
        this.log.println("Successful Ordering...");
        this.log.println();
        this.log.println("Old Attribute Ordering: ");
        this.log.println(oldAttributeOrder);
        String newAttributeOrder = this.breakLines(this.attributeList);
        if (newAttributeOrder.equals(oldAttributeOrder)) {
            this.log.println("*** New Attribute Ordering: <same>");
            this.log.println("*** No changes required...");
        } else {
            this.log.println("*** New Attribute Ordering: ");
            this.log.println(newAttributeOrder);
            this.log.println("*** Replace in CLDRFile elementOrdering  & supplementalMetadata ***");
        }
        this.log.println("Attribute Eq: ");
        Iterator<Object> it = this.attributeEquivalents.getSamples().iterator();
        while (it.hasNext()) {
            this.log.println("\t" + this.getJavaList(new TreeSet<Object>(this.attributeEquivalents.getEquivalences(it.next()))));
        }
        if (SHOW_PROGRESS) {
            it = this.attributeEquivalents.getEquivalenceSets().iterator();
            while (it.hasNext()) {
                Object last = null;
                Set s2 = (Set)it.next();
                for (Object temp : s2) {
                    if (last != null) {
                        this.log.println(String.valueOf(last) + " ~ " + String.valueOf(temp) + "\t" + String.valueOf(this.attributeEquivalents.getReasons(last, temp)));
                    }
                    last = temp;
                }
                this.log.println();
            }
        }
        String oldOrder = this.getJavaList(CLDRFile.getElementOrder());
        this.log.println("Old Element Ordering:\n" + oldOrder);
        String newOrder = "\"" + this.breakLines(this.orderingList) + "\"";
        if (newOrder.equals(oldOrder)) {
            this.log.println("*** New Element Ordering: <same>");
            this.log.println("*** No changes required...");
        } else {
            this.log.println("*** New Element Ordering:\n" + newOrder);
            this.log.println("*** Replace in CLDRFile elementOrdering  & supplementalMetadata ***");
        }
        if (SHOW_ALL) {
            this.log.println("Old Size: " + CLDRFile.getElementOrder().size());
            HashSet<String> temp = new HashSet<String>(CLDRFile.getElementOrder());
            temp.removeAll(this.orderingList);
            this.log.println("Old - New: " + String.valueOf(temp));
            this.log.println("New Size: " + this.orderingList.size());
            temp = new HashSet<String>(this.orderingList);
            temp.removeAll(CLDRFile.getElementOrder());
            this.log.println("New - Old: " + String.valueOf(temp));
            Differ<String> differ = new Differ<String>(200, 1);
            Iterator<String> oldIt = CLDRFile.getElementOrder().iterator();
            Iterator<String> newIt = this.orderingList.iterator();
            while (oldIt.hasNext() || newIt.hasNext()) {
                int i;
                if (oldIt.hasNext()) {
                    differ.addA(oldIt.next());
                }
                if (newIt.hasNext()) {
                    differ.addB(newIt.next());
                }
                differ.checkMatch(!oldIt.hasNext() && !newIt.hasNext());
                if (differ.getACount() == 0 && differ.getBCount() == 0) continue;
                this.log.println("Same: " + String.valueOf(differ.getA(-1)));
                for (i = 0; i < differ.getACount(); ++i) {
                    this.log.println("\tOld: " + String.valueOf(differ.getA(i)));
                }
                for (i = 0; i < differ.getBCount(); ++i) {
                    this.log.println("\t\tNew: " + String.valueOf(differ.getB(i)));
                }
                this.log.println("Same: " + String.valueOf(differ.getA(differ.getACount())));
            }
            this.log.println("Done with differences");
        }
        this.log.flush();
        this.writeNewSupplemental(CLDRPaths.SUPPLEMENTAL_DIRECTORY, "supplementalMetadata.xml", "<attributeOrder>", "</attributeOrder>", "<elementOrder>", "</elementOrder>", "\t\t\t", "\n\t\t");
        this.writeNewSupplemental(CLDRPaths.BASE_DIRECTORY + "/tools/cldr-code/src/main/java/org/unicode/cldr/util/", "CLDRFile.java", "// START MECHANICALLY attributeOrdering GENERATED BY FindDTDOrder", "// END MECHANICALLY attributeOrdering GENERATED BY FindDTDOrder", "// START MECHANICALLY elementOrdering GENERATED BY FindDTDOrder", "// END MECHANICALLY elementOrdering GENERATED BY FindDTDOrder", "\t\t\t\t\t\"", "\"\n\t\t\t\t\t");
    }

    private void writeNewSupplemental(String dir, String filename, String startAttributeTag, String endAttributeTag, String startElementTag, String endElementTag, String startSep, String endSep) throws IOException {
        BufferedReader oldFile = FileUtilities.openUTF8Reader(dir, filename);
        Log.setLogNoBOM(CLDRPaths.GEN_DIRECTORY + "/DTDOrder/" + filename);
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*" + startElementTag + "\\s*"), Log.getLog(), true);
        Log.println(startSep + this.breakLines(this.orderingList) + endSep + endElementTag);
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*" + endElementTag + "\\s*"), null, true);
        CldrUtility.copyUpTo(oldFile, null, Log.getLog(), false);
        Log.close();
        oldFile.close();
    }

    private String breakLines(Collection orderingList) {
        String joined = CldrUtility.join(orderingList, " ");
        return joined;
    }

    private String getJavaList(Collection orderingList) {
        boolean first2 = true;
        StringBuffer result = new StringBuffer();
        result.append('\"');
        Iterator it = orderingList.iterator();
        while (it.hasNext()) {
            if (first2) {
                first2 = false;
            } else {
                result.append(" ");
            }
            result.append(it.next().toString());
        }
        result.append('\"');
        return result.toString();
    }

    private Object getFirst() {
        TreeSet firstItems = new TreeSet();
        TreeSet nonFirstItems = new TreeSet();
        for (List list : this.elementOrderings) {
            if (list.size() == 0) continue;
            firstItems.add(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                nonFirstItems.add(list.get(i));
            }
        }
        if (firstItems.size() == 0 && nonFirstItems.size() == 0) {
            return this.DONE;
        }
        firstItems.removeAll(nonFirstItems);
        if (firstItems.size() == 0) {
            return null;
        }
        Object result = firstItems.iterator().next();
        this.removeEverywhere(result);
        return result;
    }

    private void removeEverywhere(Object possibleFirst) {
        for (List list2 : this.elementOrderings) {
            if (SHOW_PROGRESS && list2.contains(possibleFirst)) {
                this.log.println("Removing " + String.valueOf(possibleFirst) + " from " + String.valueOf(list2));
            }
            while (list2.remove(possibleFirst)) {
            }
        }
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        if (name.indexOf("contractions") >= 0 || model.indexOf("[alias, base, settings, suppress, contractions, optimize, rules, special]") >= 0) {
            // empty if block
        }
        this.allDefinedElements.add(name);
        if (SHOW_PROGRESS) {
            this.log.println("Element\t" + name + "\t" + model);
        }
        String[] list = model.split("[^-_A-Z0-9a-z]+");
        ArrayList<String> mc = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].length() == 0) continue;
            if (list[i].equals("ANY") && !name.equals("special")) {
                System.err.println("WARNING- SHOULD NOT HAVE 'ANY': " + name + "\t" + model);
            }
            if (SUBELEMENT_SKIP_LIST.contains(list[i])) continue;
            if (mc.contains(list[i])) {
                if (name.equals("currency") && list[i].equals("displayName") || list[i].equals("symbol") || list[i].equals("pattern") || name.equals("rules") && (list[i].equals("reset") || list[i].equals("import"))) continue;
                throw new IllegalArgumentException("Duplicate element in definition of  " + name + ":\t" + list[i] + ":\t" + String.valueOf(Arrays.asList(list)) + ":\t" + String.valueOf(mc));
            }
            mc.add(list[i]);
        }
        if (this.recordingAttributeElements) {
            TreeSet children = new TreeSet(mc);
            children.remove("alias");
            children.remove("special");
            children.remove("cp");
            this.elementToChildren.putAll(name, children);
        }
        this.allDefinedElements.addAll(mc);
        if (mc.size() < 1) {
            if (SHOW_PROGRESS) {
                this.log.println("\tSKIPPING\t" + name + "\t" + String.valueOf(mc));
            }
        } else {
            if (SHOW_PROGRESS) {
                this.log.println("\t" + name + "\t" + String.valueOf(mc));
            }
            this.elementOrderings.add(mc);
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("attributeDecl");
        }
        if (SHOW_PROGRESS) {
            System.out.println("Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        }
        if (!this.skipCommon.contains(aName)) {
            this.attributeSet.add(aName);
            Set<String> l = this.attribEquiv.get(eName);
            if (l == null) {
                l = new TreeSet<String>();
                this.attribEquiv.put(eName, l);
            }
            l.add(aName);
        }
        if (this.recordingAttributeElements) {
            this.attributeToElements.put(aName, eName);
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("internalEntityDecl");
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("externalEntityDecl");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (SHOW_ALL) {
            this.log.println("endDocument");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (SHOW_ALL) {
            this.log.println("startDocument");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("characters");
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("ignorableWhitespace");
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("endPrefixMapping");
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("skippedEntity");
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (SHOW_ALL) {
            this.log.println("setDocumentLocator");
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("processingInstruction");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("startPrefixMapping");
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("endElement");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("startElement");
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("error");
        }
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("fatalError");
        }
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (SHOW_ALL) {
            this.log.println("warning");
        }
        throw exception;
    }

    public List<String> getAttributeOrder() {
        return this.attributeList;
    }

    public List<String> getElementOrder() {
        return this.orderingList;
    }

    public Set<String> getCommonAttributes() {
        return this.skipCommon;
    }

    static {
        ELEMENT_SKIP_LIST = new HashSet<String>(Arrays.asList("collation", "base", "settings", "suppress_contractions", "optimize", "rules", "reset", "context", "p", "pc", "s", "sc", "t", "tc", "i", "ic", "extend", "x"));
        SUBELEMENT_SKIP_LIST = new HashSet<String>(Arrays.asList("PCDATA", "EMPTY", "ANY"));
    }
}

