/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.NotificationCategory;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VettingParameters;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.XPathParts;

public class MissingXmlGetter {
    private static final String VALUE_PLACEHOLDER = "n/a";
    private final Factory factory;
    private final CLDRFile englishFile;
    private final Factory baselineFactory;
    private int userId = 0;
    private Organization usersOrg = null;
    private VettingViewer.UsersChoice<Organization> usersChoice = null;

    public MissingXmlGetter(Factory factory, Factory baselineFactory) {
        this.factory = factory;
        this.baselineFactory = baselineFactory;
        this.englishFile = factory.make("en", true);
    }

    public void setUserInfo(int userId, Organization usersOrg, VettingViewer.UsersChoice<Organization> usersChoice) {
        this.userId = userId;
        this.usersOrg = usersOrg;
        this.usersChoice = usersChoice;
    }

    public String getXml(CLDRLocale locale, Level coverageLevel) throws IOException {
        if (this.usersOrg == null || this.usersChoice == null) {
            throw new IllegalArgumentException("usersOrg and usersChoice must be set");
        }
        CLDRConfig config = CLDRConfig.getInstance();
        SupplementalDataInfo SDI = config.getSupplementalDataInfo();
        VettingViewer<Organization> vv = new VettingViewer<Organization>(SDI, this.factory, this.usersChoice);
        EnumSet<NotificationCategory> choiceSet = VettingViewer.getDashboardNotificationCategories(this.usersOrg);
        VettingParameters args = new VettingParameters(choiceSet, locale, coverageLevel);
        args.setUserAndOrganization(this.userId, this.usersOrg);
        args.setFiles(locale, this.factory, this.baselineFactory);
        VettingViewer.DashboardData dd = vv.generateDashboard(args);
        return this.reallyGetXml(locale, dd, args.getSourceFile());
    }

    private String reallyGetXml(CLDRLocale locale, VettingViewer.DashboardData dd, CLDRFile sourceFile) throws IOException {
        SimpleXMLSource xmlSource = new SimpleXMLSource(locale.getBaseName());
        CLDRFile cldrFile = new CLDRFile(xmlSource);
        this.populateMissingCldrFile(cldrFile, sourceFile, dd);
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                TreeMap options = new TreeMap();
                cldrFile.write(pw, options);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void populateMissingCldrFile(CLDRFile cldrFile, CLDRFile sourceFile, VettingViewer.DashboardData dd) {
        for (Map.Entry<Row.R2<PathHeader.SectionId, PathHeader.PageId>, VettingViewer.WritingInfo> e : dd.sorted.entrySet()) {
            VettingViewer.WritingInfo wi = e.getValue();
            String path = wi.codeOutput.getOriginalPath();
            if (wi.problems.contains((Object)NotificationCategory.missingCoverage)) {
                this.addMissingPath(cldrFile, path);
                continue;
            }
            if (!wi.problems.contains((Object)NotificationCategory.error) && !wi.problems.contains((Object)NotificationCategory.notApproved)) continue;
            this.addPresentPath(cldrFile, sourceFile, path, wi);
        }
    }

    private void addMissingPath(CLDRFile cldrFile, String path) {
        String comment = "English: " + this.englishFile.getStringValue(path);
        this.addPathCommentValue(cldrFile, path, comment, VALUE_PLACEHOLDER);
    }

    private void addPresentPath(CLDRFile cldrFile, CLDRFile sourceFile, String path, VettingViewer.WritingInfo wi) {
        String value = sourceFile.getStringValue(path);
        if (value == null) {
            value = VALUE_PLACEHOLDER;
        }
        Object comment = "";
        if (wi.problems.contains((Object)NotificationCategory.notApproved)) {
            comment = NotificationCategory.notApproved.buttonLabel;
        }
        if (wi.problems.contains((Object)NotificationCategory.error)) {
            if (!((String)comment).isEmpty()) {
                comment = (String)comment + "; ";
            }
            comment = (String)comment + NotificationCategory.error.buttonLabel + ": " + String.valueOf((Object)wi.subtype) + "; ";
            comment = (String)comment + wi.htmlMessage;
        }
        comment = (String)comment + "; English: " + this.englishFile.getStringValue(path);
        this.addPathCommentValue(cldrFile, path, (String)comment, value);
    }

    private void addPathCommentValue(CLDRFile cldrFile, String path, String comment, String value) {
        cldrFile.add(path, value);
        cldrFile.addComment(path, comment, XPathParts.Comments.CommentType.PREBLOCK);
    }
}

