/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.text.RelativeDateTimeFormatter;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;

public class TimeDiff {
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final double ONE_YEAR = 3.14712E10;

    public static String timeDiff(long a) {
        return TimeDiff.timeDiff(a, System.currentTimeMillis());
    }

    public static String durationDiff(long a) {
        return TimeDiff.timeDiff(System.currentTimeMillis() - a);
    }

    public static String timeDiff(long a, long b) {
        double del = b - a;
        RelativeDateTimeFormatter fmt = RelativeDateTimeFormatter.getInstance(Locale.ENGLISH);
        if (del > 3.14712E10) {
            int years = (int)(del /= 3.14712E10);
            return fmt.format(years, RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.YEARS);
        }
        if (del > 8.64E7) {
            int days = (int)(del /= 8.64E7);
            return fmt.format(days, RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.DAYS);
        }
        if (del > 3600000.0) {
            double hours = (b - a) / 3600000L;
            return fmt.format(hours, RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.HOURS);
        }
        if (del > 60000.0) {
            double minutes = (b - a) / 60000L;
            return fmt.format(minutes, RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.MINUTES);
        }
        if (del > 1000.0) {
            double seconds = (b - a) / 1000L;
            return fmt.format(seconds, RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.SECONDS);
        }
        return MeasureFormat.getInstance(ULocale.ENGLISH, MeasureFormat.FormatWidth.NARROW).format(new Measure(del, MeasureUnit.MILLISECOND));
    }

    public static long daysSinceDate(Date date) {
        ZoneId zone = ZoneId.of("UTC+0");
        DateTimeFormatter epochSecondFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS).toFormatter();
        String epoch = String.valueOf(date.getTime() / 1000L);
        Instant then = epochSecondFormatter.parse((CharSequence)epoch, Instant::from);
        LocalDate thatDay = then.atZone(zone).toLocalDate();
        LocalDate today = LocalDate.now(zone);
        return Math.abs(ChronoUnit.DAYS.between(thatDay, today));
    }
}

