/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.fixedcandidates;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.unicode.cldr.util.PatternCache;

public abstract class FixedCandidateProvider
implements Function<String, Collection<String>> {
    @Override
    public abstract Collection<String> apply(String var1);

    public static FixedCandidateProvider forXPathPattern(Pattern pattern, Collection<String> collection) {
        return new PredicateCollectionProvider(xpath -> pattern.matcher((CharSequence)xpath).matches(), collection);
    }

    public static FixedCandidateProvider forXPathPattern(String patternString, Collection<String> collection) {
        return FixedCandidateProvider.forXPathPattern(PatternCache.get(patternString), collection);
    }

    public static FixedCandidateProvider forXPath(String string, Collection<String> collection) {
        return new PredicateCollectionProvider(xpath -> string.equals(xpath), collection);
    }

    public static <T extends Enum<T>> FixedCandidateProvider forXPathAndEnum(String xpath, T[] values) {
        return FixedCandidateProvider.forXPath(xpath, FixedCandidateProvider.enumValueStrings(values));
    }

    public static <T extends Enum<T>> FixedCandidateProvider forXPathPatternAndEnum(String xpathPattern, T[] values) {
        return FixedCandidateProvider.forXPathPattern(xpathPattern, (Collection<String>)FixedCandidateProvider.enumValueStrings(values));
    }

    static final <T extends Enum<T>> Collection<String> enumValueStrings(T[] forValues) {
        ArrayList<String> l = new ArrayList<String>(forValues.length);
        for (T t2 : forValues) {
            l.add(((Enum)t2).toString());
        }
        return ImmutableList.copyOf(l);
    }

    public static class CompoundFixedCandidateProvider
    extends FixedCandidateProvider {
        final Collection<FixedCandidateProvider> delegates;

        @Override
        public Collection<String> apply(String xpath) {
            for (FixedCandidateProvider fcp : this.delegates) {
                Collection<String> r = fcp.apply(xpath);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        public CompoundFixedCandidateProvider(Collection<FixedCandidateProvider> providers) {
            this.delegates = providers;
        }

        Collection<FixedCandidateProvider> getDelegates() {
            return this.delegates;
        }
    }

    public static class PredicateCollectionProvider
    extends FixedCandidateProvider {
        final Predicate<String> matcher;
        final Collection<String> collection;

        PredicateCollectionProvider(Predicate<String> matcher, Collection<String> collection) {
            this.matcher = matcher;
            this.collection = collection;
        }

        @Override
        public Collection<String> apply(String xpath) {
            if (this.matcher.test(xpath)) {
                return this.collection;
            }
            return null;
        }
    }
}

