/*
 * Decompiled with CFR 0.152.
 */
package com.google.myanmartools;

import com.google.myanmartools.BinaryMarkov;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class ZawgyiUnicodeMarkovModel {
    static final long BINARY_TAG = 6150313243970980896L;
    private static final int STD_CP0 = 4096;
    private static final int STD_CP1 = 4159;
    private static final int AFT_CP0 = 4170;
    private static final int AFT_CP1 = 4255;
    private static final int EXA_CP0 = 43616;
    private static final int EXA_CP1 = 43647;
    private static final int EXB_CP0 = 43488;
    private static final int EXB_CP1 = 43519;
    private static final int SPC_CP0 = 8192;
    private static final int SPC_CP1 = 8203;
    private static final short STD_OFFSET = 1;
    private static final short AFT_OFFSET = 65;
    private static final short EXA_OFFSET = 151;
    private static final short EXB_OFFSET = 183;
    private static final short SPC_OFFSET = 215;
    private static final short END_OFFSET = 227;
    static final int SSV_STD_EXA_EXB_SPC = 0;
    static final int SSV_STD_EXA_EXB = 1;
    static final int SSV_COUNT = 2;
    final BinaryMarkov classifier;
    final int ssv;

    static int getIndexForCodePoint(int cp, int ssv) {
        if (4096 <= cp && cp <= 4159) {
            return cp - 4096 + 1;
        }
        if (4170 <= cp && cp <= 4255) {
            return cp - 4170 + 65;
        }
        if (43616 <= cp && cp <= 43647) {
            return cp - 43616 + 151;
        }
        if (43488 <= cp && cp <= 43519) {
            return cp - 43488 + 183;
        }
        if (ssv == 0 && 8192 <= cp && cp <= 8203) {
            return cp - 8192 + 215;
        }
        return 0;
    }

    static short getSize(int ssv) {
        return ssv == 0 ? (short)227 : 215;
    }

    ZawgyiUnicodeMarkovModel(BinaryMarkov classifier, int ssv) {
        this.classifier = classifier;
        this.ssv = ssv;
    }

    public ZawgyiUnicodeMarkovModel(InputStream stream) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        long binaryTag = dis.readLong();
        if (binaryTag != 6150313243970980896L) {
            throw new IOException(String.format("Unexpected magic number; expected %016X but got %016X", 6150313243970980896L, binaryTag));
        }
        int binaryVersion = dis.readInt();
        if (binaryVersion == 1) {
            this.ssv = 0;
        } else if (binaryVersion == 2) {
            this.ssv = dis.readInt();
        } else {
            throw new IOException(String.format("Unexpected serial version number; expected 1 or 2 but got %08X", binaryVersion));
        }
        if (this.ssv < 0 || this.ssv >= 2) {
            throw new IOException(String.format("Unexpected value in ssv position; expected 0 or 1 but got %08X", this.ssv));
        }
        this.classifier = new BinaryMarkov(stream);
    }

    double predict(String input, boolean verbose) {
        int cp;
        if (verbose) {
            System.out.format("Running detector on string: %s%n", input);
        }
        int prevCp = 0;
        int prevState = 0;
        double totalDelta = 0.0;
        boolean seenTransition = false;
        for (int offset = 0; offset <= input.length(); offset += Character.charCount(cp)) {
            int currState;
            if (offset == input.length()) {
                cp = 0;
                currState = 0;
            } else {
                cp = input.codePointAt(offset);
                currState = ZawgyiUnicodeMarkovModel.getIndexForCodePoint(cp, this.ssv);
            }
            if (prevState != 0 || currState != 0) {
                float delta = this.classifier.getLogProbabilityDifference(prevState, currState);
                if (verbose) {
                    System.out.format("U+%04X -> U+%04X: delta=%8.4f ", prevCp, cp, Float.valueOf(delta));
                    int i = 1;
                    while ((float)i < Math.abs(delta)) {
                        System.out.print("!");
                        ++i;
                    }
                    System.out.println();
                }
                totalDelta += (double)delta;
                seenTransition = true;
            }
            prevCp = cp;
            prevState = currState;
        }
        if (verbose) {
            System.out.format("Final: delta=%.4f%n", totalDelta);
        }
        if (!seenTransition) {
            return Double.NEGATIVE_INFINITY;
        }
        return 1.0 / (1.0 + Math.exp(totalDelta));
    }

    public double predict(String input) {
        return this.predict(input, false);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ZawgyiUnicodeMarkovModel)) {
            return false;
        }
        ZawgyiUnicodeMarkovModel _other = (ZawgyiUnicodeMarkovModel)other;
        return Objects.equals(this.classifier, _other.classifier) && this.ssv == _other.ssv;
    }

    public int hashCode() {
        return Objects.hashCode(this.classifier) ^ Objects.hashCode(this.ssv);
    }
}

