/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrValue;

public abstract class FilteredData
implements CldrData {
    private final CldrData src;

    protected FilteredData(CldrData src) {
        this.src = Preconditions.checkNotNull(src);
    }

    protected CldrData getSourceData() {
        return this.src;
    }

    protected abstract CldrValue filter(CldrValue var1);

    @Override
    public final void accept(CldrData.PathOrder order, CldrData.ValueVisitor visitor) {
        this.src.accept(order, (CldrValue v) -> this.visitFiltered(v, visitor));
    }

    @Override
    public final CldrValue get(CldrPath path) {
        CldrValue value = this.src.get(path);
        return value != null ? this.checkFiltered(value) : null;
    }

    private void visitFiltered(CldrValue value, CldrData.ValueVisitor visitor) {
        CldrValue filteredValue = this.checkFiltered(value);
        if (filteredValue != null) {
            visitor.visit(filteredValue);
        }
    }

    private CldrValue checkFiltered(CldrValue value) {
        CldrValue filteredValue = this.filter(value);
        Preconditions.checkArgument(filteredValue == null || filteredValue.getPath().equals(value.getPath()), "filtering is not permitted to modify distinguishing paths: source=%s, filtered=%s", (Object)value, (Object)filteredValue);
        return filteredValue;
    }
}

