/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.lang.reflect.Array;
import java.util.ArrayList;

class Array2D<T> {
    private ArrayList<ArrayList<T>> data = new ArrayList();
    private int columnSize;

    Array2D() {
    }

    void set(int row, int column, T value) {
        Array2D.ensureSize(this.data, row + 1);
        ArrayList<Object> rowList = this.data.get(row);
        if (rowList == null) {
            rowList = new ArrayList();
            this.data.set(row, rowList);
        }
        Array2D.ensureSize(rowList, column + 1);
        if (this.columnSize < rowList.size()) {
            this.columnSize = rowList.size();
        }
        rowList.set(column, value);
    }

    T get(int row, int column) {
        if (row >= this.data.size()) {
            return null;
        }
        ArrayList<T> rowList = this.data.get(row);
        return rowList == null || column >= rowList.size() ? null : (T)rowList.get(column);
    }

    T[][] to(Class<?> cls) {
        Object[][] result = (Object[][])Array.newInstance(cls, this.rows(), this.columns());
        for (int row = 0; row < this.data.size(); ++row) {
            result[row] = (Object[])Array.newInstance(cls, this.columns());
            for (int column = 0; column < this.columnSize; ++column) {
                result[row][column] = this.get(row, column);
            }
        }
        return result;
    }

    int rows() {
        return this.data.size();
    }

    int columns() {
        return this.columnSize;
    }

    public static void ensureSize(ArrayList<?> list, int size) {
        list.ensureCapacity(size);
        while (list.size() < size) {
            list.add(null);
        }
    }
}

