/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.UnicodeSetBuilder;
import org.unicode.cldr.util.PatternCache;

public class PatternFixer {
    private Target target;

    public PatternFixer(Target target) {
        this.target = target;
    }

    public Target getTarget() {
        return this.target;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fix(String regexPattern, int patternOptions) {
        UnicodeSetBuilder builder = new UnicodeSetBuilder();
        ParsePosition parsePosition = new ParsePosition(0);
        StringBuffer result = new StringBuffer();
        State state = State.BASE;
        int i = 0;
        while (true) {
            block24: {
                if (i >= regexPattern.length()) {
                    return result.toString();
                }
                try {
                    char ch = regexPattern.charAt(i);
                    block1 : switch (state) {
                        case BASE: {
                            switch (ch) {
                                case '\\': {
                                    state = State.HAVE_SLASH;
                                    break;
                                }
                                case '[': {
                                    i = this.parseUnicodeSet(regexPattern, builder, parsePosition, result, i) - 1;
                                    break block24;
                                }
                            }
                            break;
                        }
                        case HAVE_SLASH: {
                            switch (ch) {
                                case 'N': 
                                case 'P': 
                                case 'p': {
                                    i = this.parseUnicodeSet(regexPattern, builder, parsePosition, result, i) - 1;
                                    break block24;
                                }
                                case 'Q': {
                                    state = State.HAVE_Q;
                                    break;
                                }
                                default: {
                                    state = State.BASE;
                                    break;
                                }
                            }
                            break;
                        }
                        case HAVE_Q: {
                            switch (ch) {
                                case '\\': {
                                    state = State.HAVE_Q_SLASH;
                                    break block1;
                                }
                            }
                            break;
                        }
                        case HAVE_Q_SLASH: {
                            switch (ch) {
                                case 'E': {
                                    state = State.BASE;
                                    break block1;
                                }
                            }
                            state = State.HAVE_Q;
                        }
                    }
                    result.append(ch);
                }
                catch (ParseException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                }
            }
            ++i;
        }
    }

    public String fix(String regexPattern) {
        return this.fix(regexPattern, 0);
    }

    public static Pattern compile(String regexPattern, int patternOptions) {
        return Pattern.compile(new PatternFixer(Target.JAVA).fix(regexPattern, patternOptions), patternOptions);
    }

    public static Pattern compile(String regexPattern) {
        return PatternCache.get(new PatternFixer(Target.JAVA).fix(regexPattern));
    }

    public static String fixJava(String regexPattern, int patternOptions) {
        return new PatternFixer(Target.JAVA).fix(regexPattern, patternOptions);
    }

    public static String fixJava(String regexPattern) {
        return new PatternFixer(Target.JAVA).fix(regexPattern);
    }

    private int parseUnicodeSet(String regexPattern, UnicodeSetBuilder builder, ParsePosition parsePosition, StringBuffer result, int i) throws ParseException {
        return 0;
    }

    private static enum State {
        BASE,
        HAVE_SLASH,
        HAVE_Q,
        HAVE_Q_SLASH;

    }

    public static enum Target {
        JAVA;

    }
}

