/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rule {
    private final Pattern prematch;
    private final boolean prematchFindAtEnd;
    private final Pattern postmatch;
    private final List<Item> results = new ArrayList<Item>();
    private int outOfBoundsCursor = 0;

    public Rule(String pre, String post, List<String> results2) {
        Pattern tempPrematch;
        boolean tempPrematchFindAtEnd = false;
        if (pre.length() == 0) {
            tempPrematch = null;
        } else {
            try {
                tempPrematch = Pattern.compile("(?<=" + pre + ")", 36);
                tempPrematchFindAtEnd = true;
            }
            catch (Exception e) {
                tempPrematch = Pattern.compile(pre + "$", 36);
            }
        }
        this.prematch = tempPrematch;
        this.prematchFindAtEnd = tempPrematchFindAtEnd;
        this.postmatch = Pattern.compile(post, 36);
        for (String s2 : results2) {
            if (s2.startsWith("$")) {
                this.results.add(new NumberedItem(Integer.parseInt(s2.substring(1)), true));
                continue;
            }
            if (s2.length() <= 0) continue;
            this.results.add(new StringItem(s2));
        }
    }

    int append(StringBuilder result, Matcher prematcher, Matcher postmatcher) {
        int startPosition = result.length();
        int cursor = -1;
        for (Item item : this.results) {
            if (item == CursorItem.CURSOR) {
                cursor = result.length();
                continue;
            }
            String insertion = item.compose(prematcher, postmatcher);
            result.append(insertion);
        }
        return cursor >= 0 ? cursor : (this.outOfBoundsCursor < 0 ? startPosition + this.outOfBoundsCursor : result.length() + this.outOfBoundsCursor);
    }

    public String toString() {
        String main = this.postmatch.toString();
        return (this.prematch == null ? "" : this.prematch.toString()) + main + " > " + String.valueOf(this.results) + " ; ";
    }

    public Matcher getPrematcher(CharSequence processedAlready) {
        return this.prematch == null ? null : this.prematch.matcher(processedAlready);
    }

    public Matcher getPostmatcher(CharSequence toBeProcessed) {
        return this.postmatch.matcher(toBeProcessed);
    }

    public boolean prematch(Matcher prematcher, CharSequence processedAlready) {
        return this.prematchFindAtEnd ? prematcher.find(processedAlready.length()) : prematcher.find();
    }

    public static class CursorItem
    implements Item {
        static Item CURSOR = new CursorItem();

        @Override
        public String compose(Matcher prematcher, Matcher postmatcher) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "|";
        }
    }

    public static class NumberedItem
    implements Item {
        boolean post;
        int number;

        public NumberedItem(int parseInt, boolean b) {
            this.number = parseInt;
            this.post = b;
        }

        @Override
        public String compose(Matcher prematcher, Matcher postmatcher) {
            return this.post ? postmatcher.group(this.number) : prematcher.group(this.number);
        }

        public String toString() {
            return "$" + this.number;
        }
    }

    public static class StringItem
    implements Item {
        String replacement;

        public StringItem(String s2) {
            this.replacement = s2;
        }

        @Override
        public String compose(Matcher prematcher, Matcher postmatcher) {
            return this.replacement;
        }

        public String toString() {
            return this.replacement;
        }
    }

    public static interface Item {
        public String compose(Matcher var1, Matcher var2);
    }
}

