/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.Joiners;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class QuickCheck {
    private static final Set<String> skipAttributes = new HashSet<String>(Arrays.asList("alt", "draft", "references"));
    private static String localeRegex;
    private static boolean showInfo;
    private static String commonDirectory;
    private static String mainDirectory;
    private static boolean resolved;
    private static Exception[] internalException;
    private static boolean verbose;
    static Matcher skipPaths;
    private static boolean pretty;
    static final Date SAMPLE_DATE;

    public static void main(String[] args) throws IOException {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        Factory factory = testInfo.getCldrFactory();
        Path annotationsDir = Path.of(CLDRPaths.ANNOTATIONS_DIRECTORY, new String[0]);
        TreeSet<String> skipped = new TreeSet<String>();
        LinkedHashMultimap<String, String> differs = LinkedHashMultimap.create();
        String keycapPath = "//ldml/characterLabels/characterLabel[@type=\"keycap\"]";
        SimpleFormatter configLocaleValueInt = SimpleFormatter.compile("locale={0};\taction=add;\tnew_path=//ldml/annotations/annotation[@cp=\"{2}\u20e3\"];\tnew_value={1}");
        String[][] metadata = new String[][]{{"bn", "\u09b6\u09c2\u09a8\u09cd\u09af", "\u098f\u0995", "\u09a6\u09c1\u0987", "\u09a4\u09bf\u09a8", "\u099a\u09be\u09b0", "\u09aa\u09be\u0981\u099a", "\u099b\u09df", "\u09b8\u09be\u09a4", "\u0986\u099f", "\u09a8\u09df"}, {"ha", "sifili", "daya", "biyu", "uku", "hudu", "biyar", "shida", "bakwai", "takwas", "tara"}, {"mr", "\u0936\u0942\u0928\u094d\u092f", "\u090f\u0915", "\u0926\u094b\u0928", "\u0924\u0940\u0928", "\u091a\u093e\u0930", "\u092a\u093e\u091a", "\u0938\u0939\u093e", "\u0938\u093e\u0924", "\u0906\u0920", "\u0928\u090a"}, {"om", "zeeroo", "tokko", "lama", "sadii", "afur", "shan", "jaha", "torba", "saddet", "sagal"}, {"pa", "\u0a38\u0a3f\u0a2b\u0a30", "\u0a07\u0a71\u0a15", "\u0a26\u0a4b", "\u0a24\u0a3f\u0a70\u0a28", "\u0a1a\u0a3e\u0a30", "\u0a2a\u0a70\u0a1c", "\u0a1b\u0a47", "\u0a38\u0a71\u0a24", "\u0a05\u0a71\u0a20", "\u0a28\u0a4c\u0a02"}, {"te", "\u0c38\u0c41\u0c28\u0c4d\u0c28", "\u0c12\u0c15\u0c1f\u0c3f", "\u0c30\u0c46\u0c02\u0c21\u0c41", "\u0c2e\u0c42\u0c21\u0c41", "\u0c28\u0c3e\u0c32\u0c41\u0c17\u0c41", "\u0c10\u0c26\u0c41", "\u0c06\u0c30\u0c41", "\u0c0f\u0c21\u0c41", "\u0c0e\u0c28\u0c3f\u0c2e\u0c3f\u0c26\u0c3f", "\u0c24\u0c4a\u0c2e\u0c4d\u0c2e\u0c3f\u0c26\u0c3f"}, {"fil", "zero", "isa", "dalawa", "tatlo", "apat", "lima", "anim", "pito", "walo", "siyam"}, {"uz", "nol", "bir", "ikki", "uch", "to\u02bbrt", "besh", "olti", "yetti", "sakkiz", "to\u02bbqqiz"}, {"zh_Hant_HK", "\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"}, {"kn", "\u0cb6\u0cc2\u0ca8\u0ccd\u0caf", "\u0c92\u0c82\u0ca6\u0cc1", "\u0c8e\u0cb0\u0ca1\u0cc1", "\u0cae\u0cc2\u0cb0\u0cc1", "\u0ca8\u0cbe\u0cb2\u0ccd\u0c95\u0cc1", "\u0c90\u0ca6\u0cc1", "\u0c86\u0cb0\u0cc1", "\u0c8f\u0cb3\u0cc1", "\u0c8e\u0c82\u0c9f\u0cc1", "\u0c92\u0c82\u0cad\u0ca4\u0ccd\u0ca4\u0cc1"}, {"ml", "\u0d2a\u0d42\u0d1c\u0d4d\u0d2f\u0d02", "\u0d12\u0d28\u0d4d\u0d28\u0d4d", "\u0d30\u0d23\u0d4d\u0d1f\u0d4d", "\u0d2e\u0d42\u0d28\u0d4d\u0d28\u0d4d", "\u0d28\u0d3e\u0d32\u0d4d", "\u0d05\u0d1e\u0d4d\u0d1a\u0d4d", "\u0d06\u0d31\u0d4d", "\u0d0f\u0d34\u0d4d", "\u0d0e\u0d1f\u0d4d\u0d1f\u0d4d", "\u0d12\u0d2e\u0d4d\u0d2a\u0d24\u0d4d"}};
        Map metadata2 = Arrays.asList(metadata).stream().collect(Collectors.toMap(x -> x[0], x -> Arrays.asList(Arrays.copyOfRange(x, 1, ((String[])x).length)), (oldValue, newValue) -> newValue, TreeMap::new));
        for (File files : ImmutableSortedSet.copyOf((Comparable[])annotationsDir.toFile().listFiles())) {
            String name = files.getName();
            if (!name.endsWith(".xml")) continue;
            String localeString = name.substring(0, name.length() - 4);
            ULocale locale = new ULocale(localeString);
            RuleBasedNumberFormat formatter = new RuleBasedNumberFormat(locale, 1);
            ULocale.Type type = ULocale.ACTUAL_LOCALE;
            ULocale actualLocale = formatter.getLocale(type);
            List metaItems = (List)metadata2.get(localeString);
            boolean haveIcu = actualLocale.equals(locale);
            if (!haveIcu && metaItems == null) continue;
            String keyCapValue = factory.make(localeString, true).getStringValue(keycapPath);
            QuickCheck.addEmoji(skipped, differs, configLocaleValueInt, localeString, formatter, metaItems, haveIcu, keyCapValue);
        }
        for (Map.Entry entry : metadata2.entrySet()) {
            String localeString = (String)entry.getKey();
            if (!skipped.contains(localeString)) continue;
            String keyCapValue = factory.make(localeString, false).getStringValue(keycapPath);
            QuickCheck.addEmoji(skipped, differs, configLocaleValueInt, localeString, null, (List)entry.getValue(), false, keyCapValue);
        }
        differs.asMap().entrySet().stream().forEach(System.out::println);
    }

    private static void addEmoji(Set<String> skipped, Multimap<String, String> differs, SimpleFormatter configLocaleValueInt, String localeString, RuleBasedNumberFormat formatter, List<String> metaItems, boolean haveIcu, String keyCapValue) {
        for (int i = 0; i < 10; ++i) {
            String best;
            String icu = haveIcu ? formatter.format(i) : null;
            String meta = metaItems == null ? null : metaItems.get(i);
            String string = best = icu != null ? icu : meta;
            if (best == null) {
                skipped.add(localeString);
                continue;
            }
            if (icu != null & meta != null) {
                differs.put(localeString, i + " icu:" + icu + " " + (!meta.equals(icu) ? "=" : "!=") + " meta:" + meta);
            }
            String iValue = String.valueOf(i);
            List<String> valueList = Arrays.asList(iValue, best, keyCapValue);
            String path = configLocaleValueInt.format(localeString, Joiners.VBAR_SP.join(valueList), iValue);
            System.out.println(path);
        }
    }

    private static void checkDtds() throws IOException {
        QuickCheck.checkDtds(commonDirectory + "supplemental");
        QuickCheck.checkDtds(commonDirectory + "collation");
        QuickCheck.checkDtds(commonDirectory + "main");
        QuickCheck.checkDtds(commonDirectory + "rbnf");
        QuickCheck.checkDtds(commonDirectory + "segments");
        QuickCheck.checkDtds(commonDirectory + "../test");
        QuickCheck.checkDtds(commonDirectory + "transforms");
    }

    private static void checkDtds(String directory) throws IOException {
        File directoryFile = new File(directory);
        File[] listFiles = directoryFile.listFiles();
        String normalizedPath = PathUtilities.getNormalizedPathString(directoryFile);
        if (listFiles == null) {
            throw new IllegalArgumentException("Empty directory: " + normalizedPath);
        }
        System.out.println("Checking files for DTD errors in: " + normalizedPath);
        for (File fileName : listFiles) {
            if (!fileName.toString().endsWith(".xml")) continue;
            QuickCheck.check(fileName);
        }
    }

    public static void check(File systemID) {
        try (InputStream fis = InputStreamFactory.createInputStream(systemID);){
            XMLReader xmlReader = XMLFileReader.createXMLReader(true);
            xmlReader.setErrorHandler(new MyErrorHandler());
            InputSource is = new InputSource(fis);
            is.setSystemId(systemID.toString());
            xmlReader.parse(is);
        }
        catch (IOException | SAXException e) {
            System.out.println("\tCan't read " + String.valueOf(systemID));
            System.out.println("\t" + String.valueOf(e.getClass()) + "\t" + e.getMessage());
        }
    }

    private static void checkPaths() {
        Relation<String, String> distinguishing = Relation.of(new TreeMap(), TreeSet.class, null);
        Relation<String, String> nonDistinguishing = Relation.of(new TreeMap(), TreeSet.class, null);
        Factory cldrFactory = Factory.make(mainDirectory, localeRegex);
        CLDRFile english = cldrFactory.make("en", true);
        Relation<String, String> pathToLocale = Relation.of(new TreeMap(CLDRFile.getComparator(DtdType.ldml)), TreeSet.class, null);
        for (String locale : cldrFactory.getAvailable()) {
            CLDRFile file;
            try {
                file = cldrFactory.make(locale, resolved);
            }
            catch (Exception e) {
                System.out.println("\nfatalError: " + e.getMessage());
                continue;
            }
            if (file.isNonInheriting()) continue;
            DisplayAndInputProcessor displayAndInputProcessor = new DisplayAndInputProcessor(file, false);
            System.out.println(locale + "\t-\t" + english.nameGetter().getNameFromIdentifier(locale));
            DtdType dtdType = null;
            Iterator<String> iterator = file.iterator();
            while (iterator.hasNext()) {
                String nonAltPath;
                String sourceLocale;
                String path = iterator.next();
                if (path.endsWith("/alias")) continue;
                String value = file.getStringValue(path);
                if (value == null) {
                    throw new IllegalArgumentException(locale + "\tError: in null value at " + path);
                }
                String displayValue = displayAndInputProcessor.processForDisplay(path, value);
                if (!displayValue.equals(value)) {
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor changes display value <" + value + ">\t=>\t<" + displayValue + ">\t\t" + path);
                }
                String inputValue = displayAndInputProcessor.processInput(path, value, internalException);
                if (internalException[0] != null) {
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor internal error <" + value + ">\t=>\t<" + inputValue + ">\t\t" + path);
                    internalException[0].printStackTrace(System.out);
                }
                if (verbose && !inputValue.equals(value)) {
                    displayAndInputProcessor.processInput(path, value, internalException);
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor changes input value <" + value + ">\t=>\t<" + inputValue + ">\t\t" + path);
                }
                pathToLocale.put(path, locale);
                if (path.contains("/identity")) continue;
                if (path.contains("proposed") && locale.equals(sourceLocale = file.getSourceLocaleID(path, null)) && !path.equals(nonAltPath = CLDRFile.getNondraftNonaltXPath(path))) {
                    String nonAltLocale = file.getSourceLocaleID(nonAltPath, null);
                    String nonAltValue = file.getStringValue(nonAltPath);
                    if (nonAltValue == null || !locale.equals(nonAltLocale)) {
                        System.out.println("\t" + locale + "\tProblem alt=proposed <" + value + ">\t\t" + path);
                    }
                }
                String fullPath = file.getFullXPath(path);
                XPathParts parts = XPathParts.getFrozenInstance(fullPath);
                if (dtdType == null) {
                    dtdType = DtdType.valueOf(parts.getElement(0));
                }
                for (int i = 0; i < parts.size(); ++i) {
                    if (parts.getAttributeCount(i) == 0) continue;
                    String element = parts.getElement(i);
                    for (String attribute : parts.getAttributeKeys(i)) {
                        if (skipAttributes.contains(attribute)) continue;
                        if (CLDRFile.isDistinguishing(dtdType, element, attribute)) {
                            distinguishing.put(element, attribute);
                            continue;
                        }
                        nonDistinguishing.put(element, attribute);
                    }
                }
            }
        }
        System.out.println();
        System.out.format("Distinguishing Elements: %s\n", distinguishing);
        System.out.format("Nondistinguishing Elements: %s\n", nonDistinguishing);
        System.out.format("Skipped %s\n", skipAttributes);
        if (pretty) {
            if (showInfo) {
                System.out.println("\nShowing Path to PrettyPath mapping\n");
            }
            PrettyPath prettyPath = new PrettyPath().setShowErrors(true);
            TreeSet<String> badPaths = new TreeSet<String>();
            for (String path : pathToLocale.keySet()) {
                String prettied = prettyPath.getPrettyPath(path, false);
                if (showInfo) {
                    System.out.println(prettied + "\t\t" + path);
                }
                if (!prettied.contains("%%") || path.contains("/alias")) continue;
                badPaths.add(path);
            }
            if (showInfo) {
                System.out.println("\nShowing Paths not in root\n");
            }
            CLDRFile root = cldrFactory.make("root", true);
            for (String path : root) {
                pathToLocale.removeAll(path);
            }
            if (showInfo) {
                for (String path : pathToLocale.keySet()) {
                    if (skipPaths.reset(path).find()) continue;
                    System.out.println(path + "\t" + String.valueOf(pathToLocale.getAll(path)));
                }
            }
            if (badPaths.size() != 0) {
                System.out.println("Error: " + badPaths.size() + " Paths were not prettied: use -DSHOW and look for ones with %% in them.");
            }
        }
    }

    static void checkStock(Factory factory) {
        String[][] items = new String[][]{{"full", "yMMMMEEEEd", "jmmsszzzz"}, {"long", "yMMMMd", "jmmssz"}, {"medium", "yMMMd", "jmmss"}, {"short", "yMd", "jmm"}};
        String calendarID = "gregorian";
        String datetimePathPrefix = "//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/";
        int total = 0;
        int mismatch = 0;
        LanguageTagParser ltp = new LanguageTagParser();
        Set<String> locales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        for (String locale : locales) {
            if (!ltp.set(locale).getRegion().isEmpty()) continue;
            CLDRFile file = factory.make(locale, false);
            DateTimeFormats dtf = new DateTimeFormats();
            dtf.set(file, "gregorian", false);
            for (String[] stockInfo : items) {
                String length = stockInfo[0];
                String path = datetimePathPrefix + "dateFormats/dateFormatLength[@type=\"" + length + "\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
                String stockDatePattern = file.getStringValue(path);
                String flexibleDatePattern = dtf.getBestPattern(stockInfo[1]);
                mismatch += QuickCheck.showStatus(++total, locale, "date", length, stockInfo[1], stockDatePattern, flexibleDatePattern);
                path = datetimePathPrefix + "timeFormats/timeFormatLength[@type=\"" + length + "\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
                String stockTimePattern = file.getStringValue(path);
                String flexibleTimePattern = dtf.getBestPattern(stockInfo[2]);
                mismatch += QuickCheck.showStatus(++total, locale, "time", length, stockInfo[2], stockTimePattern, flexibleTimePattern);
            }
        }
        System.out.println("Mismatches:\t" + mismatch + "\tTotal:\t" + total);
    }

    private static int showStatus(int total, String locale, String type, String length, String skeleton, String stockPattern, String flexiblePattern) {
        ULocale ulocale = new ULocale(locale);
        DateFormatSymbols dfs = new DateFormatSymbols(ulocale);
        boolean areSame = Objects.equals(stockPattern, flexiblePattern);
        System.out.println(total + "\t" + (areSame ? "ok" : "diff") + "\t" + locale + "\t" + type + "\t" + length + "\t" + skeleton + "\t" + stockPattern + "\t" + (areSame ? "" : flexiblePattern) + "\t'" + new SimpleDateFormat(stockPattern, dfs, ulocale).format(SAMPLE_DATE) + "\t'" + (areSame ? "" : new SimpleDateFormat(flexiblePattern, dfs, ulocale).format(SAMPLE_DATE)));
        return areSame ? 0 : 1;
    }

    static {
        showInfo = false;
        internalException = new Exception[1];
        skipPaths = PatternCache.get("/identity|/alias|\\[@alt=\"proposed").matcher("");
        SAMPLE_DATE = new Date(113, 0, 29, 13, 59, 59);
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("\nerror: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("\nfatalError: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("\nwarning: " + XMLFileReader.showSAX(exception));
            throw exception;
        }
    }
}

