/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;

public class CLDRFormat {
    static Set<String> keys1 = new TreeSet<String>();
    static Set<String> keys2 = new TreeSet<String>();

    public static void main(String[] args) throws Exception {
        String filter = CldrUtility.getProperty("filter", ".*");
        Matcher matcher = PatternCache.get(filter).matcher("");
        File src = new File(CLDRPaths.COMMON_DIRECTORY);
        File dest = new File(CLDRPaths.BASE_DIRECTORY + "/common-test/");
        File dtd = new File(String.valueOf(dest) + "/main/../../common/dtd/ldmlSupplemental.dtd");
        if (!dtd.exists()) {
            throw new IllegalArgumentException("Can't access DTD\nas is: " + String.valueOf(dtd) + "\ncanonical: " + PathUtilities.getNormalizedPathString(dtd));
        }
        for (String subDir : src.list()) {
            String srcSubdir;
            File srcDir;
            if (subDir.equals("CVS") || subDir.equals("posix") || subDir.equals("test") || !(srcDir = new File(srcSubdir = String.valueOf(src) + "/" + subDir)).isDirectory()) continue;
            String destSubdir = String.valueOf(dest) + "/" + subDir;
            Factory cldrFactory = Factory.make(srcSubdir, ".*");
            for (String key : cldrFactory.getAvailable()) {
                String subDirKey = subDir + "/" + key;
                if (!matcher.reset(subDirKey).find()) continue;
                CLDRFile cldrFile = cldrFactory.make(key, false);
                PrintWriter out = FileUtilities.openUTF8Writer(destSubdir, key + ".xml");
                cldrFile.write(out);
                out.close();
                try {
                    CLDRFile regenFile = SimpleFactory.makeFile(key, destSubdir + key, CLDRFile.DraftStatus.unconfirmed);
                    String diff = CLDRFormat.findFirstDifference(cldrFile, regenFile);
                    if (diff == null) continue;
                    System.out.println("\tERROR: difference introduced in reformatting " + srcSubdir + "/" + key + ".xml\n" + diff);
                }
                catch (Exception e) {
                    System.err.println("\tERROR: can't read reformatted file " + srcSubdir + "/" + key + ".xml");
                }
            }
        }
    }

    private static String findFirstDifference(CLDRFile cldrFile, CLDRFile regenFile) {
        keys1.clear();
        keys2.clear();
        cldrFile.forEach(keys1::add);
        regenFile.forEach(keys2::add);
        if (!keys1.equals(keys2)) {
            TreeSet<String> missing = new TreeSet<String>(keys1);
            missing.removeAll(keys2);
            TreeSet<String> extras = new TreeSet<String>(keys2);
            extras.removeAll(keys1);
            return "\tMissing: " + ((Object)missing).toString().replace(", ", ",\n") + ";\n\tExtras: " + ((Object)extras).toString().replace(", ", ",\n");
        }
        for (String path : keys1) {
            String full2;
            String full1;
            if (path.startsWith("//ldml/identity/generation") || path.startsWith("//ldml/identity/version") || (full1 = cldrFile.getFullXPath(path)).equals(full2 = regenFile.getFullXPath(path))) continue;
            return "\tFull XPaths differ: " + full1 + "!=" + full2;
        }
        return null;
    }
}

