/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.RecordingCLDRFile;
import org.unicode.cldr.util.XMLSource;

@CLDRTool(alias="generate-example-dependencies", description="Generate example dependencies")
public class GenerateExampleDependencies {
    private static final String OUTPUT_FILE_NAME = "ExampleDependencies.java";
    private static final String DO_NOT_EDIT = "/* DO NOT EDIT THIS FILE, instead regenerate it using " + GenerateExampleDependencies.class.getSimpleName() + ".java */";
    private final CLDRFile englishFile;
    private final Factory factory;
    private final Set<String> locales;
    private final String outputDir;

    public static void main(String[] args) throws IOException {
        new GenerateExampleDependencies().run();
    }

    public GenerateExampleDependencies() {
        CLDRConfig info = CLDRConfig.getInstance();
        this.englishFile = info.getEnglish();
        this.factory = info.getCldrFactory();
        this.locales = this.factory.getAvailable();
        this.outputDir = CLDRPaths.GEN_DIRECTORY + "test" + File.separator;
    }

    public void run() throws IOException {
        int localeCount = this.locales.size();
        System.out.println("Looping through " + localeCount + " locales ... (this may take an hour)");
        TreeMultimap<String, String> dependencies = TreeMultimap.create();
        int i = 0;
        for (String localeId : this.locales) {
            int percent = ++i * 100 / localeCount;
            System.out.println(localeId + " " + i + "/" + localeCount + " " + percent + "%");
            this.addDependenciesForLocale(dependencies, localeId);
        }
        System.out.println("Creating " + this.outputDir + "ExampleDependencies.java ...");
        PrintWriter writer = FileUtilities.openUTF8Writer(this.outputDir, OUTPUT_FILE_NAME);
        int dependenciesWritten = this.writeDependenciesToFile(dependencies, writer);
        System.out.println("Wrote " + dependenciesWritten + " dependencies to " + this.outputDir + OUTPUT_FILE_NAME);
        System.out.println("If it looks OK, you can move it to the proper location, replacing the old version.");
    }

    private void addDependenciesForLocale(Multimap<String, String> dependencies, String localeId) {
        RecordingCLDRFile cldrFile = this.makeRecordingCldrFile(localeId);
        cldrFile.disableCaching();
        TreeSet<String> paths = new TreeSet<String>(cldrFile.getComparator());
        cldrFile.forEach(paths::add);
        ExampleGenerator egTest = new ExampleGenerator(cldrFile, this.englishFile);
        egTest.setCachingEnabled(false);
        for (String pathB : paths) {
            String valueB;
            if (GenerateExampleDependencies.skipPathForDependencies(pathB) || (valueB = cldrFile.getStringValue(pathB)) == null) continue;
            String starredB = PathStarrer.get(pathB);
            cldrFile.enableRecording();
            egTest.getExampleHtml(pathB, valueB);
            HashSet<String> pathsA = cldrFile.getRecordedPaths();
            cldrFile.clearRecordedPaths();
            cldrFile.disableRecording();
            for (String pathA : pathsA) {
                if (pathA.equals(pathB) || GenerateExampleDependencies.skipPathForDependencies(pathA)) continue;
                String starredA = PathStarrer.get(pathA);
                dependencies.put(starredA, starredB);
            }
        }
    }

    private RecordingCLDRFile makeRecordingCldrFile(String localeId) {
        XMLSource topSource = this.factory.makeSource(localeId);
        List<XMLSource> parents = GenerateExampleDependencies.getParentSources(this.factory, localeId);
        XMLSource[] a = new XMLSource[parents.size()];
        return new RecordingCLDRFile(topSource, parents.toArray(a));
    }

    private static List<XMLSource> getParentSources(Factory factory, String localeId) {
        ArrayList<XMLSource> parents = new ArrayList<XMLSource>();
        String currentLocaleID = LocaleIDParser.getParent(localeId);
        while (currentLocaleID != null) {
            parents.add(factory.makeSource(currentLocaleID));
            currentLocaleID = LocaleIDParser.getParent(currentLocaleID);
        }
        return parents;
    }

    private static boolean skipPathForDependencies(String path) {
        return path.endsWith("/alias") || path.startsWith("//ldml/identity");
    }

    private int writeDependenciesToFile(Multimap<String, String> dependencies, PrintWriter writer) {
        writer.println("package org.unicode.cldr.test;");
        writer.println(DO_NOT_EDIT);
        writer.println("import com.google.common.collect.ImmutableSetMultimap;");
        writer.println("");
        writer.println("public class ExampleDependencies {");
        writer.println("    public static ImmutableSetMultimap<String, String> dependencies =");
        writer.println("            new ImmutableSetMultimap.Builder<String, String>()");
        int dependenciesWritten = 0;
        ArrayList<String> listA = new ArrayList<String>(dependencies.keySet());
        Collections.sort(listA);
        for (String pathA : listA) {
            ArrayList<String> listB = new ArrayList<String>(dependencies.get(pathA));
            Collections.sort(listB);
            String a = "\"" + pathA.replaceAll("\"", "\\\\\"") + "\"";
            writer.println("                    .putAll(" + a + ",");
            int remainingCount = listB.size();
            for (String pathB : listB) {
                String b = "\"" + pathB.replaceAll("\"", "\\\\\"") + "\"";
                String endOfLine = --remainingCount > 0 ? "," : ")";
                writer.println("                            " + b + endOfLine);
                ++dependenciesWritten;
            }
        }
        writer.println("                    .build();");
        writer.println("}");
        writer.println(DO_NOT_EDIT);
        writer.close();
        return dependenciesWritten;
    }
}

