/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;

class GenerateStatistics {
    static final boolean HACK = true;
    static CLDRFile english;
    static Factory factory;
    static LanguageTagParser ltp;
    static Collator col;
    static boolean notitlecase;
    static final UnicodeSet NON_LATIN;
    static Map<String, String> fixCountryNames;
    public static final Transliterator toLatin;

    GenerateStatistics() {
    }

    public static void generateSize(String sourceDir, String logDir, String match, boolean transliterate) throws IOException {
        factory = Factory.make(sourceDir, match);
        ToolUtilities.registerExtraTransliterators();
        PrintWriter logHtml = FileUtilities.openUTF8Writer(logDir, "test_generation_log.html");
        english = factory.make("en", true);
        TreeSet<Object> languages = new TreeSet<Object>(col);
        TreeSet<Object> countries = new TreeSet<Object>(col);
        TreeSet<Object> draftLanguages = new TreeSet<Object>(col);
        TreeSet<Object> draftCountries = new TreeSet<Object>(col);
        TreeSet<Object> nativeLanguages = new TreeSet<Object>();
        TreeSet<Object> nativeCountries = new TreeSet<Object>();
        TreeSet<Object> draftNativeLanguages = new TreeSet<Object>();
        TreeSet<Object> draftNativeCountries = new TreeSet<Object>();
        int localeCount = 0;
        int draftLocaleCount = 0;
        Set<String> contents = GenerateStatistics.removeSingleLanguagesWhereWeHaveScripts(factory.getAvailable());
        for (String localeID : contents) {
            if (CLDRFile.isSupplementalName(localeID) || localeID.equals("root")) continue;
            System.out.println("Collecting info for:\t" + localeID.replace("_", "\t"));
            boolean draft = false;
            if (draft) {
                ++draftLocaleCount;
                GenerateStatistics.addCounts(localeID, true, draftLanguages, draftCountries, draftNativeLanguages, draftNativeCountries);
                continue;
            }
            ++localeCount;
            GenerateStatistics.addCounts(localeID, false, languages, countries, nativeLanguages, nativeCountries);
        }
        draftLanguages.removeAll(languages);
        Iterator<String> it = nativeLanguages.iterator();
        while (it.hasNext()) {
            draftNativeLanguages.remove(it.next());
        }
        logHtml.println("<html><head>");
        logHtml.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        logHtml.println("</head><body>");
        logHtml.println("<p><b>Locales (" + localeCount + "):</b>");
        logHtml.println("<p><b>Languages (" + languages.size() + "):</b>");
        logHtml.println(GenerateStatistics.showSet(nativeLanguages, transliterate, true));
        logHtml.println("<p><b>Territories (" + countries.size() + "):</b>");
        logHtml.println(GenerateStatistics.showSet(nativeCountries, transliterate, false));
        logHtml.println("<p><b>Draft locales (" + draftLocaleCount + "):</b>");
        logHtml.println("<p><b>Draft languages (" + draftLanguages.size() + "):</b>");
        logHtml.println(GenerateStatistics.showSet(draftNativeLanguages, transliterate, true));
        logHtml.println("<p><b>Draft countries (" + draftCountries.size() + "):</b>");
        logHtml.println(GenerateStatistics.showSet(draftNativeCountries, transliterate, false));
        logHtml.println(CldrUtility.ANALYTICS);
        logHtml.println("</body></html>");
        logHtml.close();
    }

    private static Set<String> removeSingleLanguagesWhereWeHaveScripts(Set<String> contents) {
        String lang;
        String localeID;
        StandardCodes sc = StandardCodes.make();
        contents = new TreeSet<String>(contents);
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("sh");
        Iterator<String> it = contents.iterator();
        while (it.hasNext()) {
            localeID = it.next();
            if (CLDRFile.isSupplementalName(localeID)) continue;
            lang = ltp.set(localeID).getLanguage();
            String territory = ltp.set(localeID).getRegion();
            if (!sc.getGoodAvailableCodes("language").contains(lang)) {
                System.out.println("Odd language, removing: " + localeID);
                it.remove();
                continue;
            }
            if (territory.length() != 0 && !sc.getGoodAvailableCodes("territory").contains(territory)) {
                System.out.println("Odd territory, removing: " + localeID);
                it.remove();
                continue;
            }
            String langscript = ltp.set(localeID).getLanguageScript();
            if (lang.equals(langscript)) continue;
            toRemove.add(lang);
        }
        it = contents.iterator();
        while (it.hasNext()) {
            String langscript;
            localeID = it.next();
            if (CLDRFile.isSupplementalName(localeID) || !toRemove.contains(lang = ltp.set(localeID).getLanguage()) || !lang.equals(langscript = ltp.set(localeID).getLanguageScript())) continue;
            it.remove();
        }
        return contents;
    }

    private static String showSet(Set nativeCountries, boolean transliterate, boolean isLanguage) {
        UnicodeSet BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]");
        StringBuffer result = new StringBuffer();
        TreeMap<Object, TreeSet<LanguageList>> sb = new TreeMap<Object, TreeSet<LanguageList>>(LanguageList.col);
        for (LanguageList llist : nativeCountries) {
            TreeSet<LanguageList> s2 = (TreeSet<LanguageList>)sb.get(llist.getEnglishName());
            if (s2 == null) {
                s2 = new TreeSet<LanguageList>();
                sb.put(llist.getEnglishName(), s2);
            }
            s2.add(llist);
        }
        TreeSet<Object> titleSet = new TreeSet<Object>(col);
        TreeSet<Object> qualifierSet = new TreeSet<Object>(col);
        for (Object englishName : sb.keySet()) {
            Set s3 = (Set)sb.get(englishName);
            if (result.length() != 0) {
                result.append("; ");
            }
            String code = "";
            boolean needQualifier = s3.size() != 1;
            titleSet.clear();
            qualifierSet.clear();
            for (LanguageList llist : s3) {
                String locale;
                Object localName = llist.getLocalName();
                String lang = locale = llist.getLocale();
                String country = "";
                if (locale.length() > 3 && locale.charAt(locale.length() - 3) == '_') {
                    lang = locale.substring(0, locale.length() - 3);
                    country = locale.substring(locale.length() - 2);
                }
                if (BIDI_R.containsSome((CharSequence)localName)) {
                    localName = "\u200e" + (String)localName + "\u200e";
                }
                code = isLanguage ? lang : country;
                if (((String)localName).equalsIgnoreCase((String)englishName)) continue;
                needQualifier = true;
                qualifierSet.add(localName);
                if (!transliterate || !NON_LATIN.containsSome((CharSequence)localName) || lang.equals("ja")) continue;
                Object transName = localName;
                try {
                    transName = GenerateStatistics.fixedTitleCase("en", toLatin.transliterate((String)localName));
                }
                catch (RuntimeException e) {
                    System.out.println("\t" + e.getMessage());
                }
                if (NON_LATIN.containsSome((CharSequence)transName)) {
                    Log.logln("Can't transliterate " + (String)localName + ": " + (String)transName);
                    continue;
                }
                titleSet.add(transName);
            }
            String title = code + (String)(titleSet.isEmpty() ? "" : ": " + ((Object)titleSet).toString());
            Object before = "";
            String after = "";
            if (title.length() != 0) {
                before = "<span title='" + TransliteratorUtilities.toHTML.transliterate(title) + "'>";
                after = "</span>";
            }
            Object qualifiers = ((Object)qualifierSet).toString();
            qualifiers = !needQualifier || qualifierSet.isEmpty() ? "" : " " + (String)qualifiers;
            if (((String)englishName).endsWith(", China")) {
                englishName = ((String)englishName).substring(0, ((String)englishName).length() - ", China".length()) + " China";
            }
            result.append((String)before).append(TransliteratorUtilities.toHTML.transliterate((String)englishName + (String)qualifiers)).append(after);
        }
        return result.toString();
    }

    private static void addCounts(String localeID, boolean isDraft, Set<String> draftLanguages, Set<String> draftCountries, Set<Object> draftNativeLanguages, Set<Object> draftNativeCountries) {
        ltp.set(localeID);
        String lang = ltp.getLanguage();
        String langScript = ltp.getLanguageScript();
        String country = ltp.getRegion();
        draftLanguages.add(lang);
        String nativeName = GenerateStatistics.getFixedLanguageName(localeID, langScript);
        String englishName = english.nameGetter().getNameFromIdentifier(langScript);
        if (!lang.equals("en") && nativeName.equals(englishName)) {
            Log.logln((isDraft ? "D" : "") + "\tWarning: in " + localeID + ", display name for " + lang + " equals English: " + nativeName);
        }
        draftNativeLanguages.add(new LanguageList(langScript, englishName, GenerateStatistics.fixedTitleCase("en", nativeName)));
        if (!country.equals("")) {
            draftCountries.add(country);
            nativeName = GenerateStatistics.getFixedDisplayCountry(localeID, country);
            englishName = GenerateStatistics.getFixedDisplayCountry("en", country);
            if (!lang.equals("en") && nativeName.equals(englishName)) {
                Log.logln((isDraft ? "D" : "") + "\tWarning: in " + localeID + ", display name for " + country + " equals English: " + nativeName);
            }
            draftNativeCountries.add(new LanguageList(localeID, englishName, GenerateStatistics.fixedTitleCase("en", nativeName)));
        }
    }

    static String fixedTitleCase(String localeID, String in) {
        if (notitlecase) {
            return in;
        }
        String result = UCharacter.toTitleCase(new ULocale(localeID), in, null);
        result = result.replace("U.s.", "U.S.");
        result = result.replace("S.a.r.", "S.A.R.");
        return result;
    }

    private static String getFixedLanguageName(String localeID, String lang) {
        if ((localeID.equals("bs") || localeID.startsWith("bs_")) && (lang.equals("bs") || lang.startsWith("bs_"))) {
            return "Bosanski";
        }
        CLDRFile cldr = factory.make(localeID, true);
        return cldr.nameGetter().getNameFromIdentifier(lang);
    }

    private static String getFixedDisplayCountry(String localeID, String country) {
        if ((localeID.equals("bs") || localeID.startsWith("bs_")) && country.equals("BA")) {
            return "\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430";
        }
        CLDRFile cldr = factory.make(localeID, true);
        String name = cldr.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, country);
        return name;
    }

    static {
        ltp = new LanguageTagParser();
        col = CollatorHelper.ROOT_COLLATOR;
        notitlecase = true;
        NON_LATIN = new UnicodeSet("[^[:latin:][:common:][:inherited:]]");
        fixCountryNames = new HashMap<String, String>();
        fixCountryNames.put("\u0408\u0443\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u0458\u0430", "\u0421\u0440\u0431\u0438\u0458\u0430 \u0438 \u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430");
        fixCountryNames.put("Jugoslavija", "Srbija i Crna Gora");
        fixCountryNames.put("Yugoslavia", "Serbia and Montenegro");
        toLatin = Transliterator.getInstance("any-latin");
    }

    public static class DraftChecker {
        String dir;
        Map<String, Object> cache = new HashMap<String, Object>();
        Object TRUE = new Object();
        Object FALSE = new Object();

        public DraftChecker(String dir) {
            this.dir = dir;
        }

        public boolean isDraft(String localeName) {
            Object check = this.cache.get(localeName);
            if (check != null) {
                return check == this.TRUE;
            }
            BufferedReader pw = null;
            try {
                String line;
                pw = FileUtilities.openUTF8Reader(this.dir, localeName + ".xml");
                do {
                    if ((line = pw.readLine()) != null) continue;
                    throw new IllegalArgumentException("Internal Error: should never get here.");
                } while (line.indexOf("<ldml") < 0);
                check = line.indexOf("draft") >= 0 ? this.TRUE : this.FALSE;
                pw.close();
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException("Failure on " + localeName + ": " + this.dir + localeName + ".xml", e);
            }
            this.cache.put(localeName, check);
            return check == this.TRUE;
        }
    }

    private static class LanguageList
    implements Comparable<Object> {
        Object[] contents;
        static Collator col = CollatorHelper.ROOT_COLLATOR;
        static Comparator<Object[]> comp = new ArrayComparator((Comparator[])new Collator[]{col, col, null});

        LanguageList(String locale, String englishName, String localName) {
            this.contents = new Object[]{englishName, locale, localName};
        }

        @Override
        public int compareTo(Object o) {
            return comp.compare(this.contents, ((LanguageList)o).contents);
        }

        String getLocale() {
            return (String)this.contents[1];
        }

        String getEnglishName() {
            return (String)this.contents[0];
        }

        String getLocalName() {
            return (String)this.contents[2];
        }
    }
}

