/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ShowDtdDiffs {
    static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    static Set<DtdType> TYPES = EnumSet.allOf(DtdType.class);
    static final Map<DtdType, String> FIRST_VERSION;
    static final Set<String> SKIP_ELEMENTS;
    static final Set<String> SKIP_ATTRIBUTES;

    public static void main(String[] args) {
        String last = null;
        for (String current : ToolConstants.CLDR_VERSIONS) {
            String currentName = current == null ? "trunk" : current;
            for (DtdType type : TYPES) {
                DtdData dtdLast;
                DtdData dtdCurrent;
                block8: {
                    String firstVersion = FIRST_VERSION.get((Object)type);
                    if (firstVersion != null && current != null && current.compareTo(firstVersion) < 0) continue;
                    dtdCurrent = null;
                    try {
                        dtdCurrent = DtdData.getInstance(type, current);
                    }
                    catch (Exception e) {
                        if (!(e.getCause() instanceof FileNotFoundException)) {
                            throw e;
                        }
                        System.out.println(e.getMessage() + ", " + e.getCause().getMessage());
                        continue;
                    }
                    dtdLast = null;
                    if (last != null) {
                        try {
                            dtdLast = DtdData.getInstance(type, last);
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof FileNotFoundException) break block8;
                            throw e;
                        }
                    }
                }
                ShowDtdDiffs.diff(currentName + "\t" + String.valueOf((Object)type), dtdLast, dtdCurrent);
            }
            last = current;
        }
    }

    private static void diff(String prefix, DtdData dtdLast, DtdData dtdCurrent) {
        Map<String, DtdData.Element> oldNameToElement = dtdLast == null ? Collections.EMPTY_MAP : dtdLast.getElementFromName();
        ShowDtdDiffs.checkNames(prefix, dtdCurrent, oldNameToElement, "/", dtdCurrent.ROOT, new HashSet<DtdData.Element>());
    }

    private static void checkNames(String prefix, DtdData dtdCurrent, Map<String, DtdData.Element> oldNameToElement, String path, DtdData.Element element, HashSet<DtdData.Element> seen) {
        if (seen.contains(element)) {
            return;
        }
        seen.add(element);
        String name = element.getName();
        if (SKIP_ELEMENTS.contains(name)) {
            return;
        }
        if (ShowDtdDiffs.isDeprecated(dtdCurrent.dtdType, name, "*")) {
            return;
        }
        String newPath = path + "/" + element.name;
        if (!oldNameToElement.containsKey(name)) {
            String attributeNames = ShowDtdDiffs.getAttributeNames(dtdCurrent, name, Collections.EMPTY_MAP, element.getAttributes());
            System.out.println(prefix + "\tElement\t" + newPath + "\t" + attributeNames);
        } else {
            DtdData.Element oldElement = oldNameToElement.get(name);
            String attributeNames = ShowDtdDiffs.getAttributeNames(dtdCurrent, name, oldElement.getAttributes(), element.getAttributes());
            if (!attributeNames.isEmpty()) {
                System.out.println(prefix + "\tAttribute\t" + newPath + "\t" + attributeNames);
            }
        }
        for (DtdData.Element child : element.getChildren().keySet()) {
            ShowDtdDiffs.checkNames(prefix, dtdCurrent, oldNameToElement, newPath, child, seen);
        }
    }

    private static String getAttributeNames(DtdData dtdCurrent, String elementName, Map<DtdData.Attribute, Integer> attributesOld, Map<DtdData.Attribute, Integer> attributes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        block0: for (DtdData.Attribute attribute : attributes.keySet()) {
            String name = attribute.getName();
            if (SKIP_ATTRIBUTES.contains(name) || ShowDtdDiffs.isDeprecated(dtdCurrent.dtdType, elementName, name)) continue;
            for (DtdData.Attribute attributeOld : attributesOld.keySet()) {
                if (!attributeOld.name.equals(name)) continue;
                continue block0;
            }
            names.add(name);
        }
        return names.isEmpty() ? "" : Joiner.on(", ").join(names);
    }

    private static boolean isDeprecated(DtdType dtdType, String elementName, String attributeName) {
        try {
            return DtdData.getInstance(dtdType).isDeprecated(elementName, attributeName, "*");
        }
        catch (DtdData.IllegalByDtdException e) {
            return true;
        }
    }

    static {
        TYPES.remove((Object)DtdType.ldmlICU);
        FIRST_VERSION = new EnumMap<DtdType, String>(DtdType.class);
        FIRST_VERSION.put(DtdType.ldmlBCP47, "1.7.2");
        FIRST_VERSION.put(DtdType.keyboard3, "22.1");
        SKIP_ELEMENTS = new HashSet<String>(Arrays.asList("generation", "identity", "alias", "special", "telephoneCodeData"));
        SKIP_ATTRIBUTES = new HashSet<String>(Arrays.asList("references", "standard", "draft", "alt"));
    }
}

