/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.VersionInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;

public class CLDRFileOverride
extends CLDRFile {
    static final String COMPARISON_LOCALE = "en";

    public CLDRFileOverride(CLDRFile sourceFile, Map<String, String> valueOverrides) {
        super(new XMLSourceMapOverride(sourceFile.dataSource, valueOverrides));
    }

    public static class XMLSourceMapOverride
    extends XMLSource {
        private final XMLSource delegate;
        private final Map<String, String> overrides;

        public XMLSourceMapOverride(XMLSource source, Map<String, String> overrides) {
            overrides.keySet().stream().forEach(x -> {
                String loc;
                if (source.getValueAtDPath((String)x) == null && !CLDRFileOverride.COMPARISON_LOCALE.equals(loc = source.getLocaleID())) {
                    throw new IllegalArgumentException("loc=" + loc + "; path=" + x);
                }
            });
            this.overrides = overrides;
            this.setLocaleID(source.getLocaleID());
            this.delegate = source;
        }

        @Override
        public boolean isResolving() {
            return this.delegate.isResolving();
        }

        @Override
        public XMLSource freeze() {
            XMLSourceMapOverride.readonly();
            return null;
        }

        @Override
        public String getFullPathAtDPath(String path) {
            return this.delegate.getFullPathAtDPath(path);
        }

        @Override
        public String getValueAtDPath(String path) {
            String override = this.overrides.get(path);
            return override != null ? override : this.delegate.getValueAtDPath(path);
        }

        @Override
        public XPathParts.Comments getXpathComments() {
            return this.delegate.getXpathComments();
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void putFullPathAtDPath(String distinguishingXPath, String fullxpath) {
            XMLSourceMapOverride.readonly();
        }

        @Override
        public void putValueAtDPath(String distinguishingXPath, String value) {
            XMLSourceMapOverride.readonly();
        }

        @Override
        public void removeValueAtDPath(String distinguishingXPath) {
            XMLSourceMapOverride.readonly();
        }

        @Override
        public void setXpathComments(XPathParts.Comments comments) {
            XMLSourceMapOverride.readonly();
        }

        @Override
        public void getPathsWithValue(String valueToMatch, String pathPrefix, Set<String> result) {
            throw new UnsupportedOperationException("support later when needed");
        }

        @Override
        public VersionInfo getDtdVersionInfo() {
            return this.delegate.getDtdVersionInfo();
        }

        private static void readonly() {
            throw new InternalError("This is a readonly instance.");
        }
    }
}

