/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.util.BitSet;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.unicode.cldr.util.ICUServiceBuilder;

public class CldrIntervalFormat {
    public final String calendar;
    public final String firstPattern;
    public final Set<DateTimePatternGenerator.VariableField> firstFields;
    public final String separator;
    public final String secondPattern;
    public final Set<DateTimePatternGenerator.VariableField> secondFields;

    private CldrIntervalFormat(String calendar, String firstPattern, Set<DateTimePatternGenerator.VariableField> firstFields, String separator, String secondPattern, Set<DateTimePatternGenerator.VariableField> secondFields) {
        this.calendar = calendar;
        this.firstPattern = firstPattern;
        this.firstFields = ImmutableSet.copyOf(firstFields);
        this.separator = separator;
        this.secondPattern = secondPattern;
        this.secondFields = ImmutableSet.copyOf(secondFields);
    }

    public String format(Date earlier, Date later, ICUServiceBuilder icuServiceBuilder, TimeZone timezone) {
        if (earlier == null || later == null) {
            return null;
        }
        if (later.compareTo(earlier) < 0) {
            Date tmp = earlier;
            earlier = later;
            later = tmp;
        }
        SimpleDateFormat firstFormat = icuServiceBuilder.getDateFormat(this.calendar, this.firstPattern);
        firstFormat.setTimeZone(timezone);
        SimpleDateFormat secondFormat = icuServiceBuilder.getDateFormat(this.calendar, this.secondPattern);
        firstFormat.setTimeZone(timezone);
        return firstFormat.format(earlier) + this.separator + secondFormat.format(later);
    }

    public static CldrIntervalFormat getInstance(String calendar, String pattern) {
        DateTimePatternGenerator.FormatParser formatParser = CldrIntervalFormat.formatParser(pattern);
        BitSet variableFields = new BitSet();
        StringBuilder first = new StringBuilder();
        LinkedHashSet<DateTimePatternGenerator.VariableField> firstFields = new LinkedHashSet<DateTimePatternGenerator.VariableField>();
        StringBuilder second = new StringBuilder();
        LinkedHashSet<DateTimePatternGenerator.VariableField> secondFields = new LinkedHashSet<DateTimePatternGenerator.VariableField>();
        String sep = null;
        boolean doFirst = true;
        String literal = null;
        for (Object item : formatParser.getItems()) {
            if (item instanceof DateTimePatternGenerator.VariableField) {
                DateTimePatternGenerator.VariableField vField = (DateTimePatternGenerator.VariableField)item;
                int variableField = vField.getType();
                if (!variableFields.get(variableField)) {
                    variableFields.set(variableField);
                } else {
                    doFirst = false;
                    if (literal == null) {
                        throw new IllegalArgumentException("Missing literal between first and second formats in \u00ab" + pattern + "\u00bb");
                    }
                    sep = literal;
                    literal = null;
                }
                if (doFirst) {
                    if (literal != null) {
                        first.append(literal);
                    }
                    first.append(item);
                    firstFields.add(vField);
                } else {
                    if (literal != null) {
                        second.append(literal);
                    }
                    second.append(item);
                    secondFields.add(vField);
                }
                literal = null;
                continue;
            }
            literal = (String)formatParser.quoteLiteral((String)item);
        }
        if (second.length() == 0) {
            throw new IllegalArgumentException("Interval patterns must have two parts, with a separator between: \u00ab" + pattern + "\u00bb");
        }
        if (literal != null) {
            second.append(literal);
        }
        return new CldrIntervalFormat(calendar, first.toString(), firstFields, sep, second.toString(), secondFields);
    }

    private static DateTimePatternGenerator.FormatParser formatParser(String pattern) {
        DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
        if (formatParser == null || pattern == null) {
            throw new IllegalArgumentException("Can't parse: \u00ab" + pattern + "\u00bb");
        }
        return formatParser.set(pattern);
    }

    public static String removeMissingFieldsFromSkeleton(String skeleton, Set<DateTimePatternGenerator.VariableField> firstFields) {
        DateTimePatternGenerator.FormatParser formatParser = CldrIntervalFormat.formatParser(skeleton);
        StringBuilder result = new StringBuilder();
        for (Object item : formatParser.getItems()) {
            DateTimePatternGenerator.VariableField vField = (DateTimePatternGenerator.VariableField)item;
            if (!CldrIntervalFormat.hasType(firstFields, vField.getType())) continue;
            result.append(vField.toString());
        }
        return result.toString();
    }

    private static boolean hasType(Set<DateTimePatternGenerator.VariableField> firstFields2, int type) {
        return firstFields2.stream().anyMatch(x -> x.getType() == type);
    }
}

