/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.TimeZone;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.TransliteratorUtilities;

public class CldrUtility {
    public static final String CODE_SLUG = "CLDR-Code";
    public static final String GIT_COMMIT_SUFFIX = "-Git-Commit";
    public static final String HOME_KEY = "CLDRHOME";
    public static final String DIR_KEY = "CLDR_DIR";
    public static final String MAIN_KEY = "CLDR_MAIN";
    public static final boolean DEBUG_MISSING_DIRECTORIES = false;
    public static final boolean BETA = false;
    public static final String LINE_SEPARATOR = "\n";
    public static final Pattern SEMI_SPLIT = PatternCache.get("\\s*;\\s*");
    private static final boolean HANDLEFILE_SHOW_SKIP = false;
    public static final String NO_INHERITANCE_MARKER = new String(new char[]{'\u2205', '\u2205', '\u2205'});
    public static final String INHERITANCE_MARKER = new String(new char[]{'\u2191', '\u2191', '\u2191'});
    public static final UnicodeSet DIGITS = new UnicodeSet("[0-9]").freeze();
    public static final String ANALYTICS = Chart.AnalyticsID.CLDR.getScript();
    public static final List<String> MINIMUM_LANGUAGES = Arrays.asList("ar", "en", "de", "fr", "hi", "it", "es", "pt", "ru", "zh", "ja");
    public static final List<String> MINIMUM_TERRITORIES = Arrays.asList("US", "GB", "DE", "FR", "IT", "JP", "CN", "IN", "RU", "BR");
    private static final Set<Object> KNOWN_IMMUTABLES = new HashSet<Class>(Arrays.asList(String.class));
    private static final Transliterator DEFAULT_REGEX_ESCAPER = Transliterator.createFromRules("foo", "([ \\- \\\\ \\[ \\] ]) > '\\' $1 ; ([[:control:][[:z:]&[:ascii:]]]) > &hex($1);", 0);
    public static final String LICENSE = "LICENSE";
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'GMT'");
    private static DateFormat DATE_ONLY = new SimpleDateFormat("yyyy-MM-dd");

    public static String getPath(String fileOrDir, String filename) {
        if (fileOrDir == null) {
            return null;
        }
        Path path = Paths.get(fileOrDir, new String[0]);
        if (filename != null) {
            path = path.resolve(filename);
        }
        return PathUtilities.getNormalizedPathString(path) + File.separatorChar;
    }

    public static String getPath(String path) {
        return CldrUtility.getPath(path, null);
    }

    /*
     * Exception decompiling
     */
    public static boolean areFileIdentical(String file1, String file2, String[] failureLines, LineComparer lineComparer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] splitArray(String source, char separator) {
        return CldrUtility.splitArray(source, separator, false);
    }

    public static String[] splitArray(String source, char separator, boolean trim) {
        List<String> piecesList = CldrUtility.splitList(source, separator, trim);
        String[] pieces = new String[piecesList.size()];
        piecesList.toArray(pieces);
        return pieces;
    }

    public static String[] splitCommaSeparated(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder item = new StringBuilder();
        boolean inQuote = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            switch (ch) {
                case '\"': {
                    boolean bl = inQuote = !inQuote;
                    if (!inQuote || item.length() == 0) continue block4;
                    item.append('\"');
                    inQuote = true;
                    continue block4;
                }
                case ',': {
                    if (!inQuote) {
                        result.add(item.toString());
                        item.setLength(0);
                        continue block4;
                    }
                    item.append(ch);
                    continue block4;
                }
                default: {
                    item.append(ch);
                }
            }
        }
        result.add(item.toString());
        return result.toArray(new String[result.size()]);
    }

    public static List<String> splitList(String source, char separator) {
        return CldrUtility.splitList(source, separator, false, null);
    }

    public static List<String> splitList(String source, char separator, boolean trim) {
        return CldrUtility.splitList(source, separator, trim, null);
    }

    public static List<String> splitList(String source, char separator, boolean trim, List<String> output) {
        return CldrUtility.splitList(source, Character.toString(separator), trim, output);
    }

    public static List<String> splitList(String source, String separator) {
        return CldrUtility.splitList(source, separator, false, null);
    }

    public static List<String> splitList(String source, String separator, boolean trim) {
        return CldrUtility.splitList(source, separator, trim, null);
    }

    public static List<String> splitList(String source, String separator, boolean trim, List<String> output) {
        int npos;
        if (output == null) {
            output = new ArrayList<String>();
        }
        if (source.length() == 0) {
            return output;
        }
        int pos = 0;
        do {
            if ((npos = source.indexOf(separator, pos)) < 0) {
                npos = source.length();
            }
            String piece = source.substring(pos, npos);
            if (trim) {
                piece = piece.trim();
            }
            output.add(piece);
        } while ((pos = npos + 1) < source.length());
        return output;
    }

    public static <T> T protectCollection(T source) {
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : sourceMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                builder.put(CldrUtility.protectCollection(key), CldrUtility.protectCollection(value));
            }
            return (T)builder.build();
        }
        if (source instanceof Multimap) {
            Multimap sourceMap = (Multimap)source;
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry entry : sourceMap.entries()) {
                builder.put(CldrUtility.protectCollection(entry.getKey()), CldrUtility.protectCollection(entry.getValue()));
            }
            return (T)builder.build();
        }
        if (source instanceof Collection) {
            Collection sourceCollection = (Collection)source;
            Collection resultCollection = CldrUtility.clone(sourceCollection);
            if (resultCollection == null) {
                return (T)sourceCollection;
            }
            resultCollection.clear();
            for (Object item : sourceCollection) {
                resultCollection.add(CldrUtility.protectCollection(item));
            }
            return (T)(sourceCollection instanceof List ? Collections.unmodifiableList((List)sourceCollection) : (sourceCollection instanceof SortedSet ? Collections.unmodifiableSortedSet((SortedSet)sourceCollection) : (sourceCollection instanceof Set ? Collections.unmodifiableSet((Set)sourceCollection) : Collections.unmodifiableCollection(sourceCollection))));
        }
        if (source instanceof Freezable) {
            Freezable freezableSource = (Freezable)source;
            return freezableSource.freeze();
        }
        return source;
    }

    public static <T> T protectCollectionX(T source) {
        if (CldrUtility.isImmutable(source)) {
            return source;
        }
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            LinkedHashMap tempMap = new LinkedHashMap(sourceMap);
            sourceMap.clear();
            for (Object key : tempMap.keySet()) {
                sourceMap.put(CldrUtility.protectCollection(key), CldrUtility.protectCollectionX(tempMap.get(key)));
            }
            return (T)(sourceMap instanceof SortedMap ? Collections.unmodifiableSortedMap((SortedMap)sourceMap) : Collections.unmodifiableMap(sourceMap));
        }
        if (source instanceof Collection) {
            Collection sourceCollection = (Collection)source;
            LinkedHashSet tempSet = new LinkedHashSet(sourceCollection);
            sourceCollection.clear();
            for (Object item : tempSet) {
                sourceCollection.add(CldrUtility.protectCollectionX(item));
            }
            return (T)(sourceCollection instanceof List ? Collections.unmodifiableList((List)sourceCollection) : (sourceCollection instanceof SortedSet ? Collections.unmodifiableSortedSet((SortedSet)sourceCollection) : (sourceCollection instanceof Set ? Collections.unmodifiableSet((Set)sourceCollection) : Collections.unmodifiableCollection(sourceCollection))));
        }
        if (source instanceof Freezable) {
            Freezable freezableSource = (Freezable)source;
            return freezableSource.freeze();
        }
        throw new IllegalArgumentException("Can\u2019t protect: " + source.getClass().toString());
    }

    public static boolean isImmutable(Object source) {
        return source == null || source instanceof Enum || source instanceof Number || KNOWN_IMMUTABLES.contains(source.getClass());
    }

    private static <T> T clone(T source) {
        Class<?> class1 = source.getClass();
        try {
            Method declaredMethod = class1.getDeclaredMethod("clone", new Class[]{null});
            return (T)declaredMethod.invoke(source, new Object[]{null});
        }
        catch (Exception declaredMethod) {
            try {
                Constructor<?> declaredMethod2 = class1.getConstructor(new Class[]{null});
                return (T)declaredMethod2.newInstance(new Object[]{null});
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static String joinWithSeparation(String a, String separator, String b) {
        if (a.length() == 0) {
            return b;
        }
        if (b.length() == 0) {
            return a;
        }
        return a + separator + b;
    }

    public static Map<String, String> joinWithSeparation(Map<String, String> a, String separator, Map<String, String> b) {
        for (String key : b.keySet()) {
            String bvalue = b.get(key);
            String avalue = a.get(key);
            if (avalue != null) {
                if (avalue.trim().equals(bvalue.trim())) continue;
                bvalue = CldrUtility.joinWithSeparation(avalue, separator, bvalue);
            }
            a.put(key, bvalue);
        }
        return a;
    }

    public static <T> String join(Collection<T> c, String separator) {
        return CldrUtility.join(c, separator, null);
    }

    public static String join(Object[] c, String separator) {
        return CldrUtility.join(c, separator, null);
    }

    public static <T> String join(Collection<T> c, String separator, Transform<T, String> transform) {
        StringBuffer output = new StringBuffer();
        boolean isFirst = true;
        for (T item : c) {
            if (isFirst) {
                isFirst = false;
            } else {
                output.append(separator);
            }
            output.append((Object)(transform != null ? transform.transform(item) : item));
        }
        return output.toString();
    }

    public static <T> String join(T[] c, String separator, Transform<T, String> transform) {
        return CldrUtility.join(Arrays.asList(c), separator, transform);
    }

    public static <K, V> Map<K, V> asMap(Object[][] source, Map<K, V> target, boolean reverse) {
        int from = 0;
        int to = 1;
        if (reverse) {
            from = 1;
            to = 0;
        }
        for (int i = 0; i < source.length; ++i) {
            if (source[i].length != 2) {
                throw new IllegalArgumentException("Source must be array of pairs of strings: " + String.valueOf(Arrays.asList(source[i])));
            }
            target.put(source[i][from], source[i][to]);
        }
        return target;
    }

    public static <K, V> Map<K, V> asMap(Object[][] source) {
        return CldrUtility.asMap(source, new HashMap(), false);
    }

    public static String getCanonicalName(String file) {
        try {
            return PathUtilities.getNormalizedPathString(file, new String[0]);
        }
        catch (Exception e) {
            return file;
        }
    }

    public static String toRegex(UnicodeSet source) {
        return CldrUtility.toRegex(source, null, false);
    }

    public static String toRegex(UnicodeSet source, Transliterator escaper, boolean onlyBmp) {
        if (escaper == null) {
            escaper = DEFAULT_REGEX_ESCAPER;
        }
        UnicodeSetIterator it = new UnicodeSetIterator(source);
        if (source.size() == 0) {
            return "";
        }
        if (source.size() == 1) {
            it.next();
            return escaper.transliterate(it.getString());
        }
        StringBuilder base = new StringBuilder("[");
        StringBuilder alternates = new StringBuilder();
        TreeMap<UnicodeSet, UnicodeSet> lastToFirst = new TreeMap<UnicodeSet, UnicodeSet>(new UnicodeSetComparator());
        int alternateCount = 0;
        while (it.nextRange()) {
            if (it.codepoint == -1) {
                ++alternateCount;
                alternates.append('|').append(escaper.transliterate(it.string));
                continue;
            }
            if (!onlyBmp || it.codepointEnd <= 65535) {
                CldrUtility.addBmpRange(it.codepoint, it.codepointEnd, escaper, base);
                continue;
            }
            if (it.codepoint <= 65535) {
                CldrUtility.addBmpRange(it.codepoint, 65535, escaper, base);
                it.codepoint = 65536;
            }
            char leadX = UTF16.getLeadSurrogate(it.codepoint);
            char trailX = UTF16.getTrailSurrogate(it.codepoint);
            char leadY = UTF16.getLeadSurrogate(it.codepointEnd);
            char trailY = UTF16.getTrailSurrogate(it.codepointEnd);
            if (leadX == leadY) {
                CldrUtility.addSupplementalRange(leadX, leadX, trailX, trailY, escaper, lastToFirst);
                continue;
            }
            CldrUtility.addSupplementalRange(leadX, leadX, trailX, 57343, escaper, lastToFirst);
            if (leadX != leadY - '\u0001') {
                CldrUtility.addSupplementalRange(leadX + '\u0001', leadY - '\u0001', 56320, 57343, escaper, lastToFirst);
            }
            CldrUtility.addSupplementalRange(leadY, leadY, 56320, trailY, escaper, lastToFirst);
        }
        if (lastToFirst.size() != 0) {
            for (UnicodeSet last : lastToFirst.keySet()) {
                ++alternateCount;
                alternates.append('|').append(CldrUtility.toRegex((UnicodeSet)lastToFirst.get(last), escaper, onlyBmp)).append(CldrUtility.toRegex(last, escaper, onlyBmp));
            }
        }
        base.append("]");
        if (alternateCount == 0) {
            return base.toString();
        }
        if (base.length() > 2) {
            return "(?:" + String.valueOf(base) + "|" + alternates.substring(1) + ")";
        }
        if (alternateCount == 1) {
            return alternates.substring(1);
        }
        return "(?:" + alternates.substring(1) + ")";
    }

    private static void addSupplementalRange(int leadX, int leadY, int trailX, int trailY, Transliterator escaper, Map<UnicodeSet, UnicodeSet> lastToFirst) {
        System.out.println("\tadding: " + String.valueOf(new UnicodeSet(leadX, leadY)) + "\t" + String.valueOf(new UnicodeSet(trailX, trailY)));
        UnicodeSet last = new UnicodeSet(trailX, trailY);
        UnicodeSet first = lastToFirst.get(last);
        if (first == null) {
            first = new UnicodeSet();
            lastToFirst.put(last, first);
        }
        first.add(leadX, leadY);
    }

    private static void addBmpRange(int start, int limit, Transliterator escaper, StringBuilder base) {
        base.append(escaper.transliterate(UTF16.valueOf(start)));
        if (start != limit) {
            base.append("-").append(escaper.transliterate(UTF16.valueOf(limit)));
        }
    }

    public static void addTreeMapChain(Map coverageData, Object ... objects) {
        Map base = coverageData;
        for (int i = 0; i < objects.length - 2; ++i) {
            TreeMap nextOne = (TreeMap)base.get(objects[i]);
            if (nextOne == null) {
                nextOne = new TreeMap();
                base.put(objects[i], nextOne);
            }
            base = nextOne;
        }
        base.put(objects[objects.length - 2], objects[objects.length - 1]);
    }

    public static <S, T, SC extends Collection<S>, TC extends Collection<T>> TC transform(SC source, Transform<S, T> transform, TC target) {
        for (S sourceItem : source) {
            T targetItem = transform.transform(sourceItem);
            if (targetItem == null) continue;
            target.add(targetItem);
        }
        return target;
    }

    public static <SK, SV, TK, TV, SM extends Map<SK, SV>, TM extends Map<TK, TV>> TM transform(SM source, Transform<SK, TK> transformKey, Transform<SV, TV> transformValue, TM target) {
        for (Map.Entry<SK, SV> sourceEntry : source.entrySet()) {
            TK targetKey = transformKey.transform(sourceEntry.getKey());
            TV targetValue = transformValue.transform(sourceEntry.getValue());
            if (targetKey == null || targetValue == null) continue;
            target.put(targetKey, targetValue);
        }
        return target;
    }

    public static BufferedReader getUTF8Data(String name) {
        if (new File(name).isAbsolute()) {
            throw new IllegalArgumentException("Path must be relative to org/unicode/cldr/util/data  such as 'file.txt' or 'casing/file.txt', but got '" + name + "'.");
        }
        return FileReaders.openFile(CldrUtility.class, "data/" + name);
    }

    public static InputStream getInputStream(String name) {
        if (new File(name).isAbsolute()) {
            throw new IllegalArgumentException("Path must be relative to org/unicode/cldr/util/data  such as 'file.txt' or 'casing/file.txt', but got '" + name + "'.");
        }
        return CldrUtility.getInputStream(CldrUtility.class, "data/" + name);
    }

    public static InputStream getInputStream(Class<?> callingClass, String relativePath) {
        InputStream is = callingClass.getResourceAsStream(relativePath);
        return InputStreamFactory.buffer(is);
    }

    public static void putAllTransposed(Map<Object, Set<Object>> source_key_valueSet, Map<Object, Object> output_value_key) {
        for (Object key : source_key_valueSet.keySet()) {
            Set<Object> values = source_key_valueSet.get(key);
            for (Object value : values) {
                output_value_key.put(value, key);
            }
        }
    }

    public static int countInstances(String source, String substring) {
        int count = 0;
        int pos = 0;
        while ((pos = source.indexOf(substring, pos) + 1) > 0) {
            ++count;
        }
        return count;
    }

    public static void registerTransliteratorFromFile(String id, String dir, String filename) {
        CldrUtility.registerTransliteratorFromFile(id, dir, filename, 0, true);
        CldrUtility.registerTransliteratorFromFile(id, dir, filename, 1, true);
    }

    public static void registerTransliteratorFromFile(String id, String dir, String filename, int direction, boolean reverseID) {
        Transliterator t2;
        Object rid;
        if (filename == null) {
            filename = ((String)id).replace('-', '_');
            filename = ((String)filename).replace('/', '_');
            filename = (String)filename + ".txt";
        }
        String rules = CldrUtility.getText(dir, (String)filename);
        int pos = ((String)id).indexOf(45);
        if (pos < 0) {
            rid = (String)id + "-Any";
            id = "Any-" + (String)id;
        } else {
            rid = ((String)id).substring(pos + 1) + "-" + ((String)id).substring(0, pos);
        }
        if (!reverseID) {
            rid = id;
        }
        if (direction == 0) {
            Transliterator.unregister((String)id);
            t2 = Transliterator.createFromRules((String)id, rules, 0);
            Transliterator.registerInstance(t2);
            System.out.println("Registered new Transliterator: " + (String)id);
        }
        if (direction == 1) {
            Transliterator.unregister((String)rid);
            t2 = Transliterator.createFromRules((String)rid, rules, 1);
            Transliterator.registerInstance(t2);
            System.out.println("Registered new Transliterator: " + (String)rid);
        }
    }

    public static String getText(String dir, String filename) {
        try {
            String line;
            BufferedReader br = FileUtilities.openUTF8Reader(dir, filename);
            StringBuffer buffer = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                if (line.startsWith("//")) continue;
                buffer.append(line).append(LINE_SEPARATOR);
            }
            br.close();
            String rules = buffer.toString();
            return rules;
        }
        catch (IOException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't open " + dir + ", " + filename).initCause(e);
        }
    }

    public static void callMethod(String methodNames, Class<?> cls) {
        for (String methodName : methodNames.split(",")) {
            try {
                try {
                    Method method = cls.getMethod(methodName, null);
                    try {
                        method.invoke(null, (Object[])null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.out.println("No such method: " + methodName);
                    CldrUtility.showMethods(cls);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void showMethods(Class<?> cls) throws ClassNotFoundException {
        System.out.println("Possible methods of " + cls.getCanonicalName() + " are: ");
        Method[] methods = cls.getMethods();
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getGenericParameterTypes().length != 0) continue;
            String name = methods[i].getName();
            names.add(name);
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            System.out.println("\t" + (String)it.next());
        }
    }

    public static String breakLines(CharSequence input, String separator, Matcher matcher, int width) {
        StringBuffer output = new StringBuffer();
        String lastPrefix = "";
        int lastEnd = 0;
        int lastBreakPos = 0;
        matcher.reset(input);
        while (true) {
            boolean match;
            if (!(match = matcher.find())) break;
            String prefix = matcher.group(1);
            if (!prefix.equalsIgnoreCase(lastPrefix) || matcher.end() - lastBreakPos > width) {
                output.append(separator);
                lastBreakPos = lastEnd;
            } else if (lastEnd != 0) {
                output.append(' ');
            }
            output.append(input.subSequence(lastEnd, matcher.end()).toString().trim());
            lastEnd = matcher.end();
            lastPrefix = prefix;
        }
        output.append(input.subSequence(lastEnd, input.length()));
        return output.toString();
    }

    public static void showOptions(String[] args) {
        System.out.println("Arguments: " + CldrUtility.join(args, " "));
    }

    public static double roundToDecimals(double input, int places) {
        double log10 = Math.log10(input);
        double intLog10 = Math.floor(log10);
        double scale = Math.pow(10.0, intLog10 - (double)places + 1.0);
        double factored = (double)Math.round(input / scale) * scale;
        return factored;
    }

    public static String getProperty(String key, String defaultValue) {
        return CldrUtility.getProperty(key, defaultValue, defaultValue);
    }

    public static String getProperty(String key) {
        return CldrUtility.getProperty(key, null, null);
    }

    public static String getProperty(String key, String valueIfNull, String valueIfEmpty) {
        String result = CLDRConfig.getInstance().getProperty(key);
        if (result == null) {
            result = valueIfNull;
        } else if (result.length() == 0) {
            result = valueIfEmpty;
        }
        return result;
    }

    public static String hex(byte[] bytes, int start, int end, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(Utility.hex(bytes[i] & 0xFF, 2));
        }
        return result.toString();
    }

    public static boolean getProperty(String string, boolean b) {
        return CldrUtility.getProperty(string, b ? "true" : "false", "true").matches("(?i)T|TRUE");
    }

    public static String checkValidDirectory(String sourceDirectory) {
        return CldrUtility.checkValidFile(sourceDirectory, true, null);
    }

    public static String checkValidDirectory(String sourceDirectory, String correction) {
        return CldrUtility.checkValidFile(sourceDirectory, true, correction);
    }

    public static String checkValidFile(String sourceDirectory, boolean checkForDirectory, String correction) {
        File file = null;
        String normalizedPath = null;
        try {
            file = new File(sourceDirectory);
            normalizedPath = PathUtilities.getNormalizedPathString(file) + File.separatorChar;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || normalizedPath == null || checkForDirectory && !file.isDirectory()) {
            throw new RuntimeException("Directory not found: " + sourceDirectory + (String)(normalizedPath == null ? "" : " => " + normalizedPath) + (String)(correction == null ? "" : LINE_SEPARATOR + correction));
        }
        return normalizedPath;
    }

    public static void copyUpTo(BufferedReader oldFile, Pattern readUntilPattern, PrintWriter output, boolean includeMatchingLine) throws IOException {
        String line;
        Matcher readUntil;
        Matcher matcher = readUntil = readUntilPattern == null ? null : readUntilPattern.matcher("");
        while ((line = oldFile.readLine()) != null) {
            if (line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (readUntil != null && readUntil.reset(line).matches()) {
                if (!includeMatchingLine || output == null) break;
                output.println(line);
                break;
            }
            if (output == null) continue;
            output.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isoFormat(Date date) {
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return df.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isoFormatDateOnly(Date date) {
        DateFormat dateFormat = DATE_ONLY;
        synchronized (dateFormat) {
            return DATE_ONLY.format(date);
        }
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(4, 0.9f, 1);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> source) {
        ConcurrentHashMap<K, V> result = CldrUtility.newConcurrentHashMap();
        result.putAll(source);
        return result;
    }

    public static boolean equals(Object a, Object b) {
        return a == b ? true : (a == null || b == null ? false : a.equals(b));
    }

    public static String getDoubleLink(String code) {
        String anchorSafe = TransliteratorUtilities.toHTML.transliterate(code).replace(" ", "_");
        return "<a name='" + anchorSafe + "' href='#" + anchorSafe + "'>";
    }

    public static String getDoubleLinkedText(String anchor, String anchorText) {
        return CldrUtility.getDoubleLink(anchor) + TransliteratorUtilities.toHTML.transliterate(anchorText).replace("_", " ") + "</a>";
    }

    public static String getDoubleLinkedText(String anchor) {
        return CldrUtility.getDoubleLinkedText(anchor, anchor);
    }

    public static String getDoubleLinkMsg() {
        return "<a name=''{0}'' href=''#{0}''>{0}</a>";
    }

    public static String getDoubleLinkMsg2() {
        return "<a name=''{0}{1}'' href=''#{0}{1}''>{0}</a>";
    }

    public static String getCopyrightString() {
        return CldrUtility.getCopyrightString("");
    }

    public static String getCopyrightString(String linePrefix) {
        return linePrefix + CldrUtility.getCopyrightShort() + LINE_SEPARATOR + linePrefix + "For terms of use, see http://www.unicode.org/copyright.html\n" + linePrefix + "SPDX-License-Identifier: Unicode-3.0\n" + linePrefix + "CLDR data files are interpreted according to the LDML specification (http://unicode.org/reports/tr35/)";
    }

    public static String getCopyrightMarkdown() {
        return "## License\n\n" + CldrUtility.getCopyrightShort() + "\n[Terms of Use](http://www.unicode.org/copyright.html)\n\nSPDX-License-Identifier: Unicode-3.0\n";
    }

    public static String getCopyrightShort() {
        return CopyrightHelper.INSTANCE.COPYRIGHT_SHORT;
    }

    public static <K, V, M extends Map<K, V>> V get(M map, K key) {
        return map.get(key);
    }

    public static <K, C extends Collection<K>> boolean contains(C collection, K key) {
        return collection.contains(key);
    }

    public static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> classValue, Collection<String> stringValues) {
        EnumSet<E> result = EnumSet.noneOf(classValue);
        for (String s2 : stringValues) {
            result.add(Enum.valueOf(classValue, s2));
        }
        return result;
    }

    public static <K, V, M extends Map<K, V>> M putNew(M map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
        return map;
    }

    public static String[] cleanSemiFields(String line) {
        return (line = CldrUtility.cleanLine(line)).isEmpty() ? null : SEMI_SPLIT.split(line);
    }

    private static String cleanLine(String line) {
        int comment = line.indexOf("#");
        if (comment >= 0) {
            line = line.substring(0, comment);
        }
        if (line.startsWith("\ufeff")) {
            line = line.substring(1);
        }
        return line.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleFile(String filename, LineHandler handler) throws IOException {
        try (BufferedReader in = CldrUtility.getUTF8Data(filename);){
            String line = null;
            while ((line = in.readLine()) != null) {
                try {
                    if (handler.handle(line)) continue;
                }
                catch (Exception e) {
                    throw (RuntimeException)new IllegalArgumentException("Problem with line: " + line).initCause(e);
                    return;
                }
            }
        }
    }

    public static <T> T ifNull(T x, T y) {
        return x == null ? y : x;
    }

    public static <T> T ifSame(T source, T replaceIfSame, T replacement) {
        return source == replaceIfSame ? replacement : source;
    }

    public static <T> T ifEqual(T source, T replaceIfSame, T replacement) {
        return Objects.equals(source, replaceIfSame) ? replacement : source;
    }

    public static <T> Set<T> intersect(Set<T> a, Collection<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.retainAll(b);
        return result;
    }

    public static <T> Set<T> subtract(Set<T> a, Collection<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    public static boolean deepEquals(Object ... pairs) {
        int item = 0;
        while (item < pairs.length) {
            if (Objects.deepEquals(pairs[item++], pairs[item++])) continue;
            return false;
        }
        return true;
    }

    public static String[] array(Splitter splitter, String source) {
        List<String> list = splitter.splitToList(source);
        return list.toArray(new String[list.size()]);
    }

    public static String toHex(String in, boolean javaStyle) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            result.append(CldrUtility.toHex(in.charAt(i), javaStyle));
        }
        return result.toString();
    }

    public static String toHex(int j, boolean javaStyle) {
        if (j == 34) {
            return "\\\"";
        }
        if (j == 92) {
            return "\\\\";
        }
        if (32 < j && j < 127) {
            return String.valueOf((char)j);
        }
        String hexString = Integer.toHexString(j).toUpperCase();
        int gap = 4 - hexString.length();
        if (gap < 0) {
            gap = 0;
        }
        String prefix = javaStyle ? "\\u" : "U+";
        return prefix + "000".substring(0, gap) + hexString;
    }

    public static String toString(Object item) {
        if (item instanceof Object[]) {
            return CldrUtility.toString(Arrays.asList((Object[])item));
        }
        if (item instanceof Map.Entry) {
            return CldrUtility.toString(((Map.Entry)item).getKey()) + "\u2254" + CldrUtility.toString(((Map.Entry)item).getValue());
        }
        if (item instanceof Map) {
            return "{" + CldrUtility.toString(((Map)item).entrySet()) + "}";
        }
        if (item instanceof Collection) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object subitem : (Collection)item) {
                result.add(CldrUtility.toString(subitem));
            }
            return ((Object)result).toString();
        }
        return item.toString();
    }

    public static String getCldrBaseDirHash() {
        File baseDir = CLDRConfig.getInstance().getCldrBaseDirectory();
        return CldrUtility.getGitHashForDir(baseDir.toString());
    }

    public static final String getGitHashForDir(String dir) {
        String hash = CldrUtility.getGitHashDirectlyForDir(dir);
        if (hash == null) {
            hash = CldrUtility.getGitHashByRevParseForDir(dir);
        }
        if (hash == null) {
            hash = "(unknown)";
        }
        return hash;
    }

    private static String getGitHashDirectlyForDir(String dir) {
        File gitDir = new File(dir, ".git");
        File headfile = new File(gitDir, "HEAD");
        if (headfile.canRead()) {
            try {
                String s2 = Files.readString(headfile.toPath());
                if (s2 != null && !s2.isBlank()) {
                    if ((s2 = s2.trim()).startsWith("ref: ")) {
                        s2 = s2.substring(5);
                        Path refPath = gitDir.toPath().resolve(s2);
                        if (refPath.startsWith(gitDir.toPath())) {
                            s2 = Files.readString(refPath);
                            if (s2 != null && !s2.isBlank()) {
                                return s2.trim();
                            }
                        } else {
                            System.err.println("Ignoring strange git refPath " + String.valueOf(refPath));
                        }
                    }
                    return s2.trim();
                }
            }
            catch (IOException e) {
                System.err.println(String.valueOf(e) + ": readString failed for " + String.valueOf(headfile));
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getGitHashByRevParseForDir(String dir) {
        String string;
        CharSequence[] GIT_HASH_COMMANDS = new String[]{"git", "rev-parse", "HEAD"};
        if (dir == null) {
            return null;
        }
        File f = new File(dir);
        if (!f.isDirectory()) {
            return null;
        }
        Process p = Runtime.getRuntime().exec((String[])GIT_HASH_COMMANDS, null, f);
        if (!p.waitFor(15L, TimeUnit.SECONDS)) {
            System.err.println("Git query " + String.join((CharSequence)" ", GIT_HASH_COMMANDS) + " timed out");
            p.destroyForcibly();
            return null;
        }
        if (p.exitValue() != 0) {
            System.err.println("Error return : " + p.exitValue() + " from " + String.join((CharSequence)" ", GIT_HASH_COMMANDS));
            try (BufferedReader is = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String str = is.readLine();
                if (str.length() == 0) {
                    throw new Exception("git returned empty");
                }
                System.err.println("git: " + str);
            }
            return null;
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String str = is.readLine();
            if (str == null || str.length() == 0) {
                throw new Exception("git returned empty");
            }
            string = str;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t2) {
                System.err.println("While trying to get 'git' hash for " + dir + " : " + t2.getMessage());
                t2.printStackTrace();
                return null;
            }
        }
        is.close();
        return string;
    }

    public static UnicodeSet flatten(UnicodeSet value) {
        ImmutableSet<String> strings = ImmutableSet.copyOf(value.strings());
        HashSet<String> toAdd = new HashSet<String>();
        if (value.isFrozen()) {
            value = new UnicodeSet(value);
        }
        for (String s2 : strings) {
            value.remove(s2);
            if (!value.containsAll(s2)) {
                toAdd.add(s2);
            }
            value.add(s2);
        }
        value.removeAll(strings);
        value.addAll((Iterable<?>)toAdd);
        return value;
    }

    public static <T, C extends Collection<T>> C removeAll(C fromCollection, Set<String> toRemove) {
        Iterator<T> it = fromCollection.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!toRemove.contains(item)) continue;
            it.remove();
        }
        return fromCollection;
    }

    public static void tryCurrentDirAsCldrDir() {
        try {
            if (System.getProperty(DIR_KEY) == null && new File("./common/main/root.xml").exists()) {
                System.err.println("Note: CLDR_DIR was unset but you seem to be in a CLDR directory. Setting -DCLDR_DIR=.");
                System.setProperty(DIR_KEY, ".");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_ONLY.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static final class CopyrightHelper {
        public static final CopyrightHelper INSTANCE = new CopyrightHelper();
        public final String COPYRIGHT_SHORT = "Copyright \u00a9 1991-" + Calendar.getInstance().get(1) + " Unicode, Inc.";

        private CopyrightHelper() {
        }
    }

    public static final class PairComparator<K extends Comparable<K>, V extends Comparable<V>>
    implements Comparator<Pair<K, V>> {
        private Comparator<K> comp1;
        private Comparator<V> comp2;

        public PairComparator(Comparator<K> comp1, Comparator<V> comp2) {
            this.comp1 = comp1;
            this.comp2 = comp2;
        }

        @Override
        public int compare(Pair<K, V> o1, Pair<K, V> o2) {
            int diff;
            K o1First = o1.getFirst();
            K o2First = o2.getFirst();
            int n = o1First == null ? (o2First == null ? 0 : -1) : (o2First == null ? 1 : (diff = this.comp1 == null ? o1First.compareTo(o2First) : this.comp1.compare(o1First, o2First)));
            if (diff != 0) {
                return diff;
            }
            V o1Second = o1.getSecond();
            V o2Second = o2.getSecond();
            return o1Second == null ? (o2Second == null ? 0 : -1) : (o2Second == null ? 1 : (this.comp2 == null ? o1Second.compareTo(o2Second) : this.comp2.compare(o1Second, o2Second)));
        }
    }

    public static class MatcherFilter<T>
    extends Filter<T> {
        private Matcher matcher;

        public MatcherFilter(String pattern) {
            this.matcher = PatternCache.get(pattern).matcher("");
        }

        public MatcherFilter(Matcher matcher) {
            this.matcher = matcher;
        }

        public MatcherFilter<T> set(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public MatcherFilter<T> set(String pattern) {
            this.matcher = PatternCache.get(pattern).matcher("");
            return this;
        }

        @Override
        public boolean contains(T o) {
            return this.matcher.reset(o.toString()).matches();
        }
    }

    public static abstract class Filter<T> {
        public abstract boolean contains(T var1);

        public <U extends Collection<T>> U retainAll(U c) {
            Iterator<T> it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                it.remove();
            }
            return c;
        }

        public <U extends Collection<T>> U extractMatches(U c, U target) {
            for (T item : c) {
                if (!this.contains(item)) continue;
                target.add(item);
            }
            return target;
        }

        public <U extends Collection<T>> U removeAll(U c) {
            Iterator<T> it = c.iterator();
            while (it.hasNext()) {
                if (!this.contains(it.next())) continue;
                it.remove();
            }
            return c;
        }

        public <U extends Collection<T>> U extractNonMatches(U c, U target) {
            for (T item : c) {
                if (this.contains(item)) continue;
                target.add(item);
            }
            return target;
        }
    }

    public static abstract class Apply<T> {
        public abstract void apply(T var1);

        public <U extends Collection<T>> void applyTo(U collection) {
            for (T item : collection) {
                this.apply(item);
            }
        }
    }

    public static abstract class CollectionTransform<S, T>
    implements Transform<S, T> {
        @Override
        public abstract T transform(S var1);

        public Collection<T> transform(Collection<S> input, Collection<T> output) {
            return CldrUtility.transform(input, this, output);
        }

        @Override
        public Collection<T> transform(Collection<S> input) {
            return this.transform(input, new ArrayList());
        }
    }

    public static class ComparableComparator<T extends Comparable<T>>
    implements Comparator<T> {
        @Override
        public int compare(T arg0, T arg1) {
            return Utility.checkCompare(arg0, arg1);
        }
    }

    public static class CollectionComparator<T extends Comparable<T>>
    implements Comparator<Collection<T>> {
        @Override
        public int compare(Collection<T> o1, Collection<T> o2) {
            return UnicodeSet.compare(o1, o2, UnicodeSet.ComparisonStyle.SHORTER_FIRST);
        }
    }

    public static class UnicodeSetComparator
    implements Comparator<UnicodeSet> {
        @Override
        public int compare(UnicodeSet o1, UnicodeSet o2) {
            return o1.compareTo(o2);
        }
    }

    public static final class StringIterator {
        String string;
        int position = 0;

        char next() {
            char ch;
            do {
                if (this.position < this.string.length()) continue;
                return '\uffff';
            } while ((ch = this.string.charAt(this.position++)) == ' ' || ch == '\t');
            return ch;
        }

        StringIterator reset() {
            this.position = 0;
            return this;
        }

        StringIterator set(String string) {
            this.string = string;
            this.position = 0;
            return this;
        }

        boolean matches(StringIterator other) {
            char c1;
            do {
                char c2;
                if ((c1 = this.next()) == (c2 = other.next())) continue;
                return false;
            } while (c1 != '\uffff');
            return true;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static class SimpleLineComparator
    implements LineComparer {
        public static final int TRIM = 1;
        public static final int SKIP_SPACES = 2;
        public static final int SKIP_EMPTY = 4;
        public static final int SKIP_CVS_TAGS = 8;
        StringIterator si1 = new StringIterator();
        StringIterator si2 = new StringIterator();
        int flags;
        private String[] CVS_TAGS = new String[]{"Revision", "Date"};

        public SimpleLineComparator(int flags) {
            this.flags = flags;
        }

        @Override
        public int compare(String line1, String line2) {
            int skipper = 0;
            if (line1 == null) {
                skipper = 1;
            } else {
                if ((this.flags & 1) != 0) {
                    line1 = line1.trim();
                }
                if ((this.flags & 4) != 0 && line1.length() == 0) {
                    skipper = 1;
                }
            }
            if (line2 == null) {
                skipper = 2;
            } else {
                if ((this.flags & 1) != 0) {
                    line2 = line2.trim();
                }
                if ((this.flags & 4) != 0 && line2.length() == 0) {
                    skipper += 2;
                }
            }
            if (skipper != 0) {
                if (skipper == 3) {
                    return 0;
                }
                return skipper;
            }
            if (line1 == null) {
                if (line2 == null) {
                    return 0;
                }
                return -1;
            }
            if (line2 == null) {
                return -1;
            }
            if (line1.equals(line2)) {
                return 0;
            }
            if ((this.flags & 8) != 0 && (line1.indexOf(36) >= 0 && line2.indexOf(36) >= 0 ? (line1 = this.stripTags(line1)).equals(line2 = this.stripTags(line2)) : line1.startsWith("<!DOCTYPE ldml SYSTEM \"../../common/dtd/") && line2.startsWith("<!DOCTYPE ldml SYSTEM \"../../common/dtd/"))) {
                return 0;
            }
            if ((this.flags & 2) != 0 && this.si1.set(line1).matches(this.si2.set(line2))) {
                return 0;
            }
            return -1;
        }

        private String stripTags(String line) {
            int endpos;
            int pos = ((String)line).indexOf(36);
            if (pos < 0) {
                return line;
            }
            if ((endpos = ((String)line).indexOf(36, ++pos)) < 0) {
                return line;
            }
            for (int i = 0; i < this.CVS_TAGS.length; ++i) {
                if (!((String)line).startsWith(this.CVS_TAGS[i], pos)) continue;
                line = ((String)line).substring(0, pos + this.CVS_TAGS[i].length()) + ((String)line).substring(endpos);
            }
            return line;
        }
    }

    public static interface LineComparer {
        public static final int LINES_DIFFERENT = -1;
        public static final int LINES_SAME = 0;
        public static final int SKIP_FIRST = 1;
        public static final int SKIP_SECOND = 2;

        public int compare(String var1, String var2);
    }

    public static interface LineHandler {
        public boolean handle(String var1) throws Exception;
    }

    public static class VariableReplacer {
        private Map<String, String> m = new TreeMap(Collections.reverseOrder());

        public VariableReplacer add(String variable, String value) {
            this.m.put(variable, value);
            return this;
        }

        public String replace(String source) {
            String oldSource;
            do {
                oldSource = source;
                for (String variable : this.m.keySet()) {
                    String value = this.m.get(variable);
                    source = this.replaceAll(source, variable, value);
                }
            } while (!source.equals(oldSource));
            return source;
        }

        public String replaceAll(String source, String key, String value) {
            int pos;
            while ((pos = ((String)source).indexOf(key)) >= 0) {
                source = ((String)source).substring(0, pos) + value + ((String)source).substring(pos + key.length());
            }
            return source;
        }
    }
}

