/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class LocalePathValueListMatcher {
    private static final Splitter SPLIT_SEMI_COLON = Splitter.on(';').trimResults();
    final List<LocalePathValueMatcher> matchData;

    public LocalePathValueListMatcher(List<LocalePathValueMatcher> _matchData) {
        this.matchData = ImmutableList.copyOf(_matchData);
    }

    public static LocalePathValueListMatcher load(Path path) {
        try {
            return LocalePathValueListMatcher.load(Files.lines(path));
        }
        catch (IOException ex) {
            throw new ICUUncheckedIOException(ex);
        }
    }

    public static LocalePathValueListMatcher load(Stream<String> lines) {
        ArrayList<LocalePathValueMatcher> _matchData = new ArrayList<LocalePathValueMatcher>();
        lines.forEach(line -> LocalePathValueListMatcher.load(line, _matchData));
        return new LocalePathValueListMatcher(_matchData);
    }

    public boolean lookingAt(String locale, String path, String value) {
        for (LocalePathValueMatcher lpv : this.matchData) {
            if (!lpv.lookingAt(locale, path, value)) continue;
            return true;
        }
        return false;
    }

    public boolean lookingAt(String locale) {
        for (LocalePathValueMatcher lpv : this.matchData) {
            if (!lpv.lookingAt(locale)) continue;
            return true;
        }
        return false;
    }

    private static void load(String line, List<LocalePathValueMatcher> _matchData) {
        if ((line = line.trim()).startsWith("#") || line.isEmpty()) {
            return;
        }
        List<String> lineList = SPLIT_SEMI_COLON.splitToList(line);
        if (lineList.size() < 2) {
            throw new IllegalArgumentException("Match lines must have at least locale ; path: \u00ab" + line + "\u00bb");
        }
        if (lineList.size() > 3) {
            throw new IllegalArgumentException("Match lines must have a maximum of 3 fields (locale; path; value): \u00ab" + line + "\u00bb");
        }
        _matchData.add(new LocalePathValueMatcher(lineList));
    }

    public static class LocalePathValueMatcher {
        final Pattern localePattern;
        final Pattern pathPattern;
        final Pattern valuePattern;

        public LocalePathValueMatcher(List<String> parts) {
            this.localePattern = parts.size() < 1 || parts.get(0).isEmpty() ? null : Pattern.compile(parts.get(0));
            this.pathPattern = parts.size() < 2 || parts.get(1).isEmpty() ? null : Pattern.compile(parts.get(1).replace("[@", "\\[@"));
            this.valuePattern = parts.size() < 3 || parts.get(1).isEmpty() ? null : Pattern.compile(parts.get(2));
        }

        public boolean lookingAt(String locale, String path, String value) {
            return !(this.localePattern != null && !this.localePattern.matcher(locale).lookingAt() || this.pathPattern != null && !this.pathPattern.matcher(path).lookingAt() || this.valuePattern != null && !this.valuePattern.matcher(value).lookingAt());
        }

        public boolean lookingAt(String locale) {
            return this.localePattern == null || this.localePattern.matcher(locale).lookingAt();
        }

        public String toString() {
            return String.format("%s\t;\t%s\t%;\ts", this.localePattern, this.pathPattern, this.valuePattern);
        }
    }
}

