/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.text.StringCharacterIterator;

public class MemoryHelper {
    public static synchronized long availableMemory(String callerId, boolean verbose) {
        Runtime r = Runtime.getRuntime();
        long freeMem = r.freeMemory();
        long maxMem = r.maxMemory();
        long totalMem = r.totalMemory();
        if (freeMem > totalMem || totalMem > maxMem) {
            MemoryHelper.log(callerId, "Values returned by Runtime violate assumptions!");
            verbose = true;
        }
        long availMem = freeMem + maxMem - totalMem;
        if (verbose) {
            MemoryHelper.log(callerId, "Available memory: " + MemoryHelper.humanReadableByteCountSI(availMem) + "; free: " + MemoryHelper.humanReadableByteCountSI(freeMem) + "; max: " + MemoryHelper.humanReadableByteCountSI(maxMem) + "; total: " + MemoryHelper.humanReadableByteCountSI(totalMem));
        }
        return availMem;
    }

    private static void log(String callerId, String message) {
        System.out.println("MemoryHelper[" + callerId + "]: " + message);
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }
}

