/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.HashSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XMLSource;

public class RecordingCLDRFile
extends CLDRFile {
    private final HashSet<String> recordedPaths = new HashSet();
    private boolean recordingIsEnabled = false;

    public RecordingCLDRFile(XMLSource dataSource) {
        super(dataSource);
    }

    public RecordingCLDRFile(XMLSource dataSource, XMLSource ... resolvingParents) {
        super(dataSource, resolvingParents);
    }

    public void enableRecording() {
        this.recordingIsEnabled = true;
    }

    public void disableRecording() {
        this.recordingIsEnabled = false;
    }

    public void clearRecordedPaths() {
        this.recordedPaths.clear();
    }

    public HashSet<String> getRecordedPaths() {
        return this.recordedPaths;
    }

    @Override
    public String getStringValue(String xpath) {
        this.recordPath(xpath);
        return super.getStringValue(xpath);
    }

    @Override
    public String getWinningValue(String xpath) {
        this.recordPath(xpath);
        return super.getWinningValue(xpath);
    }

    @Override
    public String getConstructedValue(String xpath) {
        this.recordPath(xpath);
        return super.getConstructedValue(xpath);
    }

    private void recordPath(String xpath) {
        if (this.recordingIsEnabled) {
            this.recordedPaths.add(xpath);
        }
    }
}

