/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.XMLFileReader;

public class VoterInfoList {
    private Map<Integer, VoteResolver.VoterInfo> voterToInfo;
    private Map<String, Map<Organization, VoteResolver.Level>> localeToOrganizationToMaxVote;

    public VoterInfoList() {
        this.clearVoterToInfo();
    }

    synchronized Map<Integer, VoteResolver.VoterInfo> getVoterToInfo() {
        return this.voterToInfo;
    }

    VoterInfoList clearVoterToInfo() {
        this.setVoterToInfo(Collections.emptyMap());
        return this;
    }

    public VoteResolver.VoterInfo getInfoForVoter(int voter) {
        return this.getVoterToInfo().get(voter);
    }

    public VoterInfoList setVoterToInfo(Map<Integer, VoteResolver.VoterInfo> newVoterToInfo) {
        this.computeMaxVotesAndSet(newVoterToInfo);
        return this;
    }

    public VoterInfoList setVoterToInfo(String fileName) {
        MyHandler myHandler = new MyHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        return this.setVoterToInfo(myHandler.testVoterToInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeMaxVotesAndSet(Map<Integer, VoteResolver.VoterInfo> newVoterToInfo) {
        TreeMap<String, Map<Organization, VoteResolver.Level>> newLocaleToOrganizationToMaxVote = new TreeMap<String, Map<Organization, VoteResolver.Level>>();
        Object object = newVoterToInfo.keySet().iterator();
        while (object.hasNext()) {
            int voter = object.next();
            VoteResolver.VoterInfo info = newVoterToInfo.get(voter);
            if (info.getLevel() == VoteResolver.Level.tc || info.getLevel() == VoteResolver.Level.locked) continue;
            for (CLDRLocale loc : info.getLocales()) {
                VoteResolver.Level maxVote;
                String locale = loc.getBaseName();
                TreeMap<Organization, VoteResolver.Level> organizationToMaxVote = (TreeMap<Organization, VoteResolver.Level>)newLocaleToOrganizationToMaxVote.get(locale);
                if (organizationToMaxVote == null) {
                    organizationToMaxVote = new TreeMap<Organization, VoteResolver.Level>();
                    newLocaleToOrganizationToMaxVote.put(locale, organizationToMaxVote);
                }
                if ((maxVote = (VoteResolver.Level)((Object)organizationToMaxVote.get((Object)info.getOrganization()))) != null && info.getLevel().compareTo(maxVote) <= 0) continue;
                organizationToMaxVote.put(info.getOrganization(), info.getLevel());
            }
        }
        object = this;
        synchronized (object) {
            CldrUtility.protectCollection(newLocaleToOrganizationToMaxVote);
            this.localeToOrganizationToMaxVote = newLocaleToOrganizationToMaxVote;
            this.voterToInfo = Collections.unmodifiableMap(newVoterToInfo);
        }
    }

    public Map<Organization, VoteResolver.Level> getOrganizationToMaxVote(String locale) {
        Map<Organization, VoteResolver.Level> result = this.localeToOrganizationToMaxVote.get(locale = locale.split("_")[0]);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public Map<Organization, VoteResolver.Level> getOrganizationToMaxVote(Set<Integer> voters) {
        TreeMap<Organization, VoteResolver.Level> orgToMaxVoteHere = new TreeMap<Organization, VoteResolver.Level>();
        for (int voter : voters) {
            VoteResolver.Level maxVote;
            VoteResolver.VoterInfo info = this.getInfoForVoter(voter);
            if (info == null || (maxVote = (VoteResolver.Level)((Object)orgToMaxVoteHere.get((Object)info.getOrganization()))) != null && info.getLevel().compareTo(maxVote) <= 0) continue;
            orgToMaxVoteHere.put(info.getOrganization(), info.getLevel());
        }
        return orgToMaxVoteHere;
    }

    public VoteResolver.VoterInfo get(int voter) {
        return this.voterToInfo.get(voter);
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        private static final Pattern userPathMatcher = Pattern.compile("//users(?:[^/]*)/user\\[@id=\"([^\"]*)\"](?:[^/]*)/(org|name|level\\[@n=\"([^\"]*)\"]\\[@type=\"([^\"]*)\"]|locales\\[@type=\"([^\"]*)\"](?:/locale\\[@id=\"([^\"]*)\"])?)", 4);
        private static final boolean DEBUG_HANDLER = false;
        Map<Integer, VoteResolver.VoterInfo> testVoterToInfo = new TreeMap<Integer, VoteResolver.VoterInfo>();
        Matcher matcher = userPathMatcher.matcher("");

        MyHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (this.matcher.reset(path).matches()) {
                String localeIdString;
                String mainType;
                int id = Integer.parseInt(Group.userId.get(this.matcher));
                VoteResolver.VoterInfo voterInfo = this.testVoterToInfo.get(id);
                if (voterInfo == null) {
                    voterInfo = new VoteResolver.VoterInfo();
                    this.testVoterToInfo.put(id, voterInfo);
                }
                if ((mainType = Group.mainType.get(this.matcher)).equals("org")) {
                    Organization org = Organization.fromString(value);
                    voterInfo.setOrganization(org);
                    value = org.name();
                } else if (mainType.equals("name")) {
                    voterInfo.setName(value);
                } else if (mainType.startsWith("level")) {
                    String level = Group.levelType.get(this.matcher).toLowerCase();
                    voterInfo.setLevel(VoteResolver.Level.valueOf(level));
                } else if (mainType.startsWith("locale") && (localeIdString = Group.localeId.get(this.matcher)) != null) {
                    CLDRLocale locale = CLDRLocale.getInstance(localeIdString.split("_")[0]);
                    voterInfo.addLocale(locale);
                }
            } else {
                System.out.println("\tFailed match with " + path + "=" + value);
            }
        }

        static enum Group {
            all,
            userId,
            mainType,
            n,
            levelType,
            localeType,
            localeId;


            String get(Matcher matcher) {
                return matcher.group(this.ordinal());
            }
        }
    }
}

