/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unicode.cldr.util.CLDRFile;

public class XListFormatter {
    private ListFormatter listFormatter;

    public XListFormatter(CLDRFile cldrFile, ListTypeLength listTypeLength) {
        SimpleFormatter listPathFormat = SimpleFormatter.compile(listTypeLength.getPath());
        String doublePattern = cldrFile.getWinningValue(listPathFormat.format("2"));
        String startPattern = cldrFile.getWinningValue(listPathFormat.format("start"));
        String middlePattern = cldrFile.getWinningValue(listPathFormat.format("middle"));
        String endPattern = cldrFile.getWinningValue(listPathFormat.format("end"));
        this.listFormatter = new ListFormatter(doublePattern, startPattern, middlePattern, endPattern);
    }

    public String format(Object ... items) {
        return this.listFormatter.format(items);
    }

    public String format(Collection<?> items) {
        return this.listFormatter.format(items);
    }

    public String formatCodePoints(String items) {
        ArrayList<String> source = new ArrayList<String>();
        for (int sourceInt : CharSequences.codePoints(items)) {
            source.add(UTF16.valueOf(sourceInt));
        }
        return this.listFormatter.format(source);
    }

    public static enum ListTypeLength {
        AND_WIDE(""),
        AND_SHORT("[@type=\"standard-short\"]"),
        AND_NARROW("[@type=\"standard-narrow\"]"),
        OR_WIDE("[@type=\"or\"]"),
        OR_SHORT("[@type=\"or-short\"]"),
        OR_NARROW("[@type=\"or-narrow\"]"),
        UNIT_WIDE("[@type=\"unit\"]"),
        UNIT_SHORT("[@type=\"unit-short\"]"),
        UNIT_NARROW("[@type=\"unit-narrow\"]");

        public static final ListTypeLength NORMAL;
        final String typeString;
        static final Map<String, ListTypeLength> stringToEnum;

        private ListTypeLength(String typeString) {
            this.typeString = typeString;
        }

        public static ListTypeLength from(String listPatternType) {
            if (listPatternType == null) {
                return NORMAL;
            }
            return stringToEnum.get(listPatternType);
        }

        public String getPath() {
            return "//ldml/listPatterns/listPattern" + this.typeString + "/listPatternPart[@type=\"{0}\"]";
        }

        static {
            NORMAL = AND_WIDE;
            LinkedHashMap<String, ListTypeLength> _stringToEnum = new LinkedHashMap<String, ListTypeLength>();
            for (ListTypeLength value : ListTypeLength.values()) {
                if (value == NORMAL) continue;
                _stringToEnum.put(value.typeString.substring(value.typeString.indexOf(34) + 1, value.typeString.lastIndexOf(34)), value);
            }
            stringToEnum = ImmutableMap.copyOf(_stringToEnum);
        }
    }
}

