/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.message2;

import com.ibm.icu.impl.JavaTimeConverters;
import com.ibm.icu.message2.Directionality;
import com.ibm.icu.message2.FormattedPlaceholder;
import com.ibm.icu.message2.Function;
import com.ibm.icu.message2.FunctionFactory;
import com.ibm.icu.message2.OptUtils;
import com.ibm.icu.message2.PlainStringFormattedValue;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DateTimeFunctionFactory
implements FunctionFactory {
    private final String kind;
    private static Map<String, String> DATE_STYLES_TO_SKELETON = Map.ofEntries(Map.entry("weekday::long", "EEEE"), Map.entry("weekday::medium", "E"), Map.entry("weekday::short", "EEEEEE"), Map.entry("day-weekday::long", "dEEEE"), Map.entry("day-weekday::medium", "dE"), Map.entry("day-weekday::short", "dEEEEEE"), Map.entry("month-day::long", "MMMMd"), Map.entry("month-day::medium", "MMMd"), Map.entry("month-day::short", "Md"), Map.entry("month-day-weekday::long", "MMMMdEEEE"), Map.entry("month-day-weekday::medium", "MMMdE"), Map.entry("month-day-weekday::short", "MdEEEEEE"), Map.entry("year-month-day::long", "yMMMMd"), Map.entry("year-month-day::medium", "yMMMd"), Map.entry("year-month-day::short", "yMd"), Map.entry("year-month-day-weekday::long", "yMMMMdEEEE"), Map.entry("year-month-day-weekday::medium", "yMMMdE"), Map.entry("year-month-day-weekday::short", "yMdEEEEEE"));
    private static Map<String, String> TIME_STYLES_TO_SKELETON = Map.ofEntries(Map.entry("hour::", "j"), Map.entry("hour::true", "h"), Map.entry("hour::false", "H"), Map.entry("minute::", "jm"), Map.entry("minute::true", "hm"), Map.entry("minute::false", "Hm"), Map.entry("second::", "jms"), Map.entry("second::true", "hms"), Map.entry("second::false", "Hms"));
    private static final Pattern ISO_PATTERN = Pattern.compile("^(([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])){1}(T([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(\\.[0-9]{1,3})?(Z|[+-]((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?$");

    DateTimeFunctionFactory(String kind) {
        switch (kind) {
            case "date": {
                break;
            }
            case "time": {
                break;
            }
            case "datetime": {
                break;
            }
            default: {
                kind = "datetime";
            }
        }
        this.kind = kind;
    }

    @Override
    public Function create(Locale locale, Map<String, Object> fixedOptions) {
        String calendarOverride;
        locale = OptUtils.getBestLocale(fixedOptions, locale);
        Directionality dir = OptUtils.getBestDirectionality(fixedOptions, locale);
        boolean reportErrors = OptUtils.reportErrors(fixedOptions);
        Object skeleton = "";
        switch (this.kind) {
            case "date": {
                skeleton = DateTimeFunctionFactory.getDateFieldOptions(fixedOptions, "fields", "length");
                break;
            }
            case "time": {
                skeleton = DateTimeFunctionFactory.getTimeFieldOptions(fixedOptions, "precision");
                break;
            }
            default: {
                skeleton = DateTimeFunctionFactory.getDateFieldOptions(fixedOptions, "dateFields", "dateLength");
                skeleton = (String)skeleton + DateTimeFunctionFactory.getTimeFieldOptions(fixedOptions, "timePrecision");
            }
        }
        if (((String)skeleton).isEmpty()) {
            skeleton = OptUtils.getString(fixedOptions, "icu:skeleton", "");
        }
        if (((String)skeleton).isEmpty()) {
            skeleton = "";
            switch (this.kind) {
                case "date": {
                    skeleton = DATE_STYLES_TO_SKELETON.get("year-month-day-weekday::medium");
                    break;
                }
                case "time": {
                    skeleton = TIME_STYLES_TO_SKELETON.get("minute::");
                    break;
                }
                default: {
                    skeleton = DATE_STYLES_TO_SKELETON.get("year-month-day-weekday::medium") + TIME_STYLES_TO_SKELETON.get("minute::");
                }
            }
        }
        TimeZone tz = TimeZone.getDefault();
        String timeZoneOverride = OptUtils.getString(fixedOptions, "timeZone", "");
        if (!timeZoneOverride.isEmpty()) {
            tz = TimeZone.getTimeZone(timeZoneOverride);
        }
        if (!(calendarOverride = OptUtils.getString(fixedOptions, "calendar", "")).isEmpty()) {
            locale = new Locale.Builder().setLocale(locale).setUnicodeLocaleKeyword("ca", calendarOverride).build();
        }
        DateFormat df = DateFormat.getInstanceForSkeleton((String)skeleton, locale);
        if (!tz.equals(TimeZone.UNKNOWN_ZONE)) {
            df.setTimeZone(tz);
        }
        return new DateTimeFunctionImpl(locale, df, reportErrors);
    }

    private static String getDateFieldOptions(Map<String, Object> options, String fieldName, String lengthName) {
        StringBuilder skeleton = new StringBuilder();
        Object opt = OptUtils.getString(options, fieldName, "") + "::" + OptUtils.getString(options, lengthName, "");
        if ((opt = DATE_STYLES_TO_SKELETON.get(opt)) != null) {
            skeleton.append((String)opt);
        }
        return skeleton.toString();
    }

    private static String getTimeFieldOptions(Map<String, Object> options, String precisionName) {
        StringBuilder skeleton = new StringBuilder();
        Object opt = OptUtils.getString(options, precisionName, "") + "::" + OptUtils.getString(options, "hour12", "");
        if ((opt = TIME_STYLES_TO_SKELETON.get(opt)) != null) {
            skeleton.append((String)opt);
        }
        switch (opt = OptUtils.getString(options, "timeZoneStyle", "")) {
            case "long": {
                skeleton.append("zzzz");
                break;
            }
            case "short": {
                skeleton.append("z");
                break;
            }
        }
        return skeleton.toString();
    }

    private static Integer safeParse(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return Integer.parseInt(str);
    }

    private static Object parseIso8601(String text) {
        Matcher m4 = ISO_PATTERN.matcher(text);
        if (m4.find() && m4.groupCount() == 12 && !m4.group().isEmpty()) {
            Integer year = DateTimeFunctionFactory.safeParse(m4.group(2));
            Integer month = DateTimeFunctionFactory.safeParse(m4.group(3));
            Integer day = DateTimeFunctionFactory.safeParse(m4.group(4));
            Integer hour = DateTimeFunctionFactory.safeParse(m4.group(6));
            Integer minute = DateTimeFunctionFactory.safeParse(m4.group(7));
            Integer second = DateTimeFunctionFactory.safeParse(m4.group(8));
            Integer millisecond = 0;
            if (m4.group(9) != null) {
                String z = (m4.group(9) + "000").substring(1, 4);
                millisecond = DateTimeFunctionFactory.safeParse(z);
            } else {
                millisecond = 0;
            }
            String tzPart = m4.group(10);
            if (hour == null) {
                hour = 0;
                minute = 0;
                second = 0;
            }
            GregorianCalendar gc = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            gc.set(14, millisecond);
            if (tzPart != null) {
                if (tzPart.equals("Z")) {
                    gc.setTimeZone(TimeZone.GMT_ZONE);
                } else {
                    int sign = tzPart.startsWith("-") ? -1 : 1;
                    String[] tzParts = tzPart.substring(1).split(":");
                    if (tzParts.length == 2) {
                        Integer tzHour = DateTimeFunctionFactory.safeParse(tzParts[0]);
                        Integer tzMin = DateTimeFunctionFactory.safeParse(tzParts[1]);
                        if (tzHour != null && tzMin != null) {
                            int offset = sign * (tzHour * 60 + tzMin) * 60 * 1000;
                            gc.setTimeZone(new SimpleTimeZone(offset, "offset"));
                        }
                    }
                }
            }
            return gc;
        }
        return text;
    }

    private static class DateTimeFunctionImpl
    implements Function {
        private final DateFormat icuFormatter;
        private final Locale locale;
        private final boolean reportErrors;

        private DateTimeFunctionImpl(Locale locale, DateFormat df, boolean reportErrors) {
            this.locale = locale;
            this.icuFormatter = df;
            this.reportErrors = reportErrors;
        }

        @Override
        public FormattedPlaceholder format(Object toFormat, Map<String, Object> variableOptions) {
            if (toFormat == null) {
                return null;
            }
            if (toFormat instanceof CharSequence) {
                if ((toFormat = DateTimeFunctionFactory.parseIso8601(toFormat.toString())) instanceof CharSequence) {
                    if (this.reportErrors) {
                        throw new IllegalArgumentException("bad-operand: argument must be ISO 8601");
                    }
                    return new FormattedPlaceholder(toFormat, new PlainStringFormattedValue("{|" + String.valueOf(toFormat) + "|}"));
                }
            } else if (toFormat instanceof Temporal) {
                toFormat = JavaTimeConverters.temporalToCalendar((Temporal)toFormat);
            } else if (toFormat instanceof DayOfWeek) {
                toFormat = JavaTimeConverters.dayOfWeekToCalendar((DayOfWeek)toFormat);
            } else if (toFormat instanceof Month) {
                toFormat = JavaTimeConverters.monthToCalendar((Month)toFormat);
            }
            if (toFormat instanceof Calendar) {
                toFormat = JavaTimeConverters.convertCalendar((Calendar)toFormat);
            }
            String result = this.icuFormatter.format(toFormat);
            return new FormattedPlaceholder(toFormat, new PlainStringFormattedValue(result));
        }

        @Override
        public String formatToString(Object toFormat, Map<String, Object> variableOptions) {
            FormattedPlaceholder result = this.format(toFormat, variableOptions);
            return result != null ? result.toString() : null;
        }
    }
}

