/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Stream;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrValue;

final class InMemoryData
implements CldrData {
    private final ImmutableMap<CldrPath, CldrValue> pathValuePairs;

    InMemoryData(Iterable<CldrValue> values) {
        this.pathValuePairs = Maps.uniqueIndex(values, CldrValue::getPath);
        HashSet<CldrPath> pathPrefixes = new HashSet<CldrPath>();
        for (CldrPath p : this.pathValuePairs.keySet()) {
            Preconditions.checkArgument(pathPrefixes.add(p), "distinguishing paths must not be prefixes of other paths: %s", (Object)p);
            for (p = p.getParent(); p != null && pathPrefixes.add(p); p = p.getParent()) {
            }
        }
    }

    @Override
    public void accept(CldrData.PathOrder order, CldrData.ValueVisitor visitor) {
        this.sortKeys(order).forEach(p -> visitor.visit(this.pathValuePairs.get(p)));
    }

    @Override
    public CldrValue get(CldrPath path) {
        return this.pathValuePairs.get(path);
    }

    private Stream<CldrPath> sortKeys(CldrData.PathOrder order) {
        Stream<CldrPath> rawOrder = this.pathValuePairs.keySet().stream();
        switch (order) {
            case ARBITRARY: {
                return rawOrder;
            }
            case NESTED_GROUPING: {
                return rawOrder.sorted(Comparator.comparing(Object::toString));
            }
            case DTD: {
                return rawOrder.sorted(Comparator.naturalOrder());
            }
        }
        throw new AssertionError((Object)("Unknown path order!!: " + String.valueOf((Object)order)));
    }
}

