/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class CheckCasing
extends CheckCLDR {
    ULocale uLocale = null;
    BreakIterator breaker = null;

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.uLocale = new ULocale(cldrFileToCheck.getLocaleID());
        this.breaker = BreakIterator.getWordInstance(this.uLocale);
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (fullPath.indexOf("casing") < 0) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(fullPath);
        Case caseTest = Case.mixed;
        for (int i = 0; i < parts.size(); ++i) {
            String casingValue = parts.getAttributeValue(i, "casing");
            if (casingValue == null || (caseTest = Case.forString(casingValue)) != Case.verbatim) continue;
            return this;
        }
        String newValue = value;
        switch (caseTest) {
            case lowercase_words: {
                newValue = UCharacter.toLowerCase(this.uLocale, value);
                break;
            }
            case titlecase_words: {
                newValue = UCharacter.toTitleCase(this.uLocale, value, null);
                break;
            }
            case titlecase_firstword: {
                newValue = this.TitleCaseFirst(this.uLocale, value);
                break;
            }
        }
        if (!newValue.equals(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectCasing).setMessage("Casing incorrect: either should have casing=\"verbatim\" or be <{0}>", newValue));
        }
        return this;
    }

    private String TitleCaseFirst(ULocale locale, String value) {
        if (value.length() == 0) {
            return value;
        }
        this.breaker.setText(value);
        this.breaker.first();
        int endOfFirstWord = this.breaker.next();
        return UCharacter.toTitleCase(this.uLocale, value.substring(0, endOfFirstWord), this.breaker) + value.substring(endOfFirstWord);
    }

    public static enum Case {
        mixed,
        lowercase_words,
        titlecase_words,
        titlecase_firstword,
        verbatim;


        public static Case forString(String input) {
            return Case.valueOf(input.replace('-', '_'));
        }
    }
}

