/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.IOException;
import java.io.PrintWriter;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.icu.dev.test.TestFmwk;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.CldrUtility;

public class TestTransformsSimple
extends TestFmwk {
    private static final boolean verbose = CldrUtility.getProperty("verbose", false);
    private static PrintWriter out = verbose ? new PrintWriter(System.out, true) : null;
    static UnicodeSet latin = new UnicodeSet("[a-z]");
    static UnicodeSet lead = new UnicodeSet("[:Hangul_Syllable_Type=Leading_Jamo:]");
    static UnicodeSet vowel = new UnicodeSet("[:Hangul_Syllable_Type=Vowel_Jamo:]");
    static UnicodeSet trail = new UnicodeSet("[:Hangul_Syllable_Type=Trailing_Jamo:]");

    public static void main(String[] args) throws Exception {
        CLDRTransforms.registerCldrTransforms(null, null, out, true);
        new TestTransformsSimple().run(args);
    }

    public void TestChinese() {
        Transliterator hanLatin = Transliterator.getInstance("Han-Latin");
        this.assertTransform("Transform", "z\u00e0o Unicode", hanLatin, "\u9020Unicode");
        this.assertTransform("Transform", "z\u00e0i chu\u00e0ng z\u00e0o Unicode zh\u012b qi\u00e1n", hanLatin, "\u5728\u5275\u9020Unicode\u4e4b\u524d");
    }

    public void TestHangul2() {
        Transliterator lh = Transliterator.getInstance("Latin-Hangul");
        Transliterator hl = lh.getInverse();
        UnicodeSet representativeHangul = TestTransformsSimple.getRepresentativeHangul();
        UnicodeSetIterator it = new UnicodeSetIterator(representativeHangul);
        while (it.next()) {
            this.assertRoundTripTransform("Transform", it.getString(), lh, hl);
        }
        this.assertTransform("Transform", "\uce20", lh, "ch");
        this.assertTransform("Transform", "\uc544\ub530", lh, hl, "atta", "a-tta");
        this.assertTransform("Transform", "\uc544\ube60", lh, hl, "appa", "a-ppa");
        this.assertTransform("Transform", "\uc544\uc9dc", lh, hl, "ajja", "a-jja");
        this.assertTransform("Transform", "\uc544\uae4c", lh, hl, "akka", "a-kka");
        this.assertTransform("Transform", "\uc544\uc2f8", lh, hl, "assa", "a-ssa");
        this.assertTransform("Transform", "\uc544\ucc28", lh, hl, "acha", "a-cha");
        this.assertTransform("Transform", "\uc545\uc0ac", lh, hl, "agsa", "ag-sa");
        this.assertTransform("Transform", "\uc548\uc790", lh, hl, "anja", "an-ja");
        this.assertTransform("Transform", "\uc548\ud558", lh, hl, "anha", "an-ha");
        this.assertTransform("Transform", "\uc54c\uac00", lh, hl, "alga", "al-ga");
        this.assertTransform("Transform", "\uc54c\ub9c8", lh, hl, "alma", "al-ma");
        this.assertTransform("Transform", "\uc54c\ubc14", lh, hl, "alba", "al-ba");
        this.assertTransform("Transform", "\uc54c\uc0ac", lh, hl, "alsa", "al-sa");
        this.assertTransform("Transform", "\uc54c\ud0c0", lh, hl, "alta", "al-ta");
        this.assertTransform("Transform", "\uc54c\ud30c", lh, hl, "alpa", "al-pa");
        this.assertTransform("Transform", "\uc54c\ud558", lh, hl, "alha", "al-ha");
        this.assertTransform("Transform", "\uc555\uc0ac", lh, hl, "absa", "ab-sa");
        this.assertTransform("Transform", "\uc548\uac00", lh, hl, "anga", "an-ga");
        this.assertTransform("Transform", "\uc545\uc2f8", lh, hl, "agssa", "ag-ssa");
        this.assertTransform("Transform", "\uc548\uc9dc", lh, hl, "anjja", "an-jja");
        this.assertTransform("Transform", "\uc54c\uc2f8", lh, hl, "alssa", "al-ssa");
        this.assertTransform("Transform", "\uc54c\ub530", lh, hl, "altta", "al-tta");
        this.assertTransform("Transform", "\uc54c\ube60", lh, hl, "alppa", "al-ppa");
        this.assertTransform("Transform", "\uc555\uc2f8", lh, hl, "abssa", "ab-ssa");
        this.assertTransform("Transform", "\uc546\uce74", lh, hl, "akkka", "akk-ka");
        this.assertTransform("Transform", "\uc558\uc0ac", lh, hl, "asssa", "ass-sa");
    }

    private void assertRoundTripTransform(String message, String source, Transliterator lh, Transliterator hl) {
        String to = hl.transform(source);
        String back = lh.transform(to);
        String to2 = hl.transform(source.replaceAll("(.)", "$1 ").trim());
        String to3 = hl.transform(back.replaceAll("(.)", "$1 ").trim());
        this.assertEquals(message + " " + source + " [" + to + "/" + to2 + "/" + to3 + "]", source, back);
    }

    private void assertTransform(String message, String expected, StringTransform t2, String source) {
        this.assertEquals(message + " " + source, expected, t2.transform(source));
    }

    private void assertTransform(String message, String expected, StringTransform t2, StringTransform back, String ... source) {
        for (String s2 : source) {
            this.assertEquals(message + " " + s2, expected, t2.transform(s2));
        }
        this.assertEquals(message + " " + expected, source[0], back.transform(expected));
    }

    public void xTestTamil() throws IOException {
        String name = "Tamil-Devanagari";
        Transliterator tamil_devanagari = Transliterator.getInstance(name);
        Transliterator devanagari_tamil = Transliterator.getInstance(name, 1);
        this.writeFile(name, new UnicodeSet("[[:block=tamil:]-[\u0bd7]]"), null, tamil_devanagari, devanagari_tamil, false, null, null);
    }

    public void TestJamo() throws IOException {
        String name = "Latin-ConjoiningJamo";
        Transliterator fromLatin = Transliterator.getInstance(name);
        Transliterator toLatin = Transliterator.getInstance(name, 1);
        UnicodeSet sourceSet = TestTransformsSimple.getRepresentativeHangul();
        this.logln(sourceSet.size() + "\t" + sourceSet.toPattern(false));
        Transliterator nfd = Transliterator.getInstance("nfd");
        UnicodeSet multiply = new UnicodeSet(sourceSet);
        UnicodeSet specials = null;
        this.writeFile(name, multiply, nfd, toLatin, fromLatin, true, null, specials);
    }

    private int writeFile(String title, UnicodeSet sourceSet, Transliterator nfd, Transliterator toLatin, Transliterator fromLatin, boolean doLatin, UnicodeSet nativeSpecials, UnicodeSet latinSpecials) throws IOException {
        String item;
        UnicodeSetIterator it;
        int errorCount = 0;
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "transTest/", title + ".html");
        out.println("<html><head>");
        out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'></head><body>");
        if (nativeSpecials != null) {
            out.println("<h1>Specials</h1><table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse'>");
            TestTransformsSimple.showItems(out, true, "Source", "ToLatin", "FromLatin", "BackToLatin");
            it = new UnicodeSetIterator(nativeSpecials);
            while (it.next()) {
                item = it.getString();
                errorCount = TestTransformsSimple.checkString(out, item, nfd, fromLatin, toLatin, errorCount, null);
                errorCount = TestTransformsSimple.checkString(out, item, nfd, fromLatin, toLatin, errorCount, "-");
            }
            out.println("</table><p>Special failures:\t" + errorCount + "</p>");
            if (errorCount != 0) {
                this.errln("Special failures:\t" + errorCount);
                errorCount = 0;
            }
        }
        if (latinSpecials != null) {
            out.println("<h1>Specials</h1><table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse'>");
            TestTransformsSimple.showItems(out, true, "Latin", "ToNative", "BackToLatin", "BackToNative");
            it = new UnicodeSetIterator(latinSpecials);
            while (it.next()) {
                item = it.getString();
                errorCount = TestTransformsSimple.checkString(out, item, nfd, toLatin, fromLatin, errorCount, null);
            }
            out.println("</table><p>Special failures:\t" + errorCount + "</p>");
            if (errorCount != 0) {
                this.errln("Special failures:\t" + errorCount);
                errorCount = 0;
            }
        }
        if (doLatin) {
            out.println("<h1>Latin failures</h1><table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse'>");
            TestTransformsSimple.showItems(out, true, "Latin", "Target", "BackToLatin", "BackToTarget");
            errorCount = TestTransformsSimple.checkLatin(out, fromLatin, toLatin);
            out.println("</table><p>Latin failures:\t" + errorCount + "</p>");
            if (errorCount != 0) {
                this.errln("Latin failures:\t" + errorCount);
                errorCount = 0;
            }
        }
        out.println("<h1>Not Reversible</h1><table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse'>");
        errorCount = TestTransformsSimple.showMappings(out, sourceSet, null, nfd, fromLatin, toLatin);
        out.println("</table><p>Reversible failures:\t" + errorCount + "</p>");
        if (errorCount != 0) {
            this.errln("Reversible failures:\t" + errorCount);
            errorCount = 0;
        }
        out.println("<h1>Has Unneeded Separator</h1><table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse'>");
        errorCount = TestTransformsSimple.showMappings(out, sourceSet, "-", nfd, fromLatin, toLatin);
        out.println("</table><p>Separator failures:\t" + errorCount + "</p>");
        if (errorCount != 0) {
            this.logln("Unneeded Separators:\t" + errorCount);
            errorCount = 0;
        }
        out.print("</body></html>");
        out.close();
        return errorCount;
    }

    private static int checkLatin(PrintWriter out, Transliterator fromLatin, Transliterator toLatin) {
        int errorCount = 0;
        UnicodeSetIterator it = new UnicodeSetIterator(latin);
        while (it.next()) {
            String source = it.getString();
            String to = fromLatin.transliterate(source);
            if (!latin.containsSome(to)) continue;
            String from = toLatin.transliterate(to);
            String backto = toLatin.transliterate(from);
            errorCount += TestTransformsSimple.showItems(out, false, source, to, from, backto);
        }
        return errorCount;
    }

    private static int showMappings(PrintWriter out, UnicodeSet testSet, String separator, Transliterator nfd, Transliterator fromLatin, Transliterator toLatin) {
        int errorCount = 0;
        if (separator == null) {
            TestTransformsSimple.showItems(out, true, "Source", "ToLatin", "FromLatin", "BackToLatin");
        } else {
            TestTransformsSimple.showItems(out, true, "Source", "ToLatin", "FromLatin", "BackToLatin", "WithoutSeparator");
        }
        UnicodeSetIterator it = new UnicodeSetIterator(testSet);
        while (it.next()) {
            errorCount = TestTransformsSimple.checkString(out, it.getString(), nfd, fromLatin, toLatin, errorCount, separator);
        }
        return errorCount;
    }

    private static int checkString(PrintWriter out, String source1, Transliterator nfd, Transliterator fromLatin, Transliterator toLatin, int errorCount, String separator) {
        String otherTo;
        String otherFrom;
        boolean bad;
        String source = nfd == null ? source1 : nfd.transliterate(source1);
        String to = toLatin.transliterate(source);
        String from = fromLatin.transliterate(to);
        if (separator == null) {
            boolean bad2;
            boolean bl = bad2 = !source.equals(from);
            if (bad2 || verbose) {
                String backto = toLatin.transliterate(from);
                if (bad2) {
                    ++errorCount;
                }
                TestTransformsSimple.showItems(out, false, source, to, from, backto, bad2 ? "FAIL" : null);
            }
        } else if (to.contains(separator) && (bad = (otherFrom = fromLatin.transliterate(otherTo = to.replace("-", ""))).equals(from))) {
            ++errorCount;
            TestTransformsSimple.showItems(out, false, source, to, from, otherTo, otherFrom, bad ? "FAIL" : null);
        }
        return errorCount;
    }

    private static int showItems(PrintWriter out, boolean th, String ... sourceList) {
        out.println("<tr>");
        for (String source : sourceList) {
            if (source == null) continue;
            out.println((th ? "<th>" : "<td>") + TestTransformsSimple.pretty(source) + (th ? "</th>" : "</td>"));
        }
        out.println("</tr>");
        out.flush();
        return 1;
    }

    private static String pretty(String source) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            String color = lead.contains(c) ? "FFcccc" : (vowel.contains(c) ? "ccFFcc" : (trail.contains(c) ? "ccccFF" : "FFFFFF"));
            result.append("<span style='background-color: #" + color + "'>" + c + "</span>");
        }
        return result.toString();
    }

    public static UnicodeSet getRepresentativeHangul() {
        UnicodeSet extraSamples = new UnicodeSet("[\uce20{\uad6c\ub514}{\uad73\uc774}{\ubb34\ub837}{\ubb3c\uc5ff}{\uc544\uae4c}{\uc544\ub530}{\uc544\ube60}{\uc544\uc2f8}{\uc544\uc9dc}{\uc544\ucc28}{\uc545\uc0ac}{\uc545\uc2f8}{\uc546\uce74}{\uc548\uac00}{\uc548\uc790}{\uc548\uc9dc}{\uc548\ud558}{\uc54c\uac00}{\uc54c\ub530}{\uc54c\ub9c8}{\uc54c\ubc14}{\uc54c\ube60}{\uc54c\uc0ac}{\uc54c\uc2f8}{\uc54c\ud0c0}{\uc54c\ud30c}{\uc54c\ud558}{\uc555\uc0ac}{\uc555\uc2f8}{\uc558\uc0ac}{\uc5c5\uc12f\uc501}{\uc5c6\uc5c8\uc2b5}]");
        UnicodeSet sourceSet = new UnicodeSet();
        TestTransformsSimple.addRepresentativeHangul(sourceSet, 2, false);
        TestTransformsSimple.addRepresentativeHangul(sourceSet, 3, false);
        TestTransformsSimple.addRepresentativeHangul(sourceSet, 2, true);
        TestTransformsSimple.addRepresentativeHangul(sourceSet, 3, true);
        UnicodeSet more = TestTransformsSimple.getRepresentativeBoundaryHangul();
        sourceSet.addAll(more);
        sourceSet.addAll(extraSamples);
        return sourceSet;
    }

    private static UnicodeSet getRepresentativeBoundaryHangul() {
        String trial;
        String sample;
        UnicodeSet resultToAddTo = new UnicodeSet();
        UnicodeSet L = new UnicodeSet("[:hst=L:]");
        UnicodeSet V = new UnicodeSet("[:hst=V:]");
        UnicodeSet T = new UnicodeSet("[:hst=T:]");
        String prefixLV = "\u1100\u1161";
        String prefixL = "\u1100";
        String suffixV = "\u1161";
        String nullL = "\u110b";
        UnicodeSet L0 = new UnicodeSet("[\u1100\u110b]");
        UnicodeSetIterator iL0 = new UnicodeSetIterator(L0);
        while (iL0.next()) {
            UnicodeSetIterator iV = new UnicodeSetIterator(V);
            while (iV.next()) {
                UnicodeSetIterator iV2 = new UnicodeSetIterator(V);
                while (iV2.next()) {
                    sample = iL0.getString() + iV.getString() + nullL + iV2.getString();
                    trial = Normalizer.compose(sample, false);
                    if (trial.length() != 2) continue;
                    resultToAddTo.add(trial);
                }
            }
        }
        UnicodeSetIterator iL = new UnicodeSetIterator(L);
        while (iL.next()) {
            String suffix = iL.getString() + suffixV;
            UnicodeSetIterator iV = new UnicodeSetIterator(V);
            while (iV.next()) {
                sample = prefixL + iV.getString() + suffix;
                trial = Normalizer.compose(sample, false);
                if (trial.length() != 2) continue;
                resultToAddTo.add(trial);
            }
            UnicodeSetIterator iT = new UnicodeSetIterator(T);
            while (iT.next()) {
                sample = prefixLV + iT.getString() + suffix;
                trial = Normalizer.compose(sample, false);
                if (trial.length() != 2) continue;
                resultToAddTo.add(trial);
            }
        }
        return resultToAddTo;
    }

    private static void addRepresentativeHangul(UnicodeSet resultToAddTo, int leng, boolean noFirstConsonant) {
        UnicodeSet notYetSeen = new UnicodeSet();
        for (char c = '\uac00'; c < '\ud7af'; c = (char)(c + '\u0001')) {
            String charStr = String.valueOf(c);
            String decomp = Normalizer.decompose(charStr, false);
            if (decomp.length() != leng || decomp.startsWith("\u110b") != noFirstConsonant || notYetSeen.containsAll(decomp)) continue;
            resultToAddTo.add(c);
            notYetSeen.addAll(decomp);
        }
    }
}

