/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.text.UnicodeSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CodePointEscaper;
import org.unicode.cldr.util.Emoji;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.XPathParts;

public class CheckEmojiAnnotations {
    private static final Joiner JOIN_BAR = Joiner.on(" | ");

    public static void main(String[] args) {
        boolean chooseEmoji = true;
        UnicodeSet rgi = Emoji.getAllRgi();
        UnicodeSet rgiNoVariant = Emoji.getAllRgiNoES();
        CLDRFile root = CLDRConfig.getInstance().getAnnotationsFactory().make("en", false);
        UnicodeSet rootEmoji = new UnicodeSet();
        for (String path : root) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String cp = parts.getAttributeValue(-1, "cp");
            if (cp == null || rgiNoVariant.contains(cp) != chooseEmoji) continue;
            rootEmoji.add(cp);
        }
        rootEmoji.freeze();
        UnicodeMap<Annotations> english = Annotations.getData("en");
        TreeMap<String, UnicodeSet> keywordToEmoji = new TreeMap<String, UnicodeSet>();
        UnicodeSet allUnclean = new UnicodeSet();
        for (Annotations entry : english.values()) {
            Object emojiItem;
            Set<String> keywords = entry.getKeywords();
            Object emoji = english.getSet(entry);
            ((UnicodeSet)emoji).retainAll(rootEmoji);
            UnicodeSet emojiRestored = new UnicodeSet();
            Iterator<String> iterator = ((UnicodeSet)emoji).iterator();
            while (iterator.hasNext()) {
                emojiItem = iterator.next();
                emojiRestored.add(Emoji.restoreVariants((String)emojiItem));
            }
            UnicodeSet iterator2 = new UnicodeSet(emojiRestored).removeAll(rgi);
            allUnclean.add(iterator2);
            emojiRestored = emojiRestored.retainAll(rgi);
            if (emojiRestored.isEmpty()) continue;
            emojiItem = keywords.iterator();
            while (emojiItem.hasNext()) {
                String keyword = (String)emojiItem.next();
                UnicodeSet value = (UnicodeSet)keywordToEmoji.get(keyword);
                if (value == null) {
                    value = new UnicodeSet();
                    keywordToEmoji.put(keyword, value);
                }
                value.addAll(emojiRestored);
            }
        }
        CldrUtility.protectCollection(keywordToEmoji);
        int count = 0;
        System.out.println("### Emoji to Keywords");
        TreeSet<Object> sortedRootEmoji = new TreeSet<Object>(Emoji.COLLATOR);
        rootEmoji.addAllTo(sortedRootEmoji);
        for (Object emoji : sortedRootEmoji) {
            String restored = Emoji.restoreVariants((String)emoji);
            Set<String> set = english.get((String)emoji).getKeywords();
            System.out.println(++count + "\t" + restored + "\t" + (String)emoji + "\t" + JOIN_BAR.join(set));
        }
        UnicodeSet toEscape = new UnicodeSet(CodePointEscaper.FORCE_ESCAPE).remove(CodePointEscaper.ZWJ.getCodePoint()).remove(CodePointEscaper.RANGE.getCodePoint()).freeze();
        SimpleUnicodeSetFormatter suf = new SimpleUnicodeSetFormatter(null, toEscape);
        if (!(allUnclean = allUnclean.retainAll(rgiNoVariant).removeAll(Emoji.SKIN_MODIFIERS).removeAll(Emoji.HAIR_MODIFIERS)).isEmpty()) {
            throw new IllegalArgumentException("Missing " + suf.format(allUnclean));
        }
        System.out.println("### Keywords to Emoji");
        count = 0;
        for (Map.Entry entry : keywordToEmoji.entrySet()) {
            System.out.println(++count + "\t" + (String)entry.getKey() + "\t" + suf.format((UnicodeSet)entry.getValue()));
        }
        System.out.println("### Gender Variants");
        for (Set set : Emoji.getGenderGroups()) {
            Annotations anno;
            TreeSet<String> common = null;
            TreeSet<String> cleanEntry = new TreeSet<String>();
            for (String s2 : set) {
                if (!rootEmoji.contains(Emoji.removeVariants(s2)) || (anno = CheckEmojiAnnotations.getAnnotations(english, s2)) == null) continue;
                cleanEntry.add(s2);
                if (common == null) {
                    System.out.println();
                    common = new TreeSet<String>();
                    common.addAll(anno.getKeywords());
                    continue;
                }
                common.retainAll(anno.getKeywords());
            }
            if (cleanEntry.size() <= 1) continue;
            for (String s2 : cleanEntry) {
                anno = CheckEmojiAnnotations.getAnnotations(english, s2);
                String removed = Emoji.removeVariants(s2);
                System.out.println(s2 + "\t" + removed + "\t" + anno.getShortName() + "\t" + JOIN_BAR.join(common) + "\t" + JOIN_BAR.join(Sets.difference(anno.getKeywords(), common)));
            }
        }
    }

    public static Annotations getAnnotations(UnicodeMap<Annotations> english, String s2) {
        Annotations anno = english.get(s2);
        if (anno == null) {
            anno = english.get(s2.replace("\ufe0f", ""));
        }
        return anno;
    }
}

