/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;

@CLDRTool(alias="checkout-archive", description="Checkout CLDR archive to $ARCHIVE (usually ../cldr-archive)", url="https://cldr.unicode.org/development/creating-the-archive")
public class CheckoutArchive {
    public static void main(String[] args) throws IOException, InterruptedException {
        String[] cmd;
        MyOptions.parse(args, true);
        Path archiveDir = new File(CLDRPaths.ARCHIVE_DIRECTORY).toPath();
        if (!archiveDir.toFile().isDirectory()) {
            throw new FileNotFoundException("Archive directory " + archiveDir.toString() + " does not exist, please create it or change the value of -DARCHIVE=");
        }
        System.out.println("Setting up in $ARCHIVE " + archiveDir.toString() + " \u2026");
        int skip = 0;
        int created = 0;
        int err = 0;
        if (MyOptions.prune.option.doesOccur() && CheckoutArchive.runCommand(cmd = new String[]{"git", "worktree", "prune"})) {
            ++err;
        }
        for (String ver : ToolConstants.CLDR_VERSIONS) {
            Path dirName = archiveDir.resolve("cldr-" + ver);
            if (dirName.toFile().isDirectory()) {
                ++skip;
                System.out.println("# Skipping existing \t" + dirName.toString());
                continue;
            }
            String tag = "release-" + ver.replaceAll("\\.", "-").replaceAll("-0$", "");
            String[] cmd2 = new String[]{"git", "worktree", "add", dirName.toString(), tag};
            if (!CheckoutArchive.runCommand(cmd2)) continue;
            ++err;
        }
        System.out.println(String.format("Created %d and skipped %d version(s)", created, skip));
        if (err != 0) {
            throw new RuntimeException("Total errors: " + err);
        }
    }

    private static boolean runCommand(String[] cmd) throws InterruptedException, IOException {
        int ev;
        System.out.println("# " + String.join((CharSequence)" ", cmd));
        if (!MyOptions.echo.option.doesOccur() && (ev = new ProcessBuilder(cmd).directory(new File(CLDRPaths.BASE_DIRECTORY)).inheritIO().start().waitFor()) != 0) {
            System.err.println("Error: exit value " + ev);
            return true;
        }
        return false;
    }

    static enum MyOptions {
        prune("Perform a 'git prune' first"),
        echo("Only show commands, don't run them. (Dry run)");

        final Option option;
        static Option.Options myOptions;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = new Option(this, argumentPattern, defaultArgument, helpText);
        }

        private MyOptions(String helpText) {
            this.option = new Option(this, helpText);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

