/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.DateTimePatternGenerator;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;

public class CompareStockDatetime {
    public static void main(String[] args) {
        CLDRConfig info = ToolConfig.getToolInstance();
        Factory cldrFactory = info.getCldrFactory();
        String[][] data = new String[][]{{"date", "full"}, {"date", "long"}, {"date", "medium"}, {"date", "short"}, {"time", "full"}, {"time", "long"}, {"time", "medium"}, {"time", "short"}};
        TreeMap<CallSite, Relation<String, String>> lengthToSkeletonToLocales = new TreeMap<CallSite, Relation<String, String>>();
        Set<String> defaultContentLocales = info.getSupplementalDataInfo().getDefaultContentLocales();
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getEmptyInstance();
        for (String string : cldrFactory.getAvailableLanguages()) {
            if (defaultContentLocales.contains(string)) continue;
            System.out.println(string);
            CLDRFile cldrFile = cldrFactory.make(string, true);
            for (String[] row : data) {
                String type = row[0];
                String length = row[1];
                String xpath = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/" + type + "Formats/" + type + "FormatLength[@type=\"" + length + "\"]/" + type + "Format[@type=\"standard\"]/pattern[@type=\"standard\"]";
                String value = cldrFile.getStringValue(xpath);
                String skeleton = dtpg.getSkeleton(value);
                skeleton = skeleton.replace("yyyy", "y");
                String key = type + "-" + length;
                Relation<String, String> skeletonToLocales = (Relation<String, String>)lengthToSkeletonToLocales.get(key);
                if (skeletonToLocales == null) {
                    skeletonToLocales = Relation.of(new TreeMap(), TreeSet.class);
                    lengthToSkeletonToLocales.put((CallSite)((Object)key), skeletonToLocales);
                }
                skeletonToLocales.put(skeleton, string);
            }
        }
        System.out.println();
        for (Map.Entry entry : lengthToSkeletonToLocales.entrySet()) {
            for (Map.Entry entry2 : ((Relation)entry.getValue()).keyValuesSet()) {
                System.out.println((String)entry.getKey() + "\t" + (String)entry2.getKey() + "\t" + String.valueOf(entry2.getValue()));
            }
        }
    }
}

