/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import javax.swing.JApplet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRPaths;

public class GenerateApproximateWidths
extends JApplet
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final int IMAGE_HEIGHT = 360;
    private static final int IMAGE_WIDTH = 640;
    private static final BasicStroke BASIC_STROKE = new BasicStroke(0.5f);
    private static final Font FONT = new Font("TimesNewRoman", 0, 100);
    private static final Font FONT101 = new Font("TimesNewRoman", 0, 101);
    private BufferedImage bimg;
    private String string = "\ud835\udedb";

    @Override
    public void paint(Graphics g2) {
        Dimension d = this.getSize();
        if (this.bimg == null || this.bimg.getWidth() != d.width || this.bimg.getHeight() != d.height) {
            this.bimg = (BufferedImage)this.createImage(d.width, d.height);
        }
        int w = this.bimg.getWidth();
        int h2 = this.bimg.getHeight();
        this.drawDemo(this.bimg, w, h2);
        g2.drawImage(this.bimg, 0, 0, this);
    }

    public void drawDemo(BufferedImage bimg, int w, int h2) {
        Graphics2D g2 = bimg.createGraphics();
        g2.setBackground(Color.white);
        g2.clearRect(0, 0, w, h2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(BASIC_STROKE);
        this.drawString(g2, FONT, this.string, 0.25, w, 0.5, h2);
        this.drawString(g2, FONT101, this.string, 0.75, w, 0.5, h2);
        this.showWidths(g2);
        g2.dispose();
    }

    private void showWidths(Graphics2D g2) {
        try {
            PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "widths/", "ApproximateWidth.txt");
            UnicodeMap<Integer> map = new UnicodeMap<Integer>();
            Widths widths = new Widths(g2, new Font("Serif", 0, 100), new Font("SansSerif", 0, 100));
            UnicodeSet CHECK = new UnicodeSet("[[:^c:][:cc:][:cf:]]");
            int defaultWidth = widths.getMetrics(65533);
            CHECK.removeAll(this.addCorrections(map, "[:Cn:]", defaultWidth));
            CHECK.removeAll(this.addCorrections(map, "[\\u0000-\\u0008\\u000E-\\u001F\\u007F-\\u0084\\u0086-\\u009F]", defaultWidth));
            int cjkWidth = widths.getMetrics(19968);
            CHECK.removeAll(this.addCorrections(map, "[:ideographic:]", cjkWidth));
            CHECK.removeAll(this.addCorrections(map, "[[:Cf:][:Mn:][:Me:]]", 0));
            int count = 0;
            UnicodeSetIterator it = new UnicodeSetIterator(CHECK);
            while (it.next()) {
                int cpWidth;
                if (++count % 1000 == 0) {
                    System.out.println(count + "\t" + Utility.hex(it.codepoint));
                }
                if ((cpWidth = widths.getMetrics(it.codepoint)) == defaultWidth) continue;
                map.put(it.codepoint, (Integer)cpWidth);
            }
            out.println("# ApproximateWidth\n# @missing: 0000..10FFFF; " + defaultWidth);
            TreeSet<Integer> values = new TreeSet<Integer>(map.values());
            for (Integer integer0 : values) {
                int integer;
                if (integer0 == null || (integer = integer0.intValue()) == defaultWidth) continue;
                UnicodeSet uset = map.getSet(integer);
                out.println("\n# width: " + integer + "\n");
                UnicodeSetIterator foo = new UnicodeSetIterator(uset);
                while (foo.nextRange()) {
                    if (foo.codepoint != foo.codepointEnd) {
                        out.println(Utility.hex(foo.codepoint) + ".." + Utility.hex(foo.codepointEnd) + "; " + integer + "; # " + UCharacter.getExtendedName(foo.codepoint) + ".." + UCharacter.getExtendedName(foo.codepointEnd));
                        continue;
                    }
                    out.println(Utility.hex(foo.codepoint) + "; " + integer + "; # " + UCharacter.getExtendedName(foo.codepoint));
                }
                out.println("\n# codepoints: " + uset.size() + "\n");
            }
            out.close();
            System.out.println("Adjusted: " + String.valueOf(widths.adjusted));
            System.out.println("DONE");
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private UnicodeSet addCorrections(UnicodeMap<Integer> map, String usetString, int width) {
        UnicodeSet uset = new UnicodeSet(usetString);
        map.putAll(uset, width);
        return uset;
    }

    public void drawString(Graphics2D g2, Font font2, String mainString, double wPercent, double w, double hPercent, double h2) {
        g2.setFont(font2);
        FontMetrics metrics = g2.getFontMetrics();
        int ascent = metrics.getAscent();
        Rectangle2D bounds = metrics.getStringBounds(mainString, g2);
        double x = wPercent * (w - bounds.getWidth());
        double y = hPercent * (h2 - bounds.getHeight());
        bounds.setRect(x, y, bounds.getWidth(), bounds.getHeight());
        g2.setColor(Color.blue);
        g2.draw(bounds);
        g2.drawLine((int)x, (int)y + ascent, (int)(x + bounds.getWidth()), (int)y + ascent);
        g2.setColor(Color.black);
        g2.drawString(mainString, (int)x, (int)y + ascent);
        System.out.println(font2.getSize() + "\t" + this.string + " " + Integer.toHexString(this.string.codePointAt(0)));
    }

    public static void main(String[] argv) throws IOException {
        final GenerateApproximateWidths demo = new GenerateApproximateWidths();
        demo.init();
        Frame f = new Frame("Frame");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                demo.start();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                demo.stop();
            }
        });
        f.add(demo);
        f.pack();
        f.setSize(new Dimension(640, 360));
        f.show();
        demo.start();
    }

    @Override
    public void run() {
        this.repaint();
    }

    class Widths {
        UnicodeSet adjusted = new UnicodeSet();
        Graphics2D g;
        FontMetrics[] metrics;
        char[] buffer = new char[20];
        int bufferLen = 0;
        int baseChar = -1;
        UnicodeSet SPACING_COMBINING = new UnicodeSet("[:Mc:]").freeze();
        int[] SCRIPT2BASE = new int[213];

        public Widths(Graphics2D g2, Font ... fonts) {
            for (int i = 0; i < this.SCRIPT2BASE.length; ++i) {
                this.SCRIPT2BASE[i] = -1;
            }
            for (String s2 : new UnicodeSet("[\u0915 \u0995 \u0a15 \u0a95 \u0b15 \u0b95 \u0c15 \u0c95 \u0d15 \u0d9a \u0f40 \u1075 \u1780]")) {
                int cp = s2.codePointAt(0);
                if (cp >= 65536) continue;
                int script = UScript.getScript(cp);
                this.SCRIPT2BASE[script] = cp;
            }
            this.g = g2;
            this.metrics = new FontMetrics[fonts.length];
            for (int i = 0; i < fonts.length; ++i) {
                this.g.setFont(fonts[i]);
                this.metrics[i] = this.g.getFontMetrics();
            }
        }

        private int getBase(int cp) {
            if (this.SPACING_COMBINING.contains(cp)) {
                return this.SCRIPT2BASE[UScript.getScript(cp)];
            }
            return -1;
        }

        private int getMetrics(int cp) {
            this.fillBuffer(cp);
            double totalWidth = 0.0;
            for (FontMetrics m4 : this.metrics) {
                double width = this.getTotalWidth(m4);
                if (this.baseChar >= 0) {
                    this.fillBuffer(this.baseChar);
                    width -= this.getTotalWidth(m4) / (double)this.bufferLen;
                    this.fillBuffer(cp);
                } else {
                    width /= (double)this.bufferLen;
                }
                totalWidth += width;
            }
            int result = (int)(totalWidth / (double)this.metrics.length / 10.0 + 0.499999);
            if (result > 31 || result < 0) {
                System.out.println("Code point: " + Utility.hex(cp) + "; Value out of bounds (0..31)" + result);
                if (result > 31) {
                    result = 31;
                } else if (result < 0) {
                    result = 0;
                }
            }
            return result;
        }

        private double getTotalWidth(FontMetrics fontMetrics) {
            Rectangle2D rect1 = fontMetrics.getStringBounds(this.buffer, 0, this.bufferLen, (Graphics)this.g);
            return rect1.getWidth();
        }

        private void fillBuffer(int cp) {
            this.baseChar = -1;
            if (this.SPACING_COMBINING.contains(cp)) {
                this.baseChar = this.getBase(cp);
                if (this.baseChar != -1) {
                    this.buffer[0] = (char)this.baseChar;
                    this.buffer[1] = (char)cp;
                    this.bufferLen = 2;
                    return;
                }
            }
            if (cp < 65536) {
                this.buffer[1] = this.buffer[2] = (char)cp;
                this.buffer[0] = this.buffer[2];
                this.bufferLen = 3;
            } else {
                char[] temp = UCharacter.toChars(cp);
                this.buffer[2] = this.buffer[4] = temp[0];
                this.buffer[0] = this.buffer[4];
                this.buffer[3] = this.buffer[5] = temp[1];
                this.buffer[1] = this.buffer[5];
                this.bufferLen = 6;
            }
        }
    }
}

