/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.VersionInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="generatedecompcollrules", description="based on decomposition, generate identical/tertiary collation rules. Used to generate collation/ar.xml.", hidden="Run manually to generate collation/ar.xml - not general purpose.")
public class GenerateDecompCollationRules {
    private static final char SINGLEQUOTE = '\'';
    private static final UnicodeSet isWord = new UnicodeSet("[\\uFDF0-\\uFDFF]");
    private static final String RESET = "\u200e&";
    private static final String IDENTICAL = "\u200e=";
    private static final String TERTIARY = "\u200e<<<";
    private static final String COMMENT = "# ";
    private static final String NL = "\n";
    private static final Option.Options myOptions = new Option.Options(GenerateDecompCollationRules.class);
    static final Transliterator hex = Transliterator.getInstance("any-hex");
    static final Transliterator hexForComment = Transliterator.getInstance("[^ ] any-hex");
    static final Transliterator name = Transliterator.getInstance("any-name");
    static final Transliterator escapeRules = Transliterator.getInstance("nfc;[[:Mn:]] any-hex");

    public static void main(String[] args) throws IOException {
        UnicodeSet uSet;
        myOptions.parse(MyOptions.verbose, args, true);
        boolean verbose = myOptions.get(MyOptions.verbose).doesOccur();
        CLDRConfig cldrConfig = CLDRConfig.getInstance();
        Normalizer2 nfkd = Normalizer2.getNFKDInstance();
        Normalizer2 nfc = Normalizer2.getNFCInstance();
        Option uSetOption = myOptions.get(MyOptions.unicodeset);
        String uSetRules = uSetOption.doesOccur() ? uSetOption.getValue() : uSetOption.getDefaultArgument();
        System.out.println("UnicodeSet rules: " + uSetRules);
        try {
            uSet = new UnicodeSet(uSetRules);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.err.println("Failed to construct UnicodeSet from \"" + uSetRules + "\" - see http://unicode.org/cldr/utility/list-unicodeset.jsp");
            return;
        }
        System.out.println("UnicodeSet size: " + uSet.size());
        Relation<String, String> reg2pres = new Relation<String, String>(new TreeMap(), TreeSet.class);
        for (Object presForm : uSet) {
            String regForm = nfkd.normalize((CharSequence)presForm).trim();
            if (verbose) {
                System.out.println("# >" + (String)presForm + "< = " + hex.transliterate((String)presForm) + "... ->" + regForm + "=" + hex.transliterate(regForm));
            }
            if (regForm.length() > 31 || ((String)presForm).length() > 31) {
                System.out.println("!! Skipping, TOO LONG: " + (String)presForm + " -> " + regForm);
                continue;
            }
            reg2pres.put(regForm, (String)presForm);
        }
        System.out.println("Relation size: " + reg2pres.size());
        StringBuilder rules = new StringBuilder();
        rules.append(COMMENT).append("Generated by " + GenerateDecompCollationRules.class.getSimpleName() + "\n# ICU v" + String.valueOf(VersionInfo.ICU_VERSION) + ", Unicode v" + String.valueOf(UCharacter.getUnicodeVersion()) + "\n# from rules " + uSetRules + "\n# \n");
        for (String regForm : reg2pres.keySet()) {
            Set presForms = reg2pres.get(regForm);
            String relation = presForms.size() == 1 && isWord.containsAll((String)presForms.iterator().next()) ? TERTIARY : IDENTICAL;
            rules.append(COMMENT).append(RESET).append(hexForComment.transliterate(regForm));
            for (String presForm : presForms) {
                rules.append(relation).append(hexForComment.transliterate(presForm));
            }
            rules.append(NL);
            rules.append(RESET).append(GenerateDecompCollationRules.toRule(regForm));
            for (String presForm : presForms) {
                rules.append(relation).append(GenerateDecompCollationRules.toRule(presForm));
            }
            rules.append(NL);
        }
        if (verbose) {
            System.out.println(rules);
        }
        XPathParts xpp = new XPathParts().addElements("ldml", "collations", "collation", "cr");
        SimpleXMLSource xmlSource = new SimpleXMLSource("ar");
        CLDRFile newFile = new CLDRFile(xmlSource);
        newFile.add(xpp.toString(), "xyzzy");
        newFile.addComment(xpp.toString(), "Generated by " + GenerateDecompCollationRules.class.getSimpleName() + " " + String.valueOf(new Date()) + "\nfrom rules " + uSetRules + NL, XPathParts.Comments.CommentType.PREBLOCK);
        String filename = newFile.getLocaleID() + ".xml";
        StringWriter sw = new StringWriter();
        newFile.write(new PrintWriter(sw));
        sw.close();
        try (PrintWriter w = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, filename);){
            w.print(sw.toString().replace("xyzzy", "<![CDATA[\n" + rules.toString().replaceAll("\\\\u0020", "\\\\\\\\u0020") + "\n]]>"));
            System.out.println("Wrote to " + CLDRPaths.GEN_DIRECTORY + "/" + filename);
        }
    }

    private static String toRule(String rule) {
        String asHex = escapeRules.transform(rule);
        if (asHex.contains(" ")) {
            StringBuilder sb = new StringBuilder(rule.length());
            sb.append('\'').append(asHex).append('\'');
            return sb.toString();
        }
        return asHex;
    }

    static enum MyOptions {
        unicodeset(".*", "[[:dt=init:][:dt=med:][:dt=fin:][:dt=iso:]]", "UnicodeSet of input chars"),
        verbose(null, null, "verbose debugging messages");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

