/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ibm.icu.impl.Utility;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.XPathParts;

public class AnnotationUtil {
    static final Logger logger = Logger.getLogger(AnnotationUtil.class.getSimpleName());
    private static final String APPS_EMOJI_DIRECTORY = CLDRPaths.BASE_DIRECTORY + "/tools/cldr-apps/src/main/webapp/images/emoji";
    private static final String PATH_PREFIX = "//ldml/annotations/annotation";
    private static final Pattern BAD_EMOJI = Pattern.compile("E\\d+(\\.\\d+)?-\\d+");
    static final LoadingCache<String, Boolean> doWeHaveTheEmoji = CacheBuilder.newBuilder().build(new CacheLoader<String, Boolean>(){

        @Override
        public Boolean load(@Nonnull String emoji) throws Exception {
            return AnnotationUtil.getEmojiImageFile(emoji).exists();
        }
    });

    public static boolean matchesCode(String value) {
        return BAD_EMOJI.matcher(value).matches();
    }

    public static boolean pathIsAnnotation(String path) {
        return path.startsWith(PATH_PREFIX);
    }

    public static String removeEmojiVariationSelector(String emoji) {
        String noVs = emoji.replace("\ufe0f", "");
        return noVs;
    }

    public static String calculateEmojiImageFilename(String emoji) {
        String noVs = AnnotationUtil.removeEmojiVariationSelector(emoji);
        String fileName = "emoji_" + Utility.hex(noVs, 4, "_").toLowerCase(Locale.ROOT) + ".png";
        return fileName;
    }

    public static boolean isRightFacingFilename(String fileName) {
        return fileName.endsWith("_200d_27a1.png");
    }

    public static String getEnglishAnnotationName(String emoji) {
        String noVs = AnnotationUtil.removeEmojiVariationSelector(emoji);
        Factory factoryAnnotations = SimpleFactory.make(CLDRPaths.ANNOTATIONS_DIRECTORY, ".*");
        CLDRFile enAnnotations = factoryAnnotations.make("en", false);
        String name = enAnnotations.getStringValue("//ldml/annotations/annotation[@cp=\"" + noVs + "\"][@type=\"tts\"]");
        return name;
    }

    public static File getEmojiImageFile(String emoji) {
        String fileName = AnnotationUtil.calculateEmojiImageFilename(emoji);
        File file = new File(APPS_EMOJI_DIRECTORY, fileName);
        return file;
    }

    public static String getEmojiFromXPath(String xpath) {
        XPathParts emoji = XPathParts.getFrozenInstance(xpath);
        String cp = emoji.getAttributeValue(-1, "cp");
        return cp;
    }

    public static final boolean haveEmojiImageFile(String emoji) {
        try {
            return doWeHaveTheEmoji.get(emoji);
        }
        catch (ExecutionException e) {
            logger.log(Level.SEVERE, AnnotationUtil.getEnglishAnnotationName(emoji) + " - " + AnnotationUtil.getEmojiImageFile(emoji).getName(), e);
            return false;
        }
    }
}

