/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CodePointEscaper;

public class BidiUtils {
    public static final String ALERT = "\u26a0\ufe0f";
    static final String LRM = CodePointEscaper.LRM.getString();

    public static boolean isOrderingUnchanged(String example, List<String> outputReorderedResults, int ... bidiDirectionOptions) {
        boolean hasList;
        boolean bl = hasList = outputReorderedResults != null;
        if (!hasList) {
            outputReorderedResults = new ArrayList<String>();
        } else {
            outputReorderedResults.clear();
        }
        boolean result = true;
        for (int count = 0; count < bidiDirectionOptions.length; ++count) {
            String reordered = new Bidi(example, bidiDirectionOptions[count]).writeReordered(0);
            outputReorderedResults.add(reordered);
            if (!result || count == 0 || reordered.equals(outputReorderedResults.get(0))) continue;
            result = false;
            if (!hasList) break;
        }
        return result;
    }

    public static Set<String> getFields(String reordred, Set<String> result) {
        int start = 0;
        block0: while (start < reordred.length()) {
            for (SpanClass sc : SpanClass.values()) {
                int end = sc.uset.span(reordred, start, UnicodeSet.SpanCondition.CONTAINED);
                if (end == start) continue;
                result.add(reordred.substring(start, end));
                start = end;
                continue block0;
            }
        }
        return ImmutableSet.copyOf(result);
    }

    public static String getAlert(List<String> bidiReordereds) {
        LinkedHashSet<Set<String>> results = new LinkedHashSet<Set<String>>();
        for (String bidiReordered : bidiReordereds) {
            Set<String> fieldsLTR = BidiUtils.getFields(bidiReordered, new TreeSet<String>());
            results.add(fieldsLTR);
        }
        if (results.size() < 2) {
            return "";
        }
        Iterator it = results.iterator();
        Set first = (Set)it.next();
        Set second = (Set)it.next();
        Sets.SetView<String> uniqueFirst = Sets.difference(first, second);
        Sets.SetView<String> uniqueSecond = Sets.difference(second, first);
        return "\u26a0\ufe0f " + BidiUtils.escape(uniqueFirst) + "; " + BidiUtils.escape(uniqueSecond);
    }

    public static String escape(Set<String> uniqueFirst) {
        return uniqueFirst.stream().map(x -> CodePointEscaper.toEscaped(x)).collect(Collectors.joining(LRM + ", " + LRM, LRM, LRM));
    }

    public static String alphagram(String string) {
        return string.codePoints().sorted().collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static enum SpanClass {
        NUMBERS("\\p{N}"),
        LETTERS_MARKS("[\\p{L}\\p{M}]"),
        DATE_PUNCT("[+]"),
        SPACES("\\p{Z}"),
        OTHERS("\\p{any}");

        final UnicodeSet uset;

        private SpanClass(String unicodeSetSource) {
            this.uset = new UnicodeSet(unicodeSetSource);
        }

        static {
            UnicodeSet soFar = new UnicodeSet();
            for (SpanClass sc : SpanClass.values()) {
                sc.uset.removeAll(soFar).freeze();
                soFar.addAll(sc.uset);
            }
        }
    }
}

